<?php
class CompanyCircular extends CActiveRecord {
    
  
    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_company_circular}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('notes,title', 'required'),
            array('circular_type', 'numerical', 'integerOnly'=>true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,notes,branch_or_sponsor_id,circular_type,date_circular,created_by', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'branch_sponsor'=>array(self::BELONGS_TO, 'MasCompanyBranchSponsor', 'branch_or_sponsor_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',           
            'branch_or_sponsor_id' => 'Branch',
            'notes' => 'Circular',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria=new CDbCriteria;
        $sterm = trim(Yii::app()->request->getParam('search'));
        if($sterm)
        {
//          $criteria->addCondition('shift_name like "%' . $sterm . '%"', 'AND');
        }
    
        $criteria->compare('id',$this->id);
        $criteria->compare('branch_or_sponsor_id',$this->branch_or_sponsor_id,true);
        $criteria->compare('notes',$this->notes,true);
        $criteria->compare('isActive',$this->isActive,true);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('date_circular',$this->date_circular,true);

        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.date_circular ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return  the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }



   

}
