<?php

/**
 * This is the model class for table "{{hr_company_catalogue}}".
 *
 * The followings are the available columns in table '{{hr_company_catalogue}}':
 * @property integer $id
 * @property string $branch_or_sponsor_id
 * @property string $department_id
 * @property string $title
 * @property string $notes
 * @property string $catalogue_attachment
 * @property string $employees_viewed
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class CompanyCatalogue extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_company_catalogue}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, notes', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('branch_or_sponsor_id, department_id', 'length', 'max'=>100),
			array('catalogue_attachment', 'length', 'max'=>700),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, branch_or_sponsor_id, department_id, title, notes, catalogue_attachment, employees_viewed, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'branch_or_sponsor_id' => 'Branch Or Sponsor',
			'department_id' => 'Department',
			'title' => 'Title',
			'notes' => 'Notes',
			'catalogue_attachment' => 'Catalogue Attachment',
			'employees_viewed' => 'Employees Viewed',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('branch_or_sponsor_id',$this->branch_or_sponsor_id,true);
		$criteria->compare('department_id',$this->department_id,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('catalogue_attachment',$this->catalogue_attachment,true);
		$criteria->compare('employees_viewed',$this->employees_viewed,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CompanyCatalogue the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getbranch($id=0) {
            $model = self::model()->findbyPK($id);
            $branchname='All branches';
            $branch_name=array();
            if($model->branch_or_sponsor_id!=''){
                $branch_id=explode(',',$model->branch_or_sponsor_id);
                foreach ($branch_id as $value) {                            
                    $branch_name[]=MasCompanyBranchSponsor::model()->findbyPk($value)->branch_or_sponsor_name;
                }
                $branchname=  implode(',', $branch_name);
            }
            return $branchname;
        }
        public static function getdepartment($id=0) {
            $model = self::model()->findbyPK($id);
            $departmentname='All departments';
            $department_name=array();
            if($model->department_id!=''){
                $department_id=explode(',',$model->department_id);
                foreach ($department_id as $value) {                            
                    $department_name[]=MasDepartment::model()->findbyPk($value)->department_name;
                }
                $departmentname=  implode(',', $department_name);
            }
            return $departmentname;
        }
}
