<?php

class TeamleavebalanceController extends Controller {

    //public $layout = 'main';
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'TeamLeaveHistoryIndex', 'GetLeaveHistory'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->layout = 'main';
        $model_module_leave = HrModules::model()->findByPK(3);
        if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $hierarchy_line_manager_ids = Employee::employeesubordinates($empid);
        Employee::model()->updateByPK($empid, array('hierarchy_line_manager_ids' => $hierarchy_line_manager_ids));
        $ids = explode(',', $hierarchy_line_manager_ids);
        $conditions = [];
        foreach ($ids as $id) {
            $id = trim($id);
            if ($id !== '') {
                $conditions[] = "FIND_IN_SET('$id',t.employee_id)";
            }
        }
        $findInSetClause = implode(' OR ', $conditions);
        $model = new EmployeeLeave();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $employee_id = $_POST['employee_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.de_first_name',
            3 => 'leavetype.leave_name',
            4 => 'leave_current_balance'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if($columns[$_POST['order'][1]['column']]!='' && $_POST['order'][1]['dir']!='' ){
            $filterColumn1 = $columns[$_POST['order'][1]['column']];
            $filterOrder1 = $_POST['order'][1]['dir'];
            $orderBy.=','.$filterColumn1 . " " . $filterOrder1;
        }
        $model_general_setting = HrGenerelSettings::model()->find();
        $year = date("Y");
        $current_month = date("m");
        if ($current_month < $model_general_setting->leave_carry_forward_month) {
            $year = $year - 1;
        }
        $condition = '((' . $findInSetClause . ')) and leave_year="' . $year . '"';
        if($employee_id>0){
            $condition = 't.employee_id="' . $employee_id . '" and leave_year="' . $year . '"';  
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.de_first_name LIKE '%" . $searchString . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->with('employeedetail', 'leavetype')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'leavetype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $rowData[] = array(++$m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row['leavetype']['leave_name'], $row['leave_current_balance']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionTeamLeaveHistoryIndex() {
        $this->layout = "main";
        $model_module_leave = HrModules::model()->findByPK(3);
        if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('leave_historyindex');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetLeaveHistory() {
        $model_employee = User::model()->findbypk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $hierarchy_line_manager_ids = Employee::employeesubordinates($employee_id);
        Employee::model()->updateByPK($employee_id, array('hierarchy_line_manager_ids' => $hierarchy_line_manager_ids));
        $ids = explode(',', $hierarchy_line_manager_ids);
        $conditions = [];
        foreach ($ids as $id) {
            $id = trim($id);
            if ($id !== '') {
                $conditions[] = "FIND_IN_SET('$id',t.employee_id)";
            }
        }
        $findInSetClause = implode(' OR ', $conditions);
        $from_date = date('Y-m-d', strtotime($_POST['from_date']));
        $to_date = date('Y-m-d', strtotime($_POST['date_to']));
        $team_employee_id = $_POST['team_employee_id'];
        $model = new EmployeeLeaveDetail();
        //$status = $_POST['status'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            4 => 'leave_start_date',
            5 => 'leave_end_date',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '((' . $findInSetClause . ')) and t.leave_status="12"';
        if($from_date!='' && $to_date!=''){
            $condition .= ' AND ((leave_start_date<="' . $from_date . '" AND leave_end_date>="' . $to_date . '") OR  (leave_start_date BETWEEN  "' . $from_date . '" AND  "' . $to_date . '"
                            OR leave_end_date BETWEEN  "' . $from_date . '" AND  "' . $to_date . '"))';
        }
        if($team_employee_id>0){
            $condition .= 'AND t.employee_id="' . $team_employee_id . '"';  
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR leavetype.leave_name LIKE '%" . $searchString . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->with('employeedetail', 'leavetype')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'leavetype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {

            $apply_date = "";
            $leave_start_date = "";
            $leave_end_date = "";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }

            if ($row['leave_start_date'] != '' && $row['leave_start_date'] != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($row->leave_start_date));
            }
            if ($row['leave_end_date'] != '' && $row['leave_end_date'] != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($row->leave_end_date));
            }
            $rowData[] = array(++$m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row->leavetype->leave_name, $apply_date, $leave_start_date, $leave_end_date, $row->no_days, EmployeeLeaveDetail::getleavestatusbybranch($row->leave_status, $row->employeedetail->branch_or_sponsor_id), $row['leave_reason']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
}
