<?php

class SubscriptionController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'package','SavePackageDetails','demo'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl');
    }

    public function actionIndex() {
        $model_packages = HrSoftwarePackage::model()->findAll(array('condition' => 'isActive="Y"'));
        $this->render('package_index',array('model_packages' => $model_packages));
    }

    public function actionPackage() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrSoftwarePackage();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('package_details', array('model' => $model), false, true);
    }
    public function actionSavePackageDetails() {
        $model = new HrSoftwarePackage();
        if (isset($_POST['HrSoftwarePackage'])) {
            if ((int) @$_POST['HrSoftwarePackage']['id'] > 0) {
                $model = HrSoftwarePackage::model()->findByPK($_POST['HrSoftwarePackage']['id']);
                $model->id = (int) $_POST['HrSoftwarePackage']['id'];
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['HrSoftwarePackage'];
            if (isset($_POST['HrSoftwarePackage']['description']) && $_POST['HrSoftwarePackage']['description'] != '') {
                $model->description = $_POST['HrSoftwarePackage']['description'];
            }
            if (isset($_POST['HrSoftwarePackage']['package_details']) && $_POST['HrSoftwarePackage']['package_details'] != '') {
                $model->package_details = implode(',',$_POST['HrSoftwarePackage']['package_details']);
            }
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actiondemo() {
        $this->render('index');
    }

}
