<?php

class ShiftController extends Controller
{

    
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','GetList','Getshiftime','Create','Loademployeeshift','SaveEmployeeShift','EditShift','DeleteShiftDetails','ViewShift',
                        'DeleteShift','UpdateemployeeShift','UploadShift','DownloadShiftFormat','SaveShiftUploadCsv','UploadEmployeecsv','DownloadErrorCsv'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    
    public function filters(){
            return array(
                'accessControl', // perform access control for CRUD operations
            );
    }
    
    public function actionIndex() {
        $model_module_attendance = HrModules::model()->findByPK(2);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empatt_shift_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y')) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    
    public function actionCreate(){
        $model       = new MasShift();              
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('employee_shift_form', array('model' => $model), false, true);
    }
    
    public function actionGetshiftime(){
        $id=$_POST['shift_id'];
        if($id>0){
            $model =MasShift::model()->findByPK($id);  
            $start_time=date("h:i A", strtotime($model->start_time));
            $end_time=date("h:i A", strtotime($model->end_time));
            $jsonData['starttime'] =$start_time;
            $jsonData['endtime'] =$end_time;	                
        }else{
            $jsonData['starttime'] ='';
            $jsonData['endtime'] ='';
        }
        echo CJSON::encode($jsonData);
    }
    
    public function actionLoademployeeshift(){
        $from_date      = $_POST['from_date'];
        $shift_id       = $_POST['shift_id']; 
        $to_date        = $_POST['to_date']; 
        $branch_id        = $_POST['branch_id'];     
        $model_shift = EmployeeShift::model()->with('employeedetail')->findAll(array('condition'=>'from_date="'.$from_date.'" and to_date="'.$to_date.'" and branch_id="'.$branch_id.'" and shift_id="'.$shift_id.'"')); 
        if(empty($model_shift)){    
            $SQL =" SELECT * FROM  `erp_hr_employee` E WHERE isActive!='B' AND branch_or_sponsor_id='" . $branch_id . "' && id 
                   NOT IN (SELECT  employee_id FROM  erp_hr_employee_shift WHERE from_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                    OR to_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "' OR (from_date <=  '" . $from_date . "' AND to_date >=  '" . $to_date . "'))";                               
            $model_employee = Yii::app()->db->createCommand($SQL)->queryAll();       
            $arr_employee=array();
            foreach ($model_employee as $key => $value) {
                $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' '.$this->ciphertext($value['employee_code'],"d")]=$value['id'];
            }
            ksort($arr_employee);
            $this->renderPartial('list_employee_shift',array('model'=>$arr_employee,'shift_id'=>$shift_id,'from_date'=>$from_date,'to_date'=>$to_date,'branch_id'=>$branch_id), false, true); 
        }else{
            $this->renderPartial('shift_error_message'); 
        } 
        
    }
    
    public function actionSaveEmployeeShift(){
        if(isset($_POST['EmployeeShift'])){                
            $from_date      = $_POST['from_date'];
            $shift_id       = $_POST['shift_id'];
            $to_date        = $_POST['to_date'];
            $branch_id        = $_POST['shift_branch'];
            $shift_group_identify=1;
            $model_shift_value= EmployeeShift::model()->find(array('select' => 'max(shift_group_identify) as shift_group_identify'));
            if($model_shift_value->shift_group_identify>0){
                $shift_group_identify=$model_shift_value->shift_group_identify+1;
            }
            if($shift_id!='' && $from_date!='' && $to_date!=''){
                foreach ($_POST['EmployeeShift'] as $each_shift){
                    if (in_array($each_shift['employee_id'], $_POST['arraycid'])){
                        $model_shift= new EmployeeShift();                          
                        $model_shift->employee_id   = $each_shift['employee_id'];
                        $model_shift->allowance_amount   = $each_shift['allowance_amount'];
                        $model_shift->branch_id      = $branch_id;
                        $model_shift->shift_id      = $shift_id;
                        $model_shift->from_date     = $from_date;
                        $model_shift->to_date       =$to_date; 
                        $model_shift->shift_group_identify= $shift_group_identify;
                        $model_shift->created_by = Yii::app()->user->id;
                        $model_shift->created_date_time = date('Y-m-d H:i:s');
                        $model_shift->save(false);
                        $modal_attendance = EmployeeAttendance::model()->findAll(array('condition'=>'(attendance_date between "'.$from_date.'" and "'.$to_date.'" OR attendance_date>="'.$from_date.'" AND attendance_date<="'.$to_date.'") AND employee_id = "'.$each_shift['employee_id'].'" '));
                        if(!empty($modal_attendance)){	
                            foreach($modal_attendance as $each_attendance){		
                                $each_attendance->shift_id = $model_shift->id;	
                                $each_attendance->updated_by = Yii::app()->user->id;
                                $each_attendance->updated_date_time = date('Y-m-d H:i:s');
                                $each_attendance->save(false);
                            }
                        }
                    }
                }
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'error';
            }
            echo CJSON::encode($jsonData);
        }
    }
               
    public function actionGetList(){
        $model=new EmployeeShift();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $employee_id  = $_POST['employee_id'];
        $shift_id  = $_POST['shift_id'];
        $columns = array(
        // datatable column index  => database column name
            0 =>'id',
            1 =>'emp_details.branch_or_sponsor_id',
            2=>'shift_id',
            3 =>'from_date',
            4=>'to_date',
            5=>'shiftdetails.start_time',
            6=>'shiftdetails.end_time',
            7=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = "1=1"; 
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if($shift_id>0){
            $condition.=" and shift_id='".$shift_id."'";
        }
        if($employee_id>0){
            $condition.=" and employee_id='".$employee_id."'";
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $searchString_encryption = $this->ciphertext($searchString,"e");
          $condition.=" and (shiftdetails.shift_name LIKE '%".$searchString."%' OR employeedetail.first_name LIKE '%".$searchString."%'
                                 OR employeedetail.first_name LIKE '%".$searchString_encryption."%'
                                 OR employeedetail.last_name LIKE '%".$searchString_encryption."%'
                                 OR employeedetail.employee_code LIKE '%".$searchString_encryption."%')";
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->with('shiftdetails','employeedetail')->count(array('condition'=>$condition,'group'=>'shift_group_identify'));
        $model=$model->with('shiftdetails','employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.from_date DESC','group'=>'shift_group_identify'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $fromdate  = "";
            $todate="";
            if($row['from_date'] !='0000-00-00' && $row['from_date'] !=''){
                $fromdate  = date("d/m/Y", strtotime($row['from_date'])) ;  

            }
            if($row['to_date'] !='0000-00-00' && $row['to_date'] !=''){
                $todate  = date("d/m/Y", strtotime($row['to_date'])) ;  
            }
//            $button_string="";
            $edit_shift=$view_shift=$delete=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_att_employee_shift_edit'])  || Yii::app()->user->authorised_user == 1) {
                $edit_shift=1;
//                $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/shift/editshift&id='.$row['shift_group_identify'].'\',\'EDIT SHIFT DETAILS\',\'lg\')"><i class="fa fa-edit"></i></button>';  
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_att_employee_shift_view'])  || Yii::app()->user->authorised_user == 1) {
                $view_shift=1;
//                $button_string.= ' <button class="btn btn-primary btn-xs" title="View Shift" onclick="loadPopupModal(\'hr/shift/viewshift&id='.$row['shift_group_identify'].'\',\'VIEW SHIFT DETAILS\',\'lg\')"><i class="fa fa-eye"></i></button>';  
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_att_employee_shift_delete'])  || Yii::app()->user->authorised_user == 1) {
                $delete=1;
//                $button_string.= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteShift('.$row['shift_group_identify'].')"><i class="fa fa-trash-o "></i></a></div>';          
            }
            $rowData[]=array($m,$row['branchdetails']['branch_or_sponsor_name'],$row['shiftdetails']['shift_name'],$fromdate,$todate,date("h:i A", strtotime($row->shiftdetails->start_time)),date("h:i A", strtotime($row->shiftdetails->end_time)),array('id'=>$row['shift_group_identify'],'edit_shift'=>$edit_shift,'view_shift'=>$view_shift,'delete'=>$delete));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
      
    public function actionEditShift() {
        $id= (int) Yii::app()->request->getParam('id');
        $model_shift_details = EmployeeShift::model()->find(array('condition'=>'shift_group_identify="'.$id.'"'));
        $condition='shift_group_identify="'.$id.'"';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $condition_1='';
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
            $condition_1= ' and reporting_manager="'.$model_user->department_head_id.'"';
        }
        $model_shift = EmployeeShift::model()->with('employeedetail')->findAll(array('condition'=>$condition,'order'=>'t.id desc'));           
        //Employee without shift
        if(!empty($model_shift_details)){
            $from_date= $model_shift_details->from_date;
            $to_date= $model_shift_details->to_date; 
            $branch_id=$model_shift_details->branch_id;  
        }
        $arr_employee=array();
        if(!empty($from_date) && !empty($to_date)){
            $SQL =" SELECT * FROM  `erp_hr_employee` E WHERE isActive!='B' AND branch_or_sponsor_id='" . $branch_id . "' $condition_1 && id 
                   NOT IN (SELECT  employee_id FROM  erp_hr_employee_shift WHERE from_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                    OR to_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "' OR (from_date <=  '" . $from_date . "' AND to_date >=  '" . $to_date . "'))";                               
            $model_employee = Yii::app()->db->createCommand($SQL)->queryAll();       
           
            foreach ($model_employee as $key => $value) {
                $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' '.$this->ciphertext($value['employee_code'],"d")]=$value['id'];
            }
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false ,'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js'=> false);
       $this->renderPartial('edit_employee_shift',array('model'=>$model_shift,'model_shift_details'=>$model_shift_details,'model_employee'=>$arr_employee,), false, true);
    }

    public function actionDeleteShiftDetails() {
        $id= $_POST['id'];
        $model_shift_details = EmployeeShift::model()->findbyPK($id);
        $jsonData['shift_identify'] =$model_shift_details->shift_group_identify;
        EmployeeAttendance::model()->updateAll(array('shift_id' =>0),'(attendance_date between "'.$model_shift_details->from_date.'" and "'.$model_shift_details->to_date.'" OR attendance_date>="'.$model_shift_details->from_date.'" AND attendance_date<="'.$model_shift_details->to_date.'") ');
        EmployeeShift::model()->deleteByPk($id);
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionUpdateemployeeShift(){
        if(isset($_POST['EmployeeShift'])){                
            $from_date= $_POST['from_date_edit'];
            $shift_id= $_POST['shift_id_edit'];
            $to_date = $_POST['to_date_edit'];
            $branch_id = $_POST['branch_id_edit'];
            $shift_group_identify = $_POST['shift_group_identify_edit'];
            if($shift_id!='' && $from_date!='' && $to_date!=''){
                foreach ($_POST['EmployeeShift'] as $each_shift){
                    if (in_array($each_shift['employee_id'], $_POST['arraycid'])){
                        $model_shift= new EmployeeShift();                          
                        $model_shift->employee_id   = $each_shift['employee_id'];
                        $model_shift->allowance_amount   = $each_shift['allowance_amount'];
                        $model_shift->branch_id      = $branch_id;
                        $model_shift->shift_id      = $shift_id;
                        $model_shift->from_date     = $from_date;
                        $model_shift->to_date       =$to_date; 
                        $model_shift->shift_group_identify= $shift_group_identify;
                        $model_shift->created_by = Yii::app()->user->id;
                        $model_shift->created_date_time = date('Y-m-d H:i:s');
                        $model_shift->save(false);
                        $modal_attendance = EmployeeAttendance::model()->findAll(array('condition'=>'(attendance_date between "'.$from_date.'" and "'.$to_date.'" OR attendance_date>="'.$from_date.'" AND attendance_date<="'.$to_date.'") AND employee_id = "'.$each_shift['employee_id'].'" '));
                        if(!empty($modal_attendance)){	
                            foreach($modal_attendance as $each_attendance){		
                                $each_attendance->shift_id = $model_shift->id;	
                                $each_attendance->updated_by = Yii::app()->user->id;
                                $each_attendance->updated_date_time = date('Y-m-d H:i:s');
                                $each_attendance->save(false);
                            }
                        }
                    }
                }
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'error';
            }
            echo CJSON::encode($jsonData);
        }
    }
    public function actionDeleteShift() {
        $id= $_POST['id'];
        $model_shift_details = EmployeeShift::model()->find(array('condition'=>'shift_group_identify="'.$id.'"'));
        $from_date=$model_shift_details->from_date;
        $to_date=$model_shift_details->to_date;
        EmployeeAttendance::model()->updateAll(array('shift_id' =>0,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')),'(attendance_date between "'.$from_date.'" and "'.$to_date.'" OR attendance_date>="'.$from_date.'" AND attendance_date<="'.$to_date.'") ');
        EmployeeShift::model()->deleteAll('shift_group_identify=:refer_id', array(':refer_id' =>$id));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionViewShift() {
        $id= (int) Yii::app()->request->getParam('id');
        $model_shift_details = EmployeeShift::model()->find(array('condition'=>'shift_group_identify="'.$id.'"'));
        $condition='shift_group_identify="'.$id.'"';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        $model_shift = EmployeeShift::model()->with('employeedetail')->findAll(array('condition'=>$condition,'order'=>'t.id desc'));                 
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false ,'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js'=> false);
       $this->renderPartial('view_employee_shift',array('model_shift_details'=>$model_shift_details,'model'=>$model_shift), false, true);
    }
    public function actionUploadShift(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_shift', array(), false, true);
    }
    public function actionDownloadShiftFormat() {
        $filename = 'weekly_shift_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Employee Code *,Employee Name *,Shift Name *,Shift Start Date (YYYY-mm-dd)*,Shift End Date (YYYY-mm-dd)*';
        Yii::app()->end();
    }
    public function readEmployeeCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionSaveShiftUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');  
        $jsonData['status'] = "success";
        $url = Yii::app()->basePath . '/../uploads/shift/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/shift/error/'.$file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $shift_list = $this->readEmployeeCSV("uploads/shift/" . $file_name);
        foreach (array_slice($shift_list, 1) as $i => $data) {
            if(!empty($data[0]) || !empty($data[1])|| !empty($data[2]) || !empty($data[3]) || !empty($data[4])){
            $model_shift[$i] = new EmployeeShift();
            $model_shift[$i]->scenario="excelupload";		 
            if($data[0]!=''){
                $employee_code=$this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"')),"e");
                $model_employee = Employee::model()->find(array('condition'=>'employee_code="'.$employee_code.'"'));
                //echo $employee_code;exit;
                if($model_employee->id>0){
                    $model_shift[$i]->employee_id =$model_employee->id;
                    $model_shift[$i]->branch_id =$model_employee->branch_or_sponsor_id;
                }else{
                    $model_shift[$i]->employee_id =0;
                    $model_shift[$i]->branch_id =0;
                }
            }else{                    
                $model_shift[$i]->employee_id =0;
                $model_shift[$i]->branch_id =0;
            }
            $model_shift[$i]->employee_code =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
            $model_shift[$i]->employee_name =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));
            if($data[2]!=''){
                $condition = '((REPLACE(`shift_name`, " ", "")="'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'))).'"  OR id LIKE "%'.$data[2].'%" ) AND isActive ="Y")';        
                $model_shifttype[$i] = MasShift::model()->find(array('select' =>'id,start_time,end_time','condition' => $condition));
                $model_shift[$i]->shift_id = $model_shifttype[$i]->id;
            }else{
                $model_shift[$i]->shift_id = 0;
            }
            $model_shift[$i]->shift_name =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'));
            if($data[3]!=''){
                $model_shift[$i]->from_date =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"'));
            }else{
                $model_shift[$i]->from_date = '';
            }
            if($data[4]!=''){
                $model_shift[$i]->to_date =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"'));
            }else{
                $model_shift[$i]->to_date = '';
            }
            $model_shift[$i]->created_by  =Yii::app()->user->id;
            $model_shift[$i]->created_date_time = date('Y-m-d H:i:s');
            $validate = $model_shift[$i]->validate() && $validate;
            }
        }
        if ($validate) {					
            if (!empty($model_shift)) {
                foreach ($model_shift as $eachModel) {   
                    $shift_group_identify=1;
                    $model_shift_exist= EmployeeShift::model()->find(array('condition' => 'from_date="' . $eachModel->from_date . '" AND to_date="' . $eachModel->to_date . '" AND shift_id="'.$eachModel->shift_id.'"'));
                    if(!empty($model_shift_exist)){
                        $shift_group_identify=$model_shift_exist->shift_group_identify;
                    }else{
                        $model_shift_value= EmployeeShift::model()->find(array('select' => 'max(shift_group_identify) as shift_group_identify'));
                        if(!empty($model_shift_value)){
                            $shift_group_identify=$model_shift_value->shift_group_identify+1;
                        }
                    }
                    $eachModel->shift_group_identify= $shift_group_identify;
                    $eachModel->save();
                }
                $jsonData['error'] ="";	
            }	
        } else {			
            if (!empty($model_shift)) {
                foreach ($model_shift as $s => $data_model) {
                    $error_list[$s]['employee_code']  =$data_model['employee_code'];
                    $error_list[$s]['employee_name'] =$data_model['employee_name'];
                    $error_list[$s]['shift_name'] =$data_model['shift_name'];
                    $error_list[$s]['from_date']    =$data_model['from_date'];
                    $error_list[$s]['to_date']      =$data_model['to_date'];
                    if($data_model->validate()){
                    $error_list[$s]['remarks']     ="correct";
                    }else{
                    $error_list[$s]['remarks']     =$data_model->getErrors();	
                    }
                }
            }	
	}				
              		 
	$j=0;
        fclose($file);
        $list = array(); 
        if(!empty($error_list)){
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Employee Code *,Employee Name *,Shift Name *,Shift Start Date (YYYY-mm-dd)*,Shift End Date (YYYY-mm-dd)*,Remarks';
            foreach ($error_list as $i => $error_detail) {
                if(!empty($error_detail)){
                    if(!empty($error_detail['remarks'])){
                            $error_view[$i] = '';
                        foreach($error_detail['remarks'] as $p => $error_value){						
                                $error_view[$i] .= $error_value[0]." / ";	

                        }
                    }else{
                        $error_view[$i] .= '';
                    }
                    $list[$j++] =$error_detail['employee_code']. ',' .$error_detail['employee_name']. ',' .$error_detail['shift_name']. ',' .$error_detail['from_date']. ',' .$error_detail['to_date']. ',' .$error_view[$i];
                }
            }
            if(!empty($list) && $file_error !== false){
                foreach ($list as $line) {
                    fputcsv($file_error, explode(',', $line));
                }
                 fclose($file_error);
            }
        }
		

        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('shift/DownloadErrorCsv', 'filename'=>$file_name), array('target' => '_blank',
            'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
            . ''
            ));
        echo CJSON::encode($jsonData);
    }
    public function actionDownloadErrorCsv() {
        $file_name = Yii::app()->request->getParam('filename');
        $error_url = Yii::app()->basePath . '/../uploads/shift/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
}