<?php

class SalarysifController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetSifList','Create','GenerateSiffile','SaveSif','DownloadSif','PrintSif',
                    'deletesiffile','downloadexcel','excelsheetsalary','SalaryTransfer','GetTransferList','downloadsalarytransferfile'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_payroll = HrModules::model()->findByPK(7);
        if (((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_cash_menu']) ||
                isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_cheque_menu']) 
                ||isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_siffile_menu'])
                ||isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_exchange_menu'])
                ||isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_bank_menu']) || 
                Yii::app()->user->authorised_user == 1)) &&($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y')) {
            $en_type=Yii::app()->request->getParam('type');
            $type= $this->ciphertext($en_type,"d");
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            if($type==1 || $type==2 || $type==3 || $type==4 || $type==5){
                $this->render('index',array('type'=>$type));
            }else{
                throw new CHttpException(404, 'Page not found.');
            }
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetSifList() {
        $model = new MonthlySalarySif();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $month= $_POST['month'];	
        $wps_company= $_POST['wps_company'];
        $type= $_POST['type'];
        $year= $_POST['year'];
        $columns = array(
            0 => 'id',
            1 => 'created_date',
            2 => 'wpscompany_id',
            3 => 'salary_month',
            4 => 'total_amount',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'salary_payment_mode="'.$type.'"';
        if($month>0){
            $month=HrGenerelSettings::getMonthName($month);
            $condition.=" and salary_month='".$month."'";
        }
        if($wps_company>0){
            $condition.=" and wpscompany_id ='".$wps_company."'";
        }
        if($year>0){
            $condition.= ' AND YEAR(date)="'.$year.'"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (salary_month LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' =>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $created_date="";
            if ($row['created_date'] != '' && $row['created_date'] != '0000-00-00') {
                $created_date = date("d/m/Y", strtotime($row->created_date));
            }
            $sif_download=$exchange_download=$salary_sheet=$payment_print_code=$payment_print=$payment_delete=0;
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_download'])  || Yii::app()->user->authorised_user == 1) && $row['salary_payment_mode']==3) {
                $sif_download=1;
//                $button_string .= '<a href="?r=hr/salarysif/downloadsif&id='.$row['id'] .'"><button class="btn btn-primary btn-xs" title="Download File" ><i class="fa fa-download"></i></button></a>&nbsp;';
            }else if ((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_download'])  || Yii::app()->user->authorised_user == 1) && $row['salary_payment_mode']==4) {
                $exchange_download=1;
//                $button_string .= '<a href="?r=hr/salarysif/downloadexcel&id='.$row['id'] .'"><button class="btn btn-primary btn-xs" title="Download File" ><i class="fa fa-download"></i></button></a>&nbsp;';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_print'])  || Yii::app()->user->authorised_user == 1) {
                $payment_print_code=1;
//                $button_string.= ' <a href="?r=hr/salarysif/printsif&type='.$row['salary_payment_mode'] .'&id='.$row['id'] .'" target="_blank"><button class="btn btn-primary btn-xs" title="Print Pdf"><i class="fa fa-print"></i></button></a>&nbsp;';         
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_print'])  || Yii::app()->user->authorised_user == 1) && $row['salary_payment_mode']==3) {
                $payment_print=1;
//                $button_string.= ' <a href="?r=hr/salarysif/printsif&frm=1&type='.$row['salary_payment_mode'] .'&id='.$row['id'] .'" target="_blank"><button class="btn btn-primary btn-xs" title="Print Pdf(Without Code)"><i class="fa fa-print"></i></button></a>&nbsp;';         
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_print'])  || Yii::app()->user->authorised_user == 1) && ($row['salary_payment_mode']==3 || $row['salary_payment_mode']==4)) {
                $salary_sheet=1;
//                $button_string.= ' <a href="?r=hr/salarysif/excelsheetsalary&type='.$row['salary_payment_mode'] .'&id='.$row['id'] .'" target="_blank"><button class="btn btn-primary btn-xs" title="Salary Sheet"><i class="fa fa-file-excel-o"></i></button></a>&nbsp;';         
            }
            if( Yii::app()->user->haveFinanceModule ) :
                if( $row['posted'] == 'N' ){
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_post'])  || Yii::app()->user->authorised_user == 1) {            
//                        $button_string.= ' <a href ="javascript:void(0);" class="btn btn-info btn-xs" onclick="connect_to_finance('.$row['id'].', \'POST\')" title="Post voucher"><i class="fa fa-send"></i></a>';
                    }
                }else{ //if( $lastId->id == $row['id'] ) 
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_unpost'])  || Yii::app()->user->authorised_user == 1) {            
//                        $button_string.= ' <a href ="javascript:void(0);" class="btn btn-info btn-xs" onclick="connect_to_finance('.$row['id'].', \'UNPOST\')" title="Unpost voucher"><i class="fa fa-remove"></i></a>';
                    }
                }
            endif;

            if( $row['posted'] == 'N' ){
                if ((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sif_file_delete'])  || Yii::app()->user->authorised_user == 1)) { 
                    $payment_delete=1;
//                    $button_string.= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletesifdetail('.$row['id'].')" title="Delete SIF file"><i class="fa fa-trash-o "></i></a>';
                }
            }
            $type_wps_company='';
            if($row['salary_payment_mode']==1){
                $type_wps_company='Cash';
            }else if($row['salary_payment_mode']==2){
                $type_wps_company='Cheque';
            }else if($row['salary_payment_mode']==3 || $row['salary_payment_mode']==4){
                $type_wps_company=$row->wpscompany_detail->company_name;
            }
            $rowData[] = array(++$m,$created_date,$type_wps_company , $row->salary_month,$row->total_amount, array('id'=>$row['id'],'salary_payment_mode'=> $row['salary_payment_mode'],'sif_download'=>$sif_download,'exchange_download'=>$exchange_download,'salary_sheet'=>$salary_sheet,'payment_print_code'=>$payment_print_code,'payment_print'=>$payment_print,'payment_delete'=>$payment_delete));
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $type=(int) Yii::app()->request->getParam('type');
        $model=new MonthlySalarySif();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
    	if($type==1 || $type==2 || $type==3 || $type==4 || $type==5){
            $this->render('create',array('model'=>$model,'type'=>$type));
        }else{
            throw new CHttpException(404, 'Page not found.');
        }
    }
    public function actionGenerateSiffile() {
        $month = $_POST['month'];
        $year = $_POST['year'];
        $type = $_POST['type'];
        $bank_id='';
        if(!empty($_POST['bank_id'])){
        $bank_id = $_POST['bank_id'];
        }
        $wps_company = $_POST['wps_company']; 
        $branch_id = $_POST['branch_id'];
         $start_date=$year.'-'.$month.'-01';
        $end_date=date('Y-m-t',strtotime($start_date));
        $model=new MonthlySalarySif();
        $model_sif_details=new MonthlySalarySifDetails();
        $con='isActive="Y" and employee_wps_company="'.$wps_company.'" AND date_join<="'.$end_date.'" and (payment_type="0" OR payment_type="'.$type.'")';
        if($branch_id>0){
            $con.=' AND branch_or_sponsor_id="'.$branch_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$con));
        $arr_employee=array(); 
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d")]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($type==1 || $type==2){
            $this->render('salary_cash_cheque_payment', array('type'=>$type,'bank_id'=>$bank_id,'arr_employee' => $arr_employee,'month' => $month, 'year' => $year, 'wps_company'=>$wps_company,'model'=>$model,'model_sif_details'=>$model_sif_details));
        }else if($type==3){
            $this->render('salary_sif_file', array('type'=>$type,'arr_employee' => $arr_employee,'month' => $month, 'year' => $year, 'wps_company'=>$wps_company,'model'=>$model,'model_sif_details'=>$model_sif_details));
        }else if($type==4){
            $this->render('salary_exchange_file', array('type'=>$type,'arr_employee' => $arr_employee,'month' => $month, 'year' => $year, 'wps_company'=>$wps_company,'model'=>$model,'model_sif_details'=>$model_sif_details));
        }else if($type==5){
            $this->render('salary_bank', array('type'=>$type,'bank_id'=>$bank_id,'arr_employee' => $arr_employee,'month' => $month, 'year' => $year, 'wps_company'=>$wps_company,'model'=>$model,'model_sif_details'=>$model_sif_details));
        }
    }
    public function actionSaveSif() {       
        if (isset($_POST['MonthlySalarySif'])) {
            if (count($_POST['arraycid']) > 0) {
                date_default_timezone_set("Asia/Dubai");
                $year = isset($_POST['year']) ? $_POST['year']  :  date('Y');
                $month = isset($_POST['sif_salary_month']) ? $_POST['sif_salary_month'] : date('m');            
                $valid=TRUE;
                $salary_payment_mode=$_POST['MonthlySalarySif']['salary_payment_mode'];
                $model = new MonthlySalarySif();
                $model->attributes = $_POST['MonthlySalarySif'];
                if(isset( $_POST['MonthlySalarySif']['sublegder_id'])){
                    $model->sublegder_id = $_POST['MonthlySalarySif']['sublegder_id'];
                }
                
                $sif_year=$year.'-'.$month.'-01';
                $model->date= date("Y-m-t", strtotime($sif_year));
                $model->created_by= Yii::app()->user->id;
                $model->created_date = date('Y-m-d');
                $valid=$model->validate();
                $total_amount=0;
                if (isset($_POST['MonthlySalarySifDetails'])){
                    foreach ($_POST['MonthlySalarySifDetails'] as $i => $items) {
                        if (in_array($items['employee_id'], $_POST['arraycid'])) {
                            if(!empty($items['id']) && $items['id']>0){
                                $model_sif[$i] = MonthlySalarySifDetails::model()->findByPK($items['id']);   
                            }else{
                                $model_sif[$i] = new MonthlySalarySifDetails();
                                $model_sif[$i]->created_by= Yii::app()->user->id;
                                $model_sif[$i]->created_date = date('Y-m-d');
                            }   
                            if($salary_payment_mode==1){
                                $model_sif[$i]->scenario = 'cashpayment';
                                $model_sif[$i]->total_salary_paid=$items['salary_amount'];
                            }else if($salary_payment_mode==2){
                                $model_sif[$i]->scenario = 'chequepayment';
                                $model_sif[$i]->total_salary_paid=$items['salary_amount'];
                                $model_sif[$i]->bank_id=$items['bank_id'];
                            }else if($salary_payment_mode==3){
                                $model_sif[$i]->scenario = 'wpspayment';
                                $model_sif[$i]->total_salary_paid=$items['basic_salary']+$items['salary_amount'];
                            }else if($salary_payment_mode==4){
                                $model_sif[$i]->scenario = 'exchange';
                                $model_sif[$i]->total_salary_paid=$items['basic_salary']+$items['salary_amount'];
                            }else if($salary_payment_mode==5){
                                $model_sif[$i]->scenario = 'bank';
                                $model_sif[$i]->total_salary_paid=$items['salary_amount'];
                            }
                            $model_sif[$i]->employee_id = $items['employee_id'];
                            $model_sif[$i]->personal_file_no = $items['personal_file_no'];
                            $model_sif[$i]->iban_no = $items['iban_no'];
                            $model_sif[$i]->employee_wpscode = $items['employee_wpscode'];
                            $model_sif[$i]->start_date = $items['start_date'];
                            $model_sif[$i]->end_date = $items['end_date'];
                            $model_sif[$i]->basic_salary = $items['basic_salary'];
                            $total_amount+=$items['basic_salary'];
                            $model_sif[$i]->salary_amount = $items['salary_amount'];
                            $total_amount+=$items['salary_amount'];
                            $model_sif[$i]->total_days = $items['total_days'];
                            $model_sif[$i]->leave_days = $items['leave_days'];
                            $valid=$model_sif[$i]->validate() && $valid;
                        }
                    }
                }
                if($valid){
                    $model->total_amount=$total_amount;
                    $model->save();
                    if (!empty($model_sif)) {
                        foreach ($model_sif as $eachModel) {
                            $eachModel->sif_file_id = $model->id;
                            $eachModel->save();
                        }
                    }
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }else{
                    $error2=array();
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                    $error2 = json_decode(CActiveForm::validateTabular($model_sif, '', false), true);
                    $error = CJSON::encode(array_merge_recursive($error1, $error2));
                    if ($error != '[]')
                        echo $error;
                }
            }
        }
    }
    public function actionDownloadSif() {
        $id= (int)Yii::app()->request->getParam('id');
        $model_sif=MonthlySalarySif::model()->findbyPK($id);
        $model_sif_details=MonthlySalarySifDetails::model()->findAll(array('condition'=>'sif_file_id="'.$id.'"')); 
        if($model_sif->salary_payment_mode==3){
            $employee_count=count($model_sif_details);
            $edr="EDR";
            $end_date="";
            foreach($model_sif_details as $i=>$sif_details){
                $end_date=$sif_details->end_date;
                $list[$i++]=  $edr.','.$sif_details->personal_file_no.','.$sif_details->employee_wpscode.','.$sif_details->iban_no.','.$sif_details->start_date.','.$sif_details->end_date.','.$sif_details->total_days.','.$sif_details->basic_salary.','.$sif_details->salary_amount.','.$sif_details->leave_days;

            }
            $model_wps_company_detail=MasCompanyWpsDetails::model()->findbyPK($model_sif->wpscompany_id);
            $company_code="";
            $company_bank_code="";
            if(!empty($model_wps_company_detail)){
                if($model_wps_company_detail->company_code!='' && strlen($model_wps_company_detail->company_code)==13){
                    $company_code=$model_wps_company_detail->company_code;
                }
                if($model_wps_company_detail->company_bank_code!='' && strlen($model_wps_company_detail->company_bank_code)==9){
                   $company_bank_code=$model_wps_company_detail->company_bank_code;
                }
            }
            $employer_reference_no='01';       
            $model_currency=MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id);
            $currency=$model_currency->currencydetails->currency_code;
            $list[$i++]=  'SCR,'.$company_code.','.$company_bank_code.','.date("Y-m-d").','.date("Hi").','.date("mY",strtotime($end_date)).','.$employee_count.','.$model_sif->total_amount.','.$currency.','.$employer_reference_no;
            $file_name=$company_code.date("ymd").date("His");
            $csv_file_name=$file_name.".sif";
            $file = fopen("uploads/sif/".$csv_file_name,"w");
            foreach ($list as $line){
                fputcsv($file,explode(',',$line));
            }
            fclose($file);
            $data['csv']=$list;
            $filename ='uploads/sif/'.$csv_file_name;
            header('Content-Type: application/sif');
            header("Content-disposition: attachment; filename=\"$csv_file_name\"");
            readfile($filename);
            Yii::app()->end();
            $data['status']='success';
            echo CJSON::encode($data);
        }else if($model_sif->salary_payment_mode==4){         
            $filename = 'exchange.xls';
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            $this->renderPartial('excel_exchange', array('model_sif' => $model_sif, 'model_sif_details' => $model_sif_details), false, true);
            Yii::app()->end();
        }
    }
    public function actionPrintSif() {
        $id= (int)Yii::app()->request->getParam('id');
        $type= (int)Yii::app()->request->getParam('type');
        $frm= (int)Yii::app()->request->getParam('frm');
        if($id!='' && ($type==1 || $type==2 ||$type==3 || $type==4 || $type==5)){
            if($type==1 || $type==2 || $type==4){
                $view='print_cash_cheque_details';
            }else if($type==5){
                $view='print_bank_details';
            }else{
                if($frm==1){
                    $view='print_sif_file_code';
                }else{
                    $view='print_sif_file';
                }
            }
            $model_sif=MonthlySalarySif::model()->findbyPK($id); 
            $model_sif_details=MonthlySalarySifDetails::model()->findAll(array('condition'=>'sif_file_id="'.$id.'"')); 
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.pdf.sif.'.$view.'', array('model_sif' => $model_sif, 'model_sif_details' => $model_sif_details), true));
            $mPDF1->Output('details.pdf', 'I');
        }else{
            throw new CHttpException(404, 'Page not found.');
        }
    }
    public function actiondeletesiffile(){       
        $id = $_POST['id'];
         if($id>0){            
             $model = new MonthlySalarySif();                
             $model->deleteByPk($id);
             MonthlySalarySifDetails::model()->deleteAll('sif_file_id=:refer_id', array(':refer_id' =>$id));
             $data['status']='success';
         }
         else{
            $data['status']='error';
         }      
         echo CJSON::encode($data);
    }
    public function actiondownloadexcel()
    {
        $id= (int)Yii::app()->request->getParam('id');
        $model_sif=MonthlySalarySif::model()->findbyPK($id);
        $model_sif_details=MonthlySalarySifDetails::model()->findAll(array('condition'=>'sif_file_id="'.$id.'"')); 
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25);
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'SALARY MONTH')
            ->setCellValue('B1', 'COMPANY MOLID')
            ->setCellValue('C1', 'AGENT ROUTING CODE')
            ->setCellValue('D1', 'ACCOUNT NO')
            ->setCellValue('E1', 'EMP NAME')
            ->setCellValue('F1', 'EMP MOLID')
            ->setCellValue('G1', 'NO OF LEAVE DAYS')
            ->setCellValue('H1', 'FIX AMOUNT')
            ->setCellValue('I1', 'VAR AMT')
            ->setCellValue('J1', 'TOTAL')
            ->setCellValue('K1', 'REMARKS')
            ->setCellValue('L1', 'LABOUR CARD');
        //$objPHPExcel->getActiveSheet()->getStyle('A'.$start.':L'.$end.'')->getFont()->setSize(12);
        $objPHPExcel->getActiveSheet()->getStyle('A1:L1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle("A1:L1")->getFont()->setSize(12)->setBold( true );
        $rowCount = 2;
        $start=$rowCount; $end=0;
        $model_wps_company_detail=MasCompanyWpsDetails::model()->findbyPK($model_sif->wpscompany_id);
        foreach ($model_sif_details as $j => $details) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, date("M-Y", strtotime($model_sif->date)));
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$model_wps_company_detail->company_code, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$details->employee_wpscode, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $details->iban_no);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $details->employeedetail->employeefullname);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$details->personal_file_no, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $details->leave_days);
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, Yii::app()->numberFormatter->formatCurrency($details->basic_salary," "));
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, Yii::app()->numberFormatter->formatCurrency($details->salary_amount," "));
            $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, Yii::app()->numberFormatter->formatCurrency($details->total_salary_paid," "));
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, '');
            $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(20);
            $end=$rowCount;
            $rowCount++;
        }
        $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':A'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('H'.$start.':J'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':L'.$end.'')->getFont()->setSize(12);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Exchange File');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Exchange.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public function actionExcelsheetsalary() {
        $id= (int)Yii::app()->request->getParam('id');
        $type= (int)Yii::app()->request->getParam('type');
        $model_sif_details=MonthlySalarySifDetails::model()->findAll(array('condition'=>'sif_file_id="'.$id.'"')); 
        $arr_employee=array();
        foreach ($model_sif_details as $key => $value) {
            $arr_employee[$value['employeedetail']['employeefullname']]=$value['employee_id'];
        }
        ksort($arr_employee);        
        $filename = 'WPS SALARY LIST.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('excel_salary_sheet', array( 'id' => $id,'type' => $type,'arr_employee' => $arr_employee));
        Yii::app()->end();
    }
    //added v=by DR on 17/7/2023
    public function actionSalaryTransfer() {
        $model_module_payroll= HrModules::model()->findByPK(7);
        if (((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_transfer_file_menu']) || Yii::app()->user->authorised_user == 1)) && ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y')){
            $this->render('salary_transfer');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetTransferList() {
        $model = new SalaryProcessing();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch_id = $_POST['branch_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $columns = array(
            0 => 't.id', 
            1 => 'branch_sponsor.branch_or_sponsor_name',
            2 => 't.payroll_startdate',
            3 => 't.payroll_enddate',
            4 => 't.payroll_month',
            5 => 't.payroll_status',
            6 => 't.id', 
            );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $model_user = User::model()->findByPK(Yii::app()->user->id);
        $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '"'));
        $condition= 'payroll_status=2';
        if ($branch_id == '') {
            if ($model_usergroup->salary_tab_permission != '') {
                $branch_id = $model_usergroup->salary_tab_permission;
            }
            if (Yii::app()->user->authorised_user == 1) {
                $condition.= ' AND 1=1';
            } else {
                $condition.= ' AND payroll_branch_or_sponsor_id IN(' . $branch_id . ')';
            }
        } else {
            $condition.= ' AND payroll_branch_or_sponsor_id="' . $branch_id . '"';
        }
        if ($month > 0) {
            $condition.= ' AND MONTH(payroll_enddate)="' . $month . '"';
        }
        if ($year > 0) {
            $condition.= ' AND YEAR(payroll_enddate)="' . $year . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " AND (t.payroll_month LIKE '%" . $searchString . "%' OR branch_sponsor.branch_or_sponsor_name LIKE '%" . $searchString . "%' OR DATE(t.payroll_enddate) LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('branch_sponsor')->count(array('condition' => $condition));
        $model = $model->with('branch_sponsor')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $status = array(1 => 'Unlocked', 2 => 'Locked');
        foreach ($model as $row) {
//            $div = '';
            $transfer_file=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_transfer_file_download'])  || Yii::app()->user->authorised_user == 1) {
                $transfer_file=1;
//                $div= '<a href="?r=hr/salarysif/downloadsalarytransferfile&id='.$row['id'] .'"><button class="btn btn-primary btn-xs" title="Download Salary Transfer File" ><i class="fa fa-download"></i></button></a>&nbsp;';
            }
            $rowData[] = array(++$m, $row['branch_sponsor']['branch_or_sponsor_name'], date('d/m/Y', strtotime($row['payroll_startdate'])), date('d/m/Y', strtotime($row['payroll_enddate'])), $row['payroll_month'], $status[$row['payroll_status']], array('id'=>$row['id'],'transfer_file'=>$transfer_file));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actiondownloadsalarytransferfile()
    {
        $id= (int)Yii::app()->request->getParam('id');
        $model = SalaryProcessing::model()->findbyPK($id);
        $model_salary_slip = SalarySlip::model()->findAll(array('condition'=>'salary_processing_id="'.$id.'"'));
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
        $objPHPExcel->getActiveSheet()->mergeCells('A1:A2');
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Employee ID')
            ->setCellValue('B1', 'Total Salary')
            ->setCellValue('C1', 'Variable Pay')
            ->setCellValue('D1', 'From Date (dd/mm/yyyy)')
            ->setCellValue('E1', 'To Date (dd/mm/yyyy)')
            ->setCellValue('F1', 'Days on Leave')
            ->setCellValue('G1', 'End of Service Benefits')
            ->setCellValue('B2', '(Fixed + Variable)')
            ->setCellValue('C2', '(Optional)')
            ->setCellValue('D2', '(Optional)')
            ->setCellValue('E2', '(Optional)')
            ->setCellValue('F2', '(Optional)')
            ->setCellValue('G2', '(Optional)');
        $styleArray = array(
        'borders' => array(
            'allborders' => array(
              'style' => PHPExcel_Style_Border::BORDER_NONE
            )
          )
        );
        $objPHPExcel->getActiveSheet()
        ->getStyle('A1:G2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '2b3c73')
                )
            )
        );
        $objPHPExcel->getActiveSheet()
        ->getStyle('A1:G1')
        ->applyFromArray(
            array(
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => 'ffffff'),
                    'size'  => 13,
                )
            )
        );
        $objPHPExcel->getActiveSheet()
        ->getStyle('B2:G2')
        ->applyFromArray(
            array(
                'font'  => array(
                    'color' => array('rgb' => 'eff493'),
                    'size'  => 12,
                )
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle('B')
            ->getNumberFormat()
            ->setFormatCode(
                '0.00'
        );
        $objPHPExcel->getActiveSheet()->getStyle('C')
            ->getNumberFormat()
            ->setFormatCode(
                '0.00'
        );
        $objPHPExcel->getActiveSheet()->getStyle('G')
            ->getNumberFormat()
            ->setFormatCode(
                '0.00'
        );
        $objPHPExcel->getActiveSheet()->getStyle('B2:G2')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->getStyle('A1:G2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
//        $objPHPExcel->getActiveSheet()->getStyle("A1:G2")->getFont()->setSize(14)->setBold( true );
        $rowCount = 3;
        $start=$rowCount; $end=0;
        foreach ($model_salary_slip as $j => $details) {
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $details->employeedetail->employeecode);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, number_format($details->total_salary_amount, 2, '.', ''));
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, date("d/m/Y", strtotime($model->payroll_startdate)));
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, date("d/m/Y", strtotime($model->payroll_enddate)));
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $details->absent_working_days);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, '');
            $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(20);
            $end=$rowCount;
            $rowCount++;
        }
        $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':A'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('D'.$start.':E'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('B'.$start.':C'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('G'.$start.':G'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':L'.$end.'')->getFont()->setSize(12);
        $objPHPExcel->getActiveSheet()->getStyle('A3:A'.$end.'')->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'dcf9f9')
                )
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle('B3:B'.$end.'')->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'dcf9f9')
                )
            )
        );
        $style_Array = array(
        'borders' => array(
            'allborders' => array(
              'style' => PHPExcel_Style_Border::BORDER_THIN
            )
          )
        );
        $objPHPExcel->getActiveSheet()->getStyle('A3:G'.$end.'')->applyFromArray($style_Array);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Salary');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Exchange.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
}