<?php

class RosterController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('getBranchList', 'getEmployeeList','getShiftList', 'SaveEmployeeShift', 'getlist', 'deleteshift','ViewShiftDetails', 'Index', 'print','getbranchemployee'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

   public function actiongetBranchList() {
        $data = [];
        $condition = 'isActive =  "Y" ';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' AND id IN (' . Yii::app()->user->user_branch . ')';
        }
        $model_branch = MasCompanyBranchSponsor::model()->findall(array('condition' =>$condition));
        if (!empty($model_branch)) {
            foreach ($model_branch as $row) {
                $data[] = [
                    "id" => $row->id,
                    "name" => $row['branch_or_sponsor_name'],
                ];
            }
            $response = array("status" => "success", "msg" => "success", 'data' => $data);
        } else {
            $response = array("status" => "error", "msg" => "No data available", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actiongetShiftList() {
        $data = [];
        $model_shift = MasShift::model()->findall(array('condition' => 't.isActive="Y"'));
        if (!empty($model_shift)) {
            foreach ($model_shift as $row) {
                $data[] = [
                    "id" => $row->id,
                    "name" => $row['shift_name'],
                    "start_time" => $row['start_time'],
                    "end_time" => $row['end_time'],
                    "shift_type" => $row['shift_type'],
                    "color_code" => $row['color_code'],
                ];
            }
            $response = array("status" => "success", "msg" => "success", 'data' => $data);
        } else {
            $response = array("status" => "error", "msg" => "No data available", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actiongetEmployeeList() {
        $data = [];
        $user_login_id = Yii::app()->user->id;
        $model_user = User::model()->findbypk($user_login_id);
        $model_user->hr_connected_employee_id;
        $is_reporting_manger = Employee::model()->count(array('condition' => 'reporting_manager="' . $model_user->hr_connected_employee_id . '" AND t.isActive="Y"'));       
        $branch_id = (int) $_REQUEST['branch_id'];
        $employee_id = (int) $_REQUEST['employee_id'];
        $condition = 't.isActive="Y"';
        if ($branch_id > 0) {
            $condition .= ' and t.branch_or_sponsor_id="' . $branch_id . '"';
        }
        if ($employee_id > 0) {
            $condition .= ' and t.id="' . $employee_id . '"';
        }
        if($is_reporting_manger>0){
            $condition .= ' and t.reporting_manager="' . $model_user->hr_connected_employee_id . '"';
        }
        $model_employee = Employee::model()->findall(array('condition' => $condition, 'order' => 'de_first_name'));
        if (!empty($model_employee)) {
            foreach ($model_employee as $row) {
                $data[] = [
                    "id" => $row->id,
                    "code" => $this->ciphertext($row['employee_code'], "d"),
                    "name" => $row->employeefullname,
                    "branch" => $row->branch_sponsor->branch_or_sponsor_name,
                    "designation" => $row->designationdetail->designation_name,
                ];
            }
            $response = array("status" => "success", "msg" => "success", 'data' => $data);
        } else {
            $response = array("status" => "error", "msg" => "No data available", 'data' => $data);
        }
        echo json_encode($response);
    }
    //For Saving Shift and Off
    public function actionSaveEmployeeShift() {
        $shift_id = $_POST['shift_id'];
        $branch_id = $_POST['shift_branch'];
        $employee_id=$_POST['employee_id'];
        $id = $_POST['id'];
        $from_date=date('Y-m-d', strtotime($_POST['from_date']));
        $to_date=date('Y-m-d', strtotime($_POST['from_date']));
        $model_employee = Employee::model()->findByPK($employee_id);
        if ($shift_id== 'OFF' && $shift_id != '' && $from_date != '' && $to_date != '') {
            $current_date =date('Y-m-d');
            $weekvalue = date('w', strtotime($from_date));
            $weekvalue+=1;
            $day =array(1=>"Sunday",2=>"Monday",3=>"Tuesday",4=>"Wednesday",5=>"Thursday",6=>"Friday",7=>"Saturday") ;
            if($id>0){
                $model_attendance_details = EmployeeAttendance::model()->findByPK($id);
                $model_attendance_exist = EmployeeAttendance::model()->find(array('condition' => 'id!="'.$id.'" AND attendance_date="'.$from_date.'" AND employee_id = "'.$employee_id.'"'));
                if(empty($model_attendance_exist)){
                    if((strtotime($model_attendance_details->attendance_date)!=strtotime($from_date)) && (strtotime($from_date)>strtotime($current_date))){
                        $checking_date=$model_attendance_details->attendance_date;
                        EmployeeAttendance::model()->updateByPK($model_attendance_details->id, array('attendance_date' => $from_date,'status'=>5,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s'))); 
                        $model_old_attendance_exist = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="'.$checking_date.'" AND employee_id = "'.$employee_id.'"'));
                        if(empty($model_old_attendance_exist) && (strtotime($checking_date)<strtotime($current_date))){
                            $modal_attendance= new EmployeeAttendance();
                            $modal_attendance->employee_id = $employee_id;
                            $modal_attendance->branch_or_sponsor_id = $model_employee->branch_or_sponsor_id;
                            $modal_attendance->shift_id = 0;
                            $modal_attendance->login_time = '';
                            $modal_attendance->logout_time = '';;
                            $modal_attendance->status = 2;
                            $modal_attendance->week_day = $day[$weekvalue];
                            $modal_attendance->leave_id = 0;
                            $modal_attendance->attendance_date = $checking_date;
                            $modal_attendance->created_by = Yii::app()->user->id;
                            $modal_attendance->created_date_time = date('Y-m-d H:i:s');
                            $modal_attendance->save();
                        }
                        $attendance_id=$model_attendance_details->id;
                        $response = array('status' => 'success', 'msg' => 'Off Details Added successfully', 'id' => $attendance_id);
                    }else if(strtotime($model_attendance_details->attendance_date)!=strtotime($from_date)){
                        $attendance_id=$model_attendance_details->id;
                        if($model_attendance_details->status==1){
                            $response = array('status' => 'error', 'msg' => "Attendance marked as present", 'id' => $attendance_id);
                        }else{
                            $checking_date=$model_attendance_details->attendance_date;
                            if((strtotime($checking_date)!=strtotime($from_date)) && (strtotime($checking_date)>strtotime($current_date))){
                                EmployeeAttendance::model()->deleteAll(array('condition'=>'attendance_date="'.$checking_date.'" AND employee_id = "'.$employee_id.'"'));
                            }
                            EmployeeAttendance::model()->updateByPK($model_attendance_details->id, array('attendance_date' => $from_date,'status'=>5,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s'))); 
                            $response = array('status' => 'success', 'msg' => 'Off Details Added successfully', 'id' => $attendance_id);
                        }
                    }
                }else if(!empty ($model_attendance_exist)){
                    $attendance_id=$model_attendance_exist->id;
                    if($model_attendance_exist->status==1){
                        $response = array('status' => 'error', 'msg' => "Attendance marked as present", 'id' => $model_attendance_details->id);
                    }else if($model_attendance_exist->status==3){
                        $response = array('status' => 'error', 'msg' => "Leave Data Exist", 'id' => $model_attendance_details->id);
                    }else if($model_attendance_exist->status==2){ 
                        $checking_date=$model_attendance_details->attendance_date;
                        if((strtotime($checking_date)!=strtotime($from_date)) && (strtotime($checking_date)>strtotime($current_date))){
                            EmployeeAttendance::model()->deleteAll(array('condition'=>'attendance_date="'.$checking_date.'" AND employee_id = "'.$employee_id.'"'));
                        }
                        EmployeeAttendance::model()->updateByPK($model_attendance_exist->id, array('status'=>5,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s'))); 
                        $response = array('status' => 'success', 'msg' => 'Off Details Added successfully', 'id' => $attendance_id);
                    }
                }
            }else{
                $model_attendance_exist = EmployeeAttendance::model()->find(array('condition' => 'employee_id="'.$employee_id.'" AND attendance_date="'.$from_date.'"'));
                if(!empty($model_attendance_exist)){
                    if($model_attendance_exist->status==1){
                        $response = array('status' => 'error', 'msg' => "Attendance marked as present", 'id' => $model_attendance_details->id);
                    }else{
                    $attendance_id=$model_attendance_exist->id;
                    EmployeeAttendance::model()->updateByPK($model_attendance_exist->id, array('status'=>5,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s'))); 
                        $response = array('status' => 'success', 'msg' => 'Off Details Added successfully', 'id' => $attendance_id);                       
                    }
                }else{
                    $modal_attendance= new EmployeeAttendance();
                    $modal_attendance->employee_id = $employee_id;
                    $modal_attendance->branch_or_sponsor_id = $model_employee->branch_or_sponsor_id;
                    $modal_attendance->shift_id = 0;
                    $modal_attendance->login_time = '';
                    $modal_attendance->logout_time = '';
                    $modal_attendance->status = 5;
                    $modal_attendance->week_day = $day[$weekvalue];
                    $modal_attendance->leave_id = 0;
                    $modal_attendance->attendance_date = $from_date;
                    $modal_attendance->created_by = Yii::app()->user->id;
                    $modal_attendance->created_date_time = date('Y-m-d H:i:s');
                    $modal_attendance->save();  
                $attendance_id=$modal_attendance->id;
                $response = array('status' => 'success', 'msg' => 'Off Details Added successfully', 'id' => $attendance_id);
            }
            }
        }else if ($shift_id != '' && $from_date != '' && $to_date != '') {
            $shift_group_identify = 1;
            $other=array();
            $model_shift_value = EmployeeShift::model()->find(array('select' => 'max(shift_group_identify) as shift_group_identify'));
            if ($model_shift_value->shift_group_identify > 0) {
                $shift_group_identify = $model_shift_value->shift_group_identify + 1;
            }
            $shift_existing_date=$from_date;
            $model_shift = new EmployeeShift();
            if ((int) $id > 0) {
                $model_shift = $model_shift->findByPk($id);
                $model_shift->updated_by = Yii::app()->user->id;
                $model_shift->updated_date_time = date('Y-m-d H:i:s');
                $shift_existing_date=$model_shift->from_date;
            } else {
                $model_shift->created_by = Yii::app()->user->id;
                $model_shift->created_date_time = date('Y-m-d H:i:s');
            }
            $model_shift->scenario = 'shiftadd';
            $model_shift->employee_id = $_POST['employee_id'];
            $model_shift->branch_id = $branch_id;
            $model_shift->shift_id = $shift_id;
            $model_shift->from_date = $from_date;
            $model_shift->to_date = $to_date;
            $model_shift->shift_group_identify = $shift_group_identify;
            $valid = $model_shift->validate();
            if ($model_shift->employee_id > 0 && $model_shift->employee_id != $_POST['employee_id']) {
                $valid = false;
                $other[]='You cannot drag shift details of one employee to another employee';
            }
            if ($valid) {
                $model_shift->save();
                if(strtotime($shift_existing_date)== strtotime($from_date)){
                    $this->addattendance($from_date,$employee_id);
                }else if(strtotime($shift_existing_date)!= strtotime($from_date)){
                    $this->addattendance($shift_existing_date,$employee_id);
                    $this->addattendance($from_date,$employee_id);
                }
                $response = array('status' => 'success', 'msg' => 'Shift Details Added successfully', 'id' => $model_shift->id);
            } else {
                $response = array('status' => 'failed', 'msg' => "Error in Adding Shift Details");
            }
        }else {
            $response = array('status' => 'error', 'msg' => "Input parameters missing");
        }
        echo json_encode($response);
    }
    public function actionDeleteshift() {
        $id = (int) $_REQUEST['id'];
        $shift_id = $_REQUEST['shift_id'];
        $status = "error";
        if (!empty($id)) {
            if($shift_id=='OFF'){
                $current_date =date('Y-m-d');
                $model_attendance_details = EmployeeAttendance::model()->findbyPK($id);
                $attendance_date=$model_attendance_details->attendance_date;
                if(strtotime($attendance_date)>strtotime($current_date)){
                    EmployeeAttendance::model()->deleteByPk($id);
                }else if(strtotime($attendance_date)<=strtotime($current_date)){
                    if($model_attendance_details->status==5){
                        $leave_id=0;
                        $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => 'leave_start_date <= "' . $attendance_date . '" AND  leave_end_date >="' . $attendance_date . '" AND employee_id="' . $model_attendance_details->employee_id . '" and leave_status="12"'));
                        if (!empty($arr_leave_details)) {
                            $leave_id = $arr_leave_details->id;
                            EmployeeAttendance::model()->updateByPK($model_attendance_details->id, array('status'=>3,'leave_id'=>$leave_id,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s'))); 
                        }else{
                        EmployeeAttendance::model()->updateByPK($model_attendance_details->id, array('status'=>2,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s'))); 
                    }
                }
                }
                $status = 'success';
                $message = "Off Details Deleted Successfully";
            }else if($shift_id>0){
                $model_shift_details = EmployeeShift::model()->findbyPK($id);
                $from_date=$model_shift_details->from_date;
                $employee_id=$model_shift_details->employee_id;
                EmployeeShift::model()->deleteByPk($id);
                $modal_attendance = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="'.$from_date.'" AND employee_id = "'.$employee_id.'" '));            
                if (!empty($modal_attendance)) {
                    $this->addattendance($from_date,$employee_id);
                }
                $status = 'success';
                $message = "Shift Deleted Successfully";
            }
        }
        echo json_encode(["status" => $status, "message" =>$message ]);
    }

    public function actiongetlist() {
        $branch_id = $_REQUEST['branch_id'];
        $employee_id = $_REQUEST['employee_id'];
        $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['start_date'])));
        $end_date = date('Y-m-d', strtotime(str_replace('/', '-', $_REQUEST['end_date'])));
        $rowData = array();
        $condition = "status=5";
        if ($branch_id > 0) {
            $condition.= " AND t.branch_or_sponsor_id ='" . $branch_id . "'";
        }
        if ($employee_id > 0) {
            $condition.= " AND t.employee_id ='" . $employee_id . "'";
        }
        if (!empty($start_date)) {
            $condition .= ' AND t.attendance_date >="' . $start_date . '"';
        }
        if (!empty($end_date)) {
            $condition .= ' AND t.attendance_date <="' . $end_date . '"';
        }
        $modal_attendance = EmployeeAttendance::model()->findAll(array('condition' =>  $condition,'order'=>'attendance_date asc'));
        if(!empty($modal_attendance)){
            foreach ($modal_attendance as $each) {
                if ($each->attendance_date != '0000-00-00' && $each->attendance_date != '') {
                    $attedate = date("Y/m/d", strtotime($each->attendance_date));
                }
                $rowData[] = array(
                    "id" => $each->id,
                    "branch_name" => $each['branch_sponsor']['branch_or_sponsor_name'],
                    "branch_id" => $each->branch_or_sponsor_id,
                    "shift_id" => 'OFF',
                    "emp_id" => $each->employee_id,
                    "emp_name" => $each->employeedetail->employeefullname,
                    "color_code" => '#008000',
                    "shift_name" => 'OFF',
                    "date" => $attedate, "start_time" =>'-',
                    "end_time" =>'-'
                );
            }
        }
        $condition = "1=1";
        if ($branch_id > 0) {
            $condition .= " and employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        }
        if ($employee_id > 0) {
            $condition.= " AND t.employee_id ='" . $employee_id . "'";
        }
        if (!empty($start_date)) {
            $condition .= ' AND t.from_date >="' . $start_date . '"';
        }
        if (!empty($end_date)) {
            $condition .= ' AND t.to_date <="' . $end_date . '"';
        }
        $model = EmployeeShift::model()->with('shiftdetails', 'employeedetail')->findAll(array('condition' => $condition, 'order' => 't.from_date DESC'));
        foreach ($model as $row) {
            $fromdate = "";
            $todate = "";
            if ($row['from_date'] != '0000-00-00' && $row['from_date'] != '') {
                $fromdate = date("Y/m/d", strtotime($row['from_date']));
            }
            if ($row['to_date'] != '0000-00-00' && $row['to_date'] != '') {
                $todate = date("d/m/Y", strtotime($row['to_date']));
            }
            $rowData[] = array(
                "id" => $row->id,
                "branch_name" => $row['branchdetails']['branch_or_sponsor_name'],
                "branch_id" => $row->branch_id,
                "shift_id" => $row->shift_id,
                "emp_id" => $row->employee_id,
                "emp_name" => $row->employeedetail->employeefullname,
                "color_code" => $row->shiftdetails->color_code,
                "shift_name" => $row['shiftdetails']['shift_name'],
                "date" => $fromdate,
                "start_time" => date("h:i A", strtotime($row->shiftdetails->start_time)),
                "end_time" => date("h:i A", strtotime($row->shiftdetails->end_time))
            );
        }
        if (!empty($rowData)) {
            $response = array('status' => 'success', 'msg' => 'success', 'data' => $rowData);
        } else {
            $response = array('status' => 'error', 'msg' => 'No Data Available', 'data' => $rowData);
        }
        echo json_encode($response);
    }

    public function actionViewShiftDetails() {
        $id = (int) Yii::app()->request->getParam('shift_id');
        $model_shift_details = EmployeeShift::model()->find(array('condition' => 't.id="' . $id . '"'));
        $condition = 't.id="' . $id . '"';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        $model_shift = EmployeeShift::model()->with('employeedetail')->findAll(array('condition' => $condition, 'order' => 't.id desc'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->renderPartial('view_employee_shift', array('model_shift_details' => $model_shift_details, 'model' => $model_shift), false, true);
    }
    public function actionPrint() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('print', $_REQUEST, true));
        $mPDF1->Output('Roster Details.pdf', 'I');
    }
    //add attendance
    function addattendance($from_date,$employee_id) {
        $modal_attendance = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $from_date . '" AND employee_id = "'.$employee_id.'" '));
        if (!empty($modal_attendance)) {
            $status = $modal_attendance->status;
            $login_time = $modal_attendance->login_time;
            $logout_time = $modal_attendance->logout_time;
            $attendance_date = $from_date;
            $shift_id = $shift_id;
            $weekvalue = date('w', strtotime($attendance_date));
            $weekvalue += 1;
            $weekend = 0;
            $weekend_type = '';
            $model_employee = Employee::model()->findbyPk($employee_id);
            if ($model_employee->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weekend_type = $model_employee->weekend_off1_type;
            }
            if ($model_employee->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weekend_type = $model_employee->weekend_off2_type;
            }
            if ($model_employee->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weekend_type = $model_employee->weekend_off3_type;
            }
            if ($shift_id > 0) {
                $model_shift_detail = EmployeeShift::model()->findByPK($shift_id);
                $model_master_shift = MasShift::model()->findByPK($model_shift_detail->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else {
                $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($model_employee->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
            }
            if ($weekend == 1 && $weekend_type == 'H') {
                $original_start_time = date("H:i", strtotime($model_company_shift->weekend_work_starttime));
                $original_stop_time = date("H:i", strtotime($model_company_shift->weekend_work_endtime));
            }
            $modal_attendance->updated_by = Yii::app()->user->id;
            $modal_attendance->updated_date_time = date('Y-m-d H:i:s');
            $modal_attendance->morning_late = $this->morninglate($model_employee->id, $attendance_date, $login_time);
            $modal_attendance->total_working = $this->totalworking($model_employee->id, $attendance_date, $login_time, $logout_time);
            $modal_attendance->variance_time_loss = $this->totaltimeloss($model_employee->id, $attendance_date, $login_time, $logout_time);
            $modal_attendance->excess_time = $this->excesstime($model_employee->id, $attendance_date, $login_time, $logout_time);
            $modal_attendance->shift_id = $this->shiftdetail($model_employee->id, $attendance_date);
            if ($status == 1 && $model_employee->overtime == "Y" && $login_time != '' && $logout_time != '') {
                $model_settings = HrGenerelSettings::model()->find();
                $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model_employee->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $attendance_date . '"'));
                if (!empty($model_holiday) && $model_settings->holiday_ot_from == 'O') {
                    $modal_attendance->holiday_overtime = $this->holidayasworkingovertime($model_employee->id, $attendance_date, $login_time, $logout_time);
                    $modal_attendance->night_shift_overtime = '00:00:00';
                    $modal_attendance->normal_overtime = '00:00:00';
                    $modal_attendance->weekend_overtime = '00:00:00';
                } else if (!empty($model_holiday)) {
                    $modal_attendance->holiday_overtime = $this->holidayovertime($model_employee->id, $attendance_date, $login_time, $logout_time);
                    $modal_attendance->night_shift_overtime = '00:00:00';
                    $modal_attendance->normal_overtime = '00:00:00';
                    $modal_attendance->weekend_overtime = '00:00:00';
                } else if ($model_master_shift->shift_type == 'N') {
                    $modal_attendance->night_shift_overtime = $this->nightshiftovertime($model_employee->id, $attendance_date, $login_time, $logout_time);
                    $modal_attendance->holiday_overtime = '00:00:00';
                    $modal_attendance->normal_overtime = '00:00:00';
                    $modal_attendance->weekend_overtime = '00:00:00';
                } else if ($weekend == 1) {
                    $modal_attendance->weekend_overtime = $this->weekendovertime($model_employee->id, $attendance_date, $login_time, $logout_time);
                    $modal_attendance->night_shift_overtime = '00:00:00';
                    $modal_attendance->normal_overtime = '00:00:00';
                    $modal_attendance->holiday_overtime = '00:00:00';
                } else if (empty($model_holiday)) {
                    $modal_attendance->normal_overtime = $this->normalovertime($model_employee->id, $attendance_date, $login_time, $logout_time);
                    $modal_attendance->night_shift_overtime = '00:00:00';
                    $modal_attendance->holiday_overtime = '00:00:00';
                    $modal_attendance->weekend_overtime = '00:00:00';
                }
            } else {
                $modal_attendance->night_shift_overtime = 0;
                $modal_attendance->holiday_overtime = 0;
                $modal_attendance->normal_overtime = 0;
                $modal_attendance->weekend_overtime = 0;
            }
            if ($model_master_shift->shift_type == 'N' && $status == 1) {
                $modal_attendance->night_shift_allowance = $model_shift_detail->allowance_amount;
            }
            $modal_attendance->save();
        }
        return;
    }
    //Morning Late-Start
    function morninglate($employee_id, $date, $login_time) {
        $model_general_settings = HrGenerelSettings::model()->find();
        $cool_off_time = $model_general_settings->cool_off_time;
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if ($model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }
        $mor_late = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $weektype != 'F' && $model_holiday->id == '') {
            $from_time = strtotime($login_time);
            $secs = strtotime($cool_off_time) - strtotime("00:00:00");
            $morning_start = date("H:i", strtotime($original_start_time) + $secs);
            $morning_shift_in_time = strtotime($morning_start);
            $shift_in_time = strtotime($original_start_time);
            $time_diff = $from_time - $shift_in_time;
            if ($morning_shift_in_time >= $from_time) {
                $mor_late = '00:00';
            } else {
                $mor_late = gmdate('H:i', $time_diff);
            }
        }
        return $mor_late;
    }

    //Morning Late-End
    //Total Working -Start
    function totalworking($employee_id, $date, $login_time, $logout_time) {
        $total_working = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                if ($model_master_shift->shift_type == 'N') {
                    $diff = ($working_start_time - $working_stop_time);
                } else {
                    if ($working_stop_time > $working_start_time) {
                        $diff = ($working_stop_time - $working_start_time);
                    } else {
                        $diff = ($working_start_time - $working_stop_time);
                    }
                }
            } else {
                if ($working_stop_time > $working_start_time) {
                    $diff = ($working_stop_time - $working_start_time);
                } else {
                    $diff = ($working_start_time - $working_stop_time);
                }
            }
            $total_working = gmdate('H:i', $diff);
        }
        return $total_working;
    }

    //Total Working -End
    //Total Time Loss Per Day -Start
    function totaltimeloss($employee_id, $date, $login_time, $logout_time) {
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours = $model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if ($model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }

        $total_working = $total_timeloss = '00:00';
        if ($model_holiday->id == '') {
            if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
                $working_stop_time = strtotime($login_time);
                $working_start_time = strtotime($logout_time);
                if ($working_stop_time > $working_start_time) {
                    $diff = ($working_stop_time - $working_start_time);
                } else {
                    $diff = ($working_start_time - $working_stop_time);
                }
                $total_working = $this->totalworking($employee_id, $date, $login_time, $logout_time);
                if ((strtotime($total_working) < strtotime($branch_working_hours)) && $weekend == 0) {
                    $timeloss_stop_time = strtotime($branch_working_hours);
                    $timeloss_start_time = strtotime($total_working);
                    $timeloss_diff = ($timeloss_stop_time - $timeloss_start_time);
                    $total_timeloss = gmdate('H:i', $timeloss_diff);
                }
            }
        }
        return $total_timeloss;
    }

    //Total Time Loss Per Day -End
    //Total Excess Time Per Day -Start
    function excesstime($employee_id, $date, $login_time, $logout_time) {
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours = $model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if ($model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }

        $total_working = $total_excess_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            if ($working_stop_time > $working_start_time) {
                $diff = ($working_stop_time - $working_start_time);
            } else {
                $diff = ($working_start_time - $working_stop_time);
            }
            $total_working = $this->totalworking($employee_id, $date, $login_time, $logout_time);
            if ($weekend == 1 || $model_holiday->id > 0) {
                $total_excess_time = $total_working;
            } else if (strtotime($total_working) > strtotime($branch_working_hours)) {
                $stop_time = strtotime($total_working);
                $start_time = strtotime($branch_working_hours);
                ;
                $time_excess = ($stop_time - $start_time);
                $total_excess_time = gmdate('H:i', $time_excess);
            }
        }
        return $total_excess_time;
    }

    //Total Excess Time Per Day -End
    //Holiday Overtime Calculation Beyond Working Time-Start
    function holidayasworkingovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_holiday_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_holiday_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

    //Holiday Overtime Calculation Beyond Working Time-End
    //Holiday Overtime Calculation Beyond Working Time-Start
    function holidayovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_holiday_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_holiday_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if ($diff > 0) {
                $work_time_1 = gmdate('H:i', $diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $diff);
                }
            }
        }
        return $over_time;
    }

    //Holiday Overtime Calculation Beyond Working Time-End
    //Normal Overtime Calculation-Start
    function normalovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_normal_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_normal_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

    //Normal Overtime Calculation-End
    //Weeekend Overtime Calculation-Start
    function weekendovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_weekend_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_weekend_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if ($weektype == 'F') {
                if ($diff > 0) {
                    $work_time_1 = gmdate('H:i', $diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $diff);
                    }
                }
            } else if ($weektype == 'H') {
                //Original time
                $original_start_time = strtotime($original_start_time);
                $original_stop_time = strtotime($original_stop_time);
                $original_diff = ($original_stop_time - $original_start_time);
                //Difference
                $overtime_diff = $diff - $original_diff;
                if ($overtime_diff > 0) {
                    $work_time_1 = gmdate('H:i', $overtime_diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $overtime_diff);
                    }
                }
            }
        }
        return $over_time;
    }

    //Weekend Overtime Calculation-End
    //Night Shift Overtime Calculation-Start
    function nightshiftovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_night_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_night_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

    //Night Shift Overtime Calculation-End
    function decimalHours($time) {
        $hms = explode(":", $time);
        return ($hms[0] + ($hms[1] / 60) + ($hms[2] / 3600));
    }

    function shiftdetail($employee_id, $date) {
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        $shift_id = 0;
        if ($model_shift->id > 0) {
            $shift_id = $model_shift->id;
        }
        return $shift_id;
    }
    public function actiongetbranchemployee() {
        $branch = $_POST['branch_id'];
        $user_login_id = Yii::app()->user->id;
        $model_user = User::model()->findbypk($user_login_id);
        $condition_1 = 'isActive =  "Y" ';
        $is_reporting_manger = Employee::model()->count(array('condition' => 'reporting_manager="' . $model_user->hr_connected_employee_id . '" AND t.isActive="Y"'));
        if ($is_reporting_manger > 0) {
            $condition_1 .= ' and t.reporting_manager="' . $model_user->hr_connected_employee_id . '"';
}
        if($branch>0){
            $condition_1 .= ' AND branch_or_sponsor_id IN (' . $branch . ')';
        }
        $model_employee = Employee::model()->findall(array('condition' => $condition_1, 'order' => 'de_first_name'));
        $employee_list = CHtml::listData($model_employee, 'id', 'employeenamecode');
        $jsonData['employee'] = CHtml::dropdownlist("employee_id", '', $employee_list, array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true, 'onchange' => 'setRosterTable();'));
        echo CJSON::encode($jsonData);
    }
}
