<?php

class ProductpurchaseController extends Controller {

    public $layout = 'main';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('History', 'GetList', 'Request', 'SaveProductRequest', 'Getproductdetails', 'RemoveproductPurchase', 'PurchaseApproval',
                    'GetApprovalList', 'RequestintermediateApproval', 'SaveRequestStatus', 'ViewRequest', 'DeletePurchase'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionHistory() {
        $model_module_purchase = HrModules::model()->findByPK(16);
        if ($model_module_purchase->grant_access == 1 && $model_module_purchase->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('purchase_history');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new EmployeePurchase();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = '';
        if (isset($_POST['status'])) {
            $status = $_POST['status'];
        }

        $columns = array(
            0 => 'id',
            1 => 'apply_date',
            2 => 'payment_mode',
            3 => 'grand_total',
            4 => 'status',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        /* if($columns[$_POST['order'][1]['column']]!='' && $_POST['order'][1]['dir']!='' ){
          $filterColumn1 = $columns[$_POST['order'][1]['column']];
          $filterOrder1 = $_POST['order'][1]['dir'];
          $orderBy.=','.$filterColumn1 . " " . $filterOrder1;
          } */
        $model_employee = User::model()->findbypk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $condition = 't.employee_id="' . $employee_id . '"';
        if ($status != '') {
            $condition = 't.status="' . $status . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (payment_mode LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $apply_date = "";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }
            $paymen_mode = array(1 => 'Cash', 2 => 'From Salary');
            $button_string = '';
            $edit_button =$delete_button=$view_button=0;
            if ($row['status'] == 1) {
                $edit_button =1;
                $button_string .= '<button class="btn btn-success btn-xs" title="Edit Purchase Detail" onclick="loadPopupModal(\'hr/productpurchase/request&id=' . $row['id'] . '\',\'Edit Purchase Request \',\'lg\')"><i class="fa fa-edit"></i></button>&nbsp;';
                $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete Purchase" onclick="deletepurchase(' . $row['id'] . ')"><i class="fa fa-trash "></i></a>';
                $delete_button =1;
            }
            if ($row['status'] != 1) {
                $view_button =1;
                $button_string .= '<button class="btn btn-info btn-xs" title="View Purchase Details" onclick="loadPopupModal(\'hr/productpurchase/viewrequest&id=' . $row['id'] . '\',\'View Purchase Request\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            $rowData[] = array(++$m, $apply_date, $paymen_mode[$row['payment_mode']], $row['grand_total'], EmployeePurchase::getStatus($row['status']), array('id'=>$row['id'],'edit_button'=>$edit_button,'delete_button'=>$delete_button,'view_button'=>$view_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionRequest() {
        $id = (int) Yii::app()->request->getParam('id');
        $employee_id = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $model = new EmployeePurchase();
        $model_detail = array(new EmployeePurchaseDetail());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_detail = EmployeePurchaseDetail::model()->findAll(array('condition' => 'purchase_id="' . $id . '"'));
            if (empty($model_detail)) {
                $model_detail = array(new EmployeePurchaseDetail());
            }
        }
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="8"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('purchase_request', array('model' => $model, 'model_detail' => $model_detail, 'employee_id' => $employee_id, 'model_master_approve_setting' => $model_master_approve_setting), false, true);
    }

    public function actionGetproductdetails() {
        $product_id = $_POST['product_id'];
        $model_product = HrMasProduct::model()->findbyPK($product_id);
        $jsonData['cost_price'] = $model_product->cost_price;
        $jsonData['selling_price'] = $model_product->selling_price;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionSaveProductRequest() {
        if (isset($_POST['EmployeePurchase'])) {
            $valid = true;
            $other = array();
            $model = new EmployeePurchase();
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeePurchase']['id'] > 0) {
                $model = EmployeePurchase::model()->findByPK($_POST['EmployeePurchase']['id']);
                $model->id = (int) $_POST['EmployeePurchase']['id'];
                $model->scenario = 'update';
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeePurchase'];
            $model->apply_date = date('Y-m-d');
            $model->status = 1;
            if (isset($_POST['EmployeePurchase']['function_type'])) {
                $model->function_type = $_POST['EmployeePurchase']['function_type'];
            }
            //Employee ID
            $employee_id = $_POST['EmployeePurchase']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="8"'));
            if (!empty($model_master_approve_setting)) {
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $valid = $model->validate();
            foreach ($_POST['EmployeePurchaseDetail'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model_detail[$i] = EmployeePurchaseDetail::model()->findByPK($items['id']);
                    $model_detail[$i]->updated_by = Yii::app()->user->id;
                    $model_detail[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model_detail[$i] = new EmployeePurchaseDetail();
                    $model_detail[$i]->created_by = Yii::app()->user->id;
                    $model_detail[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                $model_detail[$i]->product_id = $items['product_id'];
                $model_detail[$i]->quantity = $items['quantity'];
                $model_detail[$i]->cost = $items['cost'];
                $model_detail[$i]->amount = $items['amount'];
                $model_detail[$i]->total_amount = $items['total_amount'];
                $valid = $model_detail[$i]->validate() && $valid;
            }
            if ($valid) {
                $model->save();
                if (!empty($model_detail)) {
                    foreach ($model_detail as $eachModel) {
                        $eachModel->purchase_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="28"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(28, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($model_detail, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionRemoveproductPurchase() {
        $id = $_POST['id'];
        if ($id > 0) {
            EmployeePurchaseDetail::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionPurchaseApproval() {
        $model_module_purchase = HrModules::model()->findByPK(16);
        if ($model_module_purchase->grant_access == 1 && $model_module_purchase->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('purchase_approval');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetApprovalList() {
        $model = new EmployeePurchase();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'apply_date',
            2 => '',
            3 => 'payment_mode',
            4 => 'grand_total',
            5 => 'status',
            6 => '',
        );
        $model_employee = User::model()->findByPk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $pending_purchase = EmployeePurchase::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN(' . $pending_purchase . ')';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (apply_date LIKE '%" . $searchString . "%' OR employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'apply_date asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $approve_reject=$view_button=0;
            if ($show_approve_button == 1) { //For Approval
                $approve_reject =1;
                $button_string .= '<button class="btn btn-success btn-xs" title="Approve/Reject Purchase Request" onclick="loadPopupModal(\'hr/productpurchase/requestintermediateapproval&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Approve/Reject Purchase Request \',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
            }
            if ($row['status'] != 1) {
                $view_button =1;
                $button_string .= '<button class="btn btn-info btn-xs" title="View Purchase Details" onclick="loadPopupModal(\'hr/productpurchase/viewrequest&id=' . $row['id'] . '\',\'Purchase Request\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            $apply_date = "";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }
            $paymen_mode = array(1 => 'Cash', 2 => 'From Salary');
            $rowData[] = array(++$m, $apply_date, $row['employeedetail']['employeefullname'], $paymen_mode[$row['payment_mode']], $row['grand_total'], EmployeePurchase::getStatus($row['status']),array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'approve_reject'=>$approve_reject,'view_button'=>$view_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionRequestintermediateApproval() {
        $id = Yii::app()->request->getparam("id");
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = EmployeePurchase::model()->findbyPk($id);
        $model_detail = EmployeePurchaseDetail::model()->findAll(array('condition' => 'purchase_id="' . $id . '"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('request_intermediate_approval', array('model' => $model, 'model_detail' => $model_detail, 'level' => $level, 'final_level' => $final_level), false, true);
    }

    public function actionSaveRequestStatus() {
        if (isset($_POST['EmployeePurchase'])) {
            $model = new EmployeePurchase();
            if ((int) @$_POST['EmployeePurchase']['id'] > 0) {
                $model->id = (int) $_POST['EmployeePurchase']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->status = $_POST['EmployeePurchase']['status'];
            $model->last_approved_level = $_POST['EmployeePurchase']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($level == 1 && $final_level == 'N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2 && $final_level == 'N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level == 'N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4 && $final_level == 'N') {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5 && $final_level == 'N') {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($final_level == 'Y') {
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="29"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(29, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionViewRequest() {
        $id = Yii::app()->request->getparam("id");
        $model = EmployeePurchase::model()->findbyPk($id);
        $model_detail = EmployeePurchaseDetail::model()->findAll(array('condition' => 'purchase_id="' . $id . '"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('view_request', array('model' => $model, 'model_detail' => $model_detail), false, true);
    }

    public function actionDeletePurchase() {
        $id = $_POST['id'];
        if ($id > 0) {
            EmployeePurchase::model()->deleteByPk($id);
            EmployeePurchaseDetail::model()->deleteAll(array('condition' => 'purchase_id="' . $id . '"'));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

}
