<?php

class PensionsettingsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'deletePensionSettings', 'SavePensionSetting', 'GetList',  'Disable','changePensionScheme','getEmployeesName','GetPensionEmployeelist','SaveemployeePensionScheme'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_pensionsetting_menu']) || Yii::app()->user->authorised_user == 1) {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {

        $model = new MasPension();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'scheme_name',
            1 => 'company_percent',
            2 => 'employee_percent',
            3 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
          $condition = "t.isActive='Y' ";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
             $condition =" (t.scheme_name LIKE '%" . $searchString . "%' OR t.company_percent LIKE '%" . $searchString . "%' OR t.employee_percent LIKE '%" . $searchString . "%' OR nationality_detail.country_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('nationality_detail')->count(array('condition' => $condition));
        $model = $model->with('nationality_detail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $edit = $disable = 0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_pensionsetting_edit'])  || Yii::app()->user->authorised_user == 1) {
                $edit = 1;
//                $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/pensionsettings/create&id=' . $row['id'] . '\',\'Edit Pension Settings \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_pensionsetting_disable'])  || Yii::app()->user->authorised_user == 1) {
                $disable = 1;
//                $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletePensionSettings(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array(++$m, $row['scheme_name'], $row['company_percent'], $row['employee_percent'], array('id' => $row->id, 'status' => $row->isActive, "edit" => $edit, "disable" => $disable));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasPension();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('pension_settings_form', array('model' => $model), false, true);
    }

    public function actionSavePensionSetting() {

        $model = new MasPension();
        if (isset($_POST['MasPension'])) {
            if ((int) @$_POST['MasPension']['id'] > 0) {
                $id = (int) @$_POST['MasPension']['id'];
                $model = $model->findByPk($id);
                $model->updated_id = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d h:i:s');
               $model->scenario = 'update'; 
            } else {
                $model->created_id = Yii::app()->user->id;
                $model->created_date = date('Y-m-d h:i:s');
                $model->scenario = 'add';
            }
            if (is_array($_POST['MasPension']['salary_type'])) {
                    $arr_salarytype = implode(",", array_filter($_POST['MasPension']['salary_type']));
                    $model->salary_type = $arr_salarytype;
                }
            $model->attributes = $_POST['MasPension'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeletePensionSettings() {

        $id = $_POST['id'];
        if ($id > 0) {

            $model = new MasPension();
            $nationality = $model->findByPk($id)->nationality; // audit log changes
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'SALARY',
                Yii::app()->user->id,
                'DELETED',
                " with pension settings for : - ". AuditLog::getCountryforSalaryLog($nationality)
            );
            // end audit log
            echo "success";
        } else {
            echo "fail";
        }
    }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasPension();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    

    public function actionchangePensionScheme() {
        $model = new MasPension();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
}
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('change_pension_scheme', array('model' => $model), false, true);
    }

    public function actiongetEmployeesName() {
        $id = $_POST['id'];
        if ($id > 0) {
            $jsonData['emp_name'] = CHtml::dropdownlist("employee_id", '', Employee::getEmployeeForPension($id), array('empty' => 'Select', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionGetPensionEmployeelist() {
        $branch = Yii::app()->request->getparam('branch');
        $employee_id = Yii::app()->request->getparam('employee_id');
        $condition = 'isActive="Y" AND have_pension="1"';
        $condition .= ' AND branch_or_sponsor_id="' . $branch . '" and isActive!="B"';
        if ($employee_id > 0) {
            $condition .= ' and id="' . $employee_id . '"';
        }
        $model_employee = Employee::model()->findAll(array('condition' => $condition, 'order' => 'first_name'));
        $arr_employee = array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'], "d") . ' ' . $this->ciphertext($value['last_name'], "d")] = $value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('employee_pensions_list', array('branch' => $branch, 'employee_id' => $employee_id, 'arr_employee' => $arr_employee), false, true);
    }

    public function actionSaveemployeePensionScheme() {
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {
                if ($items['id'] > 0) {
                    $old_scheme = $items['old_employee_pension_scheme'];
                    $new_scheme = $items['employee_pension_scheme'];
                    if ($old_scheme != $new_scheme) {
                        $model_emp = Employee::model()->findByPK($items['id']);
                        $model_emp->employee_pension_scheme = $items['employee_pension_scheme'];
                        $model_emp->save(false);
                    }
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
}
