<?php
class PaymentController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','GetPendingList','ReleasePayment','SavePaymentDetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function filters() {

        return array('accessControl'); // perform access control for CRUD operations

    } 
    public function actionIndex() {
       /*  $sql="CREATE OR REPLACE VIEW `view_payment_details` AS SELECT
    `L`.`employee_id` AS `employee_id`,
    `E`.`first_name` AS `first_name`,
    `E`.`last_name` AS `last_name`,
    `E`.`employee_code` AS `employee_code`,
    `L`.`id` AS `id`,
    `L`.`approved_date` AS `approved_date`,
    `L`.`loan_amount` AS `amount`,
    `L`.`loan_status` AS `STATUS`,
    'Loan' AS `TYPE`
FROM
    (
        `erp_hr_employee_loan_detail` `L`
    JOIN `erp_hr_employee` `E` ON
        ((`L`.`employee_id` = `E`.`id`))
    )
WHERE
    (
        (`L`.`loan_posted` = 'N') AND(`L`.`loan_status` = 12)
    )
UNION
SELECT
    `S`.`employee_id` AS `employee_id`,
    `T`.`first_name` AS `first_name`,
    `T`.`last_name` AS `last_name`,
    `T`.`employee_code` AS `employee_code`,
    `S`.`id` AS `id`,
    `S`.`approved_date` AS `approved_date`,
    `S`.`amount` AS `amount`,
    `S`.`advance_payment_status` AS `STATUS`,
    'Salary Advance' AS `TYPE`
FROM
    (
        `erp_hr_employee_salary_advance` `S`
    JOIN `erp_hr_employee` `T` ON
        ((`S`.`employee_id` = `T`.`id`))
    )
WHERE
    (
        (`S`.`posted` = 'N') AND(`S`.`advance_payment_status` = 12)
    )
UNION
SELECT
    `B`.`employee_id` AS `employee_id`,
    `U`.`first_name` AS `first_name`,
    `U`.`last_name` AS `last_name`,
    `U`.`employee_code` AS `employee_code`,
    `B`.`id` AS `id`,
    `B`.`approve_date` AS `approved_date`,
    `B`.`encashment_amount` AS `amount`,
    `B`.`status` AS `STATUS`,
    'Leave Encashment' AS `TYPE`
FROM
    (
        `erp_hr_employee_leave_encashment` `B`
    JOIN `erp_hr_employee` `U` ON
        ((`B`.`employee_id` = `U`.`id`))
    )
WHERE
    (
        (`B`.`finance_posted` = 'N') AND (`B`.`status` = 12)        
    )
UNION
SELECT
    `C`.`employee_id` AS `employee_id`,
    `V`.`first_name` AS `first_name`,
    `V`.`last_name` AS `last_name`,
    `V`.`employee_code` AS `employee_code`,
    `C`.`id` AS `id`,
    `C`.`approve_date` AS `approved_date`,
    `C`.`total_amount` AS `amount`,
    `C`.`status` AS `STATUS`,
    'End of Service' AS `TYPE`
FROM
    (
        `erp_hr_employee_eos` `C`
    JOIN `erp_hr_employee` `V` ON
        ((`C`.`employee_id` = `V`.`id`))
    )
WHERE
    (
        (`C`.`finance_posted` = 'N') AND(
            (`C`.`status` = 2) OR(`C`.`status` = 4)
        )
    )
UNION
SELECT
    `D`.`employee_id` AS `employee_id`,
    `W`.`first_name` AS `first_name`,
    `W`.`last_name` AS `last_name`,
    `W`.`employee_code` AS `employee_code`,
    `D`.`id` AS `id`,
    `D`.`date_approved` AS `approved_date`,
    `D`.`settlement_amount` AS `amount`,
    `D`.`status` AS `STATUS`,
    'Leave Settlement' AS `TYPE`
FROM
    (
        `erp_hr_employee_leavesettlement` `D`
    JOIN `erp_hr_employee` `W` ON
        ((`D`.`employee_id` = `W`.`id`))
    )
WHERE
    (
        (`D`.`posted` = 'N') AND(
            (`D`.`status` = 2) OR(`D`.`status` = 4)
        )
    )
UNION
SELECT
    `F`.`employee_id` AS `employee_id`,
    `X`.`first_name` AS `first_name`,
    `X`.`last_name` AS `last_name`,
    `X`.`employee_code` AS `employee_code`,
    `F`.`id` AS `id`,
    `F`.`approved_date` AS `approved_date`,
    `F`.`total` AS `amount`,
    `F`.`status` AS `STATUS`,
    'Expense' AS `TYPE`
FROM
    (
        `erp_hr_employee_expense` `F`
    JOIN `erp_hr_employee` `X` ON
        ((`F`.`employee_id` = `X`.`id`))
    )
WHERE
    (
        (`F`.`finance_posted` = 'N') AND(`F`.`status` = 12)
    )
UNION
SELECT
    `G`.`employee_id` AS `employee_id`,
    `Y`.`first_name` AS `first_name`,
    `Y`.`last_name` AS `last_name`,
    `Y`.`employee_code` AS `employee_code`,
    `G`.`id` AS `id`,
    `G`.`approved_date` AS `approved_date`,
    `G`.`ticket_amt` AS `amount`,
    `G`.`status` AS `STATUS`,
    'Ticket Encashment' AS `TYPE`
FROM
    (
        `erp_hr_employee_ticket_encashment` `G`
    JOIN `erp_hr_employee` `Y` ON
        ((`G`.`employee_id` = `Y`.`id`))
    )
WHERE
    (
        (`G`.`finance_posted` = 'N') AND (`G`.`status` = 12)
    )"*/
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_payments_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
   public function actionGetPendingList(){
		
        $model=new EmployeePayment();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'id',
            1 =>'TYPE',
            2 =>'employee_code',
            3 =>'first_name',
            4 =>'approved_date',
            5 =>'amount',
            6 =>'STATUS',
            7=>'t.id',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employee_code LIKE '%".$searchString_en."%' OR first_name LIKE '%".$searchString_en."%' OR TYPE LIKE '%".$searchString."%' OR last_name LIKE '%".$searchString_en."%' OR TYPE LIKE '%".$searchString."%')";
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        { 
            $approved_date="";
            if($row['approved_date'] != '0000-00-00' && $row['approved_date'] !=''){
                $approved_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $status="";
            $button_string="";
            $model="";
            if($row['TYPE']=="Loan"){
                $status=EmployeeLoanDetail::getLoanStatus($row['STATUS']);
                $model="EmployeeLoanDetail";
            }else if($row['TYPE']=="Salary Advance"){
                $status=EmployeeSalaryAdvance::getStatus($row['STATUS']);
                $model="EmployeeSalaryAdvance";
            }else if($row['TYPE']=="Leave Encashment"){
                $status=EmployeeLeaveEncashment::getStatus($row['STATUS']);
                $model="EmployeeLeaveEncashment";
            }else if($row['TYPE']=="End of Service"){
                $status=EmployeeEOS::getStatus($row['STATUS']);
                $model="EmployeeEOS";
            }else if($row['TYPE']=="Leave Settlement"){
                $status=EmployeeLeavesettlement::getStatus($row['STATUS']);
                $model="EmployeeLeavesettlement";
            }else if($row['TYPE']=="Expense"){
                $status=EmployeeExpense::getStatus($row['STATUS']);
                $model="EmployeeExpense";
            }else if($row['TYPE']=="Ticket Encashment"){
                $status=EmployeeTicketEncashment::getStatus($row['STATUS']);
                $model="EmployeeTicketEncashment";
            }
            $payments_type2=$payments_type1=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_payments_add'])  || Yii::app()->user->authorised_user == 1) {          
                if($row['STATUS']==12 && ($row['TYPE']=="Loan" || $row['TYPE']=="Salary Advance" || $row['TYPE']=="Expense" || $row['TYPE']=="Ticket Encashment" || $row['TYPE']=="Leave Encashment")){
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Payment" onclick="loadPopupModal(\'hr/payment/releasepayment&id='.$row['id'].'&type='.$row['TYPE'].'&model='.$model.'\',\'PAYMENT\',\'lg\')"><i class="fa fa-money"></i></button> &nbsp;';												
                    $payments_type1=1;
                }
                if($row['STATUS']==2 && ($row['TYPE']=="End of Service" || $row['TYPE']=="Leave Settlement")){
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Payment" onclick="loadPopupModal(\'hr/payment/releasepayment&id='.$row['id'].'&type='.$row['TYPE'].'&model='.$model.'\',\'PAYMENT\',\'lg\')"><i class="fa fa-money"></i></button> &nbsp;';												
                    $payments_type2=1;
                }
            }
            $rowData[]=array($m,$row['TYPE'],$this->ciphertext($row['employee_code'],'d'),$this->ciphertext($row['first_name'],'d').' '.$this->ciphertext($row['last_name'],'d'),$approved_date,Yii::app()->numberFormatter->formatCurrency($row['amount'], ""),$status,array('id'=>$row['id'],'type'=>$row['TYPE'],'id'=>$row['id'],'model'=>$model,'payments_type1'=>$payments_type1,'payments_type2'=>$payments_type2));                                
            $m++;
        }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    
    public function actionReleasePayment(){
        $id=(int) Yii::app()->request->getParam('id');
        $modelName=Yii::app()->request->getParam('model');
        $type=Yii::app()->request->getParam('type');
        $model=new $modelName();
        $model_payment = EmployeePayment::model()->find(array('condition' => 'id="'.$id .'" and TYPE="'.$type .'"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('payment_form', array('model' => $model,'modelName'=>$modelName,'model_payment'=>$model_payment), false, true);
    }
	
    public function actionSavePaymentDetails() {
        Yii::import('application.modules.finance.models.*');
        $model_name=$_POST['modelname'];    
        $model= new $model_name();
        $id=$_POST[$model_name]['id'];
        $payment_mode=$_POST[$model_name]['payment_mode'];
        $credit_account=0;
        $cheque_date='0000-00-00';
        $cheque_no='';
        if($payment_mode==3){
            $credit_account=$_POST[$model_name]['credit_account'];
            if($_POST[$model_name]['cheque_date']!='' && $_POST[$model_name]['cheque_date']!='0000-00-00'){
                $cheque_date= date("Y-m-d", strtotime(str_replace('/', '-', $_POST[$model_name]['cheque_date'])));
            }
        }
        if($payment_mode==2){
            if($_POST[$model_name]['cheque_date']!='' && $_POST[$model_name]['cheque_date']!='0000-00-00'){
                $cheque_date= date("Y-m-d", strtotime(str_replace('/', '-', $_POST[$model_name]['cheque_date'])));
            }
            $cheque_no=$_POST[$model_name]['cheque_no']; 
        }
        $remarks=$_POST[$model_name]['remarks'];
        $arr_value=array('payment_mode' => $payment_mode,'credit_account' => $credit_account,'cheque_no' => $cheque_no,'cheque_date' => $cheque_date,'remarks' => $remarks);
        if($model_name=='EmployeeLoanDetail'){
            $arr_value['loan_status'] = 14;
            $arr_value['payment_date'] = date('Y-m-d');
        }else if($model_name=='EmployeeSalaryAdvance'){
            $arr_value['advance_payment_status'] = 14;
            $arr_value['advance_payment_date'] = date('Y-m-d');
        }else if($model_name=='EmployeeLeaveEncashment'){
            $arr_value['status'] = 14;
            $arr_value['payment_date'] = date('Y-m-d');
        }else if($model_name=='EmployeeLeavesettlement'){
            $arr_value['status'] = 4;
            $arr_value['payment_date'] = date('Y-m-d');
        }else if($model_name=='EmployeeEOS'){
            $arr_value['status'] = 4;
            $arr_value['payment_date'] = date('Y-m-d');
        }else if($model_name=='EmployeeExpense'){
            $arr_value['status'] = 14;
            $arr_value['payment_date'] = date('Y-m-d');
        }else if($model_name=='EmployeeTicketEncashment'){
            $arr_value['status'] = 14;
            $arr_value['payment_date'] = date('Y-m-d');
        }
        $model->updateByPK($id,$arr_value);
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
}