<?php

class PasswordchangeController extends Controller {

//	public function actionIndex()
//	{
//		$this->render('index');
//	}

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'ChangePassword', 'SavePassword', 'getEmployeeName','initialpasswordreset','getemployeeforreset',
                    'sendresetpassword','resetemployeepassword'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    public function actionChangePassword() {
        $branch = $_POST['branch'];
        $employee_id = $_POST['employee_id'];
        $frm_form='';
        if(isset($_POST['frm_form']) & $_POST['frm_form']>0){
            $frm_form = $_POST['frm_form'];
        }
        $condition = "isActive!='B'";
        if ($branch > 0) {
            $condition.=' AND (branch_or_sponsor_id="'.$branch.'")';
        }
        if ($employee_id > 0) {
            $condition.=' AND (id="'.$employee_id.'")';
        }
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('employee_details', array('arr_employee' => $arr_employee, 'frm_form' => $frm_form));
    }

    public function actionSavePassword() {
        if ((isset($_POST['Employee']))) {
            $n = 0;
            $validate = true;
            date_default_timezone_set("Asia/Dubai");
            foreach ($_POST['Employee'] as $i => $items) {
                $model_password = Employee::model()->findByPK($items['id']);
                if ((trim($items['user_name']) != '')) {
                    $model_employee[$n] = new Employee();
                    if ($items['id'] > 0) {
                        $model_employee[$n] = $model_employee[$n]->findByPK($items['id']);
                        $model_employee[$n]->scenario = 'password_change';
                    }
                    $password = $model_employee[$n]->password;
                    if ($items['password'] != '') {
                        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                        $password = crypt(trim($items['password']), $salt);
                        $model_employee[$n]->password = $password;
                    }
                    $model_employee[$n]->user_name = trim($items['user_name']);
                    $validate = $model_employee[$n]->validate() && $validate;
                    //Adding User
                    $model_user_account = User::model()->find(array('condition' => 'employee_id="' . $model_employee[$n]->id . '" and level="2" and company_id="'.Yii::app()->user->master_user_company_id.'"'));
                    if (!empty($model_user_account)) {
                        $model_user[$n] = User::model()->findByPK($model_user_account->id);
                        $model_user[$n]->password = $password;
                        $model_user[$n]->username = $items['user_name'];
                        $model_user[$n]->is_lead_owner = $model_employee[$n]->is_lead_owner;
                        $model_user[$n]->token = "";
                        // $validate=$model_user_account[$n]->validate() && $validate;
                    } else {
                        $model_user[$n] = new User();
                        $model_user[$n]->password = $password;
                        $model_user[$n]->username = $items['user_name'];
                        $model_user[$n]->first_name = $this->ciphertext($model_employee[$n]->first_name,"d");
                        $model_user[$n]->last_name = $this->ciphertext($model_employee[$n]->last_name,"d");
                        $model_user[$n]->company_id = Yii::app()->user->master_user_company_id;
                        $model_user[$n]->subledger_added="N";
                        $model_user[$n]->user_group_id = 37;
                        $model_user[$n]->employee_id = $model_employee[$n]->id;
                        $model_user[$n]->designation = $model_employee[$n]->designationdetail->designation_name;
                        $model_user[$n]->is_lead_owner = $model_employee[$n]->is_lead_owner;
                        $model_user[$n]->level = 2;
                        $model_user[$n]->created_by = Yii::app()->user->id;
                        $model_user[$n]->created_date_time = date('Y-m-d h:i:s');
                        // $validate=$model_user[$n]->validate() && $validate;
                    }
                    $n++;
                }
            }
            if (!empty($model_employee)) {
                if ($validate) {
                    if (!empty($model_employee)) {
                        foreach ($model_employee as $eachModel) {
                            $eachModel->save();
                        }
                    }
                    if (!empty($model_user)) {
                        foreach ($model_user as $eachModel) {
                            $eachModel->save(false);
                        }
                    }
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                } else {
                    $error1 = json_decode(CActiveForm::validateTabular($model_employee, '', false), true);
                    $error = CJSON::encode($error1);
                    if ($error != '[]')
                        echo $error;
                }
            }else {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        }
    }

    public function actiongetEmployeeName() {
        $id = $_POST['id'];
        if ($id > 0) {
            $jsonData['emp_name'] = CHtml::dropdownlist("password_employee_id", '', Employee::getEmployee($id), array('empty' => 'Select', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionInitialpasswordReset() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('initial_password_reset');
    }
    public function actiongetemployeeforreset() {
        $id = $_POST['id'];
        if ($id > 0) {
            $jsonData['emp_name'] = CHtml::dropdownlist("password_employee_id", '', Employee::getemployeeforreset($id), array('multiple'=>true,'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionsendresetpassword() { 
        $employee_array = Yii::app()->request->getparam("employee_id");
        foreach ($employee_array as $value) {
            $model_employee= Employee::model()->findbypk($value); 
            $to='';
            if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                $to=$model_employee->email;
            }
            if($to!=''){
                $model_user_account = User::model()->find(array('condition' => 'employee_id="' . $model_employee->id . '" and level="2" and company_id="'.Yii::app()->user->master_user_company_id.'"'));
                $username='';
                if ($model_user_account->id>0) {
                    $username=$model_user_account->username;
                }else{
                    $username=$this->ciphertext($model_employee->employee_code,"d");
                }
                $password = $this->generatePassword(8);
                $employee_name = ucwords($this->ciphertext($model_employee->first_name, "d")). " " .ucwords($this->ciphertext($model_employee->last_name, "d"));
                if($password!=''){
                    //Mail Setting-Start
                    $mailContent= "<div class='contentEditableContainer contentTextEditable'>
                            <div class='contentEditable' align='center'>
                                <p style='font-family: Space Grotesk,sans-serif; text-align: left;color: #3a3a3a;background: rgba(255, 255, 255, 0.96);padding: 15px;box-shadow: 1px 1px 3px rgba(0, 0, 0, 0.42);'>
                                    <b>Dear " .$employee_name.",</b><br><br><br>
                                    Please login using the details below:<br><br>
                                </p>
                                <table>
                                    <tr>
                                        <td align='center' style='padding: 7px 0;'>
                                            <div class='contentEditableContainer contentTextEditable'>
                                                <div class='contentEditable' align='center'>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align='center' bgcolor='#1A54BA' style='background: #ffffff;padding: 9px 24px;-webkit-border-radius: 4px;-moz-border-radius: 4px;border-radius: 4px;border: 1px dashed #6bc8ce;'>
                                            <div class='contentEditableContainer contentTextEditable'>
                                                <div class='contentEditable' align='center'>
                                                    <span style='color: #6bc8ce;font-weight: bold;'><span style='color:#000;font-family: Space Grotesk,sans-serif;'>Username : </span>" .$username. "</span>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align='center' style='padding: 7px 0;'>
                                            <div class='contentEditableContainer contentTextEditable'>
                                                <div class='contentEditable' align='center'>
                                                   &nbsp;
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align='center' bgcolor='#1A54BA' style='background: #ffffff;padding: 9px 24px;-webkit-border-radius: 4px;-moz-border-radius: 4px;border-radius: 4px;border: 1px dashed #6bc8ce;'>
                                            <div class='contentEditableContainer contentTextEditable'>
                                                <div class='contentEditable' align='center'>
                                                    <span style='color: #6bc8ce;font-weight: bold;'><span style='color:#000;font-family: Space Grotesk,sans-serif;'>Password : </span>".$password. "</span>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                                <br><br>
                            </div>
                        </div>";
                    $subject = 'Login Credentials';
                    $view = 'template';
                    $baseUrl = Yii::app()->getBaseUrl(true);
                    $login_url=$baseUrl.'/index.php?r=site/login';
                    $templateBody = Yii::app()->controller->renderPartial('application.views.mail.'.$view, [
                        'branch_id'=>$model_employee->branch_or_sponsor_id,
                        'message' => $mailContent,
                        'login_url'=>$login_url,
                        'title'=>$subject   
                    ], true);
                    $model_general_setting = HrGenerelSettings::model()->find();
                    $from=$model_general_setting->from_mail_id;
                    $from_name=$model_general_setting->from_mail_name;
                    $response = Yii::app()->sendGrid->sendEmail(
                        ['email' => $to],
                        ['email' => $from, 'name' => $from_name],// From
                        $subject,// Subject
                        $templateBody // Body
                    );
                    //Mail Setting-End
                    if($response){
                        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                        $encrypt_password = crypt(trim($password), $salt);
                        $model_employee->password = $encrypt_password;
                        $model_employee->updated_by = Yii::app()->user->id;
                        $model_employee->updated_date_time = date('Y-m-d H:i:s');  
                        $model_employee->save(); //Employee Table update
                        //Adding to User Table
                        if ($model_user_account->id>0) {
                            User::model()->updateByPK($model_user_account->id, array('password' => $encrypt_password,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')));
                        } else {
                            $model_user = new User();
                            $model_user->password = $encrypt_password;
                            $model_user->username = $username;
                            $model_user->first_name = $this->ciphertext($model_employee->first_name,"d");
                            $model_user->last_name = $this->ciphertext($model_employee->last_name,"d");
                            $model_user->company_id = Yii::app()->user->master_user_company_id;
                            $model_user->subledger_added="N";
                            $model_user->user_group_id = 9999;
                            $model_user->employee_id = $model_employee->id;
                            $model_user->designation = $model_employee->designationdetail->designation_name;
                            $model_user->is_lead_owner = $model_employee->is_lead_owner;
                            $model_user->level = 2;
                            $model_user->created_by = Yii::app()->user->id;
                            $model_user->created_date_time = date('Y-m-d H:i:s');
                            $model_user->save();
                        }
                        //End User Table Add
                        //Initialize table add-start
                        $model_password_reset = new HrInitialPasswordReset();
                        $model_password_reset->employee_id = $model_employee->id;
                        $model_password_reset->username = $username;
                        $model_password_reset->encrypted_password = $encrypt_password;
                        $model_password_reset->normal_password = $password;
                        $model_password_reset->mail_status = 'Y';
                        $model_password_reset->created_by = Yii::app()->user->id;
                        $model_password_reset->created_date_time = date('Y-m-d H:i:s');
                         $model_password_reset->save();
                        //Initialize table add-end
                    }
                }
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionresetemployeepassword() { 
        $employee_id = Yii::app()->request->getparam("id");
        $model_employee= Employee::model()->findbyPk($employee_id);   
        $to='';
        if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
            $to=$model_employee->email;
        }
        if($to!=''){
            $model_user_account = User::model()->find(array('condition' => 'employee_id="' . $model_employee->id . '" and level="2" and company_id="'.Yii::app()->user->master_user_company_id.'"'));
            $username='';
            if ($model_user_account->id>0) {
                $username=$model_user_account->username;
            }else{
                $username=$this->ciphertext($model_employee->employee_code,"d");
            }
            $password = $this->generatePassword(8);
            $employee_name = ucwords($this->ciphertext($model_employee->first_name, "d")). " " .ucwords($this->ciphertext($model_employee->last_name, "d"));
            if($password!=''){
                //Mail Setting-Start
                $mailContent= "<div class='contentEditableContainer contentTextEditable'>
                        <div class='contentEditable' align='center'>
                            <p style='text-align: left;color: #3a3a3a;background: rgba(255, 255, 255, 0.96);padding: 15px;font-family: Space Grotesk,sans-serif;box-shadow: 1px 1px 3px rgba(0, 0, 0, 0.42);'>
                                <b>Dear " .$employee_name.",</b><br><br><br>
                                Please login using the details below:<br><br>
                            </p>
                            <table>
                                <tr>
                                    <td align='center' style='padding: 7px 0;font-family: Space Grotesk,sans-serif;'>
                                        <div class='contentEditableContainer contentTextEditable'>
                                            <div class='contentEditable' align='center'>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td align='center' bgcolor='#1A54BA' style='background: #ffffff;padding: 9px 24px;-webkit-border-radius: 4px;-moz-border-radius: 4px;border-radius: 4px;border: 1px dashed #6bc8ce;'>
                                        <div class='contentEditableContainer contentTextEditable'>
                                            <div class='contentEditable' align='center'>
                                                <span style='color: #6bc8ce;font-weight: bold;'><span style='color:#000;font-family: Space Grotesk,sans-serif;'>Username : </span>" .$username. "</span>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td align='center' style='padding: 7px 0;'>
                                        <div class='contentEditableContainer contentTextEditable'>
                                            <div class='contentEditable' align='center'>
                                               &nbsp;
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td align='center' bgcolor='#1A54BA' style='background: #ffffff;padding: 9px 24px;-webkit-border-radius: 4px;-moz-border-radius: 4px;border-radius: 4px;border: 1px dashed #6bc8ce;'>
                                        <div class='contentEditableContainer contentTextEditable'>
                                            <div class='contentEditable' align='center'>
                                                <span style='color: #6bc8ce;font-weight: bold;'><span style='color:#000;font-family: Space Grotesk,sans-serif;'>Password : </span>".$password. "</span>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                            <br><br>
                        </div>
                    </div>";
                $subject = 'Login Credentials';
                $view = 'template';
                $baseUrl = Yii::app()->getBaseUrl(true);
                $login_url=$baseUrl.'/index.php?r=site/login';
                $templateBody = Yii::app()->controller->renderPartial('application.views.mail.'.$view, [
                    'branch_id'=>$model_employee->branch_or_sponsor_id,
                    'message' => $mailContent,
                    'login_url'=>$login_url,
                    'title'=>$subject   
                ], true);
                $model_general_setting = HrGenerelSettings::model()->find();
                $from=$model_general_setting->from_mail_id;
                $from_name=$model_general_setting->from_mail_name;
                $response = Yii::app()->sendGrid->sendEmail(
                    ['email' => $to],
                    ['email' => $from, 'name' => $from_name],// From
                    $subject,// Subject
                    $templateBody // Body
                );
                //Mail Setting-End
                if($response){
                    $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                    $encrypt_password = crypt(trim($password), $salt);
                    $model_employee->password = $encrypt_password;
                    $model_employee->updated_by = Yii::app()->user->id;
                    $model_employee->updated_date_time = date('Y-m-d H:i:s');
                    $model_employee->save(); //Employee Table update
                    //Adding to User Table
                    if ($model_user_account->id>0) {
                        User::model()->updateByPK($model_user_account->id, array('password' => $encrypt_password,'updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')));
                    } else {
                        $model_user = new User();
                        $model_user->password = $encrypt_password;
                        $model_user->username = $username;
                        $model_user->first_name = $this->ciphertext($model_employee->first_name,"d");
                        $model_user->last_name = $this->ciphertext($model_employee->last_name,"d");
                        $model_user->company_id = Yii::app()->user->master_user_company_id;
                        $model_user->subledger_added="N";
                        $model_user->user_group_id = 9999;
                        $model_user->employee_id = $model_employee->id;
                        $model_user->designation = $model_employee->designationdetail->designation_name;
                        $model_user->is_lead_owner = $model_employee->is_lead_owner;
                        $model_user->level = 2;
                        $model_user->created_by = Yii::app()->user->id;
                        $model_user->created_date_time = date('Y-m-d H:i:s');
                        $model_user->save();
                    }
                    //End User Table Add
                    //Initialize table add-start
                    $model_password_reset = new HrInitialPasswordReset();
                    $model_password_reset->employee_id = $model_employee->id;
                    $model_password_reset->username = $username;
                    $model_password_reset->encrypted_password = $encrypt_password;
                    $model_password_reset->normal_password = $password;
                    $model_password_reset->mail_status = 'Y';
                    $model_password_reset->created_by = Yii::app()->user->id;
                    $model_password_reset->created_date_time = date('Y-m-d H:i:s');
                    $model_password_reset->save();
                    //Initialize table add-end
                }
            }
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function generatePassword($length = 8) {
        $password = "";
        $possible = "2346789bcdfghjkmnpqrtvwxyzBCDFGHJKLMNPQRTVWXYZ";
        $maxlength = strlen($possible);
        if ($length > $maxlength) {
            $length = $maxlength;
        }
        $i = 0;
        while ($i < $length) {
            $char = substr($possible, mt_rand(0, $maxlength - 1), 1);
            $password .= $char;
            $i++;
        }
        $model_password_exist = HrInitialPasswordReset::model()->find(array('condition' => 'normal_password="'.$password.'"'));
        if(!empty($model_password_exist)){
            $this->generatePassword(5);
        }else{
            return $password;
        }
    }
}
