<?php

class MastersettingsController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('SettingsLogin', 'MasSettingsLogin', 'Index', 'SavemoduleDetails', 'Iindex', 'package', 'SavePackageDetails',
                    'SaveSettings', 'SavecurrentPackage', 'SaveuploadSize','RestorePackage'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionSettingsLogin() {
        $model = new HrMasSettingsLogin();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('settings_login_form', array('model' => $model));
    }

    public function actionMasSettingsLogin() {
        $model = new HrMasSettingsLogin();
        if (isset($_POST['HrMasSettingsLogin'])) {
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $password = crypt($_POST['HrMasSettingsLogin']['password'], $salt);
            $model_login = HrMasSettingsLogin::model()->find();
            if ($model_login->password != $password) {
                $error['status'] = "error";
                $error['msg'] = "Invalid password!";
            } else {
                Yii::app()->session['master_settings_login'] = $model_login->id;
                $error['status'] = "success";
                $error['msg'] = "Login Success";
            }
            echo CJSON::encode($error);
        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionIndex() {
        if (Yii::app()->session['master_settings_login'] != '') {
            $model_hr_modules = HrModules::model()->findAll(array('order' => 'id asc'));
            $model = HrGenerelSettings::model()->find();
            $model_packages = HrSoftwarePackage::model()->findAll(array('condition' => 'isActive="Y"'));
            $model_upload = HrMasterUpload::model()->findAll();
            $model_my_packages = HrSoftwarePackage::model()->findbyPK($model->package_id);
            $company_id=0;
            if(isset(Yii::app()->user->master_user_company_id)){
                $company_id=Yii::app()->user->master_user_company_id;
                $model_company = MasCompany::model()->findbyPK($company_id);
            }
            //Employee Count
            $employee_count = Employee::model()->count();
            //Branch Count
            $branch_count = MasCompanyBranchSponsor::model()->count();
            //Admin Count
            $user_count = User::model()->count(array('condition' => 'company_id=' . Yii::app()->user->master_user_company_id . ' AND level="1"'));
            $this->render('iindex', array('employee_count' => $employee_count,'branch_count' => $branch_count,'user_count' => $user_count,'model_my_packages' => $model_my_packages, 'model_company' => $model_company, 'model_upload' => $model_upload, 'model_hr_modules' => $model_hr_modules, 'model' => $model, 'model_packages' => $model_packages), false, true);
        } else {
            $this->redirect('index.php?r=site/index');
        }
    }

    public function actionIindex() {
        if (Yii::app()->session['master_settings_login'] != '') {
            $model_hr_modules = HrModules::model()->findAll(array('order' => 'id asc'));
            $model = HrGenerelSettings::model()->find();
            $this->render('index', array('model_hr_modules' => $model_hr_modules, 'model' => $model), false, true);
        } else {
            $this->redirect('index.php?r=site/index');
        }
    }

    public function actionSavemoduleDetails() {
        if (isset($_POST['HrGenerelSettings'])) {
            $valid = true;
            if ((int) @$_POST['HrGenerelSettings']['id'] > 0) {
                $model_settings = HrGenerelSettings::model()->findByPK($_POST['HrGenerelSettings']['id']);
                $model_settings->id = (int) $_POST['HrGenerelSettings']['id'];
            }
            $model_settings->attributes = $_POST['HrGenerelSettings'];
            if (isset($_POST['HrGenerelSettings']['pending_leave_view']) && count($_POST['HrGenerelSettings']['pending_leave_view']) > 0) {
                $model_settings->pending_leave_view = implode(',', $_POST['HrGenerelSettings']['pending_leave_view']);
            } else {
                $model_settings->pending_leave_view = "";
            }
            $valid = $model_settings->validate();
            foreach ($_POST['HrModules'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = HrModules::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new HrModules();
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                $model[$i]->attributes = $_POST['HrModules'][$i];
                $valid = $model[$i]->validate() && $valid;
            }
            if ($valid) {
                $model_settings->save();
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    //9/6/2025
    public function actionPackage() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrSoftwarePackage();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('package_details', array('model' => $model), false, true);
    }

    public function actionSavePackageDetails() {
        $model = new HrSoftwarePackage();
        if (isset($_POST['HrSoftwarePackage'])) {
            if ((int) @$_POST['HrSoftwarePackage']['id'] > 0) {
                $model = HrSoftwarePackage::model()->findByPK($_POST['HrSoftwarePackage']['id']);
                $model->id = (int) $_POST['HrSoftwarePackage']['id'];
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['HrSoftwarePackage'];
            if (isset($_POST['HrSoftwarePackage']['description']) && $_POST['HrSoftwarePackage']['description'] != '') {
                $model->description = $_POST['HrSoftwarePackage']['description'];
            }
            if (isset($_POST['HrSoftwarePackage']['package_details']) && $_POST['HrSoftwarePackage']['package_details'] != '') {
                $model->package_details = implode(',', $_POST['HrSoftwarePackage']['package_details']);
            }
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSaveSettings() {
        if (isset($_POST['HrGenerelSettings'])) {
            if ((int) @$_POST['HrGenerelSettings']['id'] > 0) {
                $model_settings = HrGenerelSettings::model()->findByPK($_POST['HrGenerelSettings']['id']);
                $model_settings->id = (int) $_POST['HrGenerelSettings']['id'];
            }
            $model_settings->attributes = $_POST['HrGenerelSettings'];
            $model_settings->app_update_details = $_POST['HrGenerelSettings']['app_update_details'];
            $model_settings->app_force_update = $_POST['HrGenerelSettings']['app_force_update'];
            $model_settings->app_android_link = $_POST['HrGenerelSettings']['app_android_link'];
            $model_settings->app_ios_link = $_POST['HrGenerelSettings']['app_ios_link'];
            if (isset($_POST['HrGenerelSettings']['pending_leave_view']) && count($_POST['HrGenerelSettings']['pending_leave_view']) > 0) {
                $model_settings->pending_leave_view = implode(',', $_POST['HrGenerelSettings']['pending_leave_view']);
            } else {
                $model_settings->pending_leave_view = "";
            }
            if ($model_settings->validate()) {
                $model_settings->save();
                //Updating Module Details Based on Package
                if ($_POST['HrGenerelSettings']['old_package_id'] != $_POST['HrGenerelSettings']['package_id']) {
                    $model_my_packages = HrSoftwarePackage::model()->findbyPK($_POST['HrGenerelSettings']['package_id']);
                    if ($model_my_packages->package_details != '') {
                        HrModules::model()->updateAll(array('grant_access' => 0));
                        $arr_package_details = explode(',', $model_my_packages->package_details);
                        foreach ($arr_package_details as $module_id) {
                            HrModules::model()->updateByPK($module_id, array('grant_access' => 1, 'isActive' => 'Y', 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                        }
                    }
                }
                //Mascompany
                if (isset($_POST['MasCompany']) && $_POST['MasCompany']['id']) {
                    $model_company = MasCompany::model()->findbyPK($_POST['MasCompany']['id']);
                    if (!empty($model_company)) {
                        $company_id=$_POST['MasCompany']['id'];
                        MasCompany::model()->updateByPK($company_id, array('total_branches_allowed' => $_POST['MasCompany']['total_branches_allowed'],'total_employees_allowed' => $_POST['MasCompany']['total_employees_allowed']));
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model_settings, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSavecurrentPackage() {
        if (isset($_POST['HrModules'])) {
            $valid = true;
            foreach ($_POST['HrModules'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = HrModules::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new HrModules();
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                $model[$i]->attributes = $_POST['HrModules'][$i];
                $valid = $model[$i]->validate() && $valid;
            }
            if ($valid) {
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSaveuploadSize() {
        if (isset($_POST['HrMasterUpload'])) {
            $valid = true;
            foreach ($_POST['HrMasterUpload'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = HrMasterUpload::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new HrMasterUpload();
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                $model[$i]->attributes = $_POST['HrMasterUpload'][$i];
                $checked=$_POST['HrMasterUpload'][$i]['isActive'];
                if($checked==1){
                    $model[$i]->isActive ='Y';
                }else {
                    $model[$i]->isActive ='N';
                }
                $valid = $model[$i]->validate() && $valid;
            }
            if ($valid) {
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionRestorePackage() {
        if (isset($_POST['HrModules'])) {
            $model_settings = HrGenerelSettings::model()->find();
            $package_id=$model_settings->package_id;
            //Updating Module Details Based on Package
            $model_my_packages = HrSoftwarePackage::model()->findbyPK($package_id);
            if ($model_my_packages->package_details != '') {
                HrModules::model()->updateAll(array('grant_access' => 0));
                $arr_package_details = explode(',', $model_my_packages->package_details);
                foreach ($arr_package_details as $module_id) {
                    HrModules::model()->updateByPK($module_id, array('grant_access' => 1, 'isActive' => 'Y', 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

}
