<?php

class MasshiftController extends Controller
{

    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteShift','SaveShiftTime','GetList','DirectAdd', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_shifttimings_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
         }
         
        public function actionGetList()
         {
 
            $model=new MasShift();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'shift_name',
                   1 =>'start_time',
                   2 =>'end_time',
                   3 =>'t.id',
                );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (shift_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=$offset;
                foreach ($model as $row)
                {
                    $edit = $disable = 0;
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_shifttimings_edit'])  || Yii::app()->user->authorised_user == 1) {
                        $edit = 1;
//                        $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/masshift/create&id='.$row['id'].'\',\'Edit Shift   \',\'lg\')"><i class="fa fa-edit"></i></button>';
                    }
                    $modelshift = EmployeeShift::model()->find(array('condition' =>'shift_id="'.$row['id'].'"'));
                    if(empty($modelshift)){
                        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_shifttimings_disable'])  || Yii::app()->user->authorised_user == 1) {
                            $disable = 1;
//                            $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="DeleteShift('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';                      
                        }
                    }
                    $start_time = date("h:i A", strtotime($row['start_time']));
                    $end_time   = date("h:i A", strtotime($row['end_time']));
                    $rowData[]=array(++$m,$row['shift_name'],$start_time,$end_time, array("id" => $row->id, 'status' => $row->isActive, "edit" => $edit, "disable" => $disable));
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model       = new MasShift(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                   
            
       Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('shift_time_form', array('model' => $model), false, true);
    }
    public function actionSaveShiftTime() {
        
         $model = new MasShift;
        if (isset($_POST['MasShift'])) {
            if ((int) @$_POST['MasShift']['id'] > 0) {
                $model->id = (int) $_POST['MasShift']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
               $model->scenario = 'update';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'add';
            }
            $model->attributes   = $_POST['MasShift'];   
            $model->color_code   = $_POST['MasShift']['color_code'];   
            if ($model->validate()) {
                $model->save();

              

                $model->refresh();
                    $jsonData['model'] = 'MasShift';
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);          
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
          
    }
    public function actionDeleteShift() {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id != 0) {
            MasShift::model()->updateByPK($id, array('isActive' => 'N'));
            $model = new MasShift(); 
            $del = $model->findByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                                        'SHIFT_TIMINGS',
                                        Yii::app()->user->id,
                                        'DELETED',
                                        " with shift name : - {$del->shift_name}  "
            );
            // end audit log 
            echo CJSON::encode(array('status' => 'success'));
        }
    }
        
         public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasShift();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
  
}