<?php

class MassalarytypeController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','deleteSalaryType','SaveSalaryType','GetList','DirectAdd', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_type_menu']) || Yii::app()->user->authorised_user == 1) {    
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
         
        public function actionGetList()
         {
 
            $model=new MasSalarytype();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'salary_name',
                   1 =>'salary_type',
                   2 =>'salary_occurence',
                   3 =>'t.id'
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (salary_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $button_string="";
                    
                    if ((isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_type_edit'])  || Yii::app()->user->authorised_user == 1) && $row['id']!=19) {
                        $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/massalarytype/create&id='.$row['id'].'\',\'Edit Salary Type\',\'lg\')"><i class="fa fa-edit"></i></button>';
                    }
//                    $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteSalaryType('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';                       
                    $type   = array(1=>"Addition",2=>"Deduction");
                    $occurence   = array(1=>"Variable/Single",2=>"Fixed");
                    $rowData[] = array($m, $row['salary_name'], $type[$row['salary_type']], $occurence[$row['salary_occurence']], array("id" => $row->id, "status" => $row->isActive));
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasSalarytype(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                   
            
       Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('salary_type_form', array('model' => $model), false, true);
    }
    public function actionSaveSalaryType()
        {
            $model = new MasSalarytype();
            if (isset($_POST['MasSalarytype']))
            {
                $model->isActive = "Y";

                if ((int) @$_POST['MasSalarytype']['id'] > 0)
                {
                    $id= (int) @$_POST['MasSalarytype']['id'];
                    $model=$model->findByPk($id); 
                    $model->scenario = 'update'; 
                }else{
                 $model->scenario = 'add';
             }
             $model->attributes=$_POST['MasSalarytype'];
             if($model->save())
             { 
                //Leave Table Updation
                $model_mas_leave = new MasLeave();
                if(isset($_POST['leave_details_id'])){
                    $leave_ids= array();
                    if(count($_POST['leave_details_id'])>0){
                        foreach ($_POST['leave_details_id'] as $value) {
                            $salary_deduction_components='';
                            $leave_ids[]=$value;
                            $model_master_leave = $model_mas_leave->findbyPK($value);
                            $arr_salary_deduction_components=array();
                            if($model_master_leave->salary_deduction_components!=''){
                                $arr_salary_deduction_components=explode(',',$model_master_leave->salary_deduction_components);
                            }
                            $arr_salary_deduction_components[]=$model->id;
                            $arr_salary_deduction_components = array_unique($arr_salary_deduction_components);
                            if(count($arr_salary_deduction_components)>1){
                                $salary_deduction_components=implode(',',$arr_salary_deduction_components);
                            }else if(count($arr_salary_deduction_components)==1){
                                $salary_deduction_components=reset($arr_salary_deduction_components);
                            }else{
                                $salary_deduction_components='';
                            }
                            $model_mas_leave->updateByPK($value, array('salary_deduction_components' =>$salary_deduction_components, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                        }
                        $leave_id='';
                        if(count($leave_ids)>0){
                            $leave_id=implode(',',$leave_ids);
                        }
                            //Resetting others
                        $model_deduction_leave_details = $model_mas_leave->findAll(array('condition' => 'id NOT IN(' .$leave_id . ') AND FIND_IN_SET(' . $model->id . ', salary_deduction_components) > 0'));
                        foreach ($model_deduction_leave_details as $f=>$value) {
                            $salary_deduction_components='';
                            $arr_salary_deduction_components=array();
                            if($value->salary_deduction_components!=''){
                                $arr_salary_deduction_components=explode(',',$value->salary_deduction_components);
                            }
                            $remove_id =$model->id;
                            $key = array_search($remove_id, $arr_salary_deduction_components);
                            if ($key !== false) {
                                unset($arr_salary_deduction_components[$key]);
                            }
                            $arr_salary_deduction_components = array_unique($arr_salary_deduction_components);
                            if(count($arr_salary_deduction_components)>1){
                                $salary_deduction_components=implode(',',$arr_salary_deduction_components);
                            }else{
                                $salary_deduction_components=$arr_salary_deduction_components[0];
                            }
                            $model_mas_leave->updateByPK($value->id, array('salary_deduction_components' =>$salary_deduction_components, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                        }
                    }
                }else{
                    $model_deduction_leave_details = $model_mas_leave->findAll(array('condition' => 'salary_deduction!="N" AND FIND_IN_SET(' . $model->id . ', salary_deduction_components) > 0'));
                    foreach ($model_deduction_leave_details as $f=>$value) {
                        $salary_deduction_components='';
                        $arr_salary_deduction_components=array();
                        if($value->salary_deduction_components!=''){
                            $arr_salary_deduction_components=explode(',',$value->salary_deduction_components);
                        }
                        $remove_id =$model->id;
                        $key = array_search($remove_id, $arr_salary_deduction_components);
                        if ($key !== false) {
                            unset($arr_salary_deduction_components[$key]);
                        }
                        $arr_salary_deduction_components = array_unique($arr_salary_deduction_components);
                        if(count($arr_salary_deduction_components)>1){
                            $salary_deduction_components=implode(',',$arr_salary_deduction_components);
                        }else{
                            $salary_deduction_components=$arr_salary_deduction_components[0];
                        }
                        
                        $model_mas_leave->updateByPK($value->id, array('salary_deduction_components' =>$salary_deduction_components, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                    }
                }
                //pension settings
                if ($_POST['MasSalarytype']['salary_occurence']=='2' && $_POST['MasSalarytype']['salary_type']=='1' && ((empty($_POST['MasSalarytype']['id']) || (int) $_POST['MasSalarytype']['id'] <= 0))) {
                    $model_mas_pension = new MasPension();
                    $model_pension_details = $model_mas_pension->findAll(array('condition' => 'isActive="Y"'));
                    foreach ($model_pension_details as $j => $value) {
                        $salary_pension_types = '';
                        $arr_salary_type = array();
                        if ($value->salary_type != '') {
                            $arr_salary_type = explode(',', $value->salary_type);
                        }
                        $arr_salary_type[] = $model->id;
                        if (count($arr_salary_type) > 1) {
                            $salary_pension_types = implode(',', $arr_salary_type);
                        } else {
                            $salary_pension_types = $arr_salary_type[0];
                        }
                        $model_mas_pension->updateByPK($value->id, array('salary_type' => $salary_pension_types, 'updated_date' => date('Y-m-d H:i:s'), 'updated_id' => Yii::app()->user->id));
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                           // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                   echo $error;
           }
       }
    }
        public function actiondeleteSalaryType(){
        
            $id = $_POST['id'];
            if($id>0){
            
                $model = new MasSalarytype();   
                $del = $model->findByPk($id);              
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'SALARY',
                    Yii::app()->user->id,
                    'DELETED',
                    " with salary type name : - {$del->salary_name}  "
                );
                // end audit log 
                echo "success";
            }
            else{
                echo "fail";
            }
        
        }
         public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasSalarytype();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }   
  
}