<?php

class MasleaveController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetLeaveList', 'Create', 'SaveDetail', 'Disable','getbranchemployee','getbranchmasterleave','getbranchleave','getleavebybranch','getbranchemployeebygender'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_leave_type_menu']) || Yii::app()->user->authorised_user == 1) {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetLeaveList() {

        $model = new MasLeave();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch = $_POST['branch'];
        $leavetype = $_POST['leave_type'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'leave_name',
            2 => 'leave_abbreviation',
            3 => 'leave_type',
            4 => 'leave_days',
            5 => 'encashable',
            6 => 'carry_forward',
            7 => 'isActive',
            8 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if($branch >0){
           $condition .= ' AND branch_id="'.$branch.'"'; 
        }
        if($leavetype >0){
           $condition .= ' AND id="'.$leavetype.'"'; 
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (leave_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m =$offset;
        foreach ($model as $row) {
            $edit=$disable=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_leave_type_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit=1;
//                $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/masleave/create&id=' . $row['id'] . '\',\'Edit Leave Type \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_leave_type_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable=1;
            }
            $leave_type = "";
            if ($row['leave_type'] == 1) {
                $leave_type = "Monthly Incremented";
            } else if ($row['leave_type'] == 2) {
                $leave_type = "Yearly";
            } else {
                $leave_type = "None";
            }
            $rowData[] = array(++$m, $row['branch']['branch_or_sponsor_name'],$row['leave_name'], $row['leave_abbreviation'], $leave_type, $row['leave_days'], $row['additional_leave'], $row['encashable'], $row['carry_forward'], array('id' => $row->id,'status' => $row->isActive,"edit" => $edit,"disable" =>$disable));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasLeave();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveDetail() {
        $model = new MasLeave();
        if (isset($_POST['MasLeave'])) {

            if ((int) @$_POST['MasLeave']['id'] > 0) {
                $id = (int) @$_POST['MasLeave']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'update';
            } else {
               $model->scenario = 'add';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['MasLeave'];
            $model->apply_before = $_POST['MasLeave']['apply_before'];
            $model->additional_leave = $_POST['MasLeave']['additional_leave'];
            $model->leave_days_above_1 = $_POST['MasLeave']['leave_days_above_1'];
            if (isset($_POST['MasLeave']['employee_id']) && count($_POST['MasLeave']['employee_id']) > 0) {
                $model->employee_id = implode(',', $_POST['MasLeave']['employee_id']);
            } else {
                $model->employee_id = "";
            }
            if (isset($_POST['MasLeave']['salary_deduction']) && $_POST['MasLeave']['salary_deduction']!= "N") {
                if (isset($_POST['MasLeave']['salary_deduction_components']) && count($_POST['MasLeave']['salary_deduction_components']) > 0) {
                    $model->salary_deduction_components = implode(',', $_POST['MasLeave']['salary_deduction_components']);
                } else {
                    $model->salary_deduction_components = "";
                }
            }else{
                $model->salary_deduction_components = "";
            }
            if ($_POST['MasLeave']['ticket_available'] == 1) {
                $model->ticket_available = "Y";
            } else {
                $model->ticket_available = "N";
            }
            if ($_POST['MasLeave']['document_medical_certificate_upload'] == 1) {
                $model->document_medical_certificate_upload = "Y";
            } else {
                $model->document_medical_certificate_upload = "N";
            }
            if ($_POST['MasLeave']['carry_forward'] == "N") {
                $model->carry_forward_limit = "N";
                $model->carry_forward_leave = 0;
            }
            if ($_POST['MasLeave']['parent_id']>0) {
                $model->sub_type_leave = "Y";
            }else{
                $model->sub_type_leave = "N";
            }
            if ($_POST['MasLeave']['negative_leave_apply_permission']== "N") {
                $model->negative_leave_apply_permission = "N";
                $model->salary_deduction_negative_leave ="N";
            }else{
                $model->negative_leave_apply_permission =$_POST['MasLeave']['negative_leave_apply_permission'];
                $model->salary_deduction_negative_leave =$_POST['MasLeave']['salary_deduction_negative_leave'];
            }
            if ($_POST['MasLeave']['leave_apply_limit']== "N") {
                $model->leave_apply_limit = "N";
                $model->max_leave_apply =0;
            }else{
                $model->leave_apply_limit =$_POST['MasLeave']['leave_apply_limit'];
                $model->max_leave_apply =$_POST['MasLeave']['max_leave_apply'];
            }
            if ($model->save()) {
               
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasLeave();
        $model = $model->findByPk($id);
        if($status){
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        }
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    public function actiongetbranchemployee() {
       $model = new MasLeave();
       $branch = Yii::app()->request->getparam('branch');
       $dropdownlist=CHtml::activedropDownList($model, 'employee_id', Employee::getEmployee($branch), array('data-label'=>'Employee <span style="color:red">*</span>','multiple'=>true));
       $jsonData['emp'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
    public function actiongetbranchmasterleave() {
       $model = new EmployeeLeaveLedger();
       $branch = Yii::app()->request->getparam('branch');
       $dropdownlist=CHtml::activedropDownList($model, 'leave_type',MasLeave::getParentLeave($branch), array('data-label'=>'Leave Type <span style="color:red">*</span>','empty'=>'Select','onchange'=>'$("#leave_details").html("");'));
       $jsonData['leave'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
    public function actiongetbranchleave() {
       $model = new MasLeave();
       $branch = Yii::app()->request->getparam('branch');
       $dropdownlist=CHtml::activedropDownList($model, 'parent_id',MasLeave::getParentLeave($branch), array('data-label'=>'Parent Leave','empty'=>'Select','onchange'=>'hideparentonlyfields(this.value);'));
       $jsonData['leave'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
    public function actiongetleavebybranch() {
       $branch = $_POST['branch'];
       $dropdownlist=CHtml::dropdownlist('leave_type','',MasLeave::getLeave($branch), array('title' => 'Leave Type','class'=>'col-sm-3 form-control_1','empty' => 'All','onchange'=>'loadLeavedetails();','style'=>'width:200px;'));
       $jsonData['leave'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
    public function actiongetbranchemployeebygender() {
       $model = new MasLeave();
       $branch = (int)Yii::app()->request->getparam('branch');
       $gender = (int)Yii::app()->request->getparam('gender');
       $dropdownlist=CHtml::activedropDownList($model, 'employee_id', Employee::getemployeebygender($branch,$gender), array('data-label'=>'Employee <span style="color:red">*</span>','multiple'=>true));
       $jsonData['emp'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
}
