<?php

class MasholidayController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Delete', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
   
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_holiday_menu']) || Yii::app()->user->authorised_user == 1) {
        $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetList() {
        $model = new MasHoliday();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'holiday_date',
            2 => 'holiday_description',
            3 => 'notify',
            4=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'YEAR(holiday_date)="'.date("Y").'"  AND is_Active= "Y" ';
       
        if (isset($_POST['search']['value']) && !empty($_POST['search']['value'])) {
            $searchString = $_POST['search']['value'];
             $condition ="  (holiday_description LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $div = '';
            $notify="";
            $edit_button=$disable_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_holiday_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_holiday_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button=1;
            }
            if($row['notify']=="Y"){
                $notify='Yes';
            }else{
                $notify='No';
            }
            $model_branch_details=explode(',',$row->branch_id); 
            $model_branch = new MasCompanyBranchSponsor(); 
            if(is_countable($model_branch_details) && count($model_branch_details) > 0) { 
                    $bname=array(); 
                foreach ($model_branch_details as $value) {
                    $model_branch = $model_branch->findByPk($value);
                   $bname[] = $model_branch->branch_or_sponsor_name;
                }
                $branch_names =implode(',', $bname);
            }else{
                $model_branch = $model_branch->findByPk($row->branch_id);
              $branch_names =  $model_branch->branch_or_sponsor_name;    
            }
            
            $rowData[] = array(++$m,$branch_names,date("d/m/Y",strtotime($row['holiday_date'])), $row['holiday_description'],$notify,$div,$row['notify'], array( 'status' => $row->is_Active, "id" => $row->id,'edit_button'=>$edit_button,'disable_button'=>$disable_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasHoliday();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('holiday_from', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new MasHoliday();
        date_default_timezone_set("Asia/Dubai");
        if (isset($_POST['MasHoliday'])) {      
            $scenario='';
            if ((int) @$_POST['MasHoliday']['id'] > 0) {             
                $id = (int) @$_POST['MasHoliday']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d h:i:s');
                $model->scenario = 'update';
                $scenario = 'update';
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $scenario = 'add';
            }
            $model->attributes = $_POST['MasHoliday'];
            if ($_POST['MasHoliday']['holiday_date'] != '0000-00-00' && $_POST['MasHoliday']['holiday_date'] != '') {
                    $model->holiday_date = str_replace('/', '-', $_POST['MasHoliday']['holiday_date']);
                    $model->holiday_date= date("Y-m-d", strtotime($model->holiday_date));
            }
            if(isset($_POST['MasHoliday']['branch_id']) && count($_POST['MasHoliday']['branch_id']) > 0){
                $model->branch_id = implode(',',$_POST['MasHoliday']['branch_id']);
            }else{
                $model->branch_id = "";
            }
            if ($model->save()) {
                if($scenario=='add'){
                    $model_leave=EmployeeLeaveDetail::model()->with('employeedetail')->findAll(array('condition'=>'employeedetail.branch_or_sponsor_id IN ('.$model->branch_id.') AND ((leave_start_date<="'.$model->holiday_date.'" AND leave_end_date>="'.$model->holiday_date.'") OR  (leave_start_date  BETWEEN  "'. $model->holiday_date . '" AND  "'. $model->holiday_date.'"
                    OR leave_end_date BETWEEN  "' . $model->holiday_date . '" AND  "' . $model->holiday_date . '")) AND leave_status!=25 AND leave_status!=27'));
                    foreach ($model_leave as $key => $value) {
                        $model_employee = Employee::model()->findbyPK($value->employee_id);
                        $weekend_off1 = $model_employee->weekend_off1;
                        $weekend_off2 = $model_employee->weekend_off2;
                        $weekend_off3 = $model_employee->weekend_off3;
                        $weekend = $value->leavetype->exclude_weekend;
                        $weekvalue = date('w', strtotime($model->holiday_date));
                        $weekvalue+=1;
                        $is_weekend=0;
                        if ($weekend_off1 == $weekvalue){
                            $is_weekend=1;
                        }else if($weekend_off2 == $weekvalue){
                            $is_weekend=1;
                        }else if($weekend_off3 == $weekvalue) {
                            $is_weekend=1;
                        }
                        $holiday_deduct='Y';
                        if($is_weekend==1 && $value->leavetype->exclude_weekend=='Y'){
                            $holiday_deduct='N';
                        }
                        if($value->leavetype->exclude_holiday=='Y' && $holiday_deduct=='Y'){
                            $no_days =$value->no_days-1;
                            $normal_leave =$value->normal_leave-1;
                            EmployeeLeaveDetail::model()->updateByPK($value->id, array('no_days' => $no_days,'normal_leave' => $normal_leave));
                            $model_general_setting = HrGenerelSettings::model()->find();
                            $year = date("Y");
                            $current_month = date("m");
                            if ($current_month < $model_general_setting->leave_carry_forward_month){
                                $year = $year - 1;
                            }
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $value->employee_id . '" AND leave_type="'.$value->leave_type. '"'));
                            if($value->leave_status==12 || $value->leave_status==14  || $value->leave_status==15 || $value->leave_status==16 || $value->leave_status==17 || $value->leave_status==18 || $value->leave_status==19 || $value->leave_status==20 || $value->leave_status==21 || $value->leave_status==22 || $value->leave_status==23 || $value->leave_status==24 || $value->leave_status==26){
                                if ($model_leave->id >0) {
                                    $available_leave = $model_leave->leave_current_balance;
                                    $balance_leave = $available_leave+1;
                                    EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave));
                                }
                                EmployeeAttendance::model()->updateAll(array('status' =>4),'attendance_date="'. $model->holiday_date.'" and status="3" and employee_id="'.$value->employee_id.'"');
                            }
                        }
                    }
                    $model_attendance_absent=EmployeeAttendance::model()->with('employeedetail')->findAll(array('condition'=>'employeedetail.branch_or_sponsor_id IN ('.$model->branch_id.') AND attendance_date="'.$model->holiday_date.'" and status="2"'));
                    foreach ($model_attendance_absent as $key_1 => $value_1) {
                        EmployeeAttendance::model()->updateByPK($value_1->id, array('status' => 4));
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
               
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDelete() {

        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = MasHoliday::model()->findByPk($id);
            $model_leave=EmployeeLeaveDetail::model()->with('employeedetail')->findAll(array('condition'=>'employeedetail.branch_or_sponsor_id IN ('.$model->branch_id.') AND ((leave_start_date<="'.$model->holiday_date.'" AND leave_end_date>="'.$model->holiday_date.'") OR  (leave_start_date  BETWEEN  "'. $model->holiday_date . '" AND  "'. $model->holiday_date.'"
            OR leave_end_date BETWEEN  "' . $model->holiday_date . '" AND  "' . $model->holiday_date . '")) AND leave_status!=25 AND leave_status!=27'));
            foreach ($model_leave as $key => $value) {
                $model_employee = Employee::model()->findbyPK($value->employee_id);
                $weekend_off1 = $model_employee->weekend_off1;
                $weekend_off2 = $model_employee->weekend_off2;
                $weekend_off3 = $model_employee->weekend_off3;
                $weekvalue = date('w', strtotime($model->holiday_date));
                $weekvalue+=1;
                $is_weekend=0;
                if ($weekend_off1 == $weekvalue){
                    $is_weekend=1;
                }else if($weekend_off2 == $weekvalue){
                    $is_weekend=1;
                }else if($weekend_off3 == $weekvalue) {
                    $is_weekend=1;
                }
                $holiday_deduct='Y';
                if($is_weekend==1 && $value->leavetype->exclude_weekend=='Y'){
                    $holiday_deduct='N';
                }
                if($value->leavetype->exclude_holiday=='Y' && $holiday_deduct=='Y'){
                    $no_days =$value->no_days+1;
                    $normal_leave =$value->normal_leave+1;
                    EmployeeLeaveDetail::model()->updateByPK($value->id, array('no_days' => $no_days,'normal_leave' => $normal_leave));
                    $model_general_setting = HrGenerelSettings::model()->find();
                    $year = date("Y");
                    $current_month = date("m");
                    if($current_month<$model_general_setting->leave_carry_forward_month){
                       $year=$year-1;
                    }
                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $value->employee_id . '" AND leave_type="'.$value->leave_type. '"'));
                    if($value->leave_status==12 || $value->leave_status==14  || $value->leave_status==15 || $value->leave_status==16 || $value->leave_status==17 || $value->leave_status==18 || $value->leave_status==19 || $value->leave_status==20 || $value->leave_status==21 || $value->leave_status==22 || $value->leave_status==23 || $value->leave_status==24 || $value->leave_status==26){
                        if ($model_leave->id >0) {
                            $available_leave = $model_leave->leave_current_balance;
                            $balance_leave = $available_leave-1;
                            EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave));
                        }
                    }
                }
                EmployeeAttendance::model()->updateAll(array('status' =>3),'attendance_date="'. $model->holiday_date.'" and status="4" and employee_id="'.$value->employee_id.'"');
            }
            $model_attendance_detail = EmployeeAttendance::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.branch_or_sponsor_id IN ('.$model->branch_id.') AND attendance_date="'.$model->holiday_date.'" and status="4"'));
            foreach ($model_attendance_detail as $key => $value) {
                $model_employee = Employee::model()->findbyPK($value->employee_id);
                $weekend_off1 = $model_employee->weekend_off1;
                $weekend_off2 = $model_employee->weekend_off2;
                $weekend_off3 = $model_employee->weekend_off3;
                $weekend = $model_employee->branch_sponsor->exclude_weekend;
                if ($weekend == 1) {
                    $weekvalue = date('w', strtotime($model->holiday_date));
                    $weekvalue+=1;
                    if ($weekend_off1 == $weekvalue || $weekend_off2 == $weekvalue || $weekend_off3 == $weekvalue) {
                        EmployeeAttendance::model()->updateByPK($value->id, array('status' =>5));
                    }else{
                        EmployeeAttendance::model()->updateByPK($value->id, array('status' =>2));
                    }
                }
            }
            MasHoliday::model()->deleteByPK($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'GENERAL',
                Yii::app()->user->id,
                'DELETED',
                " with holiday date: - {$model->holiday_date}  "
            );
            // end audit log
            $jsonData['status'] = 'success';
        }else{
          $jsonData['status'] = 'error';  
        }
         echo CJSON::encode($jsonData);
    }
//    public function actionDisable() {
//        $id = Yii::app()->request->getparam('id');
//        $status = Yii::app()->request->getparam('status');
//        $model = new MasHoliday();
//        $model = $model->findByPk($id);
//        $model->is_Active = ($status == "Y" ) ? "N" : "Y";
//        $model->save();
//        echo json_encode(array("status" => "success"));
//    }

}
