<?php

class MasgratuityController extends Controller
{
    
    public function accessRules() {
    return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
                ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetGratuityList','Create','saveGratuity','deletelevel', 'Disable','View'),
                'expression' => '$user->isMember()',
                ),
            array('deny', // deny all users
                'users' => array('*'),
                ),
            );
     }

    public function filters()
    {
    return array(
        'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_eos_gratuity_menu']) || Yii::app()->user->authorised_user == 1) {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
         }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetGratuityList()
     {

        $model=new MasGratuity();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 =>'t.id',
            1 =>'rule_type',
            2 =>'isActive',
           );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
           $condition ="  (gratuity_type LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition,'group'=>'t.rule_type'));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'group'=>'t.rule_type','order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $edit_button=$view_button=$disable_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_eos_gratuity_edit']) || Yii::app()->user->authorised_user == 1) {
             // $edit_button=0;  
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_eos_gratuity_view']) || Yii::app()->user->authorised_user == 1) {
                $view_button =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_eos_gratuity_disable']) || Yii::app()->user->authorised_user == 1) { 
               // $disable_button=0;
            }
            $rowData[]=array($m,$row->gratuityrule->rule_type, array('type' =>$row->gratuityrule->rule_type,'rtype' => $row->rule_type, 'status' => $row->isActive,'edit_button'=>$edit_button,'disable_button'=>$disable_button,'view_button'=>$view_button,));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    { 
        $ctype=(int) Yii::app()->request->getParam('ctype');
        $rtype=(int) Yii::app()->request->getParam('rtype');
        $model = array(new MasGratuity());
        if($ctype>0){
            $model= MasGratuity::model()->findAll(array('condition' => 'contract_type="'. $ctype.'" and releaving_type="'. $rtype.'"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionsaveGratuity() {
        $valid=true;
        date_default_timezone_set("Asia/Dubai");
        if (isset($_POST['MasGratuity'])){			
            foreach ($_POST['MasGratuity'] as $i => $items) {
                if($items['id']>0){
                    $model[$i] = MasGratuity::model()->findByPK($items['id']);   
                    $model[$i]->updated_by= Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                    $model[$i]->scenario = 'update'; 
                }else{
                    $model[$i] = new MasGratuity();   
                    $model[$i]->created_by= Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                    $model[$i]->scenario = 'add';
                }   

                $model[$i]->attributes = $_POST['MasGratuity'][$i];
                $model[$i]->contract_type = $_POST['contract_type'];
                $model[$i]->releaving_type = $_POST['releaving_type'];
                $model[$i]->days_from=($items['gratuity_period_from']*365)+1;
                $model[$i]->days_to=($items['gratuity_period_to']*365);
                $valid=$model[$i]->validate() && $valid;
            }
        }
        if($valid){
            if (!empty($model)) {
                foreach ($model as $eachModel) {
                    $eachModel->save();
                }
            }       
            $jsonData['status'] = 'success';
           
            echo CJSON::encode($jsonData);
            Yii::app()->end();
        }else{
            $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
        Yii::app()->end();

    }
      public function actionsaveGratuity1() {
        $model = new MasGratuity;
        if (isset($_POST['MasGratuity'])) {
            if ((int) @$_POST['MasGratuity']['id'] > 0) {
                $model->id = (int) $_POST['MasGratuity']['id'];
                $model->scenario = 'update';
                $model = MasGratuity::model()->findByPK($_POST['MasGratuity']['id']);
                $audit_type = 'UPDATED';
            } else {
                unset($_POST['MasGratuity']['id']);
                $model->scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasGratuity'];
            if(!empty($_POST['MasGratuity']['salary_type']))
            {
            $model->salary_type=implode(',',$_POST['MasGratuity']['salary_type']); 
            }
            $model->days_from=($model->gratuity_period_from*365)+1;
            $model->days_to=($model->gratuity_period_to*365);
            $from= array();
            $to= array();
            if(!empty($model->days_from))
            {
            $sql="select * from erp_hr_mas_gratuity where gratuity_period_from=$model->gratuity_period_from AND gratuity_period_to=$model->gratuity_period_to";
            $from = Yii::app()->db->createCommand($sql)->queryAll();
            if($model->id>0)
            {
            $sql="select * from erp_hr_mas_gratuity where gratuity_period_from=$model->gratuity_period_from AND gratuity_period_to=$model->gratuity_period_to AND id!=$model->id";
            $from = Yii::app()->db->createCommand($sql)->queryAll();
            }
            }
//            if(!empty($model->days_to))
//            {
//            $sql1="select * from erp_hr_mas_gratuity where days_from<=$model->days_to AND days_to>=$model->days_to";
//            $to = Yii::app()->db->createCommand($sql1)->queryAll();
//            if($model->id>0)
//            {
//            $sql1="select * from erp_hr_mas_gratuity where days_from<=$model->days_to AND days_to>=$model->days_to AND id!=$model->id";
//            $to = Yii::app()->db->createCommand($sql1)->queryAll();
//            }
//            }
            if(empty($from)){
                
            if ($model->validate()) {
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'EOS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with EOS gratuity type: - {$model->gratuity_type}  "
                );
                // end audit log
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                

            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
            }
            else {
            $jsonData['status'] = 'Already Exist in this range';
            echo CJSON::encode($jsonData);    
            }
        }
        Yii::app()->end();

    }
    public function actiondeletelevel(){
        $id = $_POST['id'];
        if($id>0){
            $model = new MasGratuity();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionDisable() {
        $ctype = Yii::app()->request->getparam('ctype');
        $rtype = Yii::app()->request->getparam('rtype');
        MasGratuity::model()->deleteAll(array('condition'=>'contract_type="'.$ctype.'" and releaving_type="'.$rtype.'"'));
        echo json_encode(array("status" => "success"));
    }
     public function actionView()
    { 
        $rtype=(int) Yii::app()->request->getParam('rtype');
        $model = array(new MasGratuity());
        if($rtype>0){
            $model= MasGratuity::model()->findAll(array('condition' => 'rule_type="'. $rtype.'"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view', array('model' => $model), false, true);
    }
  }