<?php

class MasgeocodelocationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetList', 'Create', 'edit', 'Save', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {
        $model = new HrMasGeocodeLocation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'geocode_location',
            2 => 'latitude',
            3 => 'longitude'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (t.geocode_location LIKE '%" . $searchString . "%' || t.latitude LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m =$offset;
        foreach ($model as $row) {
            $edit=$disable=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_geolocation_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_geolocation_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable=1;
            }
            $rowData[] = array(++$m, $row['geocode_location'], $row['latitude'], $row['longitude'], $row['id'], array('id' => $row->id, 'status' => $row->isActive,"edit" => $edit,"disable" =>$disable));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model_geocode = new HrMasGeocodeLocation();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model_geocode = $model_geocode->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model_geocode' => $model_geocode), false, true);
    }

    public function actionSave() {
        $model_geocode = new HrMasGeocodeLocation();
        if ((isset($_POST['HrMasGeocodeLocation']))) {
            if ($_POST['HrMasGeocodeLocation']['id'] > 0) {
                $id = $_POST['HrMasGeocodeLocation']['id'];
                $model_geocode = HrMasGeocodeLocation::model()->findByPK($id);
                $model_geocode->updated_by = Yii::app()->user->id;
                $model_geocode->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model_geocode = new HrMasGeocodeLocation();
                $model_geocode->created_by = Yii::app()->user->id;
                $model_geocode->created_date_time = date('Y-m-d H:i:s');
            }
            $model_geocode->latitude = $_POST['HrMasGeocodeLocation']['latitude'];
            $model_geocode->longitude = $_POST['HrMasGeocodeLocation']['longitude'];
            $model_geocode->geocode_location = $_POST['HrMasGeocodeLocation']['geocode_location'];
        }
        if ($model_geocode->validate()) {
            $model_geocode->save();
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            $error = CActiveForm::validate($model_geocode, '', false);
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new HrMasGeocodeLocation();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}
