<?php
class MascertificateController extends Controller
{
    public function accessRules() {
    return array(
        array('allow', // allow all users to perform 'index' and 'view' actions
            'actions' => array('login', 'error', 'logout'),
            'users' => array('*'),
        ),
        array('allow', // allow authenticated user to perform 'create' and 'update' actions
            'actions' => array('Index','Create','deleteCertificate','SaveCertificate','GetList', 'Disable'),
            'expression' => '$user->isMember()',
        ),
        array('deny', // deny all users
            'users' => array('*'),
            ),
        );
     }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_certificate_menu']) || Yii::app()->user->authorised_user == 1) { 
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            }else{
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        }
         
        public function actionGetList()
         {
 
            $model=new MasCertificate();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'certificate_name',
                   1 =>'t.id',
                   2 =>'t.id'
                );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  certificate_name LIKE '%".$searchString."%'";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=$offset;
                foreach ($model as $row)
                {
                    $button_string="";
                    $title="";
                    if($row['isActive']=="Y"){
                        $title="Inactive";
                    }else{
                        $title="Active";
                    }
                    $edit_button =$disable_button=0;
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_certificate_edit'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'mascertificate/create&id='.$row['id'].'\',\'Edit Certificate  \',\'md\')"><i class="fa fa-edit"></i></button>';
                        $edit_button=1;
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_certificate_inactive'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteCertificate('.$row['id'].')"><i class="fa fa-circle-thin" title="'.$title.'"></i></a>';
                        $disable_button=1;
                    }
                    $rowData[]=array(++$m,$row['certificate_name'],$row['reference_no'],array('id' => $row->id, 'status' => $row->isActive,'edit_button'=>$edit_button,'disable_button'=>$disable_button));
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate(){
        
        $model=new MasCertificate(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('certificate_form', array('model' => $model), false, true);
    }
    public function actionSaveCertificate(){
        
        $model = new MasCertificate();
        if (isset($_POST['MasCertificate'])){
    
            $model->isActive = "Y";
            if ((int) @$_POST['MasCertificate']['id'] > 0){
                
                $id= (int) @$_POST['MasCertificate']['id'];
                $model=$model->findByPk($id); 
                $model->updated_by       = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $model->scenario = 'update';
            }
            else{
                $model->created_by       = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $model->scenario="add";
            }
            $model->attributes=$_POST['MasCertificate'];
            
            if($model->save()){       
               
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
            else{
                
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDeleteCertificate(){
    
        $id = $_POST['id'];
        if($id>0){    
            $model = new MasCertificate();  
            $certificate = $model->findByPk($id);   // audit log changes                 
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'SALARY',
                Yii::app()->user->id,
                $audit_type,
                " certificate: - {$certificate->certificate_name}  "
            );
            // end audit log
            echo "success";
        }
        else{
            echo "fail";
        }    
    }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasCertificate();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}