<?php

class MasbusinessunitController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'SaveUnit', 'BlockUnit'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_business_menu']) || Yii::app()->user->authorised_user == 1) {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetList() {
        $model = new MasBusinessUnit();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'business_unit_name',
            2 => 'document_name',
            3 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (business_unit_name LIKE '%" . $searchString . "%' OR document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=$offset;
        foreach ($model as $row) {
            $button_string = "";

            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_business_edit']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/masbusinessunit/create&id=' . $row['id'] . '\',\'' .$row['business_unit_name']. ' \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_business_disable']) || Yii::app()->user->authorised_user == 1) {
                if ($row['isActive']=='Y') {
                    $button_string .=' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Block" onclick="blockunit(' . $row['id'] . ',1)"><i class="fa fa-ban "></i></a>';
                } else {
                    $button_string .=' <a href ="javascript:void(0);" class="btn btn-success btn-xs" title="UnBlock" onclick="blockunit(' . $row['id'] . ',2)"><i class="fa fa-retweet"></i></a>';
                }
            }
            $rowData[] = array(++$m, $row['business_unit_name'],$row['document_name'], $button_string);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasBusinessUnit();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveUnit() {
        if (isset($_POST['MasBusinessUnit'])) {
            date_default_timezone_set("Asia/Dubai");
            $model = new MasBusinessUnit();
            if ((int) @$_POST['MasBusinessUnit']['id'] > 0) {                
                $model = MasBusinessUnit::model()->findByPK($_POST['MasBusinessUnit']['id']);
                $model->scenario = 'update';
                $model->id = (int) $_POST['MasBusinessUnit']['id'];
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['MasBusinessUnit'];
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionBlockUnit() {
        $id = $_POST['id'];
        $model = MasBusinessUnit::model()->findByPk($id);
        $status=$model->isActive;
        $new_status = ($status == "Y" ) ? "N" : "Y";
        $arr_value=array('isActive' =>$new_status,'updated_by' =>Yii::app()->user->id, 'updated_date_time' =>date('Y-m-d H:i:s'));
        MasBusinessUnit::model()->updateByPk($id,$arr_value);
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);       
    }
}
