<?php

class LoandetailController extends Controller
{    
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('index','GetLoanDetails','EmployeeIndex','SaveApproveloan','GetEmployeeLoanDetails','getLoanHistory',
                                        'SaveEmployeeloan','Approve','Create','EmployeeCreate','deleteLoandetail','View','EditLoan','EditLoandetail',
                                        'LoanPayment','SaveloanPayment','ApprovebyHr','SaveApproveloanHR','LoanApproval','GetPendingLoanDetails',
                                        'checkeligibility','loadmasterbranch','approvalhierarchy','LoanApprovalDocument'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function actionIndex() {
        $model_module_loan= HrModules::model()->findByPK(6);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emp_loan_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch =$this->ciphertext($en_id,"d");
            if($branch!=''){
                $model = new EmployeeLoanDetail();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index', array('model' => $model,'branch'=>$branch));
            }else{
                throw new CHttpException(404, 'Page not found.');
            }
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    
    public function actionCreate()
    {
        $model=new EmployeeLoanDetail(); 
        $id=(int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'id'=>$id), false, true);                                  
    }
    public function actionEditLoan()
    {
        $model=new EmployeeLoanDetail(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        } 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_loan', array('model' => $model,'id'=>$id), false, true);                                  
    }
    public function actionEditLoandetail()
    {
        $model=new EmployeeLoanDetail(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }   
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_loan_detail', array('model' => $model,'id'=>$id), false, true);                                  
    }
    public function actionGetLoanDetails(){		
        $model=new EmployeeLoanDetail();
        $employee_id    = $_POST['employee_id'];
        $posted ='';
        if(!empty($_POST['posted']))
        {
        $posted    = $_POST['posted'];
        }
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $branch_id=$_POST['branch_id'];
        $columns = array(
            0 =>'t.id',
            1 =>'employee_id',
            2 =>'employee_id',
            3 =>'loan_amount',
            4 =>'loan_monthly_payment',
            5 =>'loan_total_installment',
            6 =>'apply_date',
            7 =>'approved_date',
            8 =>'loan_repayment',
            9 =>'loan_status',
            10 =>'id',

        );
        $arr_status=$_POST['status'];
        $status='H';
        $pending_status_flag=0;
        
        if(is_countable($arr_status) && count($arr_status)>1){
            if (in_array('H', $arr_status)) {
                $pending_status_flag= 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $pending_loan=EmployeeLoanDetail::getPendingapproval($branch_id,1);
        $condition = "employeedetail.branch_or_sponsor_id='".$branch_id."'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if($status=='H'){
            $condition.= " AND t.id IN(".$pending_loan.")";
        }else if($status!=''){
            if($pending_status_flag==0){
                $condition.= " AND loan_status IN(".$status.")";
            }else if($pending_status_flag==1){
                $condition.= " AND (loan_status IN(".$status.") OR t.id IN(".$pending_loan."))";
            }
        }
        if($employee_id>0){
            $condition.=" and employee_id ='".$employee_id."'";
        }
        if($posted!=''){
            $condition.=" and loan_posted ='".$posted."'";
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!=""){
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row){
            $button_string = "";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=0;
            $final_level='N';
            if(!empty($row->approvelevel) && $next_approval_level<=$row->max_level){
                if($next_approval_level==1 && $row->approvelevel->level_1_type=='H' && $row->approvelevel->level_1_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=1;
                }else if($next_approval_level==2 && $row->approvelevel->level_2_type=='H' && $row->approvelevel->level_2_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=2;
                }else if($next_approval_level==3 && $row->approvelevel->level_3_type=='H' && $row->approvelevel->level_3_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=3;
                }else if($next_approval_level==4 && $row->approvelevel->level_4_type=='H' && $row->approvelevel->level_4_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=4;
                }else if($next_approval_level==5 && $row->approvelevel->level_5_type=='H' && $row->approvelevel->level_5_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=5;
                }
            }
            if(!empty($row->approvelevel) && $next_approval_level==$row->max_level){
                $final_level='Y';
            }
            $approve_reject =$approval_document=$edit_loan=$delete_loan=$view_loan=$loan_payment=$direct_approval=$approval_hierarchy=0;
            if($show_approve_button==1){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_loan_approvereject'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= ' <button class="btn btn-warning btn-xs" title="Approve/Reject Loan" onclick="loadPopupModal(\'hr/loandetail/approvebyhr&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Approve/Reject Loan\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>';       
                    $approve_reject =1;
                    
                }
            }
            if($row['loan_status']==12){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_loan_approve_print'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= ' <a href="?r=hr/loandetail/loanapprovaldocument&id='.$this->ciphertext($row['id'],"e").'" title="Loan Approval Document" target="_blank"><button class="btn btn-default btn-xs" title="Approval Document" ><i class="fa fa-print"></i></button></a>';
                    $approval_document =1;
                }
            }
            if($row['loan_status']==1):
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_loan_edit'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.=' <button class="btn btn-primary btn-xs" title="Edit Loan Detail" onclick="loadPopupModal(\'hr/loandetail/editloandetail&id='.$row['id'].'\',\'EDIT EMPLOYEE LOAN DETAILS \',\'xl\')"><i class="fa fa-edit"></i></button>';	    						 
                    $edit_loan =1;
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_loan_delete'])  || Yii::app()->user->authorised_user == 1) {
                $button_string.= ' <a href ="javascript:void(0);" title="Delete Loan Detail" class="btn btn-danger btn-xs" onclick="deleteLoandetail('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                $delete_loan =1;
                }
            endif;
            
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_loan_view'])  || Yii::app()->user->authorised_user == 1){
                if($row['loan_status']>=1){					
                $button_string.=' <button class="btn btn-success btn-xs" title="View Loan Detail" onclick="loadPopupModal(\'hr/loandetail/view&id='.$row['id'].'\',\'View Loan Details \',\'lg\')"><i class="fa fa-eye"></i></button>';	    						 
                $view_loan=1;
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_loan_pay'])  || Yii::app()->user->authorised_user == 1) {
                if($row['loan_status']==14 || $row['loan_status']==15):					
                $button_string.= ' <button class="btn btn-info btn-xs" title="Loan Payment" onclick="loadPopupModal(\'hr/loandetail/loanpayment&id='.$row['id'].'\',\'Loan Payment\',\'md\')"><i class="fa fa-money"></i></button>';            
                $loan_payment =1;
                endif;
            
            }
            if ($row['loan_status']==1 || $row['loan_status']==2 || $row['loan_status']==4 || $row['loan_status']==6 || $row['loan_status']==8 || $row['loan_status']==10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_admin_loan_details_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $last_level=$row->max_level;
                    $button_string.= ' <button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/loandetail/approvebyhr&final_level=Y&level='.$last_level.'&id=' . $row['id'] . '\',\'Approve/Reject Loan\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp';       
                    $direct_approval =1;
                }
                }
            if ($row['loan_status']==1 || $row['loan_status']==2 || $row['loan_status']==4 || $row['loan_status']==6 || $row['loan_status']==8 || $row['loan_status']==10) {
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_loan_hierarchy_view']) || Yii::app()->user->authorised_user == 1) {
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Approval Hierarchy" onclick="loadPopupModal(\'hr/loandetail/approvalhierarchy&function_type=2&employee_id=' . $row['employee_id'] . '\',\'Employee Hierarchy\',\'md\')"><i class="fa fa-book"></i></button>&nbsp;';
                        $approval_hierarchy=1;
                    }                                                           
                }    
            $loandate='';												
            if($row['approved_date'] != '0000-00-00'){
                $loandate = date("d/m/Y", strtotime($row['approved_date']));
            }		
            $applydate="";
            if($row['apply_date'] != '0000-00-00'){
                $applydate = date("d/m/Y", strtotime($row['apply_date']));
            }
            $repayment_start="";
            if($row['repayment_start_year']>0){
                $repayment_start =HrGenerelSettings::getMonthName1($row['repayment_start_month'])." ".$row['repayment_start_year'];
            }
            $rowData[]=array($m,$row['employeedetail']['employeecode'],$row['employeedetail']['employeefullname'],$row['loan_amount'],$row['loan_monthly_payment'],$row['loan_total_installment'],$repayment_start,$applydate,$loandate,$row['loan_repayment'],EmployeeLoanDetail::getLoanStatus($row['loan_status']),array('id'=>$row['id'],'employee_id'=>$row['employee_id'],'last_level'=>$last_level,'en_id'=>$this->ciphertext($row['id'],"e"),'final_level'=>$final_level,'level_no'=>$level_no,'approve_reject'=>$approve_reject,'approval_document'=>$approval_document,'edit_loan'=>$edit_loan,'delete_loan'=>$delete_loan,'view_loan'=>$view_loan,'loan_payment'=>$loan_payment,'direct_approval'=>$direct_approval,'approval_hierarchy'=>$approval_hierarchy));                
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionSaveEmployeeloan() {
        $modelloan = new EmployeeLoanDetail();
        if (isset($_POST['EmployeeLoanDetail'])) {
            if (isset($_POST['EmployeeLoanDetail']['id']) && $_POST['EmployeeLoanDetail']['id'] > 0) {
                $id = (int) $_POST['EmployeeLoanDetail']['id'];
                $modelloan = EmployeeLoanDetail::model()->findByPK($id);
                $modelloan->updated_by= Yii::app()->user->id;
                $modelloan->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $modelloan->apply_date = date("Y-m-d");   
                $modelloan->created_by= Yii::app()->user->id;
                $modelloan->created_date_time = date('Y-m-d H:i:s');
            }
            $modelloan->attributes = $_POST['EmployeeLoanDetail'];
            //Employee ID
            $employee_id=$_POST['EmployeeLoanDetail']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="2"'));          
            if(!empty($model_master_approve_setting))
            {
                $modelloan->function_type =$model_master_approve_setting->id;
                $modelloan->max_level =$model_master_approve_setting->max_level;
            }
            $modelloan->loan_status =1;
            $modelloan->proposed_installment = $_POST['EmployeeLoanDetail']['proposed_installment'];
            $modelloan->proposed_monthly_installment = $_POST['EmployeeLoanDetail']['proposed_monthly_installment'];
            $modelloan->repayment_start_month = $_POST['EmployeeLoanDetail']['repayment_start_month'];
            $modelloan->repayment_start_year = $_POST['EmployeeLoanDetail']['repayment_start_year'];
            $repayment_date =$_POST['EmployeeLoanDetail']['repayment_start_year']."-".$_POST['EmployeeLoanDetail']['repayment_start_month']."-01";
            $modelloan->repayment_start_date = $repayment_date;
            $modelloan->reason_loan = $_POST['EmployeeLoanDetail']['reason_loan'];
            if($modelloan->save()){ 
                 //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="14"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                         Yii::import('application.modules.hr.controllers.MailController');
                         MailController::sendmail(14,$modelloan->employee_id,$modelloan->id);
                    }
                }
                $jsonData['status'] = 'success';                
                echo CJSON::encode($jsonData);
            }
            else{
                $error = CActiveForm::validate($modelloan, '', false);
                if ($error != '[]')
                echo $error;
            }
        }			
    }   
    public function actionApprove() {
        $model=new EmployeeLoanDetail(); 
        $id=(int) Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('approve', array('model' => $model,'id'=>$id,'level'=>$level,'final_level'=>$final_level), false, true);                                  
    }
    public function actiondeleteLoandetail(){       
        $id = $_POST['id'];
         if($id>0){            
             $model = new EmployeeLoanDetail();                
             $model->deleteByPk($id);
             echo "success";
         }
         else{
             echo "fail";
         }      
    }
    public function actiongetLoanHistory(){
        $id    = (int) Yii::app()->request->getParam('id');
        $model = EmployeeLoanDetail::model()->findAll(array('condition'=>'employee_id="'.$id.'" and (loan_status = "12" or loan_status = "14" or loan_status = "15" or loan_status = "16")'));
        $this->renderPartial('loan_history', array('model' => $model), false, true);         
    }
    
     public function actionSaveApproveloan() {	 
        $modelloan = new EmployeeLoanDetail();
        if (isset($_POST['EmployeeLoanDetail'])) {
            if ($_POST['EmployeeLoanDetail']['id'] > 0) {      
                $modelloan = EmployeeLoanDetail::model()->findByPK($_POST['EmployeeLoanDetail']['id']);	
                $modelloan->updated_by= Yii::app()->user->id;
                $modelloan->updated_date_time = date('Y-m-d H:i:s');
                $modelloan->loan_monthly_payment=$_POST['EmployeeLoanDetail']['loan_monthly_payment'];  
                $modelloan->loan_total_installment=$_POST['EmployeeLoanDetail']['loan_total_installment'];  
                $modelloan->loan_status=$_POST['EmployeeLoanDetail']['loan_status']; 	
                $modelloan->repayment_start_month=$_POST['EmployeeLoanDetail']['repayment_start_month']; 	
                $modelloan->repayment_start_year=$_POST['EmployeeLoanDetail']['repayment_start_year']; 	
                $modelloan->repayment_start_date=$_POST['EmployeeLoanDetail']['repayment_start_year']."-".$_POST['EmployeeLoanDetail']['repayment_start_month']."-01"; 	
            }else{
                $modelloan->apply_date=date("Y-m-d");  
                $modelloan->created_by= Yii::app()->user->id;
                $modelloan->created_date_time = date('Y-m-d H:i:s');
            }
            $modelloan->attributes = $_POST['EmployeeLoanDetail'];   
            $modelloan->last_approved_level = $_POST['EmployeeLoanDetail']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id=0;
            if($modelemployee->employee_id>0){
                $approved_employee_id=$modelemployee->employee_id;
            }else if($modelemployee->hr_connected_employee_id>0){
                $approved_employee_id=$modelemployee->hr_connected_employee_id;
            }
            $level= $_POST['approval_level'];
            $final_level= $_POST['final_level']; 
            if($level==1 && $final_level=='N'){
                $modelloan->approve_level1_date = date('Y-m-d');
                $modelloan->approve_level1_comment = $_POST['approval_comment'];
                $modelloan->approve_level1_id = $approved_employee_id;
            }else if($level==2 && $final_level=='N'){
                $modelloan->approve_level2_date = date('Y-m-d');
                $modelloan->approve_level2_comment = $_POST['approval_comment'];
                $modelloan->approve_level2_id = $approved_employee_id;
            }else if($level==3 && $final_level=='N'){
                $modelloan->approve_level3_date = date('Y-m-d');
                $modelloan->approve_level3_comment = $_POST['approval_comment'];
                $modelloan->approve_level3_id = $approved_employee_id;
            }else if($level==4 && $final_level=='N'){
                $modelloan->approve_level4_date = date('Y-m-d');
                $modelloan->approve_level4_comment = $_POST['approval_comment'];
                $modelloan->approve_level4_id = $approved_employee_id;
            }else if($level==5 && $final_level=='N'){
                $modelloan->approve_level5_date = date('Y-m-d');
                $modelloan->approve_level5_comment = $_POST['approval_comment'];
                $modelloan->approve_level5_id = $approved_employee_id;
            }
            if($final_level=='Y'){
                $modelloan->approved_date = date('Y-m-d');
                $modelloan->approval_comment = $_POST['approval_comment'];
                $modelloan->approved_by = $approved_employee_id;
            }
            if ($modelloan->validate()) {
                $modelloan->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="15"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                         Yii::import('application.modules.hr.controllers.MailController');
                         MailController::sendmail(15,$modelloan->employee_id,$modelloan->id);
                    }
                }
                $modelloan->refresh();
                    $jsonData['modelloan'] = 'EmployeeLoanDetail';
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                
            }else{
                $error = CActiveForm::validate($modelloan, '', false);
                if ($error != '[]')
                echo $error;
            }

        }			
    }
    public function actionView() {
        $model=new EmployeeLoanDetail(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        $model_loan_details = EmployeeLoanDetail::model()->findAll(array('condition'=>'employee_id="'.$model->employee_id.'" and (loan_status = "12" or loan_status = "14" or loan_status = "15" or loan_status = "16")'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view_loan_details', array('model_loan_details' => $model_loan_details,'model' => $model,'id'=>$id), false, true);                                  
    }
    public function actionEmployeeIndex() {
        $this->layout = 'main';
        $model_module_loan = HrModules::model()->findByPK(6);
        if ($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_employee');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeLoanDetails(){
		
        $model=new EmployeeLoanDetail();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'t.id',
            1 =>'apply_date',
            2 =>'loan_amount',
            3 =>'loan_monthly_payment',
            4 =>'loan_total_installment',
            5 =>'approved_date',
            6 =>'payment_date',
            7 =>'loan_repayment',
            8 =>'loan_repayment',
            9 =>'loan_status',
            10 =>'',

        );
       
        $user_id = Yii::app()->user->id; 
	$modelemployee = User::model()->findByPK($user_id);
	$employee_id = $modelemployee->employee_id;
        $condition="employee_id ='".$employee_id."'";
        EmployeeLoanDetail::model()->updateAll(array('view_status' =>1,'updated_by'=> Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')), 'employee_id="'.$employee_id.'" and view_status="0" and (loan_status="12" OR loan_status="13")');
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";       
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";	
            $edit_button =$delete_button=$view_button=0;
            if($row['loan_status']==1):	
                $edit_button =1;
                $delete_button =1;
                $button_string.='<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/loandetail/editloan&id='.$row['id'].'\',\'EDIT LOAN DETAILS \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';	    						 
                $button_string.= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteLoandetail('.$row['id'].')"><i class="fa fa-trash-o "></i></a>&nbsp;';
            endif;
            if($row['loan_status']>=1):	
                $view_button =1;
               $button_string.='<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'hr/loandetail/view&id='.$row['id'].'\',\'View Employee Loan Details \',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';	    						 
            endif;
            $applydate = date("d/m/Y", strtotime($row['apply_date']));	
            $loandate="";
            if($row['approved_date'] != '0000-00-00'){
                $loandate = date("d/m/Y", strtotime($row['approved_date']));
            }			
            $paymentdate="";
            if($row['payment_date'] != '0000-00-00'){
                $paymentdate = date("d/m/Y", strtotime($row['payment_date']));
            }	
            $repayment_start="";
            if($row['repayment_start_year']>0){
                $repayment_start =HrGenerelSettings::getMonthName1($row['repayment_start_month'])." ".$row['repayment_start_year'];
            }
            $rowData[]=array($m,$applydate,$row['loan_amount'],$row['loan_monthly_payment'],$row['loan_total_installment'],$repayment_start,$loandate,$paymentdate,$row['loan_repayment'],($row['loan_amount']-$row['loan_repayment']),EmployeeLoanDetail::getLoanStatus($row['loan_status']),array("id"=>$row['id'],'edit_button'=>$edit_button,'delete_button'=>$delete_button,'view_button'=>$view_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    } 
    public function actionEmployeeCreate()
    {
        $model=new EmployeeLoanDetail(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('apply_loan', array('model' => $model,'id'=>$id), false, true);                                  
    }	    
    public function actionLoanPayment() {
        $model=new EmployeeLoanDetail(); 
        $model_loan=new EmployeeLoan(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('loan_payment', array('model' => $model,'model_loan' => $model_loan,'id'=>$id), false, true);                                  
    }
    public function actionSaveloanPayment() {	 
        $modelloan = new EmployeeLoanDetail();       
        if (isset($_POST['EmployeeLoanDetail'])) {
            if ($_POST['EmployeeLoanDetail']['id'] > 0) {      
                $modelloan = EmployeeLoanDetail::model()->findByPK($_POST['EmployeeLoanDetail']['id']);		
                $modelloan->updated_by= Yii::app()->user->id;
                $modelloan->updated_date_time = date('Y-m-d H:i:s');
                $modelloan->scenario ='payment';
            }                  
            $loan_amount=$modelloan->loan_amount;
            $loan_repaid=$modelloan->loan_repayment;
            $loan_repayment=$_POST['EmployeeLoan']['loan_amount'];
            $total_payment=$loan_repaid+$loan_repayment;
            if($total_payment==$loan_amount){
                $modelloan->loan_status=16;
            }else{
                $modelloan->loan_status=15;
            }
            $modelloan->loan_repayment=$total_payment;
            if ($modelloan->validate()) {
                $modelloan->save();
                $model_loan_installment = EmployeeLoan::model()->find(array('select' => 'max(loan_installment) as loan_installment', 'condition' => 'loan_id="' . $modelloan->id . '"'));
                $model_loan_payment = new EmployeeLoan();
                $model_loan_payment->employee_id = $modelloan->employee_id;
                $model_loan_payment->loan_id = $modelloan->id;
                $model_loan_payment->loan_amount = $_POST['EmployeeLoan']['loan_amount'];;
                $model_loan_payment->date_payment = date('Y-m-d');
                $model_loan_payment->loan_installment = $model_loan_installment->loan_installment + 1;

                //ALTER TABLE `erp_hr_employee_loan` ADD `voucher_id` INT NOT NULL AFTER `posted`;
                //$model_loan_payment->postVoucher();
                $model_loan_payment->save();
                
                $modelloan->refresh();
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                
            }else{
                $error = CActiveForm::validate($modelloan, '', false);
                if ($error != '[]')
                echo $error;
            }

        }			
    }
    public function actionApprovebyHr() {
        $model=new EmployeeLoanDetail(); 
        $id=(int) Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('approve_hr', array('model' => $model,'id'=>$id,'level'=>$level,'final_level'=>$final_level), false, true);                                  
    }
    public function actionSaveApproveloanHR() {	 
        $modelloan = new EmployeeLoanDetail();
        if (isset($_POST['EmployeeLoanDetail'])) {
            if ($_POST['EmployeeLoanDetail']['id'] > 0) {      
                $modelloan = EmployeeLoanDetail::model()->findByPK($_POST['EmployeeLoanDetail']['id']);	
                $modelloan->updated_by= Yii::app()->user->id;
                $modelloan->updated_date_time = date('Y-m-d H:i:s');
                $modelloan->loan_monthly_payment=$_POST['EmployeeLoanDetail']['loan_monthly_payment'];  
                $modelloan->loan_total_installment=$_POST['EmployeeLoanDetail']['loan_total_installment'];  
                $modelloan->loan_status=$_POST['EmployeeLoanDetail']['loan_status']; 
                $modelloan->repayment_start_month=$_POST['EmployeeLoanDetail']['repayment_start_month']; 	
                $modelloan->repayment_start_year=$_POST['EmployeeLoanDetail']['repayment_start_year']; 	
                $modelloan->repayment_start_date=$_POST['EmployeeLoanDetail']['repayment_start_year']."-".$_POST['EmployeeLoanDetail']['repayment_start_month']."-01"; 	
            }
            $modelloan->attributes = $_POST['EmployeeLoanDetail']; 
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id=0;
            if($modelemployee->employee_id>0){
                $approved_employee_id=$modelemployee->employee_id;
            }else if($modelemployee->hr_connected_employee_id>0){
                $approved_employee_id=$modelemployee->hr_connected_employee_id;
            }
            $modelloan->approved_by = $approved_employee_id;
            $modelloan->approved_date = date('Y-m-d');
            $modelloan->approval_comment=$_POST['approval_comment']; 
            if ($modelloan->validate()) {
                $modelloan->save();
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="15"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                         Yii::import('application.modules.hr.controllers.MailController');
                         MailController::sendmail(15,$modelloan->employee_id,$modelloan->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CActiveForm::validate($modelloan, '', false);
                if ($error != '[]')
                echo $error;
            }

        }			
    }
    public function actionLoanApproval() {
        $this->layout = 'main';
        $model_module_loan = HrModules::model()->findByPK(6);
        if ($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_approval');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetPendingLoanDetails(){
		
        $model=new EmployeeLoanDetail();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $status = '';
        if(isset($_POST['status']))
        {
        $status  = $_POST['status'];
        }
        $columns = array(
            0 =>'t.id',
            1 =>'employeedetail.first_name',
            2 =>'apply_date',
            3 =>'loan_amount',
            4 =>'loan_monthly_payment',
            5 =>'loan_total_installment',
            6 =>'',

        );
        $user_id = Yii::app()->user->id; 
	$modelemployee = User::model()->findByPK($user_id);
	$employee_id = $modelemployee->employee_id;
        $pending_loans=EmployeeLoanDetail::getintermediateapproval($employee_id,1);
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN('.$pending_loans.')';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";       
        }
        $count = $model->with('employeedetail','approvelevel')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail','approvelevel')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>"t.id asc"));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string = "";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=0;
            $final_level='N';
            if($next_approval_level<=$row->max_level){
                if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=1;
                }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=2;
                }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=3;
                }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=4;
                }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=5;
                }
            }
            if($next_approval_level==$row->max_level){
                $final_level='Y';
            }
            $approve_reject=0;
            if($show_approve_button==1){ //For Approval
                $approve_reject =1;
                $button_string.= '<button class="btn btn-primary btn-xs" title="Approve/Reject Loan" onclick="loadPopupModal(\'hr/loandetail/approve&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Approve/Reject Loan \',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';           
            }
            $applydate = date("d/m/Y", strtotime($row['apply_date']));	
            $repayment_start="";
            if($row['repayment_start_year']>0){
                $repayment_start =HrGenerelSettings::getMonthName1($row['repayment_start_month'])." ".$row['repayment_start_year'];
            }
            $rowData[]=array($m,$row['employeedetail']['employeefullname'],$applydate,$row['loan_amount'],$row['loan_monthly_payment'],$row['loan_total_installment'],$repayment_start,array('final_level'=>$final_level,'level_no'=>$level_no,'id'=>$row['id'],'approve_reject'=>$approve_reject));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    } 
    public function actioncheckeligibility()
    {
        $id=(int) Yii::app()->request->getParam('employee_id');
        $mod_employee = Employee::model()->findByPK($id);
        $current_date=date('Y-m-d');
        $d1 = strtotime($mod_employee->date_join);
        $d2 = strtotime($current_date);
        $datediff = $d2 - $d1;
        $service_days = $datediff / (60 * 60 * 24)+1;
        $years= round($service_days/365,1);
        $model_loan_details_pending = EmployeeLoanDetail::model()->find(array('condition'=>'employee_id="'.$id.'" and (loan_status = "0" or loan_status = "1" or loan_status = "3" or loan_status = "4" or loan_status = "6")'));
        $model_loan_details_last_payment = EmployeeLoan::model()->find(array('select' => 'max(date_payment) as date_payment','condition'=>'employee_id="'.$id.'"'));
        $years_1=0;
        if($model_loan_details_last_payment->date_payment!='' && $model_loan_details_last_payment->date_payment!='0000-00-00'){
            $d3 = strtotime($model_loan_details_last_payment->date_payment);
            $datediff_1 = $d2 - $d3;
            $service_days_1 = $datediff_1 / (60 * 60 * 24)+1;
            $years_1= round($service_days_1/365,1);
        }
        if($mod_employee->disciplinary_action=='N' && $model_loan_details_pending->id==''){
            Yii::import('application.controllers.front.EosdetailsController'); 
            $gratuity_amt=EosdetailsController::geteos($id);
            $percent_25=$percent_50=0.00;
            if($gratuity_amt>0){
                $percent_25=  round(($gratuity_amt*25/100),2); 
                $percent_50=  round(($gratuity_amt*50/100),2); 
            } 
            $jsonData['minamt'] = $percent_25;
            $jsonData['maxamt'] = $percent_50;
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch', array());
    }
    public function actionLoanApprovalDocument() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_loan_approve_print'])  || Yii::app()->user->authorised_user == 1) {
            $en_id = Yii::app()->request->getParam('id');
            $id =$this->ciphertext($en_id,"d");
            $model_loan= EmployeeLoanDetail::model()->findbyPK($id);
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            if(!empty($model_loan)){
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.loandetail.print_employee_loan_approval_document', array('id'=>$id,'model_loan'=>$model_loan), true));
            }else{
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.pdf.error', array(), true));
            }
            $mPDF1->Output('Loan Approval Document.pdf', 'I');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionapprovalhierarchy() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $function_type = Yii::app()->request->getparam("function_type");
        $model_level = HrEmployeeApproveLevel::model()->with('employeedetail')->find(array("condition" =>'employee_id ="' . $employee_id. '" AND functionality_id="'.$function_type.'"' ));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('approve_hierarchy', array('model_level' => $model_level, 'employee_id' => $employee_id));
    }
}