<?php

class HrsettingsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('AddReportingManager', 'loademployeeforreporting', 'GeneralSettings', 'SaveGeneralSettings', 'SavereportingManager', 
                                    'checkreportingmanager', 'Mailsettings', 'MailsettingsEmployeeList','AddAttendanceManager','loademployeedetails',
                                    'savemailsetting','saveemployeeattendancemanager','checkattendancemanager','DashboardPermission','PdfSettings',
                                    'SaveDashboardPermission','UploadProfilePhoto','SavePdfSettings','index','GetApprovalSettings','createapproval',
                                    'SaveapprovalSettings','AddThresholdSalary','loademployeeforsalary','SaveThresholdSalary','Changesalarytransfermode',
                                    'loademployeeforsalarymode','SaveSalaryMode','AddContractType','loademployeeforcontract','SaveContractType',
                                    'ChangeSalaryCalculationMethod','LoadEmployeeForSalaryCalculationMethod','SaveSalaryCalculationMethod','AppPermission',
                                    'SaveAppPermission'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionAddReportingManager() {
        $model = new ReportingManager();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('reporting_manager', array('model' => $model), false, true);
    }

    public function actionloademployeeforreporting() {
        $branch = $_POST['branch'];
        $model_employee = Employee::model()->findAll(array('condition' => 'branch_or_sponsor_id="' . $branch . '"'));
        $model_reporting = ReportingManager::model()->findAll(array('select' => 'employee_id', 'condition' => 'branch="' . $branch . '"'));
        $model_employee_1 = array();
        foreach ($model_reporting as $key => $value) {
            $model_employee_1[$key] = $value->employee_id;
        }
        $this->renderPartial('reporting_employee_list', array('model' => $model_employee, 'model_reporting' => $model_employee_1, 'branch' => $branch), false, true);
    }

    public function actionGeneralSettings() {

        $model = HrGenerelSettings::model()->find();
        if (empty($model)) {
            $model = new HrGenerelSettings;
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('general_settings_form', array('model' => $model), false, true);
    }

    public function actionSaveGeneralSettings() {
        $model = new HrGenerelSettings();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['HrGenerelSettings'])) {            
            if ((int) @$_POST['HrGenerelSettings']['id'] > 0) {
                $model->id = (int) $_POST['HrGenerelSettings']['id'];
                $model = $model->findByPK($model->id);
            }
//            $model->attributes = $_POST['HrGenerelSettings'];
            $model->isActive = "Y";
            $model->leave_apply_before_current_date = $_POST['HrGenerelSettings']['leave_apply_before_current_date'];
//            $model->ifsc_code = $_POST['HrGenerelSettings']['ifsc_code'];
            $model->overtime_hours = $_POST['HrGenerelSettings']['overtime_hours'];
            $model->cool_off_time = $_POST['HrGenerelSettings']['cool_off_time'];
            $model->disclaimer_salary_slip = $_POST['HrGenerelSettings']['disclaimer_salary_slip'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSavereportingManager() {
        if (isset($_POST['Employee'])) {
            $branch = $_POST['branch'];
            foreach ($_POST['Employee'] as $each) {
                if (count($_POST['arraycid']) > 0) {
                    if (in_array($each['id'], $_POST['arraycid'])) {
                        if ($each['id'] != '') {
                            date_default_timezone_set("Asia/Dubai");
                            $model_reporting = ReportingManager::model()->find(array('condition' => 'employee_id="' . $each['id'] . '"'));
                            if (empty($model_reporting)) {
                                $model_reporting = new ReportingManager();
                                $model_reporting->employee_id = $each['id'];
                                $model_reporting->branch = $branch;
                                $model_reporting->created_by = Yii::app()->user->id;
                                $model_reporting->created_date_time = date('Y-m-d h:i:s');
                                $model_reporting->save();
                            } else {
                                ReportingManager::model()->updateByPK($model_reporting->id, array('updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')));
                            }
                        }
                    } else {
                        ReportingManager::model()->deleteAll(array('condition' => 'employee_id="' . $each['id'] . '"'));
                    }
                } else {
                    ReportingManager::model()->deleteAll(array('condition' => 'branch="' . $branch . '"'));
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actioncheckreportingmanager() {
        $report_staff_id = $_POST['report_staff_id'];
        $model_employee = Employee::model()->findAll(array('condition' => 'reporting_manager="' . $report_staff_id . '"'));
        if (!empty($model_employee)) {
            $jsonData['message'] = 'exist';
        } else {
            $jsonData['message'] = 'notexist';
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionMailsettings() {
        $model = new Mailsettings();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('mail_settings', array('model' => $model), false, true);
    }

    public function actionMailsettingsEmployeeList() {
        $model = new Mailsettings();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('mail_settings_emp_list', array('model' => $model), false, true);
    }

    public function actionSaveMailSetting() {

        $error_flag = FALSE;
        foreach ($_POST['Mailsettings'] as $value) {
            $jsonData["la"]= $value;
            $model = new Mailsettings();
            if ((int)$value['id'] > 0) {
               $model = $model->findByPk($value['id']);
            }
            $model->employee_id = $value['employee_id'];


            $model->leave_notify = ($value['leave_notify'] == 'on' ) ? "1" : "0";
            if (!$model->save()) {
                $error_flag = true;
                $error = CActiveForm::validate($model, '', false);
            }
        }
        if ($error_flag) {
            if ($error != '[]')
            {echo $error;}
        }
        else {
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
    //24/10/2018
    public function actionAddAttendanceManager() {
        $model = new ReportingManager();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('attendance_manager', array('model' => $model), false, true);
    }
    public function actionloademployeedetails() {
        $branch = $_POST['branch'];
        $model_employee = Employee::model()->findAll(array('condition' => 'branch_or_sponsor_id="' . $branch . '"'));
        $model_attendance_manager = AttendanceManager::model()->findAll(array('select' => 'employee_id', 'condition' => 'branch="' . $branch . '"'));
        $model_employee_1 = array();
        foreach ($model_attendance_manager as $key => $value) {
            $model_employee_1[$key] = $value->employee_id;
        }
        $this->renderPartial('attendancemanager_employee_list', array('model' => $model_employee, 'model_attendance_manager' => $model_employee_1, 'branch' => $branch), false, true);
    }
    public function actionsaveemployeeattendancemanager() {
        if (isset($_POST['Employee'])) {
            $branch = $_POST['attnd_branch'];
            foreach ($_POST['Employee'] as $each) {
                if (is_countable($_POST['arraycid']) && count($_POST['arraycid']) > 0) {
                    if (in_array($each['id'], $_POST['arraycid'])) {
                        if ($each['id'] != '') {
                            date_default_timezone_set("Asia/Dubai");
                            $model_attendance_manager = AttendanceManager::model()->find(array('condition' => 'employee_id="' . $each['id'] . '"'));
                            if (empty($model_attendance_manager)) {
                                $model_attendance_manager = new AttendanceManager();
                                $model_attendance_manager->employee_id = $each['id'];
                                $model_attendance_manager->branch = $branch;
                                $model_attendance_manager->created_by = Yii::app()->user->id;
                                $model_attendance_manager->created_date_time = date('Y-m-d h:i:s');
                                $model_attendance_manager->save();
                            } else {
                                AttendanceManager::model()->updateByPK($model_attendance_manager->id, array('updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')));
                            }
                        }
                    } else {
                        AttendanceManager::model()->deleteAll(array('condition' => 'employee_id="' . $each['id'] . '"'));
                    }
                } else {
                    AttendanceManager::model()->deleteAll(array('condition' => 'branch="' . $branch . '"'));
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actioncheckattendancemanager() {
        $staff_id = $_POST['staff_id'];
        $model_employee = Employee::model()->findAll(array('condition' => 'attendance_manager="'.$staff_id.'"'));
        if (!empty($model_employee)) {
            $jsonData['message'] = 'exist';
        } else {
            $jsonData['message'] = 'notexist';
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionDashboardPermission() {

        $model = HrGenerelSettings::model()->find();
        if (empty($model)) {
            $model = new HrGenerelSettings;
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('dashboard_permission_form', array('model' => $model), false, true);
    }
    public function actionSaveDashboardPermission() {
        $model = new HrGenerelSettings();
        //print_r($_POST); die();
        if (isset($_POST['HrGenerelSettings'])) {
            if ((int) @$_POST['HrGenerelSettings']['id'] > 0) {
                $model->id = (int) $_POST['HrGenerelSettings']['id'];
                $model = $model->findByPK($model->id);
            }
            $allPermissions = array();
            foreach ($_POST['HrGenerelSettings']['employee_panel_permission'] as $eachPermissionArray) {
                if (is_array($eachPermissionArray)) {
                    foreach ($eachPermissionArray as $eachPermission) {
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->employee_panel_permission = json_encode($allPermissions);
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionPdfSettings() {

        $model = DocumentSettings::model()->find();
        if (empty($model)) {
            $model = new DocumentSettings;
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false,);
        $this->renderPartial('pdf_setting', array('model' => $model), false, true);
    }
    public function actionSavePdfSettings() {
        $model = new DocumentSettings();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['DocumentSettings'])) {
            if ((int) @$_POST['DocumentSettings']['id'] > 0) {
                $model->id = (int) $_POST['DocumentSettings']['id'];
                $model = $model->findByPK($model->id);
            }
            $model->attributes = $_POST['DocumentSettings'];
            $model->company_web_address = $_POST['DocumentSettings']['company_web_address'];
            $model->company_logo = $_POST['DocumentSettings']['company_logo'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    public function actionGetApprovalSettings() {
        $model = new MasApproveSetting();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'branch_id',
            2 => 'functionality_name',
            3 => 'max_level'
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (functionality_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_desgn_edit'])  || Yii::app()->user->authorised_user == 1) {
               $button_string = '<div style="width:100%; text-align:center;"><button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hrsettings/createapproval&id=' . $row['id'] . '\',\'Edit Approval Settings \',\'lg\')"><i class="fa fa-edit"></i></button></div>';
             }

            $rowData[] = array($m, $row['branch']['branch_or_sponsor_name'], $row['functionality_name'],$row['max_level'], $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreateApproval() {
        $id=(int) Yii::app()->request->getParam('id');
        $model = new MasApproveSetting();
        if ($id>0) {
            $model = MasApproveSetting::model()->findbyPK($id);
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if ($id==1 || $id==4 || $id==5 || $id==6 || $id==7) {
            $this->renderPartial('create_approval', array('model' => $model), false, true);
        }else{
            $this->renderPartial('create_approval_form', array('model' => $model), false, true);
        }
    }
    public function actionSaveapprovalSettings() {        
        if (isset($_POST['MasApproveSetting'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['MasApproveSetting']))){	
                $model_approval_level= new MasApproveSetting();   
                if ((int) @$_POST['MasApproveSetting']['id'] > 0) {
                    $model_approval_level->id = (int) $_POST['MasApproveSetting']['id'];
                    $model_approval_level = MasApproveSetting::model()->findByPK($_POST['MasApproveSetting']['id']);  
                    $model_approval_level->updated_by= Yii::app()->user->id;
                    $model_approval_level->updated_date_time = date('Y-m-d h:i:s');

                }else{
                    $model_approval_level->created_by= Yii::app()->user->id;
                    $model_approval_level->created_date_time = date('Y-m-d h:i:s');
                }   

                $model_approval_level->functionality_name = $_POST['MasApproveSetting']['functionality_name'];
                $model_approval_level->max_level = $_POST['MasApproveSetting']['max_level'];	
                if(isset($_POST['MasApproveSetting']['employee_level_1']) && count($_POST['MasApproveSetting']['employee_level_1']) > 0){
                    $model_approval_level->employee_level_1 = implode(',',$_POST['MasApproveSetting']['employee_level_1']);
                }else{
                    $model_approval_level->employee_level_1 = "";
                }
                if(isset($_POST['MasApproveSetting']['employee_level_2']) && count($_POST['MasApproveSetting']['employee_level_2']) > 0){
                    $model_approval_level->employee_level_2 = implode(',',$_POST['MasApproveSetting']['employee_level_2']);
                }else{
                    $model_approval_level->employee_level_2 = "";
                }
                if(isset($_POST['MasApproveSetting']['employee_level_3']) && count($_POST['MasApproveSetting']['employee_level_3']) > 0){
                    $model_approval_level->employee_level_3 = implode(',',$_POST['MasApproveSetting']['employee_level_3']);
                }else{
                    $model_approval_level->employee_level_3 = "";
                }
                if(isset($_POST['MasApproveSetting']['employee_level_4']) && count($_POST['MasApproveSetting']['employee_level_4']) > 0){
                    $model_approval_level->employee_level_4 = implode(',',$_POST['MasApproveSetting']['employee_level_4']);
                }else{
                    $model_approval_level->employee_level_4 = "";
                }
                
            }
            if($model_approval_level->validate()){
                $model_approval_level->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    public function actionAddThresholdSalary() {
        $model = new Employee();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('threshold_salary', array('model' => $model), false, true);
    }
    public function actionloademployeeforsalary() {
        $branch =Yii::app()->request->getparam('branch'); 
        $model_employee = Employee::model()->findAll(array('condition' =>'branch_or_sponsor_id="' . $branch . '" AND isActive!="B"'));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value['employeefullname']. ' ' . $value['employeecode']] = $value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('salary_threshold_list', array('branch' => $branch,'arr_employee'=>$arr_employee), false, true); 
    }  
    public function actionSaveThresholdSalary() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    Employee::model()->updateByPK($items['id'], array('threshold_salary' =>$items['threshold_salary']));                   
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
    public function actionChangesalarytransfermode() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('salary_transfer_mode', array(), false, true);
    }
    public function actionloademployeeforsalarymode() {
        $branch =Yii::app()->request->getparam('branch'); 
        $model_employee = Employee::model()->findAll(array('condition' =>'branch_or_sponsor_id="' . $branch . '" AND isActive!="B"'));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value['employeefullname']. '-' . $value['employeecode']] = $value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('salary_transfer_mode_list', array('branch' => $branch,'arr_employee'=>$arr_employee), false, true); 
    } 
    public function actionSaveSalaryMode() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    Employee::model()->updateByPK($items['id'], array('payment_type' =>$items['payment_type']));                   
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
    public function actionAddContractType() {
        $model = new Employee();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('contract_type', array('model' => $model), false, true);
    }
    public function actionloademployeeforcontract() {
        $branch =Yii::app()->request->getparam('branch'); 
        $model_employee = Employee::model()->findAll(array('condition' =>'branch_or_sponsor_id="' . $branch . '" AND isActive!="B"'));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value['employeefullname']. ' ' . $value['employeecode']] = $value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('contract_type_list', array('branch' => $branch,'arr_employee'=>$arr_employee), false, true); 
    }  
    public function actionSaveContractType() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    Employee::model()->updateByPK($items['id'], array('employee_type' =>$items['employee_type']));                   
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
    //added on 18-02-2021
    public function actionChangeSalaryCalculationMethod() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('salary_calculation_method', array(), false, true);
    }
    public function actionLoadEmployeeForSalaryCalculationMethod(){
        $branch =Yii::app()->request->getparam('branch'); 
        $model_employee = Employee::model()->findAll(array('condition' =>'branch_or_sponsor_id="' . $branch . '" AND isActive!="B"'));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value['employeefullname']. ' ' . $value['employeecode']] = $value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('salary_calculation_method_list', array('branch' => $branch,'arr_employee'=>$arr_employee), false, true); 
    }
    public function actionSaveSalaryCalculationMethod() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    Employee::model()->updateByPK($items['id'], array('salary_calculation_method' =>$items['salary_calculation_method']));                   
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
    public function actionAppPermission() {

        $model = HrGenerelSettings::model()->find();
        if (empty($model)) {
            $model = new HrGenerelSettings;
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('app_permission_form', array('model' => $model), false, true);
    }
    public function actionSaveAppPermission() {
        $model = new HrGenerelSettings();
        if (isset($_POST['HrGenerelSettings'])) {
            if ((int) @$_POST['HrGenerelSettings']['id'] > 0) {
                $model->id = (int) $_POST['HrGenerelSettings']['id'];
                $model = $model->findByPK($model->id);
            }
            $allPermissions = array();
            foreach ($_POST['HrGenerelSettings']['app_permission'] as $eachPermissionArray) {
                if (is_array($eachPermissionArray)) {
                    foreach ($eachPermissionArray as $eachPermission) {
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->app_permission = json_encode($allPermissions);
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
}
