<?php
class HrrequestController extends Controller {
    public $layout = 'main';
    public function accessRules() {
        return array(array('allow', // allow all users to perform 'index' and 'view' actions
        'actions' => array('login', 'error', 'logout', 'Forgotpassword'), 'users' => array('*'),), array('allow', // allow authenticated user to perform 'create' and 'update' actions
        'actions' => array('index', 'GetRequestDetails', 'PrintCertificate', 'PrintCertificateDetails', 'View', 'DownloadCertificate', 'indexCertificate', 'Approve', 'indexMeeting', 'SaveApprovecertificate', 'upload', 'Create', 'GetEmployeeCertificateList', 'GetEmployeeMeetingRequestList', 'saveExcuseMeeting', 'EmployeeApplyCertificate', 'SaveApplyCertificate', 'IndexComplaint', 'CreateComplaint', 'saveComplaintSuggestion', 'Indexresignation', 'GetResignation', 'createResignation', 'SaveApplyResignation', 'Viewresignation', 'approveLmResignation', 'GetEmployeeComplaintList', 'GetResignationApproval', 'SaveLmApproval', 'HrResignation', 'GetResignationApprovalHR', 'ViewresignationHRApprove', 'SaveHRApproval', 'ViewresignationHRApproveView', 'createResignationHR', 'SaveApplyHRResignation', 'UploadExpense', 'Indexexpense', 'GetExpense', 'CreateExpense', 'Indexapproveexpense', 'SaveExpense', 'sendExpense', 'GetExpenseApproval', 'ViewexpenseLM', 'DeleteExpense', 'DownloadDocument', 'SaveExpenseLmApproval', 'hrExpense', 'GetExpenseApprovalHR', 'ViewexpenseHR', 'SaveExpenseHRApproval', 'ViewexpenseHRApproveView', 'indexhrmeeting', 'GetMeetingRequestHrList', 'deleteRequest', 'ViewMeetingRequest', 'Indexhrcomplaint', 'GetHrComplaintList', 'DeleteComplaint', 'ViewComplaintRequest', 'ApproveResignationlm', 'CreateRequest', 'saveCertificate', 'CreateExcuse', 'CreateSuggestion', 'CreateEmployeeExpense', 'SaveExpenseDetails', 'CertificateApproval', 'GetPendingRequest', 'CertificateApprove', 'saveApproveReject', 'loadmasterbranch', 'deleteRequestdetails', 'loadmasterbranchname', 'getemployeedetails', 'loadcompanybranch', 'getemployeedetail', 'GetExchangeRate', 'deleteuploadedfile', 'IndexDetails', 'GetExpenseHistory', 'checkduplicateentry', 'checkduplicateexpense', 'GetExpenseVerify', 'VerifyexpenseRequest', 'PrintExpenseDetails', 'SaveVerifyExpense', 'deleteExpensedetails','PrintcertificateWord','approvalhierarchy'), 'expression' => '$user->isMember()',), array('deny', // deny all users
        'users' => array('*'),),);
    }
    public function filters() {
        return array('accessControl');
    }
    //Certificate-Start
    public function actionloadmasterbranchname() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch_certificate', array());
    }
    public function actionIndex() {
        $this->layout = 'layout';
        $model_module_doc_request= HrModules::model()->findByPK(10);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emprequest_docmnt_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_doc_request->grant_access == 1 && $model_module_doc_request->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch = $this->ciphertext($en_id, "d");
            if ($branch != '') {
                $model = new EmployeeCertificate();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index', array('model' => $model, 'branch' => $branch));
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetRequestDetails() {
        $model = new EmployeeCertificate();
        $employee_id = $_POST['employee_id'];
       // $status = $_POST['status'];
        $branch_id = $_POST['branch_id'];
        $certificate = $_POST['certificate'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'apply_date', 4 => 'approval_date', 5 => 'mascertificate.certificate_name', 6 => 'apply_notes', 7 => 'status', 8 => 'id',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $arr_status=$_POST['status'];
        $status='H';
        $pending_status_flag=0;
        
        if(is_countable($arr_status) && count($arr_status)>1){
            if (in_array('H', $arr_status)) {
                $pending_status_flag= 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee = $model_user->hr_connected_employee_id;
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition.= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        $pending_ids = EmployeeCertificate::getPendingapproval($branch_id, 1);

        if ($employee_id != '') {
            $condition.= " and employee_id ='" . $employee_id . "'";
        }
        if ($certificate != '') {
            $condition.= " and certificate_id ='" . $certificate . "'";
        }
        if($status=='H'){
            $condition.= " AND t.id IN(".$pending_ids.")";
        }else if($status!=''){
            if($pending_status_flag==0){
                $condition.= " AND status IN(".$status.")";
            }else if($pending_status_flag==1){
                $condition.= " AND (status IN(".$status.") OR t.id IN(".$pending_ids."))";
            }
        }
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR mascertificate.certificate_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'mascertificate')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'mascertificate')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $applydate = "";
            $approval_date = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($row['apply_date'] != '0000-00-00' && $row['apply_date'] != '') {
                $applydate = date("d/m/Y", strtotime($row['apply_date']));
            }
            if ($row['approval_date'] != '0000-00-00' && $row['approval_date'] != '') {
                $approval_date = date("d/m/Y", strtotime($row['approval_date']));
            }
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && $row->approvelevel->level_1_type == 'H' && $row->approvelevel->level_1_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && $row->approvelevel->level_2_type == 'H' && $row->approvelevel->level_2_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && $row->approvelevel->level_3_type == 'H' && $row->approvelevel->level_3_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && $row->approvelevel->level_4_type == 'H' && $row->approvelevel->level_4_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && $row->approvelevel->level_5_type == 'H' && $row->approvelevel->level_5_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($row->status == 3 || $row->status == 5 || $row->status == 7 || $row->status == 9 || $row->status == 11 || $row->status == 13 || $row->status == 14) {
                $show_approve_button = 0;
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $button_string = "";
            $print_varify=$approve_upload=$approve_reject=$view_certificate=$delete_certificate= $direct_approval=$admin_certificate=$delete_certificate=0;
            if ($show_approve_button == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_document_request_print']) || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-warning btn-xs" title="Print & Verify Certificate(PDF)" onclick="loadPopupModal(\'hr/hrrequest/printcertificate&type=1&id=' . $row['id'] . '\',\'PRINT & VERIFY CERTIFICATE \',\'md\')"><i class="fa fa-file-pdf-o"></i></button> &nbsp;';
                    $print_varify =1;
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_document_request_approve']) || Yii::app()->user->authorised_user == 1) {
                    if ($final_level == 'Y') {
                        $button_string.= '<button class="btn btn-success btn-xs" title="Approve & Upload Certificate" onclick="loadPopupModal(\'hr/hrrequest/Approve&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'APPROVE CERTIFICATE \',\'md\')"><i class="fa fa-thumbs-o-up"></i></button> &nbsp;';
                        $approve_upload=1;
                    } else {
                        $button_string.= '<button class="btn btn-success btn-xs" title="Confirm/Reject Certificate Request" onclick="loadPopupModal(\'hr/hrrequest/certificateapprove&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Confirm/Reject Certificate\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                        $approve_reject =1;
                    }
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_document_request_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-info btn-xs" title="View Certicate Application Details" onclick="loadPopupModal(\'hr/hrrequest/view&id=' . $row['id'] . '\',\'CERTIFICATE APPLICATION DETAILS\',\'lg\')"><i class="fa fa-eye"></i></button> &nbsp;';
                $view_certificate =1;
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emp_document_request_delete']) || Yii::app()->user->authorised_user == 1) && $row['status'] == 1) {
                $button_string.= '<a href ="javascript:void(0);" title="Delete Certificate Request" class="btn btn-danger btn-xs" onclick="deleteRequestdetails(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
                $delete_certificate =1;
            }
            if ($row->status==1 || $row->status==2 || $row->status==4 || $row->status==6 || $row->status==8 || $row->status==10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_document_admin_request_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-warning btn-xs" title="Print & Verify Certificate(Direct)" onclick="loadPopupModal(\'hr/hrrequest/printcertificate&type=1&id=' . $row['id'] . '\',\'PRINT & VERIFY CERTIFICATE \',\'md\')"><i class="fa fa-file-pdf-o"></i></button> &nbsp;';
                    $admin_certificate =1;
                    $last_level=$row->max_level;
                    $button_string.= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/hrrequest/Approve&final_level=Y&level=' . $last_level . '&id=' . $row['id'] . '\',\'APPROVE CERTIFICATE \',\'md\')"><i class="fa fa-thumbs-o-up"></i></button> &nbsp;';
                     $direct_approval =1;
                    }
                }
            $rowData[] = array($m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $applydate, $approval_date, $row['mascertificate']['certificate_name'], $row['apply_notes'], EmployeeCertificate::getStatus($row['status']), array('id'=>$row['id'],'last_level'=>$last_level,'final_level'=>$final_level,'level_no'=>$level_no,'print_varify'=>$print_varify,'approve_upload'=>$approve_upload,'approve_reject'=>$approve_reject,'view_certificate'=>$view_certificate, 'direct_approval'=>$direct_approval,'admin_certificate'=>$admin_certificate,'delete_certificate'=>$delete_certificate));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionPrintCertificate() {
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $model = EmployeeCertificate::model()->findByPk($id);
        if (!empty($model)) {
           // if ($ref_no == '') {
                $model_certificate_reference_no = EmployeeCertificate::model()->with('employeedetail')->find(array('select' => 'max(reference_no) as reference_no', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $model->employeedetail->branch_or_sponsor_id . '" and certificate_id="' . $model->certificate_id . '" and (status="12" OR status="14")'));
                if (empty($model_certificate_reference_no)) {
                    $model_master_certificate = MasCertificate::model()->findByPk($model->certificate_id);
                    $model->reference_no = $model_master_certificate->reference_no;
                }  else if ($model->reference_no != '' && $model->reference_no!=0) {
                    $model->reference_no = $model->reference_no;
                } else {
                    $model->reference_no = $model_certificate_reference_no->reference_no + 1;
                }
           // }
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('print_certificate', array('model' => $model, 'type' => $type), false, true);
    }
    public function actionPrintCertificateDetails() {
        $id = $_POST['EmployeeCertificate']['id'];
        $ref_no = $_POST['EmployeeCertificate']['reference_no'];
        $use_letter_head=$date_leaving=$certificate_for=$type_certificate ='';
        if(!empty($_POST['date_leaving'])){
            $date_leaving = $_POST['date_leaving'];
        }
        if(!empty($_POST['certificate_for'])){
            $certificate_for = $_POST['certificate_for'];
        }
        if(!empty($_POST['type'])){
            $type_certificate = $_POST['type'];
        }
        
        if (isset($_POST['use_letter_head']) && $_POST['use_letter_head'] != '') {
            $use_letter_head = $_POST['use_letter_head'];
        }
        $model = EmployeeCertificate::model()->findByPk($id);
        if (!empty($model)) {
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d H:i:s');
            if ($ref_no == '') {
                $model_certificate_reference_no = EmployeeCertificate::model()->with('employeedetail')->find(array('select' => 'max(reference_no) as reference_no', 'condition' => 'employeedetail.branch_or_sponsor_id="' . $model->employeedetail->branch_or_sponsor_id . '" and certificate_id="' . $model->certificate_id . '" and (status="12" OR status="14")'));
                if ($model_certificate_reference_no->reference_no == '') {
                    $model_master_certificate = MasCertificate::model()->findByPk($model->certificate_id);
                    $ref_no = $model_master_certificate->reference_no;
                } else {
                    $ref_no = $model_certificate_reference_no->reference_no + 1;
                }
            }
            if (isset($_POST['EmployeeCertificate']['addresses_to']) && $_POST['EmployeeCertificate']['addresses_to'] != '') {
                $model->addresses_to = $_POST['EmployeeCertificate']['addresses_to'];
            }
            if (isset($_POST['EmployeeCertificate']['embassy']) && $_POST['EmployeeCertificate']['embassy'] != '') {
                $model->embassy = $_POST['EmployeeCertificate']['embassy'];
            }
            if (isset($_POST['EmployeeCertificate']['visit_country']) && $_POST['EmployeeCertificate']['visit_country'] != '') {
                $model->visit_country = $_POST['EmployeeCertificate']['visit_country'];
            }
            if (isset($_POST['EmployeeCertificate']['visit_purpose']) && $_POST['EmployeeCertificate']['visit_purpose'] != '') {
                $model->visit_purpose = $_POST['EmployeeCertificate']['visit_purpose'];
            }
            if (isset($_POST['EmployeeCertificate']['visit_from']) && $_POST['EmployeeCertificate']['visit_from'] != '') {
                $model->visit_from = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeCertificate']['visit_from'])));
            }
            if (isset($_POST['EmployeeCertificate']['visit_to']) && $_POST['EmployeeCertificate']['visit_to'] != '') {
                $model->visit_to = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeCertificate']['visit_to'])));
            }
            if (isset($_POST['EmployeeCertificate']['performance_month_1']) && $_POST['EmployeeCertificate']['performance_month_1'] != '') {
                $model->performance_month_1 = $_POST['EmployeeCertificate']['performance_month_1'];
            }
            if (isset($_POST['EmployeeCertificate']['performance_month_2']) && $_POST['EmployeeCertificate']['performance_month_2'] != '') {
                $model->performance_month_2 = $_POST['EmployeeCertificate']['performance_month_2'];
            }
            if (isset($_POST['EmployeeCertificate']['performance_month_3']) && $_POST['EmployeeCertificate']['performance_month_3'] != '') {
                $model->performance_month_3 = $_POST['EmployeeCertificate']['performance_month_3'];
            }
            if (isset($_POST['EmployeeCertificate']['probation']) && $_POST['EmployeeCertificate']['probation'] != '') {
                $model->probation = $_POST['EmployeeCertificate']['probation'];
            }
            if (isset($_POST['EmployeeCertificate']['visitcompny_town']) && $_POST['EmployeeCertificate']['visitcompny_town'] != '') {
                $model->visitcompny_town = $_POST['EmployeeCertificate']['visitcompny_town'];
            }
            if(!empty($_POST['EmployeeCertificate']['month'])){
                $model->month = $_POST['EmployeeCertificate']['month'];
            }
            if(!empty($_POST['EmployeeCertificate']['new_salary'])){
            $model->new_salary = $_POST['EmployeeCertificate']['new_salary'];
        }
             if(!empty($_POST['EmployeeCertificate']['salary_year'])){
            $model->salary_year = $_POST['EmployeeCertificate']['salary_year'];
        }
            $model->reference_no = $ref_no;
            $model->save(false);
            $type = $model->certificate_id;
            $vehicle_type = '';
            $visa_type = '';
            $visit_purpose = '';
            $sign = '';
            $p_noun = '';
            $sign_2 = '';
            if ($model->employeedetail->gender == 1) {
                $sign = 'Mr.';
                $p_noun = 'his';
                $sign_1 = 'him';
                $sign_2 = 'he';
            } else {
                $sign = 'Ms.';
                //                if ($model->employeedetail->marital_status == 1) {
                //                    $sign = 'Ms.';
                //                } else {
                //                    $sign = 'Mrs.';
                //                }
                $p_noun = 'her';
                $sign_1 = 'her';
                $sign_2 = 'she';
            }
            $signature_array = array();
            if (isset($_POST['authority'])) {
                $signature = $_POST['authority'];
                $sig_val = HrMasCertificateAutorization::model()->findByPK($signature);
                $signature_array = array('name' => $sig_val->employeedetail->employeefullname, 'designation' => $sig_val->designation, 'authority_signature' => $sig_val->authority_signature);
            }
            $model_document = EmployeeDocuments::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and document_id="1"'));
            $model_document_emirate = EmployeeDocuments::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and document_id="2"'));
            $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $model->employee_id . '" and isActive="Y"  AND valid_from <="' . date('Y-m-d') . '" AND valid_to >="' . date('Y-m-d') . '"'));
        } else {
            $type = 0;
        }
        $certificate = '';
        $title = "";
        switch ($type) {
            case 1:
                $certificate = "pdf_salary_certificate";
            break;
            case 2:
                $certificate = "pdf_salary_transfer";
            break;
            case 3:
                $certificate = "pdf_passport_release";
            break;
            case 4:
                $certificate = "pdf_retrenchment";
            break;
            case 5:
                $certificate = "pdf_confirmation";
            break;
            case 6:
                $certificate = "pdf_business_trip";
            break;
            case 8:
                $certificate = "pdf_increment_letter";
            break;
            case 11:
                $certificate = "pdf_liquor_licence";
            break;
            case 12:
                $certificate = "pdf_noc_licence";
            break;
            case 13:
                $certificate = "pdf_personal_trip";
            break;
            default:
                $certificate = "pdf_default";
        }
       
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        if ($model->employeedetail->branch_sponsor->watermark_logo != '') {
            $mPDF1->SetWatermarkImage('uploads/logo/' . $model->employeedetail->branch_sponsor->watermark_logo, 0.4, '', 'F');
        }
        $mPDF1->showWatermarkImage = true;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $seal = $model->employeedetail->branch_sponsor->certificate_seal;

        $mPDF1->WriteHTML($this->renderPartial("application.modules.hr.views.pdf.certificate.$certificate", array('model_document_emirate' => $model_document_emirate, 'sign_2' => $sign_2, 'use_letter_head' => $use_letter_head, 'sign_1' => $sign_1, 'visa_type' => $visa_type, 'visit_purpose' => $visit_purpose, 'date_leaving' => $date_leaving, 'ref_no' => $ref_no, 'signature' => $signature_array, 'sign' => $sign, 'p_noun' => $p_noun, 'vehicle_type' => $vehicle_type, 'title' => $title, 'model_salary' => $model_salary, 'seal' => $seal, 'model' => $model, 'model_document' => $model_document), true));
        $mPDF1->Output($certificate . '.pdf', 'I');
    }
    public function actionApprove() {
        $model = new EmployeeCertificate();
        $id = (int)Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('approve', array('model' => $model, 'id' => $id, 'level' => $level, 'final_level' => $final_level), false, true);
    }
    public function actionSaveApprovecertificate() {
        if (isset($_POST['EmployeeCertificate'])) {
            $model = new EmployeeCertificate();
            if ((int)@$_POST['EmployeeCertificate']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeCertificate']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            if (isset($_POST['EmployeeCertificate']['certificate_document']))
            {
            $model->certificate_document = $_POST['EmployeeCertificate']['certificate_document'];
            }
            $model->last_approved_level = $_POST['EmployeeCertificate']['last_approved_level'];
            if (isset($_POST['EmployeeCertificate']['approval_comment']))
            {
            $model->approval_comment = $_POST['EmployeeCertificate']['approval_comment'];
            }
            $model->approval_date = date('Y-m-d');
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $model->approval_id = $approved_employee_id;
            $model->status = $_POST['EmployeeCertificate']['status'];
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="19"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(19, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionView() {
        $model = new EmployeeCertificate();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('certificate_application_view', array('model' => $model, 'id' => $id), false, true);
    }
    public function actionDownloadCertificate() {
        $id = (int)Yii::app()->request->getParam('id');
        $type = (int)Yii::app()->request->getParam('type');
        $model_certificate = EmployeeCertificate::model()->findByPk($id);
        $file = $model_certificate->certificate_document;
        $path = Yii::getPathOfAlias('webroot') . "/uploads/certificate/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        if ($type == 1) {
            EmployeeCertificate::model()->updateByPK($id, array('status' => 14, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
        }
        Yii::app()->end();
    }
    public function actionIndexCertificate() {
        $this->layout = 'main';
        $model_module_doc_request= HrModules::model()->findByPK(10);
        if ($model_module_doc_request->grant_access == 1 && $model_module_doc_request->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_certificate');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetEmployeeCertificateList() {
        $model = new MasCertificate();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'certificate_name', 2 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" and apply_from="N"';
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        EmployeeCertificate::model()->updateAll(array('view_status' => 1, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')), 'employee_id="' . $empid . '" and view_status="0" and (status="2" OR status="3")');
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " and (certificate_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $model_certificate_request_approved = EmployeeCertificate::model()->find(array('condition' => 'employee_id="' . $empid . '" and certificate_id="' . $row->id . '" and status="12"'));
            $model_certificate_request = EmployeeCertificate::model()->find(array('condition' => 'employee_id="' . $empid . '" and certificate_id="' . $row->id . '" and (status="1" OR status="2" OR status="4" OR status="6" OR status="8" OR status="10")'));
            $button_string = "";
            $status=0;
            $download_button=$apply_button=0;
            if (!empty($model_certificate_request_approved)) {
                $download_button =1;
                $button_string.= '<a class="btn btn-primary btn-xs" title="Download" href=' . $this->createUrl('hrrequest/downloadcertificate', array('id' => $model_certificate_request_approved->id, 'type' => 1)) . ' target="_blank"><i class="fa fa-download"></i></a>';
            } else if (empty($model_certificate_request)) {
                $button_string.= '<button class="btn btn-primary btn-xs" title="Apply" onclick="loadPopupModal(\'hr/hrrequest/employeeapplycertificate&cid=' . $row['id'] . '&id=' . $empid . '\',\'Apply for Certificate \',\'lg\')"><i class="fa fa-paper-plane"></i></button>';
                $apply_button=1;
                
            } else {
                $status= 1;
            }
            $rowData[] = array(++$m, $row['certificate_name'],$status, array('cid'=>$row['id'],'employee_id'=>$empid,'id'=>$model_certificate_request_approved->id,'download_button'=>$download_button,'apply_button'=>$apply_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionEmployeeApplyCertificate() {
        $id = Yii::app()->request->getparam("id");
        $cid = Yii::app()->request->getparam("cid");
        $model = EmployeeCertificate::model()->find(array('condition' => 'certificate_id="' . $cid . '" and employee_id="' . $id . '" and status="1"'));
        if (empty($model)) {
            $model = new EmployeeCertificate();
        }
        $certificate_name = MasCertificate::model()->findByPK($cid)->certificate_name;
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $id . '" and functionality_id="4"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('apply_certificate_form', array('model' => $model, 'cid' => $cid, 'id' => $id, 'certificate_name' => $certificate_name, 'model_master_approve_setting' => $model_master_approve_setting), false, true);
    }
    public function actionSaveApplyCertificate() {
        if (isset($_POST['EmployeeCertificate'])) {
            $model = new EmployeeCertificate();
            if ((int)@$_POST['EmployeeCertificate']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeCertificate']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeCertificate'];
            //Employee ID
            $employee_id = $_POST['EmployeeCertificate']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="4"'));
            if(!empty($model_master_approve_setting))
            {
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $model->apply_notes = $_POST['EmployeeCertificate']['apply_notes'];
            $employee_visit_from='';
            if(isset($_POST['EmployeeCertificate']['visit_from']))
            {
                $employee_visit_from=$_POST['EmployeeCertificate']['visit_from'];
            }
            $employee_visit_to='';
            if(isset($_POST['EmployeeCertificate']['visit_to']))
            {
                $employee_visit_to=$_POST['EmployeeCertificate']['visit_to'];
            }
            if ($_POST['EmployeeCertificate']['apply_date'] != '0000-00-00' && $_POST['EmployeeCertificate']['apply_date'] != '') {
                $model->apply_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeCertificate']['apply_date'])));
            }
            if ($employee_visit_from != '0000-00-00' && $employee_visit_from != '') {
                $model->visit_from = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeCertificate']['visit_from'])));
            }
            if ($employee_visit_to != '0000-00-00' && $employee_visit_to != '') {
                $model->visit_to = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeCertificate']['visit_to'])));
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="18"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(18, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionCreateRequest() {
        $branch = Yii::app()->request->getParam('branch');
        $model = new EmployeeCertificate();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('certificate_form', array('model' => $model, 'branch' => $branch), false, true);
    }
    public function actionSaveCertificate() {
        if (isset($_POST['EmployeeCertificate'])) {
            $model = new EmployeeCertificate();
            if ((int)@$_POST['EmployeeCertificate']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeCertificate']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeCertificate'];
            $model->apply_notes = $_POST['EmployeeCertificate']['apply_notes'];
            $model->apply_date = date("Y-m-d");
            $model->status = 1;
            //Employee ID
            $employee_id = $_POST['EmployeeCertificate']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="4"'));
            if(!empty($model_master_approve_setting))
            {
                $model->function_type = $model_master_approve_setting->id;
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $model->last_approved_level = 0;
        /*    if ($_POST['EmployeeCertificate']['certificate_id'] > 0) {
                $model_certificate_reference_no = EmployeeCertificate::model()->find(array('select' => 'max(reference_no) as reference_no', 'condition' => 'certificate_id="' . $_POST['EmployeeCertificate']['certificate_id'] . '"'));
                if (empty($model_certificate_reference_no) || $model_certificate_reference_no->reference_no == '') {
                    $model_master_certificate = MasCertificate::model()->findByPk($_POST['EmployeeCertificate']['certificate_id']);
                    $model->reference_no = $model_master_certificate->reference_no;
                } else {
                    $model->reference_no = $model_certificate_reference_no->reference_no + 1;
                }
            }*/
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionCertificateApproval() {
        $this->layout = "main";
        $model_module_doc_request = HrModules::model()->findByPK(10);
        if ($model_module_doc_request->grant_access == 1 && $model_module_doc_request->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('certificate_approval');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetPendingRequest() {
        $model = new EmployeeCertificate();
        $certificate = $_POST['type'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'employeedetail.first_name', 2 => 'mascertificate.certificate_name', 3 => 'apply_date', 4 => 'status', 5 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $model_employee = User::model()->findByPk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $pending_certificates = EmployeeCertificate::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND t.last_approved_level<t.max_level And t.id IN(' . $pending_certificates . ')';
        if ($certificate != '') {
            $condition.= " and certificate_id ='" . $certificate . "'";
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR mascertificate.certificate_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'mascertificate', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'mascertificate', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $applydate = "";
            if ($row['apply_date'] != '0000-00-00' && $row['apply_date'] != '') {
                $applydate = date("d/m/Y", strtotime($row['apply_date']));
            }
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($row->status == 3 || $row->status == 5 || $row->status == 7 || $row->status == 9 || $row->status == 11 || $row->status == 13 || $row->status == 14) {
                $show_approve_button = 0;
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $approve_reject=$view_button=0;
            if ($show_approve_button == 1) { //For Approval
                $approve_reject =1;
                $button_string.= '<button class="btn btn-success btn-xs" title="Confirm/Reject" onclick="loadPopupModal(\'hr/hrrequest/certificateapprove&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Confirm/Reject Certificate\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
            }
            $button_string.= '<button class="btn btn-info btn-xs" title="Certicate Application Details" onclick="loadPopupModal(\'hr/hrrequest/view&id=' . $row['id'] . '\',\'CERTIFICATE APPLICATION DETAILS\',\'lg\')"><i class="fa fa-eye"></i></button> &nbsp;';
            $rowData[] = array(++$m, $this->ciphertext($row['employeedetail']['first_name'], 'd') . ' ' . $this->ciphertext($row['employeedetail']['last_name'], 'd'), $row['mascertificate']['certificate_name'], $applydate, EmployeeCertificate::getStatus($row['status']), array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'approve_reject'=>$approve_reject,'view_button'=>$view_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCertificateApprove() {
        $this->layout = "main";
        $id = Yii::app()->request->getparam("id");
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = EmployeeCertificate::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('certificate_approve', array('model' => $model, 'level' => $level, 'final_level' => $final_level), false, true);
    }
    public function actionsaveApproveReject() {
        if (isset($_POST['EmployeeCertificate'])) {
            $model = new EmployeeCertificate();
            if ((int)@$_POST['EmployeeCertificate']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeCertificate']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->status = $_POST['EmployeeCertificate']['status'];
            $model->last_approved_level = $_POST['EmployeeCertificate']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            if ($level == 1) {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2) {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3) {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4) {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5) {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="19"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(19, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actiondeleteRequestdetails() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new EmployeeCertificate();
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionPrintcertificateWord() {
        $id = $_GET['EmployeeCertificate']['id'];
        $ref_no = $_GET['EmployeeCertificate']['reference_no'];
        $date_leaving = $_GET['date_leaving'];
        $certificate_for = $_GET['certificate_for'];
        $type_certificate = $_GET['type'];
        if (isset($_GET['use_letter_head']) && $_GET['use_letter_head'] != '') {
            $use_letter_head = $_GET['use_letter_head'];
        }
        $model = EmployeeCertificate::model()->findByPk($id);
        if (!empty($model)) {
            if ($ref_no == '') {
                $model_certificate_reference_no = EmployeeCertificate::model()->with('employeedetail')->find(array('select' => 'max(reference_no) as reference_no', 'condition' => 'employeedetail.branch_or_sponsor_id="'.$model->employeedetail->branch_or_sponsor_id.'" and certificate_id="' . $model->certificate_id . '" and status="12"'));
                if ($model_certificate_reference_no->reference_no == '') {
                    $model_master_certificate = MasCertificate::model()->findByPk($model->certificate_id);
                    $ref_no = $model_master_certificate->reference_no;
                } else {
                    $ref_no = $model_certificate_reference_no->reference_no + 1;
                }
            }
            if (isset($_GET['EmployeeCertificate']['addresses_to']) && $_GET['EmployeeCertificate']['addresses_to'] != '') {
                $model->addresses_to = $_GET['EmployeeCertificate']['addresses_to'];
            }
            if (isset($_GET['EmployeeCertificate']['embassy']) && $_GET['EmployeeCertificate']['embassy'] != '') {
                $model->embassy = $_GET['EmployeeCertificate']['embassy'];
            }
            if (isset($_GET['EmployeeCertificate']['visit_country']) && $_GET['EmployeeCertificate']['visit_country'] != '') {
                $model->visit_country = $_GET['EmployeeCertificate']['visit_country'];
            }
            if (isset($_GET['EmployeeCertificate']['visit_purpose']) && $_GET['EmployeeCertificate']['visit_purpose'] != '') {
                $model->visit_purpose = $_GET['EmployeeCertificate']['visit_purpose'];
            }
            if (isset($_GET['EmployeeCertificate']['visit_from']) && $_GET['EmployeeCertificate']['visit_from'] != '') {
                $model->visit_from = date("Y-m-d", strtotime(str_replace('/', '-', $_GET['EmployeeCertificate']['visit_from'])));
            }
            if (isset($_GET['EmployeeCertificate']['visit_to']) && $_GET['EmployeeCertificate']['visit_to'] != '') {
                $model->visit_to = date("Y-m-d", strtotime(str_replace('/', '-', $_GET['EmployeeCertificate']['visit_to'])));
            }
            if (isset($_GET['EmployeeCertificate']['performance_month_1']) && $_GET['EmployeeCertificate']['performance_month_1'] != '') {
                $model->performance_month_1 = $_GET['EmployeeCertificate']['performance_month_1'];
            }
            if (isset($_GET['EmployeeCertificate']['performance_month_2']) && $_GET['EmployeeCertificate']['performance_month_2'] != '') {
                $model->performance_month_2 = $_GET['EmployeeCertificate']['performance_month_2'];
            }
            if (isset($_GET['EmployeeCertificate']['performance_month_3']) && $_GET['EmployeeCertificate']['performance_month_3'] != '') {
                $model->performance_month_3 = $_GET['EmployeeCertificate']['performance_month_3'];
            }
            $model->month =$_GET['EmployeeCertificate']['month'];
            $model->new_salary =$_GET['EmployeeCertificate']['new_salary'];
            $model->salary_year =$_GET['EmployeeCertificate']['salary_year'];
            $model->reference_no = $ref_no;
            $model->save(false);
            $type = $model->certificate_id;
            $vehicle_type = '';
            $visa_type = '';
            $visit_purpose = '';
            $sign = '';
            $p_noun = '';
            $sign_2 = '';
            if ($model->employeedetail->gender == 1) {
                $sign = 'Mr.';
                $p_noun = 'his';
                $sign_1 = 'him';
                $sign_2 = 'he';
            } else {
                $sign = 'Ms.';
//                if ($model->employeedetail->marital_status == 1) {
//                    $sign = 'Ms.';
//                } else {
//                    $sign = 'Mrs.';
//                }
                $p_noun = 'her';
                $sign_1 = 'her';
                $sign_2 = 'she';
            }

            $signature_array = array();
            if (isset($_GET['field'])) {
                $signature = $_GET['field'];
                foreach ($signature as $value) {
                    $signature_array[] = $value;
                }
            }
            $model_document = EmployeeDocuments::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and document_id="1"'));
            $model_document_emirate = EmployeeDocuments::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and document_id="2"'));
            $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $model->employee_id . '" and isActive="Y"  AND valid_from <="' . date('Y-m-d') . '" AND valid_to >="' . date('Y-m-d') . '"'));
        } else {
            $type = 0;
        }
        $certificate = '';
        $title = "";
        switch ($type) {
            case 1:
                $certificate = "word_salary_certificate";
                break;
            case 2:
                $certificate = "word_salary_transfer";
                break;
            case 3:
                $certificate = "word_termination";
                break;
            case 4:
                $certificate="word_retrenchment";
                break;
            case 5:
                $certificate="word_confirmation";
                break;
            case 6:
                $certificate="word_probation_extension";
                break;
            case 8:
                $certificate="word_increment_letter";
                break;
            case 11:
                $certificate="word_termination_performance";
                break;
            default:
                $certificate = "word_default";
        }
        $filename = 'certificate.doc';
        header("Content-type: application/vnd.ms-word");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial("word/".$certificate, array('model_document_emirate'=>$model_document_emirate,'sign_2' => $sign_2, 'use_letter_head' => $use_letter_head, 'sign_1' => $sign_1, 'visa_type' => $visa_type, 'visit_purpose' => $visit_purpose, 'date_leaving' => $date_leaving, 'ref_no' => $ref_no, 'signature' => $signature_array, 'sign' => $sign, 'p_noun' => $p_noun, 'vehicle_type' => $vehicle_type, 'title' => $title, 'model_salary' => $model_salary, 'model' => $model, 'model_document' => $model_document),  false, true);
    }
    //End Certificate
    //Late Excuse-Start
    public function actionIndexMeeting() {
        $this->layout = 'main';
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index_meeting');
    }
    public function actionIndexhrmeeting() {
        $this->layout = 'layout';
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_emprequest_meeting_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_hr_meeting');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetEmployeeMeetingRequestList() {
        $model = new EmployeeLeaveExcuse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'request_date', 2 => 'type', 3 => 'customer_name', 4 => 'excuse_reason', 5 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $condition = 't.employee_id="' . $empid . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR request_date LIKE '%" . $searchString . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $type = '';
            if ($row['type'] == 1) {
                $type = 'Meeting';
            } else {
                $type = 'Excuse';
            }
            $button_string = '<button class="btn btn-primary btn-xs" title="Excuse / Meeting Requests" onclick="loadPopupModal(\'hr/hrrequest/ViewMeetingRequest&id=' . $row['id'] . '\',\'' . $type . ' Requests \',\'lg\')"><i class="fa fa-eye"></i></button>';
            $rowData[] = array($m, date('d/m/Y', strtotime($row['request_date'])), $type, $row['customer_name'], $row['excuse_reason'], $button_string,);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionGetMeetingRequestHrList() {
        $model = new EmployeeLeaveExcuse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'request_date', 4 => 'type', 5 => 'customer_name', 6 => 'excuse_reason', 7 => 't.id');
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition.= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR request_date LIKE '%" . $searchString . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            if ($row['type'] == 1) {
                $type = 'Meeting';
            } else {
                $type = 'Excuse';
            }
            $button_string = "";
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_meeting_requests_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-primary btn-xs" title="Excuse / Meeting Requests" onclick="loadPopupModal(\'hr/hrrequest/ViewMeetingRequest&id=' . $row['id'] . '\',\'' . $type . ' Requests \',\'lg\')"><i class="fa fa-eye"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_meeting_requests_delete']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteRequest(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>';
            }
            $rowData[] = array($m, $this->ciphertext($row['employeedetail']['employee_code'], "d"), $this->ciphertext($row['employeedetail']['first_name'], "d") . ' ' . $this->ciphertext($row['employeedetail']['last_name'], "d"), date('d/m/Y', strtotime($row['request_date'])), $type, $row['customer_name'], $row['excuse_reason'], $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionViewMeetingRequest() {
        $model = new EmployeeLeaveExcuse();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('meetingrequest_view_Hr', array('model' => $model, 'id' => $id), false, true);
    }
    public function actiondeleteRequest() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new EmployeeLeaveExcuse();
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }
    }
    public function actionCreate() {
        $id = Yii::app()->request->getparam('id');
        $employee_id = Yii::app()->request->getparam('employee_id');
        $model = new EmployeeLeaveExcuse;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('apply_excuse_form', array('model' => $model, 'employee_id' => $employee_id, 'title' => 'Apply for Leave Excuse'));
    }
    public function actionsaveExcuseMeeting() {
        if (isset($_POST['EmployeeLeaveExcuse'])) {
            $model = new EmployeeLeaveExcuse();
            if ((int)@$_POST['EmployeeLeaveExcuse']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeLeaveExcuse']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_date_time = date('Y-m-d H:i:s');
                $model->updated_by = Yii::app()->user->id;
            } else {
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->created_by = Yii::app()->user->id;
            }
            $model->attributes = $_POST['EmployeeLeaveExcuse'];
            $model->duration_type = $_POST['EmployeeLeaveExcuse']['duration_type'];
            $model->start_time = $_POST['EmployeeLeaveExcuse']['start_time'];
            $model->end_time = $_POST['EmployeeLeaveExcuse']['end_time'];
            $model->excuse_reason = $_POST['EmployeeLeaveExcuse']['excuse_reason'];
            if ($_POST['EmployeeLeaveExcuse']['customer_name'] != '') {
                $model->customer_name = $_POST['EmployeeLeaveExcuse']['customer_name'];
            }
            if ($_POST['EmployeeLeaveExcuse']['request_date'] != '0000-00-00' && $_POST['EmployeeLeaveExcuse']['request_date'] != '') {
                $model->request_date = $_POST['EmployeeLeaveExcuse']['request_date'];
                $model->request_date = str_replace('/', '-', $model->request_date);
                $model->request_date = date("Y-m-d", strtotime($model->request_date));
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="20"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(20, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionCreateExcuse() {
        $id = Yii::app()->request->getparam('id');
        $model = new EmployeeLeaveExcuse;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('create_excuse', array('model' => $model));
    }
    //End Late Excuse
    //Start Complaint-Suggestion
    public function actionGetHrComplaintList() {
        $model = new ComplaintSuggestion();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'created_date_time', 4 => 'complaint_suggestion', 5 => 't.id',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition.= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (complaint_suggestion LIKE '%" . $searchString . "%' OR employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $view_complaint=$delete_complaint=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_complaint_requests_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-primary btn-xs" title="Complaints / Suggestions Requests" onclick="loadPopupModal(\'hr/hrrequest/ViewComplaintRequest&id=' . $row['id'] . '\',\'Complaints / Suggestions Requests \',\'lg\')"><i class="fa fa-eye"></i></button>';
                $view_complaint=1;
                
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_complaint_requests_delete']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteComplaint(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>';
                $delete_complaint =1;
                
            }
            $rowData[] = array($m, $this->ciphertext($row['employeedetail']['employee_code'], "d"), $this->ciphertext($row['employeedetail']['first_name'], "d") . ' ' . $this->ciphertext($row['employeedetail']['last_name'], "d"), date('d/m/Y', strtotime($row['created_date_time'])), $row['complaint_suggestion'], array('id'=>$row['id'],'view_complaint'=>$view_complaint,'delete_complaint'=>$delete_complaint));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionViewComplaintRequest() {
        $model = new ComplaintSuggestion();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('Complaintrequest_view_Hr', array('model' => $model, 'id' => $id), false, true);
    }
    public function actionDeleteComplaint() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new ComplaintSuggestion();
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }
    }
    public function actionIndexComplaint() {
        $this->layout = 'main';
        $model_request_service = HrModules::model()->findByPK(31);
        if ($model_request_service->grant_access == 1 && $model_request_service->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_complaint');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionIndexhrcomplaint() {
        $this->layout = 'layout';
        $model_request_service = HrModules::model()->findByPK(31);
        if ($model_request_service->grant_access == 1 && $model_request_service->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emprequest_complaint_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index_hr_complaint');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeComplaintList() {
        $model = new ComplaintSuggestion();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'created_date_time', 2 => 'complaint_suggestion', 3 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $condition = 't.employee_id="' . $empid . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (complaint_suggestion LIKE '%" . $searchString . "%' OR employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = '<button class="btn btn-primary btn-xs" title="View Complaints / Suggestion Requests" onclick="loadPopupModal(\'hr/hrrequest/ViewComplaintRequest&id=' . $row['id'] . '\',\'Complaints/Suggestion\',\'lg\')"><i class="fa fa-eye"></i></button>';
            $rowData[] = array($m, $row['complaint_suggestion'], date('d/m/Y', strtotime($row['created_date_time'])), array('id'=>$row['id']));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreateComplaint() {
        $employee_id = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $id = Yii::app()->request->getparam('id');
        $model = new ComplaintSuggestion;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('apply_complaint_form', array('model' => $model, 'employee_id' => $employee_id, 'title' => 'Apply for Complaint'));
    }
    public function actionsaveComplaintSuggestion() {
        if (isset($_POST['ComplaintSuggestion'])) {
            $model = new ComplaintSuggestion();
            if ((int)@$_POST['ComplaintSuggestion']['id'] > 0) {
                $model->id = (int)$_POST['ComplaintSuggestion']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['ComplaintSuggestion'];
            $model->complaint_suggestion = $_POST['ComplaintSuggestion']['complaint_suggestion'];
            $model->created_date = date('Y-m-d');
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="13"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(13, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionCreateSuggestion() {
        $id = Yii::app()->request->getparam('id');
        $model = new ComplaintSuggestion;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('create_suggestion', array('model' => $model));
    }
    //End Complaint-Suggestion
    //Resignation Start
    public function actionloadcompanybranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch_resignation', array());
    }
    public function actiongetemployeedetails() {
        $employee = Yii::app()->request->getparam("id");
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee . '" and functionality_id="7"'));
        $functiontype = $model_master_approve_setting->id;
        $jsonData['functiontype'] = $functiontype;
        $jsonData['maxlevel'] = $model_master_approve_setting->max_level;
        echo CJSON::encode($jsonData);
    }
    public function actionHrResignation() {
        $this->layout = 'layout';
        $model_module_resignation= HrModules::model()->findByPK(14); 
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emprequest_resigntn_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_resignation->grant_access == 1 && $model_module_resignation->isActive == 'Y')){
            $en_id = Yii::app()->request->getParam('id');
            $branch = $this->ciphertext($en_id, "d");
            if ($branch != '') {
                $model = new EmployeeResignation();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index_approvehrresignation', array('model' => $model, 'branch' => $branch));
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetResignationApprovalHR() {
        $model = new EmployeeResignation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $employee_id = $_POST['employee_id'];
        //$status = $_POST['status'];
        $branch_id = $_POST['branch_id'];
        $columns = array(0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'apply_date', 4 => 'LM_approval_date', 5 => 'last_date', 6 => 'noticeperioddetail.period_name', 7 => 'status', 8 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $arr_status=$_POST['status'];
        $status='H';
        $pending_status_flag=0;
        
        if(is_countable($arr_status) && count($arr_status)>1){
            if (in_array('H', $arr_status)) {
                $pending_status_flag= 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $pending_resignation = EmployeeResignation::getPendingapproval($branch_id, 1);
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee = $model_user->hr_connected_employee_id;
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition.= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if($status=='H'){
            $condition.= " AND t.id IN(".$pending_resignation.")";
        }else if($status!=''){
            if($pending_status_flag==0){
                $condition.= " AND status IN(".$status.")";
            }else if($pending_status_flag==1){
                $condition.= " AND (status IN(".$status.") OR t.id IN(".$pending_resignation."))";
            }
        }
        if ($employee_id > 0) {
            $condition.= ' and t.employee_id="' . $employee_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " and (employeedetail.employee_code LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.first_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.middle_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.last_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR reason LIKE '%" . $searchString . "%' OR noticeperioddetail.period_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'noticeperioddetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'noticeperioddetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && $row->approvelevel->level_1_type == 'H' && $row->approvelevel->level_1_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && $row->approvelevel->level_2_type == 'H' && $row->approvelevel->level_2_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && $row->approvelevel->level_3_type == 'H' && $row->approvelevel->level_3_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && $row->approvelevel->level_4_type == 'H' && $row->approvelevel->level_4_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && $row->approvelevel->level_5_type == 'H' && $row->approvelevel->level_5_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            if ($row->status == 3 || $row->status == 5 || $row->status == 7 || $row->status == 9 || $row->status == 11 || $row->status == 13 || $row->status == 14) {
                $show_approve_button = 0;
            }
            $approve_reject=$view_details=$direct_approval=0;
            if ($show_approve_button == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_resignation_request_approve']) || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-success btn-xs" title="Confirm/Reject Resignation" onclick="loadPopupModal(\'hr/hrrequest/viewresignationhrapprove&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Confirm/Reject Resignation\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                    $approve_reject=1;
                    }
            }
            $last_date = "";
            $apply_date = "";
            $approval_date = "";
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_resignation_request_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-warning btn-xs" title="View Resignation Details" onclick="loadPopupModal(\'hr/hrrequest/viewresignation&id=' . $row['id'] . '\',\'Resignation Details \',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
                 $view_details=1;
            }
             if ($row->status==1 || $row->status==2 || $row->status==4 || $row->status==6 || $row->status==8 || $row->status==10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_resignation_admin_request_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $last_level=$row->max_level;
                    $button_string.= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/hrrequest/viewresignationhrapprove&final_level=Y&level=' . $last_level . '&id=' . $row['id'] . '\',\'Confirm/Reject Resignation\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                    $direct_approval=1;
                    
                }
                }
            if ($row['apply_date'] != '0000-00-00' && $row['apply_date'] != '') {
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                $approval_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            if ($row['employeedetail']['date_leaving'] != '0000-00-00' && $row['employeedetail']['date_leaving'] != '') {
                $last_date = date("d/m/Y", strtotime($row['employeedetail']['date_leaving']));
            } else if ($row['last_date'] != '0000-00-00' && $row['last_date'] != '') {
                $last_date = date("d/m/Y", strtotime($row['last_date']));
            }
            $rowData[] = array($m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $apply_date, $approval_date, $last_date, $row['noticeperioddetail']['period_name'], EmployeeResignation::getStatus($row['status']), array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'last_level'=>$last_level,'approve_reject'=>$approve_reject,'view_details'=>$view_details,'direct_approval'=>$direct_approval));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionViewresignationHRApprove() {
        $model = new EmployeeResignation();
        $id = (int)Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('resignation_view_Hr_approve', array('model' => $model, 'id' => $id, 'level' => $level, 'final_level' => $final_level), false, true);
    }
    public function actionSaveHRApproval() {
        if (isset($_POST['EmployeeResignation'])) {
            $model = new EmployeeResignation();
            if ((int)@$_POST['EmployeeResignation']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeResignation']['id'];
                $model = $model->findByPK($model->id);
            }
            $model->attributes = $_POST['EmployeeResignation'];
            $model->status = $_POST['EmployeeResignation']['status'];
            $model->last_approved_level = $_POST['EmployeeResignation']['last_approved_level'];
            if ($_POST['EmployeeResignation']['last_date'] != '0000-00-00' && $_POST['EmployeeResignation']['last_date'] != '') {
                $model->last_date = str_replace('/', '-', $_POST['EmployeeResignation']['last_date']);
                $model->last_date = date("Y-m-d", strtotime($model->last_date));
            }
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($level == 1 && $final_level == 'N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2 && $final_level == 'N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level == 'N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4 && $final_level == 'N') {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5 && $final_level == 'N') {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($final_level == 'Y') {
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="12"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(12, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionCreateResignationHR() {
        $id = Yii::app()->request->getparam('id');
        $branch = Yii::app()->request->getparam('branch');
        $model = new EmployeeResignation;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('apply_resignation_form_hr', array('model' => $model, 'branch' => $branch, 'title' => 'Apply for Complaint'));
    }
    public function actionSaveApplyHRResignation() {
        if (isset($_POST['EmployeeResignation'])) {
            $model = new EmployeeResignation();
            if ((int)@$_POST['EmployeeResignation']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeResignation']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->apply_date = date('Y-m-d');
            }
            $model->attributes = $_POST['EmployeeResignation'];
            $model->function_type = $_POST['EmployeeResignation']['function_type'];
            $model->last_approved_level = $_POST['EmployeeResignation']['last_approved_level'];
            //Employee ID
            $employee_id = $_POST['EmployeeResignation']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="5"'));
            if(!empty($model_master_approve_setting))
            {
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $status = $_POST['EmployeeResignation']['status'];
            if ($status == 12) {
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = 'Auto Approval';
                $modelemployee = User::model()->findByPK(Yii::app()->user->id);
                $approved_employee_id = 0;
                if ($modelemployee->employee_id > 0) {
                    $approved_employee_id = $modelemployee->employee_id;
                } else if ($modelemployee->hr_connected_employee_id > 0) {
                    $approved_employee_id = $modelemployee->hr_connected_employee_id;
                }
                $model->approved_by = $approved_employee_id; //HR Login
                
            }
            //            if ($_POST['EmployeeResignation']['last_date'] != '0000-00-00' && $_POST['EmployeeResignation']['last_date'] != '') {
            //                $model->last_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeResignation']['last_date'])));
            //            }
            $model->status = $_POST['EmployeeResignation']['status'];
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionIndexresignation() {
        $this->layout = 'main';
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $condition = 'employee_id = "' . $empid . '" and (status = 1 or status = 2 or status = 4 or status = 4 or status = 4 or status = 6 or status = 8 or status = 10 or status = 12) ';
        $resignation_present = EmployeeResignation::model()->find(array('condition' => $condition, 'order' => 'created_date_time DESC'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index_resignation', array('resignation_present' => $resignation_present));
    }
    public function actionCreateResignation() {
        $employee_id = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $id = Yii::app()->request->getparam('id');
        $model = new EmployeeResignation;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="5"'));
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('apply_resignation_form', array('model' => $model, 'employee_id' => $employee_id, 'model_master_approve_setting' => $model_master_approve_setting));
    }
    public function actionGetResignation() {
        $model = new EmployeeResignation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'apply_date', 2 => 'last_date', 3 => 'notice_type', 4 => 'status', 5 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $user_login_id = Yii::app()->user->id;
        $employee_id = User::model()->findbypk($user_login_id);
        $model_emp = Employee::model()->findByPk($employee_id->employee_id);
        $condition = 't.employee_id = "' . $model_emp->id . '"';
        //Notification update
        EmployeeResignation::model()->updateAll(array('view_status' => 1, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')), 'employee_id="' . $model_emp->id . '" and view_status="0" and status="12"');
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " and (reason LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $last_date = "";
            $apply_date = "";
            $button_string = '<button class="btn btn-primary btn-xs" title="View Resignation Details" onclick="loadPopupModal(\'hr/hrrequest/viewresignation&id=' . $row['id'] . '\',\'Resignation Details \',\'lg\')"><i class="fa fa-eye"></i></button>';
            if ($row['last_date'] != '0000-00-00' && $row['last_date'] != '') {
                $last_date = date("d/m/Y", strtotime($row['last_date']));
            }
            if ($row['apply_date'] != '0000-00-00' && $row['apply_date'] != '') {
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            $rowData[] = array($m, $apply_date, $last_date, $row['noticeperioddetail']['period_name'], EmployeeResignation::getStatus($row['status']), array('id'=>$row['id']));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionSaveApplyResignation() {
        if (isset($_POST['EmployeeResignation'])) {
            $model = new EmployeeResignation();
            if ((int)@$_POST['EmployeeResignation']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeResignation']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->created_by = Yii::app()->user->id;
            }
            $model->attributes = $_POST['EmployeeResignation'];
            $model->function_type = $_POST['EmployeeResignation']['function_type'];
            //Employee ID
            $employee_id = $_POST['EmployeeResignation']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="5"'));
            if(!empty($model_master_approve_setting))
            {
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $model->apply_date = date('Y-m-d');
            $model->status = 1;
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="11"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(11, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionViewresignation() {
        $model = new EmployeeResignation();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('resignation_view', array('model' => $model, 'id' => $id), false, true);
    }
    public function actionApproveLmResignation() {
        $this->layout = 'main';
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index_approvelmresignation');
    }
    public function actionGetResignationApproval() {
        $model = new EmployeeResignation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];

        $status='';
        if(isset($_POST['status']))
        {
            $status = $_POST['status'];
        }
       

        $columns = array(0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'apply_date', 4 => 'last_date', 5 => 'noticeperioddetail.period_name', 6 => 'status', 7 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $user_id = Yii::app()->user->id;
        $modelemployee = User::model()->findByPK($user_id);
        $employee_id = $modelemployee->employee_id;
        $pending_resignation = EmployeeResignation::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN(' . $pending_resignation . ')';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " and (employeedetail.employee_code LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.first_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.middle_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.last_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR reason LIKE '%" . $searchString . "%' OR noticeperioddetail.period_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'noticeperioddetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'noticeperioddetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($row->status == 3 || $row->status == 5 || $row->status == 7 || $row->status == 9 || $row->status == 11 || $row->status == 13 || $row->status == 14) {
                $show_approve_button = 0;
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $approve_button=0;
            if ($show_approve_button == 1) { //For Approval
                $approve_button =1;
                $button_string.= '<button class="btn btn-success btn-xs" title="Confirm/Reject Resignation" onclick="loadPopupModal(\'hr/hrrequest/approveresignationlm&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Confirm/Reject Resignation\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
            }
            $last_date = "";
            $apply_date = "";
            $button_string.= '<button class="btn btn-warning btn-xs" title="View Resignation Details" onclick="loadPopupModal(\'hr/hrrequest/viewresignation&id=' . $row['id'] . '\',\'Resignation Details \',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
            if ($row['apply_date'] != '0000-00-00' && $row['apply_date'] != '') {
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            if ($row['last_date'] != '0000-00-00' && $row['last_date'] != '') {
                $last_date = date("d/m/Y", strtotime($row['last_date']));
            }
            $rowData[] = array(++$m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $apply_date, $last_date, $row['noticeperioddetail']['period_name'], EmployeeResignation::getStatus($row['status']), array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'approve_button'=>$approve_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionApproveResignationlm() {
        $model = new EmployeeResignation();
        $id = (int)Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('resignation_view_Hr', array('model' => $model, 'id' => $id, 'level' => $level, 'final_level' => $final_level), false, true);
    }
    public function actionSaveLmApproval() {
        if (isset($_POST['EmployeeResignation'])) {
            $model = new EmployeeResignation();
            if ((int)@$_POST['EmployeeResignation']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeResignation']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeResignation'];
            $model->status = $_POST['EmployeeResignation']['status'];
            $model->last_approved_level = $_POST['EmployeeResignation']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($level == 1 && $final_level == 'N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2 && $final_level == 'N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level == 'N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4) {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5) {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($final_level == 'Y') {
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="12"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(12, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    //    Resignation END
    //    Expense-Start
    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch_expense', array());
    }
    public function actionIndexexpense() {
        $this->layout = 'main';
        $model_module_expense= HrModules::model()->findByPK(11);
        if ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_expense');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionHrExpense() {
        $this->layout = 'layout';
        $model_module_expense= HrModules::model()->findByPK(11);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emprequest_exp_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch = $this->ciphertext($en_id, "d");
            if ($branch != '') {
                $model_user = User::model()->findByPk(Yii::app()->user->id);
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                if ($model_user->userGroup->group_name == "Accounts") {
                    $this->render('index_expense_verify', array('branch' => $branch));
                } else {
                    $this->render('index_hr_expense', array('branch' => $branch));
                }
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionIndexapproveexpense() {
        $this->layout = 'main';
        $model_module_expense= HrModules::model()->findByPK(11);
        if ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_approve_expense');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetExpense() {
        $model = new EmployeeExpense();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'created_date', 2 => 'approved_date', 3 => 'total', 4 => 'status', 5 => '');
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $user_login_id = Yii::app()->user->id;
        $employee_id = User::model()->findbypk($user_login_id);
        $model_emp = Employee::model()->findByPk($employee_id->employee_id);
        $condition = 't.employee_id = "' . $model_emp->id . '"';
        //Notification update
        EmployeeExpense::model()->updateAll(array('view_status' => 1, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')), 'employee_id="' . $model_emp->id . '" and view_status="0" and (status="12" OR status="13")');
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " and (created_date LIKE '%" . $searchString . "%' OR total LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $created_date = "";
            $approval_date = "";
            $button_string = '';
            $edit_button=$delete_button=0;
            if ($row['status'] == 0 || $row['status'] == 1) {
                // || $row['status'] == 3 || $row['status'] == 5 || $row['status'] == 7 || $row['status'] == 9 || $row['status'] == 11 || $row['status'] == 13
                $button_string.= '<button class="btn btn-success btn-xs" title="Edit Expense Details" onclick="loadPopupModal(\'hr/hrrequest/createexpense&id=' . $row['id'] . '\',\'Edit Expense Details \',\'xl\')"><i class="fa fa-pencil"></i></button> &nbsp;';
                //$button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Send to Line manager" onclick="sendExpense(' . $row['id'] . ')"><i class="fa fa-retweet"></i></a>';
              $edit_button =1;  
            }
            $button_string.= '<button class="btn btn-warning btn-xs" title="View Expense Details" onclick="loadPopupModal(\'hr/hrrequest/viewexpensehrapproveview&id=' . $row['id'] . '\',\'Expense Details \',\'xl\')"><i class="fa fa-eye"></i></button> &nbsp;';
//            $button_string.= '<button class="btn btn-info btn-xs" title="Copy Expense Details" onclick="loadPopupModal(\'hr/hrexpense/copyexpense&id=' . $row['id'] . '\',\'Copy Expense Details \',\'xl\')"><i class="fa fa-copy"></i></button> &nbsp;';
            if ($row['status'] == 0) {
                $delete_button =1;
                $button_string.= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete Expense Detail" onclick="deleteExpense(' . $row['id'] . ')"><i class="fa fa-trash"></i></a>';
            }
            if ($row['created_date'] != '0000-00-00' && $row['created_date'] != '') {
                $created_date = date("d/m/Y", strtotime($row['created_date']));
            }
            if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                $approval_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $rowData[] = array(++$m, $created_date, $approval_date, $row['total'], EmployeeExpense::getStatus($row['status']), array('id'=>$row['id'],'edit_button'=>$edit_button,'delete_button'=>$delete_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionGetExpenseApproval() {
        $model = new EmployeeExpense();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'created_date', 4 => 'total', 5 => 'status', 6 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $user_id = Yii::app()->user->id;
        $modelemployee = User::model()->findByPK($user_id);
        $employee_id = $modelemployee->employee_id;
        $pending_expense = EmployeeExpense::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN(' . $pending_expense . ')';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " and (employeedetail.employee_code LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.first_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.middle_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.last_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR total LIKE '%" . $searchString . "%' )";
        }
        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $created_date = "";
            $approve_date = "";
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $approve_button =0;
            if ($show_approve_button == 1) { //For Approval
                $button_string.= '<button class="btn btn-success btn-xs" title="Confirm/Reject Expense Request" onclick="loadPopupModal(\'hr/hrrequest/viewexpenselm&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Confirm/Reject Expense Request \',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                $approve_button =1;
            }
            if ($row['created_date'] != '0000-00-00' && $row['created_date'] != '') {
                $created_date = date("d/m/Y", strtotime($row['created_date']));
            }
            $rowData[] = array($m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $created_date, $row['total'], EmployeeExpense::getStatus($row['status']), array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'approve_button'=>$approve_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreateExpense() {
        $model = new EmployeeExpense;
        $id = Yii::app()->request->getparam('id');
        $model_details = array(new EmployeeExpenseDetails);
        $model_additional_details = array();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"', 'order' => 'id asc'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
            $model_additional_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '" AND (expense_component_id=21 OR expense_component_id=22)'));
            if (empty($model_additional_details)) {
                $model_additional_details = array();
            }
        }
        $user_id = Yii::app()->user->id;
        $modelemployee = User::model()->findByPK($user_id);
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $modelemployee->employee_id . '" and functionality_id="7"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('apply_expense', array('model' => $model, 'model_details' => $model_details, 'model_additional_details' => $model_additional_details, 'expense_id' => $id, 'model_master_approve_setting' => $model_master_approve_setting));
    }
    public function actiongetemployeedetail() {
        $employee = Yii::app()->request->getparam("id");
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee . '" and functionality_id="5"'));
        $functiontype = $model_master_approve_setting->id;
        $jsonData['functiontype'] = $functiontype;
        $jsonData['maxlevel'] = $model_master_approve_setting->max_level;
        echo CJSON::encode($jsonData);
    }
    public function actionGetExchangeRate() {
        $currency_id = $_POST['currency_id'];
        $modelCurrency = MasCurrency::model()->find(array('select' => 'exchange_rate', 'condition' => 'id="' . $currency_id . '"'));
        $drop['drop'] = $modelCurrency->exchange_rate;
        echo json_encode($drop);
    }
    public function actionViewexpenseLM() {
        $model = new EmployeeExpense();
        $id = (int)Yii::app()->request->getParam('id');
        $level = (int)Yii::app()->request->getParam('level');
        $final_level = Yii::app()->request->getparam("final_level");
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('expense_view_LM', array('model' => $model, 'id' => $id, 'model_details' => $model_details, 'level' => $level, 'final_level' => $final_level), false, true);
    }
    public function actionViewexpenseHR() {
        $model = new EmployeeExpense();
        $id = (int)Yii::app()->request->getParam('id');
        $level = (int)Yii::app()->request->getParam('level');
        $final_level = Yii::app()->request->getparam("final_level");
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('expense_view_HR', array('model' => $model, 'id' => $id, 'model_details' => $model_details, 'level' => $level, 'final_level' => $final_level), false, true);
    }
    public function actionViewexpenseHRApproveView() {
        $model = new EmployeeExpense();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"', 'order' => 'id asc'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
            $model_additional_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '" AND (expense_component_id=21 OR expense_component_id=22)', 'order' => 'id asc'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('expense_view_Hr_approve_view', array('model' => $model, 'id' => $id, 'model_details' => $model_details, 'model_additional_details' => $model_additional_details), false, true);
    }
    public function actionDeleteExpense() {
        $id = $_POST['id'];
        $model = EmployeeExpenseDetails::model()->findbyPK($id);
        $path = '';
        if ($model->file != '') {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $model->file;
        }
        $model_expense = EmployeeExpense::model()->findbypk($model->expense_id);
        $total = $model_expense->total - $model->grand_total;
        EmployeeExpense::model()->updateByPK($model->expense_id, array('total' =>$total));
        $status = $model->deleteByPk($id);
        if ($status == 1) {
            if (file_exists($path)) {
                unlink($path);
            }
            $data['status'] = 'success';
        } else {
            $data['status'] = 'error';
        }
        echo CJSON::encode($data);
    }
    public function actionSaveExpense() {
        if (isset($_POST['EmployeeExpense'])) {
            $button_status = $_POST['button_status'];
            $validate = true;
            $model = new EmployeeExpense();
            if ((int)@$_POST['EmployeeExpense']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeExpense']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->created_date = date('Y-m-d');
            }
            $model->attributes = $_POST['EmployeeExpense'];
            $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
            $employee = Employee::model()->findbypk($empid);
            $model->employee_id = $empid;
            $model->function_type = $_POST['EmployeeExpense']['function_type'];
            //Employee ID
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $empid . '" and functionality_id="7"'));
            if(!empty($model_master_approve_setting))
            {
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $model->last_approved_level = 0;
            $model->total = $_POST['EmployeeExpense']['total'];
            if ($button_status == 1) {
                $model->status = 0;
            } else if ($button_status == 2) {
                $model->status = 1;
            }
            $validate = $model->validate();
            $grand_total=0.00;
            if (isset($_POST['EmployeeExpenseDetails'])) {
                foreach ($_POST['EmployeeExpenseDetails'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $modalexpensedetails[$i] = EmployeeExpenseDetails::model()->findByPK($items['id']);
                    } else {
                        $modalexpensedetails[$i] = new EmployeeExpenseDetails();
                    }
                    $modalexpensedetails[$i]->expense_date = str_replace('/', '-', $items['expense_date']);
                    $modalexpensedetails[$i]->expense_date = date("Y-m-d", strtotime($modalexpensedetails[$i]->expense_date));
                    $modalexpensedetails[$i]->notes = $items['notes'];
                    $modalexpensedetails[$i]->expense_component_id = $items['expense_component_id'];
                    $modalexpensedetails[$i]->employee_id = $model->employee_id;
                    $modalexpensedetails[$i]->amount = $items['amount'];
                    $modalexpensedetails[$i]->currency_id = $items['currency_id'];
                    $modalexpensedetails[$i]->exchange_rate = $items['exchange_rate'];
                    $modalexpensedetails[$i]->grand_total = $items['grand_total'];
                    $grand_total+=(float)$items['grand_total'];
                    $modalexpensedetails[$i]->file = $items['file'];
                    if ($items['expense_component_id'] == 21 || $items['expense_component_id'] == 22) {
                        $modalexpensedetails[$i]->person_attended_entertained = $_POST['HrExpenseComponent'][$i]['person_attended_entertained'];
                        $modalexpensedetails[$i]->place = $_POST['HrExpenseComponent'][$i]['place'];
                        $modalexpensedetails[$i]->business_details = $_POST['HrExpenseComponent'][$i]['business_details'];
                    }
                    if ($items['expense_component_id'] == 21) {
                        $modalexpensedetails[$i]->company = $_POST['HrExpenseComponent'][$i]['company'];
                    }
                    $validate = $modalexpensedetails[$i]->validate() && $validate;
                }
            }
            $model->total = $grand_total;
            if ($validate) {
                if ($model->save()) {
                    if (!empty($modalexpensedetails)) {
                        foreach ($modalexpensedetails as $eachModel) {
                            $eachModel->expense_id = $model->id;
                            $eachModel->save();
                        }
                    }
                    if ($button_status == 2) {
                        //Mail
                        $model_settings = HrGenerelSettings::model()->find();
                        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="9"'));
                        if(!empty($model_settings) && !empty($model_mail_settings)){
                            if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                                Yii::import('application.modules.hr.controllers.MailController');
                                MailController::sendmail(9, $model->employee_id, $model->id);
                            }
                        }
                    }
                    if ($model->status == 0) {
                        $jsonData['msg'] = 'Details Saved Successfully';
                    } else {
                        $jsonData['msg'] = 'Details Submitted Successfully';
                    }
                    $jsonData['status'] = 'success';
                }
                echo CJSON::encode($jsonData);
            } else {
                $error = json_decode(CActiveForm::validate($model, '', false), true);
                $error1 = json_decode(CActiveForm::validate($modalexpensedetails, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error, $error1));
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionsendexpense() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = EmployeeExpense::model()->findByPk($id);
            EmployeeExpense::model()->updateByPK($id, array('status' => 2));
            //            //Mail
            //            $model_settings = HrGenerelSettings::model()->find();
            //            $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="9"'));
            //            if(!empty($model_settings)){
            //                if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
            //                     Yii::import('application.modules.hr.controllers.MailController');
            //                     MailController::sendmail(9,$model->employee_id,$model->id);
            //                }
            //            }
            echo "success";
        } else {
            echo "fail";
        }
    }
    public function actionDownloadDocument() {
        $id = (int)Yii::app()->request->getParam('id');
        $arr_employee_document = EmployeeExpenseDetails::model()->findByPk($id);
        $file = $arr_employee_document->file;
        //var_dump($file);
        //die();
        $arr_doc_val = explode(',', $arr_employee_document->file);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $arr_employee_document->file . "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0;$i < count($arr_doc_val);$i++) {
                    $path = "uploads/expense/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_employee_document->file;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    public function actionSaveExpenseLmApproval() {
        if (isset($_POST['EmployeeExpense'])) {
            $model = new EmployeeExpense();
            if ((int)@$_POST['EmployeeExpense']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeExpense']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeExpense'];
            $model->last_approved_level = $_POST['EmployeeExpense']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($level == 1 && $final_level == 'N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2 && $final_level == 'N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level == 'N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4 && $final_level == 'N') {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5 && $final_level == 'N') {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($final_level == 'Y') {
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            $model->status = $_POST['EmployeeExpense']['status'];
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="10"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(10, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionSaveExpenseHRApproval() {
        if (isset($_POST['EmployeeExpense'])) {
            $model = new EmployeeExpense();
            if ((int)@$_POST['EmployeeExpense']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeExpense']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeExpense'];
            $model->status = $_POST['EmployeeExpense']['status'];
            $model->last_approved_level = $_POST['EmployeeExpense']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($level == 1 && $final_level == 'N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2 && $final_level == 'N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level == 'N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4 && $final_level == 'N') {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5 && $final_level == 'N') {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($final_level == 'Y') {
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="10"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(10, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionGetExpenseApprovalHR() {
        $model = new EmployeeExpense();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        // $status = $_POST['status'];
        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        $columns = array(0 => 't.id', 1 => 't.id', 2 => 'employeedetail.employee_code', 3 => 'employeedetail.first_name', 4 => 'created_date', 5 => 'approved_date', 6 => 'total', 7 => 'status', 8 => 't.id',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $arr_status=$_POST['status'];
        $status='H';
        $pending_status_flag=0;
        
        if(is_countable($arr_status) && count($arr_status)>1){
            if (in_array('H', $arr_status)) {
                $pending_status_flag= 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $pending_expense = EmployeeExpense::getPendingapproval($branch_id, 1);
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee = $model_user->hr_connected_employee_id;
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition.= ' AND employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if($status=='H'){
            $condition.= " AND t.id IN(".$pending_expense.")";
        }else if($status!=''){
            if($pending_status_flag==0){
                $condition.= " AND status IN(".$status.")";
            }else if($pending_status_flag==1){
                $condition.= " AND (status IN(".$status.") OR t.id IN(".$pending_expense."))";
            }
        } 
        if ($employee_id > 0) {
            $condition.= ' and t.employee_id="' . $employee_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " and (employeedetail.employee_code LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.first_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.middle_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.last_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR total LIKE '%" . $searchString . "%' )";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && $row->approvelevel->level_1_type == 'H' && $row->approvelevel->level_1_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && $row->approvelevel->level_2_type == 'H' && $row->approvelevel->level_2_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && $row->approvelevel->level_3_type == 'H' && $row->approvelevel->level_3_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && $row->approvelevel->level_4_type == 'H' && $row->approvelevel->level_4_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && $row->approvelevel->level_5_type == 'H' && $row->approvelevel->level_5_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $approve_reject =$edit_expense=$delete_expense=$view_expense=$download_expense=$print_expense=$direct_approval=$approval_hierarcy=0;
            if ($show_approve_button == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_approve']) || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-success btn-xs" title="Confirm/Reject Expense Request" onclick="loadPopupModal(\'hr/hrrequest/viewexpensehr&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Confirm/Reject Expense Request\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>';
                    $approve_reject =1;
                }
            }
            if ($row->status == 3 || $row->status == 5 || $row->status == 7 || $row->status == 9 || $row->status == 11 || $row->status == 13 || $row->status == 14) {
                $show_approve_button = 0;
            }
            if ($row->status == 0) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_edit']) || Yii::app()->user->authorised_user == 1) {
                    $button_string.= ' <button class="btn btn-warning btn-xs" title="Edit Expense Request" onclick="loadPopupModal(\'hr/hrrequest/createemployeeexpense&branch=' . $row['employeedetail']['branch_or_sponsor_id'] . '&id=' . $row['id'] . '\',\'Edit Expense Request\',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
                    $edit_expense =1;
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_delete']) || Yii::app()->user->authorised_user == 1) {
                    $button_string.= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete Expense Detail" onclick="deleteExpense(' . $row['id'] . ')"><i class="fa fa-trash"></i></a>';
                    $delete_expense=1;
                    
                }
            }
            $created_date = "";
            $approve_date = "";
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= ' <button class="btn btn-info btn-xs" title="View Expense Details" onclick="loadPopupModal(\'hr/hrrequest/viewexpensehrapproveview&id=' . $row['id'] . '\',\'Expense Details \',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
                $view_expense =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_download']) || Yii::app()->user->authorised_user == 1) {
                $model_document = EmployeeExpenseDetails::model()->find(array('condition' => 'expense_id="' . $row->id . '" AND file!=""'));
                if (!empty($model_document)):
                    $button_string.= CHtml::link('<i class="fa fa-download"></i>', array('hrreports/downloadDocument&id=' . $row->id), array('title' => 'Download', 'class' => "btn btn-default btn-xs"));
                    $download_expense=1;
                endif;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_print']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= ' <a href="?r=hr/hrrequest/printexpensedetails&id=' . $this->ciphertext($row['id'], "e") . '" title="Approval Document" target="_blank"><button class="btn btn-default btn-xs" title="Print" ><i class="fa fa-print"></i></button></a>&nbsp;';
                $print_expense =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_copy']) || Yii::app()->user->authorised_user == 1) {
//                $button_string.= '<button class="btn btn-primary btn-xs" title="Copy Expense Details" onclick="loadPopupModal(\'hr/hrexpense/copyexpensedetail&id=' . $row['id'] . '\',\'Copy Expense Details \',\'xl\')"><i class="fa fa-copy"></i></button> &nbsp;';
            }
            if ($row->status==1 || $row->status==2 || $row->status==4 || $row->status==6 || $row->status==8 || $row->status==10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_admin_details_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $last_level=$row->max_level;
                    $button_string.= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/hrrequest/viewexpensehr&final_level=Y&level=' . $last_level . '&id=' . $row['id'] . '\',\'Confirm/Reject Expense Request\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                    $direct_approval =1;
                }
                }
                if ($row->status==1 || $row->status==2 || $row->status==4 || $row->status==6 || $row->status==8 || $row->status==10) {
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_hierarchy_view']) || Yii::app()->user->authorised_user == 1) {
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Approval Hierarchy" onclick="loadPopupModal(\'hr/hrrequest/approvalhierarchy&function_type=7&employee_id=' . $row['employee_id'] . '\',\'Employee Hierarchy\',\'md\')"><i class="fa fa-book"></i></button>&nbsp;';
                        $approval_hierarcy =1;
                    }
                }
            if ($row['created_date'] != '0000-00-00' && $row['created_date'] != '') {
                $created_date = date("d/m/Y", strtotime($row['created_date']));
            }
            if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                $approve_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $rowData[] = array($m, $row['id'], $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $created_date, $approve_date, $row['total'], EmployeeExpense::getStatus($row['status']), array('id'=>$row['id'],'employee_id'=>$row['employee_id'],'en_id'=>$this->ciphertext($row['id'], "e"),'last_level'=>$last_level,'branch'=>$row['employeedetail']['branch_or_sponsor_id'],'final_level'=>$final_level,'level_no'=> $level_no,'approve_reject'=>$approve_reject,'edit_expense'=>$edit_expense,'delete_expense'=>$delete_expense,'view_expense'=>$view_expense,'download_expense'=>$download_expense,'print_expense'=>$print_expense,'direct_approval'=>$direct_approval,'approval_hierarcy'=>$approval_hierarcy));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actiondeleteuploadedfile() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $each_details = new EmployeeExpenseDetails();
        $model_documents = EmployeeExpenseDetails::model()->findByPk($id);
        $document_file_array = explode(',', $model_documents->file);
        if (($key = array_search($file_name, $document_file_array)) !== false) {
            unset($document_file_array[$key]);
            $files = implode(',', $document_file_array);
            EmployeeExpenseDetails::model()->updateByPK($id, array('file' => $files));
            $div_file = '<span id=spanfile_"' . $i . '">';
            foreach ($document_file_array as $value_file) {
                $f_name = "'" . $value_file . "'";
                $div_file.= $value_file . '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deleteuploadedfile(' . $i . ',' . $id . ',' . $f_name . ');"><i class="fa fa-trash"></i></a><br>';
            }
            $div_file.= '</span>';
            $div_file.= CHtml::activeHiddenField($each_details, "[" . $i . "]file", array('value' => $files));
            echo $div_file;
        }
    }
    //Added by DR on 26/10/2022
    public function actionIndexDetails() {
        $this->layout = 'main';
        $model_module_expense= HrModules::model()->findByPK(11);
        if ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('approved_expense_history');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetExpenseHistory() {
        $model = new EmployeeExpense();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $filter_employee_id = $_POST['employee_id'];
        $filter_status = $_POST['status'];
        $columns = array(0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'created_date', 4 => 'approved_date', 5 => 'total', 6 => 'status', 7 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $user_id = Yii::app()->user->id;
        $modelemployee = User::model()->findByPK($user_id);
        $employee_id = $modelemployee->employee_id;
        $condition = 'employeedetail.isActive="Y" AND (approve_level1_id="' . $employee_id . '" OR approve_level2_id="' . $employee_id . '" OR approve_level3_id="' . $employee_id . '" OR approve_level4_id="' . $employee_id . '" OR approve_level5_id="' . $employee_id . '" OR approved_by="' . $employee_id . '")';
        if ($filter_employee_id > 0) {
            $condition.= ' AND t.employee_id="' . $filter_employee_id . '"';
        }
        if ($filter_status > 0) {
            $condition.= ' AND t.status="' . $filter_status . '"';
        } else {
            $condition.= ' AND (t.status="12" OR t.status="13" OR t.status="14")';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " and (employeedetail.employee_code LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.first_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.middle_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.last_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR total LIKE '%" . $searchString . "%' )";
        }
        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $created_date = "";
            $approval_date = "";
            if ($row['created_date'] != '0000-00-00' && $row['created_date'] != '') {
                $created_date = date("d/m/Y", strtotime($row['created_date']));
            }
            if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                $approval_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $button_string = '<button class="btn btn-warning btn-xs" title="View Expense Details" onclick="loadPopupModal(\'hr/hrrequest/viewexpensehrapproveview&id=' . $row['id'] . '\',\'Expense Details \',\'lg\')"><i class="fa fa-eye"></i></button>';
            $rowData[] = array(++$m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $created_date, $approval_date, $row['total'], EmployeeExpense::getStatus($row['status']), array('id'=>$row['id']));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actioncheckduplicateentry() {
        $expense_date = Yii::app()->request->getparam("expense_date");
        $currency_id = Yii::app()->request->getparam("currency_id");
        $grand_total = Yii::app()->request->getparam("grand_total");
        $component_id = Yii::app()->request->getparam("component_id");
        $id = Yii::app()->request->getparam("id");
        $row_num = Yii::app()->request->getparam("row_num");
        if ($expense_date != '' && $expense_date != '0000-00-00') {
            $expense_date = date("Y-m-d", strtotime(str_replace('/', '-', $expense_date)));
        }
        $model_user = User::model()->findbypk(Yii::app()->user->id);
        $employee_id = $model_user->employee_id;
        //        $condition='employee_id="'.$employee_id.'" and expense_date="'.$expense_date.'" AND currency_id="'.$currency_id.'" AND expense_component_id="'.$component_id.'" AND grand_total="'.$grand_total.'"';
        $condition = 'employee_id="' . $employee_id . '" and expense_date="' . $expense_date . '" AND grand_total="' . $grand_total . '"';
        if ($id > 0) {
            $condition.= ' AND id!="' . $id . '"';
        }
        $model = EmployeeExpenseDetails::model()->find(array('condition' => $condition));
        if (!empty($model)) {
            $jsonData['exist'] = 1;
        } else {
            $jsonData['exist'] = 0;
        }
        $jsonData['row_number'] = $row_num;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actioncheckduplicateexpense() {
        $expense_date = Yii::app()->request->getparam("expense_date");
        $currency_id = Yii::app()->request->getparam("currency_id");
        $grand_total = Yii::app()->request->getparam("grand_total");
        $component_id = Yii::app()->request->getparam("component_id");
        $id = Yii::app()->request->getparam("id");
        $row_num = Yii::app()->request->getparam("row_num");
        if ($expense_date != '' && $expense_date != '0000-00-00') {
            $expense_date = date("Y-m-d", strtotime(str_replace('/', '-', $expense_date)));
        }
        $employee_id = Yii::app()->request->getparam("employee_id");;
        $condition = 'employee_id="' . $employee_id . '" and expense_date="' . $expense_date . '" AND grand_total="' . $grand_total . '"';
        if ($id > 0) {
            $condition.= ' AND id!="' . $id . '"';
        }
        $model = EmployeeExpenseDetails::model()->find(array('condition' => $condition));
        if (!empty($model)) {
            $jsonData['exist'] = 1;
        } else {
            $jsonData['exist'] = 0;
        }
        $jsonData['row_number'] = $row_num;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionGetExpenseVerify() {
        $model = new EmployeeExpense();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        $columns = array(0 => 't.id', 1 => 't.id', 2 => 'employeedetail.employee_code', 3 => 'employeedetail.first_name', 4 => 'created_date', 5 => 'approved_date', 6 => 'total', 7 => 'status', 8 => 't.id',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        if ($status != '' && $status != 'V') {
            $condition.= " And status= '" . $status . "'";
        } else if ($status == 'V') {
            $condition.= " And status= '12' AND accounts_verified='N'";
        }
        if ($employee_id > 0) {
            $condition.= ' and t.employee_id="' . $employee_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " and (employeedetail.employee_code LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.first_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.middle_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR employeedetail.last_name LIKE '%" . $this->ciphertext($searchString, "e") . "%' OR total LIKE '%" . $searchString . "%' )";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $created_date = "";
            $approve_date = "";
            if ($row['accounts_verified'] == 'N') {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_verify']) || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-warning btn-xs" title="Verify Expense Request" onclick="loadPopupModal(\'hr/hrrequest/verifyexpenserequest&id=' . $row['id'] . '\',\'Verify Expense Request\',\'xl\')"><i class="fa fa-check"></i></button>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-info btn-xs" title="View Expense Details" onclick="loadPopupModal(\'hr/hrrequest/viewexpensehrapproveview&id=' . $row['id'] . '\',\'Expense Details \',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_download']) || Yii::app()->user->authorised_user == 1) {
                $model_document = EmployeeExpenseDetails::model()->find(array('condition' => 'expense_id="' . $row->id . '" AND file!=""'));
                if (!empty($model_document)):
                    $button_string.= CHtml::link('<i class="fa fa-download"></i>', array('hrreports/downloadDocument&id=' . $row->id), array('title' => 'Download', 'class' => "btn btn-primary btn-xs"));
                endif;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_print']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= ' <a href="?r=hr/hrrequest/printexpensedetails&id=' . $this->ciphertext($row['id'], "e") . '" title="Approval Document" target="_blank"><button class="btn btn-default btn-xs" title="Print" ><i class="fa fa-print"></i></button></a>&nbsp;';
            }
            if ($row['created_date'] != '0000-00-00' && $row['created_date'] != '') {
                $created_date = date("d/m/Y", strtotime($row['created_date']));
            }
            if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                $approve_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $rowData[] = array($m, $row['id'], $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $created_date, $approve_date, $row['total'], EmployeeExpense::getStatus($row['status']), $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionVerifyexpenseRequest() {
        $model = new EmployeeExpense();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('verify_expense', array('model' => $model, 'id' => $id, 'model_details' => $model_details), false, true);
    }
    public function actionSaveVerifyExpense() {
        if (isset($_POST['EmployeeExpense'])) {
            $model = new EmployeeExpense();
            if ((int)@$_POST['EmployeeExpense']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeExpense']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            if (isset($_POST['EmployeeExpense']['accounts_verified']) && $_POST['EmployeeExpense']['accounts_verified'] == 1) {
                $model->accounts_verified = 'Y';
                $modelemployee = User::model()->findByPK(Yii::app()->user->id);
                if (!empty($modelemployee)) {
                    $model->verified_by = Yii::app()->user->id;
                    $model->verified_date_time = date('Y-m-d H:i:s');
                    $model->verified_by_name = $modelemployee->Fullname;
                }
            } else {
                $model->accounts_verified = 'N';
                $model->verified_by = 0;
                $model->verified_date_time = '';
                $model->verified_by_name = '';
            }
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionPrintExpenseDetails() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_request_print']) || Yii::app()->user->authorised_user == 1) {
            $model = new EmployeeExpense();
            $en_id = Yii::app()->request->getParam('id');
            $id = $this->ciphertext($en_id, "d");
            if ($id > 0) {
                $model = $model->findByPk($id);
                $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"', 'order' => 'id asc'));
                $model_additional_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '" AND (expense_component_id=21 OR expense_component_id=22)', 'order' => 'id asc'));
            }
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            if (!empty($model)) {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrrequest.pdf.print_employee_expense_pdf', array('expense_id' => $id, 'model_details' => $model_details, 'model' => $model, 'model_additional_details' => $model_additional_details), true));
            } else {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.pdf.error', array(), true));
            }
            $mPDF1->Output('expense_details.pdf', 'I');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    //added by DR on 1611/2022
    public function actiondeleteExpensedetails() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = EmployeeExpense::model()->findByPk($id);
            if ($model->id) {
                $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $model->id . '"'));
                foreach ($model_details as $key => $value) {
                    if ($value->file != '') {
                        $doc_file = $value->file;
                        $arr_doc_val = explode(',', $doc_file);
                        $status = 0;
                        if (count($arr_doc_val) > 1) {
                            foreach ($arr_doc_val as $value) {
                                $path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $value;
                                if (unlink($path)) {
                                    $status = 1;
                                }
                            }
                            if ($status == 1) {
                                EmployeeExpenseDetails::model()->deleteByPk($value->id);
                            }
                        } else {
                            $path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $doc_file;
                            if (unlink($path)) {
                                EmployeeExpenseDetails::model()->deleteByPk($value->id);
                                $jsonData['status'] = 'success';
                            }
                        }
                    } else {
                        EmployeeExpenseDetails::model()->deleteByPk($value->id);
                    }
                }
                //end delete
                $model_details_exist = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $model->id . '"'));
                if (empty($model_details_exist)) {
                    EmployeeExpense::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                } else {
                    $jsonData['status'] = 'error';
                }
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionCreateEmployeeExpense() {
        $model = new EmployeeExpense;
        $id = Yii::app()->request->getparam('id');
        $branch = Yii::app()->request->getparam('branch');
        $model_details = array(new EmployeeExpenseDetails);
        $model_additional_details = array();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
            $model_additional_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '" AND (expense_component_id=21 OR expense_component_id=22)'));
            if (empty($model_additional_details)) {
                $model_additional_details = array();
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create_expense', array('model' => $model, 'model_details' => $model_details, 'branch' => $branch, 'model_additional_details' => $model_additional_details));
    }
    public function actionSaveExpenseDetails() {
        if (isset($_POST['EmployeeExpense'])) {
            $validate = true;
            date_default_timezone_set("Asia/Dubai");
            $model = new EmployeeExpense();
            if ((int)@$_POST['EmployeeExpense']['id'] > 0) {
                $model->id = (int)$_POST['EmployeeExpense']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->created_date = date('Y-m-d'); //For apply date
                
            }
            $model->attributes = $_POST['EmployeeExpense'];
            $employee = $_POST['EmployeeExpense']['employee_id'];
            $mod_employee = Employee::model()->findbypk($employee);
            $model->total = $_POST['EmployeeExpense']['total'];
            $model->status = $_POST['EmployeeExpense']['status'];
            $model->function_type = $_POST['EmployeeExpense']['function_type'];
            $model->last_approved_level = $_POST['EmployeeExpense']['last_approved_level'];
            //Employee ID
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee . '" and functionality_id="7"'));
            if(!empty($model_master_approve_setting))
            {
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $status = $_POST['EmployeeExpense']['status'];
            if ($status == 12) {
                $modelemployee = User::model()->findByPK(Yii::app()->user->id);
                $approved_employee_id=0;
                if($modelemployee->employee_id>0){
                    $approved_employee_id=$modelemployee->employee_id;
                }else if($modelemployee->hr_connected_employee_id>0){
                    $approved_employee_id=$modelemployee->hr_connected_employee_id;
                }
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = 'Auto Approval';
                $model->approved_by = $approved_employee_id; //HR Login
            }
            $validate = $model->validate();
            $grand_total=0.00;
            if (isset($_POST['EmployeeExpenseDetails'])) {
                foreach ($_POST['EmployeeExpenseDetails'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $modalexpensedetails[$i] = EmployeeExpenseDetails::model()->findByPK($items['id']);
                    } else {
                        $modalexpensedetails[$i] = new EmployeeExpenseDetails();
                    }
                    $modalexpensedetails[$i]->expense_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['expense_date'])));
                    $modalexpensedetails[$i]->expense_component_id = $items['expense_component_id'];
                    $modalexpensedetails[$i]->notes = $items['notes'];
                    $modalexpensedetails[$i]->employee_id = $model->employee_id;
                    $modalexpensedetails[$i]->amount = $items['amount'];
                    $modalexpensedetails[$i]->currency_id = $items['currency_id'];
                    $modalexpensedetails[$i]->exchange_rate = $items['exchange_rate'];
                    $modalexpensedetails[$i]->grand_total = $items['grand_total'];
                    $grand_total+=(float)$items['grand_total'];
                    $modalexpensedetails[$i]->file = $items['file'];
                    if ($items['expense_component_id'] == 21 || $items['expense_component_id'] == 22) {
                        $modalexpensedetails[$i]->person_attended_entertained = $_POST['HrExpenseComponent'][$i]['person_attended_entertained'];
                        $modalexpensedetails[$i]->place = $_POST['HrExpenseComponent'][$i]['place'];
                        $modalexpensedetails[$i]->business_details = $_POST['HrExpenseComponent'][$i]['business_details'];
                    }
                    if ($items['expense_component_id'] == 21) {
                        $modalexpensedetails[$i]->company = $_POST['HrExpenseComponent'][$i]['company'];
                    }
                    $validate = $modalexpensedetails[$i]->validate() && $validate;
                }
            }
            
            $model->total = $grand_total;
            if ($validate) {
                if ($model->save()) {
                    if (!empty($modalexpensedetails)) {
                        foreach ($modalexpensedetails as $eachModel) {
                            $eachModel->expense_id = $model->id;
                            $eachModel->save();
                        }
                    }
                    if ($model->status == 0) {
                        $jsonData['msg'] = 'Details Saved Successfully';
                    } else {
                        $jsonData['msg'] = 'Details Submitted Successfully';
                    }
                    $jsonData['status'] = 'success';
                }
                echo CJSON::encode($jsonData);
            } else {
                $error = json_decode(CActiveForm::validate($model, '', false), true);
                $error1 = json_decode(CActiveForm::validate($modalexpensedetails, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error, $error1));
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionapprovalhierarchy() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $function_type = Yii::app()->request->getparam("function_type");
        $model_level = HrEmployeeApproveLevel::model()->with('employeedetail')->find(array("condition" =>'employee_id ="' . $employee_id. '" AND functionality_id="'.$function_type.'"' ));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('approve_hierarchy', array('model_level' => $model_level, 'employee_id' => $employee_id));
    }
}
