<?php

class HrquestionController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'savequestions','deleteQuestion', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_questions']) || Yii::app()->user->authorised_user == 1) {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new HrQuestions();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'question_type.question_for',
            2 => 't.id',
            3 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (question_for LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('question_type')->count(array('condition' => $condition,'group'=>'question_type_id'));
        $model = $model->with('question_type')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'group'=>'question_type_id', 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $edit_button=$disable_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_questions_edit']) || Yii::app()->user->authorised_user == 1) {
             $edit_button=1;   
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_questions_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button=1;
            }
            $question_count = HrQuestions::model()->with('question_type')->count(array('condition' =>'question_type_id="'.$row->question_type_id.'"'));
            $rowData[] = array(++$m, $row->question_type->question_for,$question_count, array('id' => $row->question_type_id, 'status' => $row->isActive,'edit_button'=>$edit_button,'disable_button'=>$disable_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = array(new HrQuestions());
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = HrQuestions::model()->with('question_type')->findAll(array('condition' =>'question_type_id="'.$id.'"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionsavequestions() {
        if (isset($_POST['HrQuestions'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if (isset($_POST['HrQuestions'])){			
                foreach ($_POST['HrQuestions'] as $i => $items) {
                    if($items['id']>0){
                        $model_questions[$i] = HrQuestions::model()->findByPK($items['id']); 
                        $model_questions[$i]->scenario = 'update';
                        $model_questions[$i]->updated_by= Yii::app()->user->id;
                        $model_questions[$i]->updated_date_time = date('Y-m-d h:i:s');
                    }else{
                        $model_questions[$i] = new HrQuestions();   
                        $model_questions[$i]->scenario = 'add';
                        $model_questions[$i]->created_by= Yii::app()->user->id;
                        $model_questions[$i]->created_date_time = date('Y-m-d h:i:s');
                    }   
										
                    $model_questions[$i]->question = $items['question'];
                    $model_questions[$i]->question_type_id = $_POST['question_for'];		
                    $valid=$model_questions[$i]->validate() && $valid;
                    
                }
            }
            if($valid){
                if (!empty($model_questions)) {
                    foreach ($model_questions as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error1 = json_decode(CActiveForm::validateTabular($model_questions, '', false), true);
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
    public function actiondeleteQuestion(){
        $id = $_POST['id'];
        if($id>0){
            $model = new HrQuestions();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $new_status=($status == "Y" ) ? "N" : "Y";
        HrQuestions::model()->updateAll(array('isActive' =>$new_status), 'question_type_id="'.$id.'"');
        echo json_encode(array("status" => "success"));
    }

}
