<?php

class HrpermissionController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','GetList','Create','SaveDashboardPermission'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_emppanelpermission_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
     public function actionGetList() {
        $model = new HrPanelPermission();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'employee_category',
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (employee_category LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $employee_category=array(1=>'Permanent',2=>'Temporary/Contract',3=>'Trainee');
        foreach ($model as $row) {
            $edit_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_panel_permission_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_button=1;
            }
            $rowData[] = array(++$m, $employee_category[$row['employee_category']], array('id' => $row['id'], 'code' =>$employee_category[$row['employee_category']],'edit_button'=>$edit_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrPanelPermission();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSaveDashboardPermission() {
        $model = new HrPanelPermission();
        if (isset($_POST['HrPanelPermission'])) {
            if ((int) @$_POST['HrPanelPermission']['id'] > 0) {
                $model->id = (int) $_POST['HrPanelPermission']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $allPermissions = array();
            foreach ($_POST['HrPanelPermission']['employee_panel_permission'] as $eachPermissionArray) {
                if (is_array($eachPermissionArray)) {
                    foreach ($eachPermissionArray as $eachPermission) {
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->employee_panel_permission = json_encode($allPermissions);
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
}
