<?php

class HrmasproductController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'SaveProduct', 'BlockProduct','Uploadproduct','Upload','DownloadSampleCsv',
                    'SaveUploadCsv','DownloadErrorCsv'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_product_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetList() {
        $model = new HrMasProduct();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $columns = array(
            0 => 'id',
            1 => 'product_code',
            2 => 'product_name',
            3 => 't.id',
            4 => 'selling_price',
            5 => 'cost_price',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if ($status == "Y") {
            $condition.= ' AND t.isActive="Y"';
        }else if ($status == "N") {
            $condition.= ' AND t.isActive="N"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (product_code LIKE '%" . $searchString . "%' OR product_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=$offset;
        foreach ($model as $row) {
            $button_string = "";
            $edit_button =$block_button=$unblock_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hrmasproduct_edit']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/hrmasproduct/create&id=' . $row['id'] . '\',\'' .$row['product_code']. '-' .$row['product_name']. ' \',\'xl\')"><i class="fa fa-edit"></i></button>';
                $edit_button =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hrmasproduct_disable']) || Yii::app()->user->authorised_user == 1) {
                if ($row['isActive']=='Y') {
                    $button_string .=' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Block" onclick="blockproduct(' . $row['id'] . ',1)"><i class="fa fa-ban "></i></a>';
                    $block_button=1;
                } else {
                    $button_string .=' <a href ="javascript:void(0);" class="btn btn-success btn-xs" title="UnBlock" onclick="blockproduct(' . $row['id'] . ',2)"><i class="fa fa-retweet"></i></a>';
                    $unblock_button=1;
                }
            }
            $rowData[] = array(++$m, $row['product_code'],$row['product_name'],$row['cost_price'],$row['selling_price'],array('id'=>$row['id'],'status'=>$row['isActive'],'edit_button'=>$edit_button,'block_button'=>$block_button,'unblock_button'=>$unblock_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new HrMasProduct();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveProduct() {
        if (isset($_POST['HrMasProduct'])) {
            date_default_timezone_set("Asia/Dubai");
            $model = new HrMasProduct();
            if ((int) @$_POST['HrMasProduct']['id'] > 0) {                
                $model = HrMasProduct::model()->findByPK($_POST['HrMasProduct']['id']);
                $model->id = (int) $_POST['HrMasProduct']['id'];
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $model->scenario = 'update';
            } else {
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['HrMasProduct'];
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionBlockProduct() {
        $id = $_POST['id'];
        $model = HrMasProduct::model()->findByPk($id);
        $status=$model->isActive;
        $new_status = ($status == "Y" ) ? "N" : "Y";
        $arr_value=array('isActive' =>$new_status,'updated_by' =>Yii::app()->user->id, 'updated_date_time' =>date('Y-m-d H:i:s'));
        HrMasProduct::model()->updateByPk($id,$arr_value);
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);       
    }
    public function actionUploadproduct() {
        $model = new HrMasProduct();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_product', array('model' => $model), false, true);
    }
    public function actionDownloadSampleCsv() {
        $filename = 'upload_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Code *,Name *,Cost Price *,Selling Price *';
        Yii::app()->end();
    }
    public function readProductCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionSaveUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');  
        $jsonData['status'] = "success";
        $url = Yii::app()->basePath . '/../uploads/products_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/products_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $productcode_error = array();
        $product_list = $this->readProductCSV("uploads/products_csv/" . $file_name);
        foreach (array_slice($product_list, 1) as $i => $data) {
            if(!empty($data[0])|| !empty($data[1]) || !empty($data[2]) || !empty($data[3])){
            $model[$i] = new HrMasProduct();
            if($data[0]!=''){
                $model[$i]->product_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
            }else{                    
                $model[$i]->product_code = '';
            }
            $productcode_error[$i] = $model[$i]->product_code;
            if($data[1]!=''){
                $model[$i]->product_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));
            }else{                    
                $model[$i]->product_name = '';
            }
            if($data[2]!=''){
                $model[$i]->cost_price = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'));
            }else{                    
                $model[$i]->cost_price = '';
            }
            if($data[3]!=''){
                $model[$i]->selling_price = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"'));
            }else{                    
                $model[$i]->selling_price = '';
            }
            $model[$i]->created_by = Yii::app()->user->id;
            $model[$i]->created_date_time = date('Y-m-d h:i:s');  
            $model[$i]->isActive = 'Y';
            $validate = $model[$i]->validate() && $validate;
            }
        }
        function array_not_unique($raw_array) {
            $dupes = array();
            natcasesort($raw_array);
            reset($raw_array);

            $old_key   = NULL;
            $old_value = NULL;
            foreach ($raw_array as $key => $value) {
                if ($value === NULL) { continue; }
                 if($old_value!=NULL){
                    if (strcasecmp($old_value, $value) === 0) {
                        $dupes[$old_key] = $old_value;
                        $dupes[$key]     = $value;
                    }
                 }
                $old_value = $value;
                $old_key   = $key;
            }
            return $dupes;
        }
        $productcode_common = array_not_unique($productcode_error);
        if ($validate && empty($productcode_common)) {					
            if (!empty($model)) {
                foreach ($model as $eachModel) {                            
                    $eachModel->save();
                }
                $jsonData['error'] ="";	
            }	
        } else {			
            if (!empty($model)) {
                foreach ($model as $s => $data_model) {
                    $error_list[$s]['product_code'] =$data_model['product_code'];
                    $error_list[$s]['product_name'] =$data_model['product_name'];
                    $error_list[$s]['cost_price'] =$data_model['cost_price'];
                    $error_list[$s]['selling_price'] =$data_model['selling_price'];
                    if($data_model->validate()){
                        $error_list[$s]['remarks']     ="Correct";
                    }else{
                        $error_list[$s]['remarks']     =$data_model->getErrors();	
                    }
                }
            }	
	}				
              		 
	$j=0;
        fclose($file);
        $list = array(); 
        if(!empty($error_list)){
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Code *,Name *,Cost Price *,Selling Price *,Remarks';
            foreach ($error_list as $i => $error_detail) {
                if(!empty($error_detail)){
                    if(!empty($error_detail['remarks'])){
                            $error_view[$i] = '';
                        foreach($error_detail['remarks'] as $p => $error_value){						
                                $error_view[$i] .= $error_value[0]." / ";	
                        }
                    }else{
                        $error_view[$i] .= '';
                    }
                    if (in_array($error_detail['product_code'], $productcode_common)){
                        $error_view[$i] .= " Code duplication /";
                    }	else {
                        $error_view[$i] .= '';
                    }
                    $list[$j++] = $error_detail['product_code']. ',' .$error_detail['product_name']. ',' .$error_detail['cost_price']. ',' .$error_detail['selling_price']. ',' .$error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }
		

        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('hrmasproduct/DownloadErrorCsv', 'id'=>$file_name), array('target' => '_blank',
            'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
            . ''
            ));
        echo CJSON::encode($jsonData);
    }
    public function actionDownloadErrorCsv() {
        $file_name =Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/products_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
}
