<?php

class HrmascourseController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'Disable','deleteCourse'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
       if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_course_menu']) || Yii::app()->user->authorised_user == 1) {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }else{
        throw new CHttpException(401, 'Unauthorized Access.');
    }
}

    public function actionGetList() {
        $model = new HrMasTrainingCourse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'course_name',
            2 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (course_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $edit_button=$disable_button=1;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_course_edit']) || Yii::app()->user->authorised_user == 1) {
               $edit_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_course_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button =1;
            }
            $rowData[] = array(++$m, $row->course_name, array('id' => $row->id, 'status' => $row->isActive,'edit_button'=>$edit_button,'disable_button'=>$disable_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new HrMasTrainingCourse();
        $model_training = array(new HrMasTrainingCourseDetail());
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_training = HrMasTrainingCourseDetail::model()->findAll(array('condition'=>'master_id="'.$id.'"'));
            if(empty($model_training)){
                $model_training = array(new HrMasTrainingCourseDetail());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'model_training'=>$model_training), false, true);
    }

    public function actionSave() {
        $model = new HrMasTrainingCourse;
        if (isset($_POST['HrMasTrainingCourse'])) {
            if ((int) @$_POST['HrMasTrainingCourse']['id'] > 0) {
                $model->id = (int) $_POST['HrMasTrainingCourse']['id'];
                $model->scenario = 'update';
                $model = HrMasTrainingCourse::model()->findByPK($_POST['HrMasTrainingCourse']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                unset($_POST['HrMasTrainingCourse']['id']);
                $model->scenario = 'add';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['HrMasTrainingCourse'];
            $valid=$model->validate();		
            foreach ($_POST['HrMasTrainingCourseDetail'] as $i => $items) {
                if($items['id']>0){
                    $model_training[$i] = HrMasTrainingCourseDetail::model()->findByPK($items['id']); 
                     $model_training[$i]->scenario = 'update';
                }else{
                    $model_training[$i] = new HrMasTrainingCourseDetail();
                   $model_training[$i]->scenario = 'add';
                }   			
                $model_training[$i]->training_course = $items['training_course'];		
                $valid=$model_training[$i]->validate() && $valid;

            }
            if ($valid) {               
                $model->save();
                if (!empty($model_training)) {
                    foreach ($model_training as $eachModel) {
                        $eachModel->master_id =$model->id;
                        $eachModel->save();
                    }
                }     
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_training[0]->training_course==''){
                   $error2 = json_decode(CActiveForm::validateTabular($model_training, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new HrMasTrainingCourse();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    public function actiondeleteCourse(){
        $id = $_POST['id'];
        if($id>0){
            $model = new HrMasTrainingCourseDetail();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}
