<?php

class HrmasassetController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Delete', 'DirectAdd', 'Disable','UploadAsset','UploadEmployeecsv','DownloadSampleCsv','DownloadErrorCsv','readAssetCSV','SaveAssetUploadCsv','readAssetCSV','SaveAssetUploadCsv'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_asset= HrModules::model()->findByPK(30);
        if (($model_module_asset->grant_access == 1 && $model_module_asset->isActive == 'Y')){ 
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_asset_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new HrMasAsset();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'isActive',
            1 => 'asset_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"'; // 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (asset_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m =$offset;
        foreach ($model as $row) {
            $edit=$disable=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_asset_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_asset_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable=1;
            }
            $rowData[] = array(++$m, $row['asset_name'], array('id' => $row->id, 'status' => $row->isActive,'edit'=>$edit,'disable'=>$disable));
        }


        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new HrMasAsset();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {

        $model = new HrMasAsset();

        if (isset($_POST['HrMasAsset'])) {

            if ((int) @$_POST['HrMasAsset']['id'] > 0) {

                $id = (int) @$_POST['HrMasAsset']['id'];
                $model = $model->findByPk($id);
                $model = $model->findByPk($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['HrMasAsset'];

            if ($model->save()) {

                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new HrMasAsset();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N " : "Y";
        $model->save(false);
        echo json_encode(array("status" => "success", 'active' => $model->isActive));
    }
     public function actionUploadAsset(){
        //added by nisha on 08-03-2023
        $model=new HrMasAsset();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('asset_upload', array('model' => $model), false, true);
    }
    public function actionDownloadSampleCsv() {
        $filename = 'asset_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Asset Name*';
        Yii::app()->end();
    } 
    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/asset_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    public function readAssetCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionSaveAssetUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');  
        $url = Yii::app()->basePath . '/../uploads/asset_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/asset_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $asset_error = array();
        $asset_list = $this->readAssetCSV("uploads/asset_csv/" . $file_name);
        $linecount = count(file("uploads/asset_csv/" . $file_name))-1;
            foreach (array_slice($asset_list, 1) as $i => $data) {
                if(!empty($data[0])){
                    if($data[0]!=''){
                $asset_model[$i] = new HrMasAsset();
                $asset_model[$i]->scenario="excelupload";
                $asset_model[$i]->asset_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
                }else{                    
                    $asset_model[$i]->asset_name = '';
                }
                $asset_error[$i] = $asset_model[$i]->asset_name;   
                $asset_model[$i]->isActive = 'Y';
                $asset_model[$i]->created_by  =Yii::app()->user->id;
                $asset_model[$i]->created_date_time = date('Y-m-d H:i:s');
                $validate = $asset_model[$i]->validate() && $validate;
                }
            }
            //echo '<pre>';  print_r($asset_model);      die();
            function array_not_unique($raw_array) {
                $dupes = array();
                natcasesort($raw_array);
                reset($raw_array);

                $old_key   = NULL;
                $old_value = NULL;
                foreach ($raw_array as $key => $value) {
                    if ($value === NULL) { continue; }
                    if($old_value!=NULL){
                        if (strcasecmp($old_value, $value) === 0) {
                            $dupes[$old_key] = $old_value;
                            $dupes[$key]     = $value;
                        }
                    }
                    $old_value = $value;
                    $old_key   = $key;
                }
                return $dupes;
            }
               

            $des_common = array_not_unique($asset_error);
            if ($validate) {                    
                if (!empty($asset_model)) {
                    foreach ($asset_model as $eachModel) { 
                        $eachModel->save();
                    }
                    $jsonData['error'] =""; 
                }   
            } else {            
                if (!empty($asset_model)) {
                    foreach ($asset_model as $s => $data_model) {
                        $error_list[$s]['asset_name'] =$data_model['asset_name'];
                        
                        if($data_model->validate()){
                        $error_list[$s]['remarks']     ="correct";
                        }else{
                        $error_list[$s]['remarks']     =$data_model->getErrors();   
                        }
                    }
                }   
            }               

            $j=0;
            fclose($file);
            $list = array(); 
            if(!empty($error_list)){
                $file_error = fopen($error_url, "w+");
                $list[$j++] = 'Asset Name*,Remarks';
                foreach ($error_list as $i => $error_detail) {
                    if(!empty($error_detail)){
                        if(!empty($error_detail['remarks'])){
                                $error_view[$i] = '';
                            foreach($error_detail['remarks'] as $p => $error_value){                        
                                    $error_view[$i] .= $error_value[0]." / ";   

                            }
                        }else{
                            $error_view[$i] .= '';
                        }
                        if (in_array($error_detail['asset_name'], $des_common)){
                            $error_view[$i] .= " Asset name duplication in CSV /";
                        }   else {
                            $error_view[$i] .= '';
                        }
                        
                        $list[$j++] = $error_detail['asset_name'].  ',' .$error_view[$i];
                    }
                }
                foreach ($list as $line) {
                    fputcsv($file_error, explode(',', $line));
                }
                fclose($file_error);
            }
            $jsonData['status'] = "success";
            $jsonData['error_url'] = $error_url;
            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download log', array('hrmasasset/DownloadErrorCsv', 'id'=>$file_name), array('target' => '_blank',
                'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                . ''
                ));
        
        echo CJSON::encode($jsonData);
    }

}

?>