<?php

class HrmasappraisaltypeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'Edit','SaveWeightage','deleteGoal'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_appraisal_type_menu']) || Yii::app()->user->authorised_user == 1) {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new HrMasAppraisalType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'appraisal_type',
            2 => 'default_weightage',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (appraisal_type LIKE '%" . $searchString . "%') OR (departmentdetails.department_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('departmentdetails')->count(array('condition' => $condition,'group'=>'appraisal_department'));
        $model = $model->with('departmentdetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'group'=>'appraisal_department', 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $edit_button=$disable_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_appraisaltype_edit']) || Yii::app()->user->authorised_user == 1) { 
                $edit_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_appraisaltype_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button =1;
            }
            
            $goal_count = HrMasAppraisalType::model()->with('departmentdetails')->count(array('condition' =>'appraisal_department="'.$row->appraisal_department.'"'));
            $rowData[] = array(++$m,$row->departmentdetails->department_name,$goal_count, $row->appraisal_department,array('edit_button'=>$edit_button,'disable_button'=>$disable_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = array(new HrMasAppraisalType());
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = HrMasAppraisalType::model()->with('departmentdetails')->findAll(array('condition' =>'appraisal_department="'.$id.'"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionsave() {
        $other=array();$groups = array();
        if (isset($_POST['HrMasAppraisalType'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            $total_weightage=0;
            if (isset($_POST['HrMasAppraisalType'])){			
                foreach ($_POST['HrMasAppraisalType'] as $i => $items) {
                    if($items['id']>0){
                        $model_goal[$i] = HrMasAppraisalType::model()->findByPK($items['id']);   
                        $model_goal[$i]->scenario = 'add';
                        $model_goal[$i]->updated_by= Yii::app()->user->id;
                        $model_goal[$i]->updated_date_time = date('Y-m-d H:i:s');
                    }else{
                        $model_goal[$i] = new HrMasAppraisalType();   
                        $model_goal[$i]->scenario = 'update';
                        $model_goal[$i]->created_by= Yii::app()->user->id;
                        $model_goal[$i]->created_date_time = date('Y-m-d H:i:s');

                    }   
										
                    $model_goal[$i]->appraisal_type = $items['appraisal_type'];
                    $model_goal[$i]->appraisal_department = $_POST['department_id'];
                    $model_goal[$i]->default_weightage = $items['default_weightage'];
                    $total_weightage = $total_weightage+ $items['default_weightage'];
                    $valid=$model_goal[$i]->validate() && $valid;
                    } 
                    
                    
                }
            }
            //weightage percent on 100 
            if($total_weightage!=100){
               $other[]='Total weightage  should have maximum weightage 100. Now its'.(floatval($total_weightage));
                $valid=false;     
            }
            if($valid){
                if (!empty($model_goal)) {
                    foreach ($model_goal as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error1 = json_decode(CActiveForm::validateTabular($model_goal, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1,$other));
                if ($error != '[]'){
                    echo $error;    
                }
            }
            
        
    }
    public function actionEdit() {
        $model = HrMasAppraisalType::model()->findAll();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_weightage', array('model' => $model), false, true);
    }
    public function actionSaveWeightage(){
        if (isset($_POST['HrMasAppraisalType'])) {
            $total=0;
            foreach ($_POST['HrMasAppraisalType'] as $i => $item) {
                if ($item['id'] > 0) {
                    $total+=$item['default_weightage'];
                    $model_appraisaltype[$i] = HrMasAppraisalType::model()->findByPK($item['id']);
                    $model_appraisaltype[$i]->default_weightage = $item['default_weightage'];
                    $model_appraisaltype[$i]->updated_by = Yii::app()->user->id;
                    $model_appraisaltype[$i]->updated_date_time = date('Y-m-d H:i:s');
                }
            }
            if($total!=100){
                echo '["Weightage sum should be equal to 100"]';
            }else{
                foreach ($model_appraisaltype as $i => $item) {
                    $item->save(false);
                } 
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        }
    }
    public function actiondeleteGoal(){
        $id = $_POST['id'];
        if($id>0){
            $model = new HrMasAppraisalType();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}
