<?php

class HremployeeanalysisController extends Controller {

    //public $layout = 'main';
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','GetGraph','GetbranchEmployee','loademployeedetails','Dashboard','loademployeedetail','GetDashboardGraph','ClearStaffboardData'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() { 
        $this->render('index');
    }
    public function actionGetbranchEmployee() {
        $branch = Yii::app()->request->getparam("branch");
        $jsonData['employee']=CHtml::dropDownList('employee_employee_id','',Employee::getEmployee($branch), array('class' => 'tooltipster', 'title' => 'Employee', 'data-label' => 'Employee', 'empty' => 'All Employees'));
        echo CJSON::encode($jsonData);
    }
    public function actionloademployeedetails() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $model = Employee::model()->findbyPK($employee_id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('employee_details', array('model' => $model));
    }
    public function actionGetGraph(){
        $month = Yii::app()->request->getparam("month"); 
        $employee_id= Yii::app()->request->getparam("employee_id"); 
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('graph_attendance_month',array('month'=>$month,'employee_id'=>$employee_id));
    }
    function decimalHours($time)
    {
        $hms = explode(":", $time);
        return ($hms[0] + ($hms[1]/60) + ($hms[2]/3600));
    }
    public function actionDashboard() {
        $this->layout = "main";
        $model_module_employee = HrModules::model()->findByPK(1);
        if ($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y') {
            $this->render('dashboard');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionloademployeedetail() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $model = Employee::model()->findbyPK($employee_id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('employee_details_dashboard', array('model' => $model));
    }
    public function actionGetDashboardGraph(){
        $month = Yii::app()->request->getparam("month"); 
        $employee_id= Yii::app()->request->getparam("employee_id"); 
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('graph_dashboard_attendance_month',array('month'=>$month,'employee_id'=>$employee_id));
    }
    public function actionClearStaffboardData(){
        $id = $_POST['id'];
        $employee_id = $_POST['employee_id'];
        if($id>0){
            $model = new HrNotification();                
            $model = $model->findbypk($id);
            $readstatus="";
            if($model->read_status!=''){
                $readstatus=$model->read_status.','.$employee_id;
            }else{
                $readstatus=$employee_id;
}
            HrNotification::model()->updateByPK($model->id, array('read_status' =>$readstatus));
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}
