<?php

class HrdashboardController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'filterleavebyemployee', 'senddocumentexpirymail', 'sendcompanydocexpirymail', 'sendgreetingsmail', 'GetExpiryList', 'GetCompnyDocExpiryList', 'GetInprocesDocList', 'GetInprocesCompnyDocList', 'GetBirthdayList', 'GetApprovedleaveList'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_employee = HrModules::model()->findByPK(1);
        $model_module_attendance = HrModules::model()->findByPK(2);
        $model_module_leave = HrModules::model()->findByPK(3);
        $model_module_company = HrModules::model()->findByPK(36);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_dashboard_menu']) || Yii::app()->user->authorised_user == 1) &&
                (($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y') ||
                ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y') ||
                ($model_module_company->grant_access == 1 && $model_module_company->isActive == 'Y') ||
                ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y'))) {
            $to_date = date('Y-m-d');
            $branch_condition = ' ';
            if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                $branch_condition .= ' and employeedetails.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
            }
            $arr_employee_document_reminder = EmployeeDocuments::model()->with('employeedetails', 'document')->findAll(array('condition' => 't.renew_on<="' . $to_date . '"  AND t.status = 0 AND employeedetails.isActive ="Y" and document.document_type="1"' . $branch_condition, 'order' => 't.validate_till_date ASC'));
            $arr_employee_inprocess_doc = EmployeeDocuments::model()->with('employeedetails')->findAll(array('condition' => 't.status="1" and employeedetails.isActive!=1' . $branch_condition));
            $this->render('index', array('arr_employee_document_reminder' => $arr_employee_document_reminder, 'arr_employee_inprocess_doc' => $arr_employee_inprocess_doc), false, true);
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionfilterleavebyemployee() {
        $id = $_POST['id'];
        $branch = $_POST['branch'];
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->renderPartial('employee_leave_details', array('id' => $id, 'branch' => $branch), false, true);
    }

    public function actionsenddocumentexpirymail() {
        $employee_id = $_POST['employee_id'];
        $id = $_POST['id'];
        //Mail
        $model_settings = HrGenerelSettings::model()->find();
        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="26"'));
        if (!empty($model_settings)) {
            if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                Yii::import('application.modules.hr.controllers.MailController');
                MailController::sendmail(26, $employee_id, $id);
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionsendcompanydocexpirymail() {
        $id = $_POST['id'];
        //Mail
        $model_settings = HrGenerelSettings::model()->find();
        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="27"'));
        if (!empty($model_settings)) {
            if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                Yii::import('application.modules.hr.controllers.MailController');
                MailController::sendmail(27, 0, $id);
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionsendgreetingsmail() {
        $id = $_POST['id'];
        $type = $_POST['type'];
        //Mail
        $model_settings = HrGenerelSettings::model()->find();
        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="25"'));
        if (!empty($model_settings)) {
            if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                Yii::import('application.modules.hr.controllers.MailController');
                MailController::sendmail(25, $id, $type);
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionGetExpiryList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetails.first_name',
        );

        $filterColumn = '';
        $filterOrder = '';
        if (isset($_POST['order'][0]['column']) && isset($columns[$_POST['order'][0]['column']])) {
            $filterColumn = $columns[$_POST['order'][0]['column']];
        }
        if (isset($_POST['order'][0]['dir'])) {
            $filterOrder = $_POST['order'][0]['dir'];
        }

        //$filterColumn = $columns[$_POST['order'][0]['column']];
        //$filterOrder = $_POST['order'][0]['dir'];


        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        $model_settings = HrGenerelSettings::model()->find();
        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="26"'));
        $to_date = date('Y-m-d');
        $branch_condition = ' ';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $branch_condition .= ' and employeedetails.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $branch_condition .= " and ( employeedetails.first_name LIKE '%" . $searchString_en . "%' OR employeedetails.middle_name LIKE '%" . $searchString_en . "%' OR employeedetails.last_name LIKE '%" . $searchString_en . "%' OR document.document_name LIKE '%" . $searchString . "%')";
        }
        $arr_employee_document_reminder = EmployeeDocuments::model()->with('employeedetails', 'document')->findAll(array('condition' => 't.renew_on<="' . $to_date . '"  AND t.status = 0 AND employeedetails.isActive ="Y" and document.document_type="1"' . $branch_condition, 'order' => 't.validate_till_date ASC'));
        $arr_employee_inprocess_doc = EmployeeDocuments::model()->with('employeedetails', 'document')->findAll(array('condition' => 't.status="1" and employeedetails.isActive!=1' . $branch_condition));
        $count = count($arr_employee_document_reminder);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($arr_employee_document_reminder as $row) {
            $div = '';
            if (!empty($model_settings)) {
                if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                    $div .= '<a href ="javascript:void(0);" title="Email" class="btn btn-danger btn-xs" onclick="sendexpirymail(' . $row['employee_id'] . ',' . $row['id'] . ')"><i class="fa fa-envelope"></i></a>';
                }
            }
            $div .= '<a href ="javascript:void(0);" title="Change to Inprocess State" class="btn btn-danger btn-xs" onclick="employeeinprocessstatus(' . $row['id'] . ')"><i class="fa fa-arrow-right"></i></a>';
            $color = 0;
            if ($row['expiry_notify'] == 2) {
                $color = 3;
            }
            $current_date = date('Y-m-d');
            $current_date_1 = date('Y-m-d', strtotime('+1 days', strtotime(date('Y-m-d'))));
            $current_date_15 = date('Y-m-d', strtotime('+15 days', strtotime(date('Y-m-d'))));
            if (strtotime($row->validate_till_date) <= strtotime($current_date)) {
                $color = 2;
            } else if ((strtotime($row->validate_till_date) >= strtotime($current_date_1)) && (strtotime($row->validate_till_date) <= strtotime($current_date_15))) {
                $color = 1;
            } else {
                $color = 0;
            }
//, '<div class="btn-wrap text-center">' . $div . '</div>',
            $rowData[] = array(++$m, $row->employeedetails->employeefullname, $row->document->document_name, date("d/m/Y", strtotime($row->validate_till_date)), $color);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetCompnyDocExpiryList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'documentname.document_name',
        );
        $filterColumn = '';
        $filterOrder = '';
        if (isset($_POST['order'][0]['column']) && isset($columns[$_POST['order'][0]['column']])) {
            $filterColumn = $columns[$_POST['order'][0]['column']];
        }
        if (isset($_POST['order'][0]['dir'])) {
            $filterOrder = $_POST['order'][0]['dir'];
        }



        //$filterColumn = $columns[$_POST['order'][0]['column']];
        //$filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        $model_settings = HrGenerelSettings::model()->find();
        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="27"'));
        $to_date = date('Y-m-d');
        $arr_company_document_reminder = CompanyDocument::model()->with('documentname')->findAll(array('condition' => 't.renew_on<="' . $to_date . '" and status="0" and documentname.document_type="1"', 'order' => 't.validate_till_date ASC'));
        $to_date = date('Y-m-d');
        $count = count($arr_company_document_reminder);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($arr_company_document_reminder as $row) {
            $div = '';
            $div .= '<a href ="javascript:void(0);" title="Change to Inprocess State" class="btn btn-danger btn-xs" onclick="changeinprocessstatus(' . $row['id'] . ')"><i class="fa fa-arrow-right"></i></a>';
            if (!empty($model_settings)) {
                if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                    $div .= '<a href ="javascript:void(0);" title="Email" class="btn btn-danger btn-xs" onclick="sendcompanydocexpirymail(' . $row['id'] . ')"><i class="fa fa-envelope"></i></a>';
                }
            }
            $color = 0;
            if ($row['expiry_notify'] == 2) {
                $color = 3;
            }
            if ($color == 0) {
                $current_date = date('Y-m-d');
                $current_date_1 = date('Y-m-d', strtotime('+1 days', strtotime(date('Y-m-d'))));
                $current_date_15 = date('Y-m-d', strtotime('+15 days', strtotime(date('Y-m-d'))));
                if (!empty($employee_document_reminder) && (strtotime($employee_document_reminder->validate_till_date) <= strtotime($current_date))) {
                    $color = 2;
                } else if (!empty($employee_document_reminder) && (strtotime($employee_document_reminder->validate_till_date) >= strtotime($current_date_1)) && (strtotime($employee_document_reminder->validate_till_date) <= strtotime($current_date_15))) {
                    $color = 1;
                } else {
                    $color = 0;
                }
            }
            //, '<div class="btn-wrap text-center">' . $div . '</div>',
            $rowData[] = array(++$m, $row->documentname->document_name, $row->document_number, date("d/m/Y", strtotime($row->validate_till_date)), $color);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetInprocesDocList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetails.first_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        $model_settings = HrGenerelSettings::model()->find();
        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="26"'));
        $to_date = date('Y-m-d');
        $branch_condition = ' ';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $branch_condition .= ' and employeedetails.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $arr_employee_inprocess_doc = EmployeeDocuments::model()->with('employeedetails')->findAll(array('condition' => 't.status="1"'));
        $count = count($arr_employee_inprocess_doc);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($arr_employee_inprocess_doc AS $employee_inprocess_doc) {
            $model_doc = HrEmployeeInprocessDocument::model()->findAll(array('condition' => 'completed="N" and document_id="' . $employee_inprocess_doc->document_id . '" and employee_id="' . $employee_inprocess_doc->employee_id . '"'));
            $arr_stages = array();
            $stages = '';
            foreach ($model_doc as $value) {
                $arr_stages[] = $value->pro_stage->stages;
            }
            $stages = implode(',', $arr_stages);
            if ($employee_inprocess_doc->inprocess_date != '0000-00-00' && $employee_inprocess_doc->inprocess_date != '') {
                $inprocess_date = date('d/m/Y', strtotime($employee_inprocess_doc->inprocess_date));
            }
            $div = '';
            $div .= '<a href ="javascript:void(0);" title="Change to Inprocess State" class="btn btn-danger btn-xs" onclick="loadPopupModal(\'hr/inprocess/emplyeeinprocessdocument&id=' . $employee_inprocess_doc['id'] . '\',\'Edit Employee Inprocess Document \')"><i class="fa fa-pencil"></i></a>';
            $rowData[] = array(++$m, $inprocess_date, $employee_inprocess_doc->employeedetails->employeefullname, $employee_inprocess_doc->document->document_name, $stages, '<div class="btn-wrap text-center">' . $div . '</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetInprocesCompnyDocList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetails.first_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $arr_company_inprocess_doc = CompanyDocument::model()->findAll(array('condition' => 't.status="1"'));
        $count = count($arr_company_inprocess_doc);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($arr_company_inprocess_doc AS $company_inprocess_doc) {
            $model_doc = CompanyInprocessDocument::model()->findAll(array('condition' => 'completed="N" and document_id="' . $company_inprocess_doc->document_id . '"'));
            $arr_stages = array();
            $stages = '';
            foreach ($model_doc as $value) {
                $arr_stages[] = $value->pro_stage->stages;
            }
            $stages = implode(',', $arr_stages);
            if ($company_inprocess_doc->inprocess_date != '0000-00-00' && $company_inprocess_doc->inprocess_date != '') {
                $inprocess_date = date('d/m/Y', strtotime($company_inprocess_doc->inprocess_date));
            }
            $div = '';
            $div .= '<a href ="javascript:void(0);" title="Change to Inprocess State" class="btn btn-danger btn-xs" onclick="loadPopupModal(\'hr/inprocess/companyinprocessdocument&id=' . $company_inprocess_doc['id'] . '\',\'Edit  Inprocess Document \')"><i class="fa fa-pencil"></i></a>';
            $rowData[] = array(++$m, $inprocess_date, $company_inprocess_doc->documentname->document_name, $stages, '<div class="btn-wrap text-center">' . $div . '</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetBirthdayList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'first_name',
        );

        $filterColumn = '';
        $filterOrder = '';
        if (isset($_POST['order'][0]['column']) && isset($columns[$_POST['order'][0]['column']])) {
            $filterColumn = $columns[$_POST['order'][0]['column']];
        }
        if (isset($_POST['order'][0]['dir'])) {
            $filterOrder = $_POST['order'][0]['dir'];
        }
        // $filterColumn = $columns[$_POST['order'][0]['column']];
        // $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $branch_condition = ' ';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $branch_condition .= ' and t.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $arr_employee_birthdays = Employee::model()->findAll(array('select' => 'id,employee_code,first_name,last_name,date_of_birth,email', 'condition' => 'isActive="Y" AND MONTH(`date_of_birth`)= MONTH(CURRENT_DATE)' . $branch_condition, 'order' => 'DAY( `date_of_birth` )'));
        $model_settings = HrGenerelSettings::model()->find();
        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="25"'));
        $count = count($arr_employee_birthdays);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($arr_employee_birthdays AS $employee_birthdays) {
            $div = '';
            if (!empty($model_settings)) {
                if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                    $div .= '<a href ="javascript:void(0);" title="Email" class="btn btn-danger btn-xs" onclick="sendgreetingsmail(' . $employee_birthdays->id . ')"><i class="fa fa-envelope"></i></a>';
                }
            }
            $rowData[] = array(++$m, $this->ciphertext($employee_birthdays->employee_code, "d"), $employee_birthdays->employeefullname, date('d-F', strtotime($employee_birthdays->date_of_birth)), '<div class="btn-wrap text-center">' . $div . '</div>');
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetApprovedleaveList() {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'first_name',
        );
        $filterColumn = '';
        $filterOrder = '';
        if (isset($_POST['order'][0]['column']) && isset($columns[$_POST['order'][0]['column']])) {
            $filterColumn = $columns[$_POST['order'][0]['column']];
        }
        if (isset($_POST['order'][0]['dir'])) {
            $filterOrder = $_POST['order'][0]['dir'];
        }
        // $filterColumn = $columns[$_POST['order'][0]['column']];
        // $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $branch_condition = ' ';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $branch_condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $from_date = date('Y-m-d');
        $modelannualleave = EmployeeLeaveDetail::model()->with('employeedetail', 'leavetype')->findAll(array('condition' => 'leave_end_date>="' . $from_date . '" and  employeedetail.isActive="Y" and t.leave_status="12"' . $branch_condition));
        $count = count($modelannualleave);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($modelannualleave as $key => $leave) {
            $rowData[] = array(++$m, $leave->leavetype->leave_name, date('d/m/Y', strtotime($leave->leave_start_date)), date('d/m/Y', strtotime($leave->leave_end_date)), $leave->employeedetail->employeefullname, $leave->no_days);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

}
