<?php

class HrappraisalquestionController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'savequestions','deleteQuestion', 'Disable','GetGoalDetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_appraisal_question_menu']) || Yii::app()->user->authorised_user == 1) {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetList() {
        $model = new HrAppraisalQuestions();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'departmentdetail.department_name',
            2 => 't.id',
            3 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (department_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('departmentdetail')->count(array('condition' => $condition,'group'=>'department_id'));
        $model = $model->with('departmentdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'group'=>'department_id', 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $edit_button=$disable_button=0;
        foreach ($model as $row) {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_questions_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_button =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_questions_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button=1;
            }
            $question_count = HrAppraisalQuestions::model()->with('departmentdetail')->count(array('condition' =>'department_id="'.$row->department_id.'"'));
            $rowData[] = array($m, $row->departmentdetail->department_name,$question_count, array('id' => $row->department_id, 'status' => $row->isActive,'edit_button'=>$edit_button,'disable_button'=>$disable_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = array(new HrAppraisalQuestions());
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = HrAppraisalQuestions::model()->with('departmentdetail')->findAll(array('condition' =>'department_id="'.$id.'" AND t.isActive="Y"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'id'=>$id), false, true);
    }

    public function actionsavequestions() {
        $other=array();$groups = array();
        if (isset($_POST['HrAppraisalQuestions'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if (isset($_POST['HrAppraisalQuestions'])){			
                foreach ($_POST['HrAppraisalQuestions'] as $i => $items) {
                    if($items['id']>0){
                        $model_questions[$i] = HrAppraisalQuestions::model()->findByPK($items['id']);   
                        $model_questions[$i]->scenario = 'add';
                        $model_questions[$i]->updated_by= Yii::app()->user->id;
                        $model_questions[$i]->updated_date_time = date('Y-m-d h:i:s');
                    }else{
                        $model_questions[$i] = new HrAppraisalQuestions();   
                        $model_questions[$i]->scenario = 'update';
                        $model_questions[$i]->created_by= Yii::app()->user->id;
                        $model_questions[$i]->created_date_time = date('Y-m-d H:i:s');
                    }   
										
                    $model_questions[$i]->appraisal_type = $items['appraisal_type'];
                    $model_questions[$i]->question = $items['question'];
                    $model_questions[$i]->weightage_percent = $items['weightage_percent'];
                    $model_questions[$i]->department_id = $_POST['department_id'];	
                    $key = $items['appraisal_type'];
                    if (!array_key_exists($key, $groups)) {
                        $groups[$key] = array(
                        'id' => $items['appraisal_type'],
                        'total_weightage' => $items['weightage_percent'],
                        );
                    } 
                    else 
                    {
                        $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['weightage_percent'];
                    } 
                    $valid=$model_questions[$i]->validate() && $valid;
                    
                }
            }
            //weightage percent on 100 
            if(!empty($groups))
            {
                foreach($groups as $key=>$eachType)  
                {
                    $mas_type=HrMasAppraisalType::model()->findByPk($key);
                    if($eachType['total_weightage']!=100){
                        $other[]=$mas_type->appraisal_type.' should have maximum weightage 100. Now its'.(floatval($eachType['total_weightage']));
                        $valid=false;                        
                    }
                }  
            }
            if($valid){
                if (!empty($model_questions)) {
                    foreach ($model_questions as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error1 = json_decode(CActiveForm::validateTabular($model_questions, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1,$other));
                if ($error != '[]'){
                    echo $error;    
                }
            }
            
        }
    }
    public function actiondeleteQuestion(){
        $id = $_POST['id'];
        if($id>0){
            $model = new HrAppraisalQuestions();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $new_status=($status == "Y" ) ? "N" : "Y";
        HrAppraisalQuestions::model()->updateAll(array('isActive' =>$new_status), 'department_id="'.$id.'"');
        echo json_encode(array("status" => "success"));
    }
    public function actionGetGoalDetails() {
        $id = (int)Yii::app()->request->getParam('id');
        
        $model_questions = new HrAppraisalQuestions();
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('goal_questions', array('dept' => $id, 'model_questions' => $model_questions,'model_settings' => $model_settings), false, true);
    }
}
