<?php

class HrallowanceController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','LoademployeeDetails','Saveallowance'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    
    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array(), false, true);
    }
    public function actionLoademployeeDetails() {
        $branch = Yii::app()->request->getparam("branch");
        $department_id = Yii::app()->request->getparam("department_id");
        $condition='branch_or_sponsor_id="' . $branch . '" AND isActive!="B"';
        if($department_id!=''){
            $condition.=' AND department="'.$department_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('employee_details_allowance', array('arr_employee' => $arr_employee, 'branch' => $branch));
    }
    public function actionSaveallowance() {
        if (isset($_POST['HrHolidayAllowance'])) {
            date_default_timezone_set("Asia/Dubai");
            $valid=true;
            $i=0;
            foreach ($_POST['HrHolidayAllowance'] as $k => $items) {
                
                    if($items['id']>0){
                        $model_details[$i] = HrHolidayAllowance::model()->findByPK($items['id']);   
                        $model_details[$i]->updated_by= Yii::app()->user->id;
                        $model_details[$i]->updated_date_time = date('Y-m-d H:i:s');
                        $model_details[$i]->attributes = $_POST['HrHolidayAllowance'][$k];
                        $valid=$model_details[$i]->validate() && $valid;
                        $i++;
                    }else{
                        if($items['allowance_amount']>0){
                            $model_details[$i] = new HrHolidayAllowance();  
                            $model_details[$i]->created_by= Yii::app()->user->id;
                            $model_details[$i]->created_date_time = date('Y-m-d H:i:s');
                            $model_details[$i]->attributes = $_POST['HrHolidayAllowance'][$k];
                            $valid=$model_details[$i]->validate() && $valid;
                            $i++;
                        }
                    }  
            }
           if(empty($model_details)){
              $valid=false; 
           }
            if($valid){
                if (!empty($model_details)) {
                    foreach ($model_details as $eachModel) {
                        $eachModel->save();

                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error1=array();
                if (!empty($model_details)){
                   $error1 = json_decode(CActiveForm::validateTabular($model_details, '', false), true);
                }else{
                    $error1[]='Please enter allownace amount details in atleast one row';
                }
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
    public function actiondeleteincentive() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model =HrSaleTarget::model()->findByPk($id);
            if($model->id){
                HrSaleTargetDetails::model()->deleteAll('target_id=:refer_id', array(':refer_id' => $model->id));
                $model_details_exist= HrSaleTargetDetails::model()->findAll(array('condition' => 'target_id="'. $model->id.'"'));
                if(empty($model_details_exist)){
                    HrSaleTarget::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                }else{
                    $jsonData['status'] = 'error';
                }
            }else{
                $jsonData['status'] = 'error';
            }
        } else {
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}
