<?php

class GeneralhrController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('changedepartment','GetEmployeelist','ChangeNationality','ChangeDesignation','SaveemployeeDepartment','SaveemployeeDesignation','GetNationalityEmployeelist','getEmployeeName','SaveemployeeNationality','ChangeGender','GetgenderEmployeelist','saveemployeegender','ChangeDateofbirth','SaveemployeeDateofbirth','ChangeDateofjoining','SaveemployeeDateofjoin','ChangeBankDetails','GetBankEmployeelist','saveemployeebankdetails','ChangeMaritalStatus','saveemployeemaritalstatus','getemployeeteamlist','changeTeam','saveemployeeteam'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionchangeTeam() {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('change_team');
    }
    public function actionChangeDepartment() {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('department_form');
    }
    public function actionGetEmployeelist() {
        $branch =Yii::app()->request->getparam('branch'); 
        $type =Yii::app()->request->getparam('type'); 
        $department_id =Yii::app()->request->getparam('department_id'); 
        $designation_id =Yii::app()->request->getparam('designation_id'); 
        $condition='branch_or_sponsor_id="'.$branch.'" and isActive!="B"';
        if($type==1 && $department_id>0){
            $condition.=' and department="'.$department_id.'"';
        }else if($type==2 && $designation_id>0){
            $condition.=' and designation="'.$designation_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition,'order'=>'first_name'));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d")]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if($type==1){
            $this->renderPartial('employee_department_list', array('branch' => $branch,'department_id' => $department_id,'arr_employee'=>$arr_employee), false, true);
        }else if($type==2){
            $this->renderPartial('employee_designation_list', array('branch' => $branch,'designation_id' => $designation_id,'arr_employee'=>$arr_employee), false, true);
        }        
    }
    public function actiongetemployeeteamlist() {
        $branch =Yii::app()->request->getparam('branch'); 
        $type =Yii::app()->request->getparam('type'); 
        $team_id =Yii::app()->request->getparam('team_id'); 
        $department_id='';
        $condition='branch_or_sponsor_id="'.$branch.'" and isActive!="B"';
        if($type==1 && $team_id>0){
            $condition.=' and team_id="'.$team_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition,'order'=>'first_name'));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d")]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if($type==1){
            $this->renderPartial('employee_team_list', array('branch' => $branch,'department_id' => $department_id,'arr_employee'=>$arr_employee), false, true);
        }       
    }
    public function actionSaveemployeeDepartment() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0 && $items['effective_date']!=""){
                    $old_department=$items['old_department'];
                    $new_department=$items['department'];
                    if($old_department!=$new_department){
                        $model= Employee::model()->findByPK($items['id']);                                  
                        $model->department = $items['department'];
                        $effective_date=$items['effective_date'];
                        $effective_date = str_replace('/', '-', $effective_date);
                        $effective_date = date("Y-m-d", strtotime($effective_date));                  
                        $model->save();                        
                        $model_department= new EmployeeDepartment(); 
                        $model_department->employee_id =$model->id;
                        $model_department->department_id =$model->department;
                        $model_department->from_date =$effective_date;
                        $model_department->created_by = Yii::app()->user->id;
                        $model_department->created_date_time = date('Y-m-d h:i:s');
                        $model_department->save();
                        $to_date= date('Y-m-d', strtotime('-1 days', strtotime($effective_date)));
                        $model_department_details = EmployeeDepartment::model()->find(array('condition'=>'employee_id="'.$model->id.'" and department_id="'.$old_department.'" and to_date="0000-00-00"'));
                        if(!empty($model_department_details)){
                            EmployeeDepartment::model()->updateByPK($model_department_details->id, array('to_date' =>$to_date,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d h:i:s')));
                        }
                    }
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
    public function actionChangeDesignation() {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('designation_form');
    }
    public function actionSaveemployeeDesignation() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0 && $items['effective_date']!=""){
                    $old_designation=$items['old_designation'];
                    $new_designation=$items['designation'];
                    if($old_designation!=$new_designation){
                        $model= Employee::model()->findByPK($items['id']);                                  
                        $model->designation = $items['designation'];
                        $effective_date=$items['effective_date'];
                        $effective_date = str_replace('/', '-', $effective_date);
                        $effective_date = date("Y-m-d", strtotime($effective_date));                  
                        $model->save();                        
                        $model_designation= new EmployeeDesignation(); 
                        $model_designation->employee_id =$model->id;
                        $model_designation->designation_id =$model->designation;
                        $model_designation->from_date =$effective_date;
                        $model_designation->created_by = Yii::app()->user->id;
                        $model_designation->created_date_time = date('Y-m-d h:i:s');
                        $model_designation->save();
                        $to_date= date('Y-m-d', strtotime('-1 days', strtotime($effective_date)));
                        $model_designation_details = EmployeeDesignation::model()->find(array('condition'=>'employee_id="'.$model->id.'" and designation_id="'.$old_designation.'" and to_date="0000-00-00"'));
                        if(!empty($model_designation_details)){
                            EmployeeDesignation::model()->updateByPK($model_designation_details->id, array('to_date' =>$to_date,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d h:i:s')));
                        }
                    }
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
    
    public function actionSaveBranch1() {  
        $model_employee = Employee::model()->findAll(array('condition' => 'isActive!="B"','order'=>'first_name'));
            foreach ($model_employee as $i => $items) {  
                        $model_department= new EmployeeDepartment();
                        $model_department->employee_id =$items->id;
                        $model_department->department_id =$items->department;
                        $model_department->from_date =$items->date_join;
                        $model_department->save();
                        $model_designation= new EmployeeDesignation();
                        $model_designation->employee_id =$items->id;
                        $model_designation->designation_id =$items->designation;
                        $model_designation->from_date =$items->date_join;
                        $model_designation->save();
                        
                 
            }                         
    }

    // code added by nisha on 22-05-2023
    public function actionChangeNationality() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_nationality');
    }
    public function actionChangeGender() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_gender');
    }
    public function actionChangeDateofbirth() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_dateofbirth');
    }
    public function actionChangeDateofjoining() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_dateofjoining');
    }
    public function actionChangeMaritalStatus() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_marital_status');
    }

    public function actionChangeBankDetails() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_bankdetails');
    }
    public function actionGetBankEmployeelist() {
        $branch =Yii::app()->request->getparam('branch'); 
        $type =Yii::app()->request->getparam('type'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $condition='branch_or_sponsor_id="'.$branch.'" and isActive!="B"';
        if($employee_id>0){
            $condition.=' and id="'.$employee_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition,'order'=>'first_name'));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d")]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if($type==1){
            $this->renderPartial('employee_bankdetails_list', array('branch' => $branch,'employee_id' => $employee_id,'arr_employee'=>$arr_employee), false, true);
         }
    }

    public function actionGetNationalityEmployeelist() {
        $branch =Yii::app()->request->getparam('branch'); 
        $type =Yii::app()->request->getparam('type'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $condition='branch_or_sponsor_id="'.$branch.'" and isActive!="B"';
        if($employee_id>0){
            $condition.=' and id="'.$employee_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition,'order'=>'first_name'));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d")]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if($type==1){
            $this->renderPartial('employee_nationality_list', array('branch' => $branch,'employee_id' => $employee_id,'arr_employee'=>$arr_employee), false, true);
         }else if($type==2){
            $this->renderPartial('employee_gender_list', array('branch' => $branch,'employee_id' => $employee_id,'arr_employee'=>$arr_employee), false, true);
         } else if($type==3){
            $this->renderPartial('employee_dob_list', array('branch' => $branch,'employee_id' => $employee_id,'arr_employee'=>$arr_employee), false, true);
         } else if($type==4){
            $this->renderPartial('employee_doj_list', array('branch' => $branch,'employee_id' => $employee_id,'arr_employee'=>$arr_employee), false, true);
         } else if($type==5){
            $this->renderPartial('employee_maritalstatus_list', array('branch' => $branch,'employee_id' => $employee_id,'arr_employee'=>$arr_employee), false, true);
         }             
    }

    public function actiongetEmployeeName() {
        $id = $_POST['id'];
        if ($id > 0) {
            $jsonData['emp_name'] = CHtml::dropdownlist("employee_id", '', Employee::getEmployee($id), array('empty' => 'Select', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveemployeeNationality() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    $old_nationality=$items['old_nationality'];
                    $new_nationality=$items['nationality'];
                    if($old_nationality!=$new_nationality){
                        $model_emp= Employee::model()->findByPK($items['id']);
                        $model_emp->nationality = $items['nationality'];
                        $model_emp->save(false);  
                    }
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
    public function actionsaveemployeegender() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    $old_gender=$items['old_gender'];
                    $new_gender=$items['gender'];
                    if($old_gender!=$new_gender){
                        $model_emp= Employee::model()->findByPK($items['id']);
                        $model_emp->gender = $items['gender'];
                        $model_emp->save(false);  
                    }
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
      public function actionsaveemployeemaritalstatus() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    $old_marital_status=$items['old_marital_status'];
                    $new_marital_status=$items['marital_status'];
                    if($old_marital_status!=$new_marital_status){
                        $model_emp= Employee::model()->findByPK($items['id']);
                        $model_emp->marital_status = $items['marital_status'];
                        $model_emp->save(false);  
                    }
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
   public function actionSaveemployeeDateofbirth() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    $model_emp= Employee::model()->findByPK($items['id']);
                    $date_of_birth=$items['date_of_birth'];
                    if($date_of_birth!='' && $date_of_birth!='0000-00-00'){
                        $date_of_birth = str_replace('/', '-', $date_of_birth);
                        $date_of_birth = date("Y-m-d", strtotime($date_of_birth));
                        $model_emp->date_of_birth = $date_of_birth;
                        $model_emp->save(false);  
                    }
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }

      public function actionSaveemployeeDateofjoin() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    $model_emp= Employee::model()->findByPK($items['id']);
                    $date_join=$items['date_join'];
                    if($date_join!='' && $date_join!='0000-00-00'){
                        $date_join = str_replace('/', '-', $date_join);
                        $date_join = date("Y-m-d", strtotime($date_join));
                        $model_emp->date_join = $date_join;
                        $model_emp->save(false);  
                    }
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
     public function actionsaveemployeebankdetails() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0){
                    $model_emp= Employee::model()->findByPK($items['id']);
                    $model_emp->employee_bankname=$items['employee_bankname'];
                    $model_emp->employee_accountno=$items['employee_accountno'];
                    $model_emp->employee_wpscode=$items['employee_wpscode'];
                    $model_emp->personal_file_no=$items['personal_file_no'];
                    $model_emp->employee_iban_no=$items['employee_iban_no'];
                    $model_emp->save(false);  
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }

    public function actionSaveemployeeTeam() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $i => $items) {  
                if($items['id']>0 && $items['effective_date']!=""){
                    $old_team=$items['old_team'];
                    $new_team=$items['team_id'];
                    if($old_team!=$new_team){
                        $model= Employee::model()->findByPK($items['id']);                                
                        $model->team_id = $items['team_id'];
                        $effective_date=$items['effective_date'];
                        $effective_date = str_replace('/', '-', $effective_date);
                        $effective_date = date("Y-m-d", strtotime($effective_date));                  
                        $model->save();                        
                        $model_team= new HrEmployeeTeam(); 
                        $model_team->employee_id =$model->id;
                        $model_team->team_id =$model->team_id;
                        $model_team->from_date =$effective_date;
                        $model_team->created_by = Yii::app()->user->id;
                        $model_team->created_date_time = date('Y-m-d h:i:s');
                        $model_team->save(false);
                        $to_date= date('Y-m-d', strtotime('-1 days', strtotime($effective_date)));
                        $model_team_details = HrEmployeeTeam::model()->find(array('condition'=>'employee_id="'.$model->id.'" and team_id="'.$old_team.'" and to_date="0000-00-00"'));
                        if(!empty($model_team_details)){
                            HrEmployeeTeam::model()->updateByPK($model_team_details->id, array('to_date' =>$to_date,'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d h:i:s')));
                        }
                    }
                }      
            }           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }  
    }
    
}
