<?php

class ExcelController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'PrintEmployeeAttendanceExcel','printWorkingHoursdailyExcel', 'printWorkingHoursweeklyExcel','printWorkingHoursMonthlyExcel', 'PrintLeavelistExcel', 'PrintLeavehistoryExcel',
                    'PrintEmployeeListExcel', 'PrintEmployeeblockListExcel','PrintEmployeedepartmentListExcel', 'PrintEmployeedocumentListExcel','PrintEmployeesalaryExcel', 'PrintEmployeedesignationListExcel','PrintEmployeeExpiredDocumentExcel', 
                    'PrintEmployeeAssetlistExcel','PrintEmployeeLoanExcel', 'PrintEmployeeTicketExcel', 'PrintEmployeeGratuityExcel','PrintEmployeeLeaveSettlementExcel','PrintEmployeeNewHirelistExcel', 'PrintEmployeeEOSExcel', 
                    'PrintBranchListExcel', 'PrintInOutExcel','PrintSalaryBeforeLockExcel', 'PrintPrintSalarySlipExcel', 'PrintSalarySlipExcel','PrintIncrementSalaryExcel', 'PrintOvertimelistExcel','PrintSalaryBeforeExcel', 
                    'PrintEmployeeYearlyAttendanceExcel','PrintMonthlyAttendanceReport', 'PrintLeaveLedgerExcel', 'Printexcelbranchdetail', 'excelleaveyeardetails', 'excelLeaveBalance','PrintAdvanceExcel', 'PrintOrderAnnexureReportExcel', 
                    'PrintNomineeExcel', 'PrintPurchaseExcel', 'PrintTrainingExcel', 'ExcelAnnualList','PrintTrainingPlan', 'PrintExpenseExcel', 'MastersalaryExcel', 'PrintEmployeeAppraisalList', 'PrintEmployeeEosList', 'PrintEmployeeRecruitmentList','PrintNotPunchExcel',
                    'PrintEmployeeIndividualAppraisalList', 'grosssalaryexcel', 'PrintEmployeeQualificationReportExcel', 'PrintLeaveEncashmentExcel','PrintEmployeeHierarchyListExcel','PrintEmployeeSettingsListExcel','PrintEmployeeTeamListExcel','excelticketyeardetails','PrintEosClearancetExcel','EmployeeLeaveBalanceExcel',
                    'PrintEmployeeBankdetailsExcel','PrintEmployeePunchHistoryExcel','MasterMonthlySalaryExcel','PrintEmployeedepartmentChangeListExcel','PrintEmployeedesignationChangeListExcel','PrintSalaryNonzero','PrintSalaryNonzerobefore','PrintSalaryAdvanceExcel','PrintExcuseExcel','EmployeeWeekendExcel','PrintDepartmentHierarchyListExcel','PrintEmployeelevelListExcel'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionPrintEmployeeAttendanceExcel() {
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $emp_id = $_GET['emp_id'];
        $attend_emp_sponsor = $_GET['attend_emp_sponsor'];
        $department_id = $_GET['department_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_attendence.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeattendence_excel', array('department_id' => $department_id, 'from_date' => $from_date, 'to_date' => $to_date, 'emp_id' => $emp_id, 'attend_emp_sponsor' => $attend_emp_sponsor), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeYearlyAttendanceExcel() {
        $leavetype = $_GET['leavetype'];
        $year = $_GET['year'];
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_attendence.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_leave_yearly_excel', array('leavetype' => $leavetype, 'year' => $year, 'employee_id' => $employee_id, 'branch_id' => $branch_id), false, true);
        Yii::app()->end();
    }

    public function actionprintWorkingHoursdailyExcel() {
        $branch_id = $_GET['branch_id'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $employee_id = $_GET['employee_id'];
        $working_report_type = $_GET['working_report_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_workingHours.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeworkinhHoursdaily_excel', array('year' => $year, 'branch_id' => $branch_id, 'month' => $month, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), false, true);
        Yii::app()->end();
    }

    public function actionprintWorkingHoursweeklyExcel() {
        $branch_id = $_GET['branch_id'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $employee_id = $_GET['employee_id'];
        $working_report_type = $_GET['working_report_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_workingHours.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeworkinhHoursweekly_excel', array('year' => $year, 'branch_id' => $branch_id, 'month' => $month, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), false, true);
        Yii::app()->end();
    }

    public function actionprintWorkingHoursMonthlyExcel() {
        $branch_id = $_GET['branch_id'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $employee_id = $_GET['employee_id'];
        $working_report_type = $_GET['working_report_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'list_employee_workingHours.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeworkingHoursmonthly_excel', array('year' => $year, 'branch_id' => $branch_id, 'month' => $month, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), false, true);
        Yii::app()->end();
    }

    public function actionPrintLeavelistExcel() {
        $branch_id = $_GET['branch_id'];
        $leave_name = $_GET['leave_name'];
        $employee_id = $_GET['employee_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_leavelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeleavelist_excel', array('branch_id' => $branch_id, 'leave_name' => $leave_name, 'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
        Yii::app()->end();
    }

    public function actionPrintLeavehistoryExcel() {
        $leave_id = $_GET['leave_id'];
        $employee_id = $_GET['employee_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_leavehistory.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeleavehistory_excel', array('leave_id' => $leave_id, 'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $department_id = $_GET['department_id'];
        $designation_id = $_GET['designation_id'];
        $reportmanager_id = $_GET['reportmanager_id'];
        $category_id = $_GET['category_id'];
        $status = $_GET['status'];
        $team_id = $_GET['team_id'];
        
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employeelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeelist_excel', array('Branch' => $Branch, 'category_id' => $category_id, 'employee_id' => $employee_id, 'department_id' => $department_id, 'designation_id' => $designation_id, 'reportmanager_id' => $reportmanager_id, 'status' => $status,'team_id' =>$team_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeblockListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $department = $_GET['department'];
        $date_from = Yii::app()->request->getParam('date_from');
        $date_to = Yii::app()->request->getParam('date_to');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employeeblocklist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeblocklist_excel', array('Branch' => $Branch,'department'=>$department, 'employee_id' => $employee_id, 'date_from' => $date_from, 'date_to' => $date_to), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeedepartmentListExcel() {
        $branch_id =(int) $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $department_name = $_GET['department_name'];
        $reportman_id = $_GET['reportman_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_department_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeedepartmentlist_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'department_name' => $department_name, 'reportman_id' => $reportman_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeedocumentListExcel() {
        $employee_id = $_GET['employee_id'];
        $document_id = $_GET['document_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_docuemnt_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeedocumentlist_excel', array('document_id' => $document_id, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeedesignationListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $designation_name = $_GET['designation_name'];
        $report_id = $_GET['report_id'];
        // echo "ok".$report_id;
        // die();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_designation_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeedesignationlist_excel', array('Branch' => $Branch, 'employee_id' => $employee_id, 'designation_name' => $designation_name, 'report_id' => $report_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeExpiredDocumentExcel() {
        $document_id = $_GET['document_id'];
        $employee_id = $_GET['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_documnt_Expired.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeExpireddocument_excel', array('document_id' => $document_id, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeAssetlistExcel() {
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $status = $_GET['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_assetlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeAssetlist_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'status' => $status), false, true);
        Yii::app()->end();
    }

    /* public function actionPrintEmployeesalaryExcel() {
      $branch_id = $_GET['branch_id'];
      $employee_id = $_GET['employee_id'];
      Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
      $filename = 'employee_salary.xls';
      header("Content-type: application/vnd.ms-excel");
      header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
      $this->renderPartial('print_employeeSalarylist_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id), false, true);
      Yii::app()->end();
      } */

    public function actionPrintEmployeesalaryExcel1() {
        $sponser_id = $_GET['sponser_id'];
        $year = $_GET['year'];
        $month = $_GET['month'];
        $category = $_GET['category'];
        $con = 'MONTH(payroll_enddate) = "' . $month . '" and YEAR(payroll_enddate) = "' . $year . '" and payroll_status = 1';
        if ($sponser_id != '') {
            $con .= ' AND payroll_branch_or_sponsor_id= "' . $sponser_id . '"';
        }
        $process = SalaryProcessing::model()->find(array('condition' => $con));
        if (!empty($process)) {
            $condition = '1=1 and salary_processing_id = "' . $process->id . '"';
            if ($sponser_id != '') {
                $condition .= ' and employeedetail.branch_or_sponsor_id="' . $sponser_id . '"';
            }
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
                $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
            }
            if ($category != '') {
                $condition .= ' AND employeedetail.employee_category= "' . $category . '"';
            }
            $modelSalarySlip = SalarySlip::model()->with('employeedetail')->findAll(array('condition' => $condition));
        }
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);

        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Branch')
                ->setCellValue('C1', 'Employee Code');

        //sTYLE
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN
                )
            )
        );
        //Salary Head
        $head_row = 1;
        $head_col = 4;
        $model_salary_type = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_occurence="2" and salary_type="1" '));
        if (!empty($model_salary_type)) {
            foreach ($model_salary_type as $model_add) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $model_add->salary_name);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $head_col++;
            }
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Total Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(20);
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($head_col);
        $objPHPExcel->getActiveSheet()->getStyle('A1:' . $adjustedColumn . '1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('A1:' . $adjustedColumn . '1')->getFont()->setSize(12)->setBold(true);
        $objPHPExcel->getActiveSheet()
                ->getStyle('A1:' . $adjustedColumn . '1')
                ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D3D3D3')
                            )
                        )
        );
        $j = 1;
        $rowCount = 2;
        $start = $rowCount;
        foreach ($arr_employee as $emp_val) {
            $empdetail = Employee::model()->findbyPK($emp_val);
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $j);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('B' . $rowCount, $empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C' . $rowCount, $empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('D' . $rowCount, $empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $total_salary = 0.00;
            $col_index = 4;
            $row_alphabet_3 = $this->cellsToMergeByColsRow($col_index);
            foreach ($model_master_salary as $key_3 => $salary_id) {
                $model_salary_details = EmployeeSalary::model()->find(array('condition' => 'salary_type="' . $salary_id->salary_type . '" and employee_id="' . $empdetail->id . '" and valid_to="0000-00-00"'));
                $salary_amount = '0.00';
                if ($model_salary_details->id > 0) {
                    $salary_amount = $model_salary_details->amount;
                    $total_salary += $salary_amount;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_amount, " "));
                $col_index++;
            }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($total_salary, " "));
            $row_alphabet_4 = $this->cellsToMergeByColsRow($col_index);
            $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_3 . '' . $rowCount . ':' . $row_alphabet_4 . '' . $rowCount . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_4 . '' . $rowCount . ':' . $row_alphabet_4 . '' . $rowCount . '')->getFont()->setSize(12)->setBold(true);
            $rowCount++;
            $j++;
        }
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Salary Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Salary Details.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }

    public function actionPrintEmployeesalaryExcel() {
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $condition = 't.isActive="Y"';
        if ($employee_id != '') {
            $condition .= ' AND id = "' . $employee_id . '"';
        }

        if ($branch_id != '') {
            $condition .= ' AND branch_or_sponsor_id = "' . $branch_id . '"';
        } else {
           if($model_usergroup_master->salary_tab_permission!=''){
                // if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                     $condition.= ' and branch_or_sponsor_id IN ('.$model_usergroup_master->salary_tab_permission.')';
            }
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
        }
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeefullname . ' ' . $value->employeecode] = $value['id'];
        }
        ksort($arr_employee);
        //Salary Master
        
        $model_user = User::model()->findByPk(Yii::app()->user->id);
    $model_master_salary = $model_usergroup_sal=array();
    $model_usergroup_master = MasUserGroup::model()->findbyPK($model_user->user_group_id);
    $cond_br_sal=$cond_br_doc=$cond_br_leave='';
        if($branch_id!='' && $branch_id!="null" ){
            $cond_br_sal='id="'.$model_user->user_group_id.'" and  salary_tab_permission IN(' . $branch_id . ')';
        }else if(!empty($model_usergroup_master)){
            if($model_usergroup_master->salary_tab_permission!=''){
                $cond_br_sal='id="'.$model_user->user_group_id.'" and salary_tab_permission IN ('.$model_usergroup_master->salary_tab_permission.')';
            }else{
                $cond_br_sal='id="'.$model_user->user_group_id.'" and salary_tab_permission IN(' . $model_usergroup_master->salary_tab_permission . ')';
            }
        }
        if($model_usergroup_master->salary_tab_permission!=''){
            $model_usergroup_sal = MasUserGroup::model()->find(array('condition' =>$cond_br_sal ));
        }
        if (!empty($model_usergroup_sal) && $model_usergroup_sal->id>0 || Yii::app()->user->authorised_user == 1) {
            $model_master_salary = EmployeeSalary::model()->with('salary')->findAll(array('group'=>'t.salary_type','order' => 'salary.salary_name ASC'));
        }
  
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(50);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Branch')
                ->setCellValue('C1', 'Employee Code')
                ->setCellValue('D1', 'Employee Name');
        //sTYLE
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN
                )
            )
        );
        //Salary Head
        $head_row = 1;
        $head_col = 4;
        if (!empty($model_master_salary)) {
            foreach ($model_master_salary as $key => $salary_id) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $salary_id->salary->salary_name);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $head_col++;
            }
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Total Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(20);
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($head_col);
        $objPHPExcel->getActiveSheet()->getStyle('A1:' . $adjustedColumn . '1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('A1:' . $adjustedColumn . '1')->getFont()->setSize(12)->setBold(true);
        $objPHPExcel->getActiveSheet()
                ->getStyle('A1:' . $adjustedColumn . '1')
                ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D3D3D3')
                            )
                        )
        );
         $objPHPExcel->getActiveSheet()
            ->getStyle('D:' . $adjustedColumn . '')
            ->getNumberFormat()
            ->setFormatCode('#,##0.00');
        $j = 1;
        $rowCount = 2;
        $start = $rowCount;
        foreach ($arr_employee as $emp_val) {
            $empdetail = Employee::model()->findbyPK($emp_val);
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $j);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('B' . $rowCount, $empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C' . $rowCount, $empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('D' . $rowCount, $empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $total_salary = 0.00;
            $col_index = 4;
            $row_alphabet_3 = $this->cellsToMergeByColsRow($col_index);
            foreach ($model_master_salary as $key_3 => $salary_id) {
                $model_salary_details = EmployeeSalary::model()->find(array('condition' => 'salary_type="' . $salary_id->salary_type . '" and employee_id="' . $empdetail->id . '" and valid_to="0000-00-00"'));
                $salary_amount = '0.00';
                if (!empty($model_salary_details) && $model_salary_details->id > 0) {
                    $salary_amount = $model_salary_details->amount;
                    $total_salary += $salary_amount;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_amount);
                $col_index++;
            }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $total_salary);
            $row_alphabet_4 = $this->cellsToMergeByColsRow($col_index);
            $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_3 . '' . $rowCount . ':' . $row_alphabet_4 . '' . $rowCount . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_4 . '' . $rowCount . ':' . $row_alphabet_4 . '' . $rowCount . '')->getFont()->setSize(12)->setBold(true);
            $rowCount++;
            $j++;
        }
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Salary Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Salary Details.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }

    function cellsToMergeByColsRow($head_col) {
        $head_col++;
        $adjustment = +($head_col - 24);
        $currentColumn = 'X';
        $columnIndex = PHPExcel_Cell::columnIndexFromString($currentColumn);
        $adjustedColumnIndex = $columnIndex + $adjustment;
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($adjustedColumnIndex - 1);
        return $adjustedColumn;
    }

    public function actionPrintEmployeeLoanExcel() {
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $status = $_GET['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_loan.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeloan_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'status' => $status), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeTicketExcel() {
        $employee_id = $_GET['employee_id'];
        $year = $_GET['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_ticket.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeticket_excel', array('employee_id' => $employee_id, 'year' => $year), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeGratuityExcel() {

        $employee_id = $_GET['employee_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_gratuity.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeegratuity_excel', array('employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeLeaveSettlementExcel() {
        $employee_id = $_GET['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_leavesettlement.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeleave_settlement_excel', array('employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintSalaryBeforeExcel() {
        //code added by rahul on 25-7-2022//
        $sponser_id = $_GET['sponser_id'];
        $year = $_GET['year'];
        $month = $_GET['month'];
        // $category = $_GET['category'];
        $con = 'MONTH(payroll_enddate) = "' . $month . '" and YEAR(payroll_enddate) = "' . $year . '" and payroll_status = 1';
        if ($sponser_id != '') {
            $con .= ' AND payroll_branch_or_sponsor_id= "' . $sponser_id . '"';
        }
        $process = SalaryProcessing::model()->find(array('condition' => $con));
        if (!empty($process)) {
            $condition = '1=1 and salary_processing_id = "' . $process->id . '"';
            if ($sponser_id != '') {
                $condition .= ' and employeedetail.branch_or_sponsor_id="' . $sponser_id . '"';
            }
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
                $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
            }
            // if ($category != '') {
            //     $condition .= ' AND employeedetail.employee_category= "' . $category . '"';
            // }
            $modelSalarySlip = SalarySlip::model()->with('employeedetail')->findAll(array('condition' => $condition));
        }
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'ID')
                ->setCellValue('C1', 'Employee Name');
        //Salary Head
        $head_row = 1;
        $head_col = 3;
        $model_salary_type = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_occurence="2" and salary_type="1" '));
        if (!empty($model_salary_type)) {
            foreach ($model_salary_type as $key => $model_add) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $model_add->salary_name);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $head_col++;
            }
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Monthly Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $model_salary_type_1 = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_occurence="1" and salary_type="1"'));
        foreach ($model_salary_type_1 as $key_2 => $model_add) {
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $model_add->salary_name);
            $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
            $head_col++;
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Overtime');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'AL Addition');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        /*$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Holiday Allowance');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Night Shift Allowance');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Incentive');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;*/
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Other Addition');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Gross Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $model_salary_type_2 = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and  salary_type="2"'));
        foreach ($model_salary_type_2 as $model_add) {
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $model_add->salary_name);
            $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
            $head_col++;
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Salary Advance');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Loan Amount');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Leave Amount');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'AL Deduction');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Pre Join Deduction');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Other Deduction');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Total Deduction');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Net Amount');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        /*$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Threshold Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'SIF Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(20);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Balance Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;*/
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Salary By');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($head_col);
        $head_col++;
        $objPHPExcel->getActiveSheet()->getStyle('A1:' . $adjustedColumn . '1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('A1:' . $adjustedColumn . '1')->getFont()->setSize(12)->setBold(true);
        //sTYLE
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN
                )
            )
        );
        $objPHPExcel->getActiveSheet()
                ->getStyle('A1:' . $adjustedColumn . '1')
                ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D3D3D3')
                            )
                        )
        );
        $objPHPExcel->getActiveSheet()
            ->getStyle('D:' . $adjustedColumn . '')
            ->getNumberFormat()
            ->setFormatCode('#,##0.00');
        $j = 1;
        $rowCount = 2;
        $start = $rowCount;$end=0;
        $incentive_amount = 0.00;
        $night_shift_amount = 0.00;
        $holiday_amount = 0.00;
        $salary_advance_amount = 0.00;
        $annual_leave_addition = 0.00;
        $annual_leave_deduction = 0.00;
        $before_joining_salary = 0.00;
        $loan_amount = 0.00;
        $leave_amount = 0.00;
        $other_addition = 0.00;
        $total_addition_amount = 0.00;
        $other_deduction = 0.00;
        $total_deduction_amount = 0.00;
        $total_salary_amount = 0.00;
        $overtime_amount = 0.00;
        $total_gross_salary = 0.00;
        $total_net_salary = 0.00;
        $total_sif_salary = 0.00;
        $total_unsif_salary = 0.00;
        $f=1;
        $paymode=array('0'=>'All','1'=>'Cash','2'=>'Cheque','3'=>'WPS','4'=>'Exchange','5'=>'Bank');
        $start_date = $year . '-' . $month . '-01';
        $end_date=date("Y-m-t", strtotime($start_date));
        if (!empty($modelSalarySlip)) {
            foreach ($modelSalarySlip as $j => $salary_detail) {
                $gross_salary = 0.00;
                $net_salary = 0.00;
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $f);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('B' . $rowCount, $salary_detail->employeedetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('C' . $rowCount, $salary_detail->employeedetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                $col_index = 3;
                $row_alphabet_3 = $this->cellsToMergeByColsRow($col_index);
                foreach ($model_salary_type as $key_1 => $value) {
                    $model_salaryslip_details = SalarySlipDetails::model()->find(array('condition' => 'salary_slip_id="' . $salary_detail->id . '" and salary_id="' . $value->id . '"'));
                    $salary_type_amount = 0.00;
                    if (!empty($model_salaryslip_details) && $model_salaryslip_details->salary_amount > 0) {
                        $salary_type_amount = $model_salaryslip_details->salary_amount;
                        $gross_salary += $salary_type_amount;
                        $net_salary += $salary_type_amount;
                        $total_net_salary += $salary_type_amount;
                        $total_gross_salary += $salary_type_amount;
                    }
                    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_type_amount);
                    $col_index++;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $gross_salary);
                $row_alphabet_4 = $this->cellsToMergeByColsRow($col_index);
                $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_4 . '' . $rowCount . ':' . $row_alphabet_4 . '' . $rowCount . '')->getFont()->setSize(11)->setBold(true);
                $col_index++;
                foreach ($model_salary_type_1 as $key_2 => $value) {
                    $model_salaryslip_details = SalarySlipDetails::model()->find(array('condition' => 'salary_slip_id="' . $salary_detail->id . '" and salary_id="' . $value->id . '"'));
                    $salary_type_amount = 0.00;
                    if (!empty($model_salaryslip_details) && $model_salaryslip_details->salary_amount > 0) {
                        $salary_type_amount = $model_salaryslip_details->salary_amount;
                        $net_salary += $salary_type_amount;
                        $total_net_salary += $salary_type_amount;
                    }
                    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_type_amount);
                    $col_index++;
                }
                $overtime_amount+=$salary_detail->overtime_amount;
                $net_salary+=$salary_detail->overtime_amount;
                $total_net_salary+=$salary_detail->overtime_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->overtime_amount);
                $col_index++;
                $annual_leave_addition+=$salary_detail->annual_leave_addition;
                $net_salary+=$salary_detail->annual_leave_addition;
                $total_net_salary+=$salary_detail->annual_leave_addition;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->annual_leave_addition);
                $col_index++;
                /*$holiday_amount+=$salary_detail->public_holiday_allowance;
                $net_salary+=$salary_detail->public_holiday_allowance;
                $total_net_salary+=$salary_detail->public_holiday_allowance;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->public_holiday_allowance, ""));
                $col_index++;
                $night_shift_amount+=$salary_detail->night_shift_allowance;
                $net_salary+=$salary_detail->night_shift_allowance;
                $total_net_salary+=$salary_detail->night_shift_allowance;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->night_shift_allowance, ""));
                $col_index++;
                $incentive_amount+=$salary_detail->incentive;
                $net_salary+=$salary_detail->incentive;
                $total_net_salary+=$salary_detail->incentive;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->incentive, ""));
                $col_index++;*/
                $other_addition+=$salary_detail->other_addition;
                $net_salary+=$salary_detail->other_addition;
                $total_net_salary+=$salary_detail->other_addition;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$salary_detail->other_addition);
                $col_index++;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$net_salary);
                $row_alphabet_7 = $this->cellsToMergeByColsRow($col_index);
                $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_7 . '' . $rowCount . ':' . $row_alphabet_7 . '' . $rowCount . '')->getFont()->setSize(11)->setBold(true);
                $col_index++;
                $deduction_amt=$deduction_amt_1=0.00;
                foreach ($model_salary_type_2 as $key_1 => $value) {
                    $model_salaryslip_details = SalarySlipDetails::model()->find(array('condition' => 'salary_slip_id="' . $salary_detail->id . '" and salary_id="' . $value->id . '"'));
                    $salary_type_amount = 0.00;
                    if ($model_salaryslip_details->salary_amount > 0) {
                        $salary_type_amount = $model_salaryslip_details->salary_amount;
                        $deduction_amt+=$model_salaryslip_details->salary_amount;
                    }
                    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_type_amount);
                    $col_index++;
                }
                $salary_advance_amount+=$salary_detail->salary_advance_amount;
                $deduction_amt_1+=$salary_detail->salary_advance_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->salary_advance_amount);
                $col_index++;
                $loan_amount+=$salary_detail->loan_amount;
                $deduction_amt_1+=$salary_detail->loan_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->loan_amount);
                $col_index++;
                $leave_amount+=$salary_detail->leave_amount;
                 $deduction_amt_1+=$salary_detail->leave_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->leave_amount);
                $col_index++;
                $annual_leave_deduction+=$salary_detail->annual_leave_deduction;
                $deduction_amt_1+=$salary_detail->annual_leave_deduction;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->annual_leave_deduction);
                $col_index++;
                $before_joining_salary+=$salary_detail->before_joining_salary;
                 $deduction_amt_1+=$salary_detail->before_joining_salary;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->before_joining_salary);
                $col_index++;
                $other_deduction+=$salary_detail->other_deduction;
                $deduction_amt_1+=$salary_detail->other_deduction;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->other_deduction);
                $col_index++;
                 $total_deduction_amount+=($deduction_amt+$deduction_amt_1);
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $deduction_amt+$deduction_amt_1);
                $col_index++;
                $row_alphabet_5 = $this->cellsToMergeByColsRow($col_index);
                $total_salary_amount+=$salary_detail->total_salary_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->total_salary_amount);
                $col_index++;
                $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_5 . '' . $rowCount . ':' . $row_alphabet_5 . '' . $rowCount . '')->getFont()->setSize(11)->setBold(true);
                /*$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->threshold_salary, ""));
                $col_index++;
                $total_sif_salary+=$salary_detail->sif_transfer_salary;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->sif_transfer_salary, ""));
                $col_index++;
                $total_unsif_salary+=$salary_detail->sif_untransfer_salary;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->sif_untransfer_salary, ""));
                $col_index++;*/
                $row_alphabet_6 = $this->cellsToMergeByColsRow($col_index);
                $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_3 . '' . $rowCount . ':' . $row_alphabet_6 . '' . $rowCount . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
                $MonthlySalarySif = MonthlySalarySifDetails::model()->find(array('condition'=> 'start_date >= "' . $start_date . '" AND end_date<="'.$end_date.'" AND employee_id="'.$salary_detail->employee_id.'"'));
                    $mode_payment ='';
                    if(!empty($MonthlySalarySif)){
                      $mode_payment=  $paymode[$MonthlySalarySif->salarysif->salary_payment_mode];
                    }else{
                      $mode_payment=  $paymode[$salary_detail->employeedetail->payment_type];
                    }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $mode_payment);
                $end=$rowCount;
                $rowCount++;
                $f++;
            }
        }
        $footer_row = $end + 1;
        // $head_row = 1;
        $footer_col = 3;
        $objPHPExcel->getActiveSheet()->SetCellValue('C' . $footer_row, 'Total');

        $objPHPExcel->getActiveSheet()->getStyle('C' . $footer_row . ':C' . $footer_row . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        if(!empty($process)){
        $con_total = 't.salary_processing_id="' . $process->id . '"';
        
   
      /*  if ($category != '') {
            $con_total.=' and employeedetail.employee_category= "' . $category . '"';
        } */
        foreach ($model_salary_type as $key_1 => $value) {
            $con_total_1 = $con_total . ' AND salary_id="' . $value->id . '"';
            $model_salarytotal_details = SalarySlipDetails::model()->with('salaryslip.employeedetail')->find(array('select' => 'sum(salary_amount) as salary_amount', 'condition' => $con_total_1));
            $salary_amount_var = 0.00;
            if(!empty($model_salarytotal_details)){
               $salary_amount_var = $model_salarytotal_details->salary_amount;
             }

            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $salary_amount_var);
                 

            $footer_col++;
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $total_gross_salary);

        $footer_col++;
        foreach ($model_salary_type_1 as $key_1 => $value) {
            $con_total_2 = $con_total . ' AND salary_id="' . $value->id . '"';
            $salary_amount_1= 0.00;
            $model_salarytotal_details = SalarySlipDetails::model()->with('salaryslip.employeedetail')->find(array('select' => 'sum(salary_amount) as salary_amount', 'condition' => $con_total_2));
            if(!empty($model_salarytotal_details)){
                $salary_amount_1 =$model_salarytotal_details->salary_amount;
            }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $salary_amount_1);

            $footer_col++;
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $overtime_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $annual_leave_addition);
        $footer_col++;
        /*$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($holiday_amount, ""));
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($night_shift_amount, ""));
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($incentive_amount, ""));
        $footer_col++;*/
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $other_addition);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $total_net_salary);
        $footer_col++;
        foreach ($model_salary_type_2 as $key_1 => $value) {
            $con_total_3 = $con_total . ' AND salary_id="' . $value->id . '"';
            $model_salarytotal_details = SalarySlipDetails::model()->with('salaryslip.employeedetail')->find(array('select' => 'sum(salary_amount) as salary_amount', 'condition' => $con_total_3));
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($model_salarytotal_details->salary_amount, ""));
            $footer_col++;
        }}
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $salary_advance_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $loan_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $leave_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $annual_leave_deduction);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $before_joining_salary);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $other_deduction);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row,$total_deduction_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $total_salary_amount);
        $footer_col++;
        /*$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, '');
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($total_sif_salary, ""));
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($total_unsif_salary, ""));*/
        $row_al_5 = $this->cellsToMergeByColsRow($footer_col);
        $objPHPExcel->getActiveSheet()->getStyle('C'.$footer_row.':'.$row_al_5.''.$footer_row.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('C'.$footer_row.':'.$row_al_5.''.$footer_row.'')->getFont()->setSize(12)->setBold(true); 
        $objPHPExcel->getActiveSheet()
                ->getStyle('A'.$footer_row.':'.$row_al_5.''.$footer_row.'')
                ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D3D3D3')
                            )
                        )
        );
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Salary Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Salary Details.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }

    public function actionPrintSalaryBeforeExcel12() {
        $sponser_id = $_GET['sponser_id'];
        $year = $_GET['year'];
        $month = $_GET['month'];
        $category = $_GET['category'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salarydetails.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('Print_salary_before_excel', array('sponser_id' => $sponser_id, 'year' => $year, 'month' => $month, 'category' => $category), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeNewHirelistExcel() {
        $branch_id = $_GET['branch_id'];
        $from_date = $_GET['from_date'];
        $department = $_GET['department'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_NewHirelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeNewHirelist_excel', array('branch_id' => $branch_id, 'department' => $department, 'from_date' => $from_date), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeEOSExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $department_name = $_GET['department_name'];
        $designation_name = $_GET['designation_name'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_EOSlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeEOS_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id, 'department_name' => $department_name, 'designation_name' => $designation_name, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
        Yii::app()->end();
    }

    public function actionPrintSalaryBeforeLockExcel() {
        $branch = $_GET['branch'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_before.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salaryBeforelock_excel', array('branch' => $branch, 'month' => $month, 'year' => $year), false, true);
        Yii::app()->end();
    }

    public function actionPrintSalarySlipExcel12() {
        $branch = $_GET['branch'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $category = $_GET['category'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_slip.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salaryslip_excel', array('branch' => $branch, 'month' => $month, 'year' => $year, 'category' => $category), false, true);
        Yii::app()->end();
    }
     public function actionPrintSalarySlipExcel() {
        //code added by rahul on 25-7-2022//
        $branch = $_GET['branch'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $category = $_GET['category'];
        $con='MONTH(payroll_enddate) = "' . $month . '" and YEAR(payroll_enddate) = "' . $year . '" and payroll_status = 2';
            if($branch!=''){
                $con.=' AND payroll_branch_or_sponsor_id= "'.$branch.'"';
            }
            $process = SalaryProcessing::model()->find(array('condition' =>$con));
            if (!empty($process)) {
                $condition = '1=1 and salary_processing_id = "' . $process->id . '"';
                if ($branch != '') {
                    $condition.=' and employeedetail.branch_or_sponsor_id="' . $branch . '"';
                }
                $model_user = User::model()->findByPk(Yii::app()->user->id);
                    if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
                        $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
                    }
                if($category!=''){
                    $condition.=' AND employeedetail.employee_category= "'.$category.'"';
                }
                
                $modelSalarySlip = SalarySlip::model()->with('employeedetail')->findAll(array('condition' => $condition));
            }
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'ID')
                ->setCellValue('C1', 'Name');
        //Salary Head
        $head_row = 1;
        $head_col = 3;
         $model_salary_type = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_occurence="2" and salary_type="1" '));
            foreach ($model_salary_type as $model_add) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $model_add->salary_name);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $head_col++;
            
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Monthly Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $model_salary_type_1 = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and salary_occurence="1" and salary_type="1"'));
            foreach ($model_salary_type_1 as $model_add) {
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $model_add->salary_name);
            $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
            $head_col++;
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Overtime');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'AL Addition');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
    /*        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Holiday Allowance');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Night Shift Allowance');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Incentive');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++; */
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Other Addition');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Gross Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $model_salary_type_2 = MasSalarytype::model()->findAll(array('condition' => 'isActive="Y"  and  salary_type="2"'));
            foreach ($model_salary_type_2 as $model_add) {
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $model_add->salary_name);
            $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
            $head_col++;
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Salary Advance');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Loan Amount');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Leave Amount');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'AL Deduction');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Pre Join Deduction');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Other Deduction');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Total Deduction');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Net Amount');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
    /*    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Threshold Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'SIF Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(20);
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Balance Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($head_col);
        $head_col++; */
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Salary By');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($head_col);
        $head_col++;
        $objPHPExcel->getActiveSheet()->getStyle('A1:' . $adjustedColumn . '1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('A1:' . $adjustedColumn . '1')->getFont()->setSize(12)->setBold(true);
        //sTYLE
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN
                )
            )
        );
        $objPHPExcel->getActiveSheet()
                ->getStyle('A1:' . $adjustedColumn . '1')
                ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D3D3D3')
                            )
                        )
        );
        $objPHPExcel->getActiveSheet()->getStyle('D:' . $adjustedColumn . '')
            ->getNumberFormat()
            ->setFormatCode('#,##0.00');
        $j = 1;
        $rowCount = 2;
        $start = $rowCount;$end=0;
        $incentive_amount=0.00;
            $night_shift_amount=0.00;
            $holiday_amount=0.00;
            $salary_advance_amount=0.00;
            $annual_leave_addition=0.00;
            $annual_leave_deduction=0.00;
            $before_joining_salary=0.00;
            $loan_amount=0.00;
            $leave_amount=0.00;
            $other_addition=0.00;
            $total_addition_amount=0.00;
            $other_deduction=0.00;
            $total_deduction_amount=0.00;
            $total_salary_amount=0.00;
            $overtime_amount=0.00;
            $total_gross_salary=0.00;
            $total_net_salary=0.00;
            $total_sif_salary=0.00;
            $total_unsif_salary=0.00;
        $addictions = 0.00;
        $f=1;
        $paymode=array('0'=>'All','1'=>'Cash','2'=>'Cheque','3'=>'WPS','4'=>'Exchange','5'=>'Bank');
        $start_date = $year . '-' . $month . '-01';
        $end_date=date("Y-m-t", strtotime($start_date));
         if (!empty($modelSalarySlip)) {
                foreach ($modelSalarySlip as $j => $salary_detail) {
                    $gross_salary=0.00;
                    $net_salary=0.00;
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $f);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('B' . $rowCount, $salary_detail->employeedetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('C' . $rowCount, $salary_detail->employeedetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                $col_index = 3;
                $row_alphabet_3 = $this->cellsToMergeByColsRow($col_index);
                 foreach ($model_salary_type as $key_1 => $value) {
                            $model_salaryslip_details = SalarySlipDetails::model()->find(array('condition' => 'salary_slip_id="'.$salary_detail->id.'" and salary_id="'.$value->id.'"'));  
                        $salary_type_amount=0.00;
                        if((!empty($model_salaryslip_details)) && $model_salaryslip_details->salary_amount>0){
                            $salary_type_amount=$model_salaryslip_details->salary_amount;
                            $gross_salary+=$salary_type_amount;
                            $net_salary+=$salary_type_amount;
                            $total_net_salary+=$salary_type_amount;
                            $total_gross_salary+=$salary_type_amount;
                        }
                    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_type_amount);
                    $col_index++;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $gross_salary);
                $row_alphabet_4 = $this->cellsToMergeByColsRow($col_index);
                $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_4 . '' . $rowCount . ':' . $row_alphabet_4 . '' . $rowCount . '')->getFont()->setSize(11)->setBold(true);
                $col_index++;
                foreach ($model_salary_type_1 as $key_1 => $value) {
                            $model_salaryslip_details = SalarySlipDetails::model()->find(array('condition' => 'salary_slip_id="'.$salary_detail->id.'" and salary_id="'.$value->id.'"'));  
                        $salary_type_amount=0.00;
                        if((!empty($model_salaryslip_details)) && $model_salaryslip_details->salary_amount>0){
                            $salary_type_amount=$model_salaryslip_details->salary_amount;
                            $net_salary+=$salary_type_amount;
                            $total_net_salary+=$salary_type_amount;
                        }
                    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_type_amount);
                    $col_index++;
                }
                 $overtime_amount+=$salary_detail->overtime_amount;
                            $net_salary+=$salary_detail->overtime_amount;
                            $total_net_salary+=$salary_detail->overtime_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->overtime_amount);
                $col_index++;
                $annual_leave_addition+=$salary_detail->annual_leave_addition;
                                    $net_salary+=$salary_detail->annual_leave_addition;
                                    $total_net_salary+=$salary_detail->annual_leave_addition;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->annual_leave_addition);
                $col_index++;
    /*            $holiday_amount+=$salary_detail->public_holiday_allowance;
                                    $net_salary+=$salary_detail->public_holiday_allowance;
                                    $total_net_salary+=$salary_detail->public_holiday_allowance;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->public_holiday_allowance, ""));
                $col_index++;
                $night_shift_amount+=$salary_detail->night_shift_allowance;
                            $net_salary+=$salary_detail->night_shift_allowance;
                            $total_net_salary+=$salary_detail->night_shift_allowance;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->night_shift_allowance, ""));
                $col_index++;
               $incentive_amount+=$salary_detail->incentive;
                            $net_salary+=$salary_detail->incentive;
                            $total_net_salary+=$salary_detail->incentive;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->incentive, ""));
                $col_index++; */
               $other_addition+=$salary_detail->other_addition;
                            $net_salary+=$salary_detail->other_addition;
                            $total_net_salary+=$salary_detail->other_addition;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->other_addition);
                $col_index++;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $net_salary);
                $row_alphabet_7 = $this->cellsToMergeByColsRow($col_index);
                $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_7 . '' . $rowCount . ':' . $row_alphabet_7 . '' . $rowCount . '')->getFont()->setSize(11)->setBold(true);
                $col_index++;
                $deduction_amt=$deduction_amt_1=0.00;
                        foreach ($model_salary_type_2 as $key_1 => $value) {
                            $model_salaryslip_details = SalarySlipDetails::model()->find(array('condition' => 'salary_slip_id="'.$salary_detail->id.'" and salary_id="'.$value->id.'"'));  
                        $salary_type_amount=0.00;
                        if($model_salaryslip_details->salary_amount>0){
                            $salary_type_amount=$model_salaryslip_details->salary_amount;
                            $deduction_amt+=$model_salaryslip_details->salary_amount;
                        }
                    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_type_amount);
                    $col_index++;
                }
                $salary_advance_amount+=$salary_detail->salary_advance_amount;
                $deduction_amt_1+=$salary_detail->salary_advance_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->salary_advance_amount);
                $col_index++;
                $loan_amount+=$salary_detail->loan_amount;
             $deduction_amt_1+=$salary_detail->loan_amount;

                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->loan_amount);
                $col_index++;
                $leave_amount+=$salary_detail->leave_amount;
                $deduction_amt_1+=$salary_detail->leave_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->leave_amount);
                $col_index++;
                 $annual_leave_deduction+=$salary_detail->annual_leave_deduction;
                 $deduction_amt_1+=$salary_detail->annual_leave_deduction;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->annual_leave_deduction);
                $col_index++;
                $before_joining_salary+=$salary_detail->before_joining_salary;
                $deduction_amt_1+=$salary_detail->before_joining_salary;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->before_joining_salary);
                $col_index++;
                $other_deduction+=$salary_detail->other_deduction;
                $deduction_amt_1+=$salary_detail->other_deduction;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->other_deduction);
                $col_index++;
     
                $total_deduction_amount+=($deduction_amt+$deduction_amt_1);
                                   
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $deduction_amt+$deduction_amt_1);
                $col_index++;
                $row_alphabet_5 = $this->cellsToMergeByColsRow($col_index);
                 $total_salary_amount+=$salary_detail->total_salary_amount;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $salary_detail->total_salary_amount);
                $col_index++;
                $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_5 . '' . $rowCount . ':' . $row_alphabet_5 . '' . $rowCount . '')->getFont()->setSize(11)->setBold(true);
        /*        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->threshold_salary, ""));
                $col_index++;
                $total_sif_salary+=$salary_detail->sif_transfer_salary;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->sif_transfer_salary, ""));
                $col_index++;
                 $total_unsif_salary+=$salary_detail->sif_untransfer_salary;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, Yii::app()->numberFormatter->formatCurrency($salary_detail->sif_untransfer_salary, ""));
                $col_index++; */
                $row_alphabet_6 = $this->cellsToMergeByColsRow($col_index);
                $objPHPExcel->getActiveSheet()->getStyle('' . $row_alphabet_3 . '' . $rowCount . ':' . $row_alphabet_6 . '' . $rowCount . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

                    $MonthlySalarySif = MonthlySalarySifDetails::model()->find(array('condition'=> 'start_date >= "' . $start_date . '" AND end_date<="'.$end_date.'" AND employee_id="'.$salary_detail->employee_id.'"'));
                    $mode_payment ='';
                    if(!empty($MonthlySalarySif)){
                      $mode_payment=  $paymode[$MonthlySalarySif->salarysif->salary_payment_mode];
                    }else{
                      $mode_payment=  $paymode[$salary_detail->employeedetail->payment_type];
                    }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $mode_payment);
                $end=$rowCount;
                $rowCount++;
                $f++;
            }
        }
        $footer_row = $end + 1;
        // $head_row = 1;
        $footer_col = 3;
        $objPHPExcel->getActiveSheet()->SetCellValue('C' . $footer_row, 'Total');

        $objPHPExcel->getActiveSheet()->getStyle('C' . $footer_row . ':C' . $footer_row . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        if(!empty($process)){
        $con_total='t.salary_processing_id="'.$process->id.'"';
                    if($category!=''){
                        $con_total.=' and employeedetail.employee_category= "'.$category.'"';
                    }
                    foreach ($model_salary_type as $key_1 => $value) {
                        $con_total_1=$con_total.' AND salary_id="'.$value->id.'"';
                        $model_salarytotal_details= SalarySlipDetails::model()->with('salaryslip.employeedetail')->find(array('select'=>'sum(salary_amount) as salary_amount','condition' =>$con_total_1));
                          $salary_amount_var = 0.00;
            if(!empty($model_salarytotal_details)){
               $salary_amount_var = $model_salarytotal_details->salary_amount;
             }  
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $salary_amount_var);

            $footer_col++;
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $total_gross_salary);

        $footer_col++;
       foreach ($model_salary_type_1 as $key_2 => $value) {
                        $con_total_2=$con_total.' AND salary_id="'.$value->id.'"';
                        $model_salarytotal_details= SalarySlipDetails::model()->with('salaryslip.employeedetail')->find(array('select'=>'sum(salary_amount) as salary_amount','condition' =>$con_total_2));  
                   
              $salary_amount_var = 0.00;
            if(!empty($model_salarytotal_details)){
               $salary_amount_var = $model_salarytotal_details->salary_amount;
             }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $salary_amount_var);

            $footer_col++;
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $overtime_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $annual_leave_addition);
        $footer_col++;
    /*    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($holiday_amount, ""));
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($night_shift_amount, ""));
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($incentive_amount, ""));
        $footer_col++; */
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $other_addition);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $total_net_salary);
        $footer_col++;
        foreach ($model_salary_type_2 as $key_1 => $value) {
                        $con_total_3=$con_total.' AND salary_id="'.$value->id.'"';
                        $model_salarytotal_details= SalarySlipDetails::model()->with('salaryslip.employeedetail')->find(array('select'=>'sum(salary_amount) as salary_amount','condition' =>$con_total_3));  
                   
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $model_salarytotal_details->salary_amount);
            $footer_col++;
        }}
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row,$salary_advance_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $loan_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $leave_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $annual_leave_deduction);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $before_joining_salary);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $other_deduction);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $total_deduction_amount);
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, $total_salary_amount);
        $footer_col++;
/*        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, '');
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($total_sif_salary, ""));
        $footer_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($footer_col, $footer_row, Yii::app()->numberFormatter->formatCurrency($total_unsif_salary, "")); */
        $row_al_5 = $this->cellsToMergeByColsRow($footer_col);
        $objPHPExcel->getActiveSheet()->getStyle('C'.$footer_row.':'.$row_al_5.''.$footer_row.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('C'.$footer_row.':'.$row_al_5.''.$footer_row.'')->getFont()->setSize(12)->setBold(true);        
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Salary Slip Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="salary_slip.xls.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }


    public function actionPrintIncrementSalaryExcel() {
        //codde added by rahul on 19-7-22//
        $branch = $_GET['branch'];
        $employee_id = $_GET['employee_id'];
        $salary_type = $_GET['salary_type'];
        $condition = '1=1';
        if ($employee_id != '')
            $condition .= ' AND t.employee_id = ' . $employee_id;
        if ($branch != '')
            $condition .= ' AND employeedetail.branch_or_sponsor_id = ' . $branch;
        if ($salary_type != '')
            $condition .= ' AND t.salary_type = ' . $salary_type;
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        $modelincrement = EmployeeSalary::model()->with('employeedetail', 'salary')->findAll(array('condition' => $condition));
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension(0)->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Branch')
                ->setCellValue('C1', 'ID')
                ->setCellValue('D1', 'Name')
                ->setCellValue('E1', 'Salary Type')
                ->setCellValue('F1', 'Valid From')
                ->setCellValue('G1', 'Valid TO')
                ->setCellValue('H1', 'Amount');
        $objPHPExcel->getActiveSheet()->getStyle('A1:H1')->getFont()->setBold(true)->setSize(12);
        $rowCount = 2;
        $number = 1;
        foreach ($modelincrement as $model) {

            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $model->employeedetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $model->employeedetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $model->employeedetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $model->salary->salary_name);

            if ($model->valid_from != "0000-00-00") {
                $valid = date('d/m/Y', strtotime($model->valid_from));
            } else {
                $valid = "-";
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $valid);
            if ($model->valid_to != "0000-00-00") {
                $valid_to = date('d/m/Y', strtotime($model->valid_to));
            } else {
                $valid_to = "-";
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $valid);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $valid_to);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $model->amount);
            $objPHPExcel->getActiveSheet()
                    ->getStyle('H:H')
                    ->getNumberFormat()
                    ->setFormatCode('#,##0.00');
            $rowCount++;
            $number++;
        }
        $objPHPExcel->getActiveSheet()->getStyle('H1:H1' . $rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Salary Increment');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Salary Increment.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }

    public function actionPrintIncrementSalaryExcel12() {
        $branch = $_GET['branch'];
        $employee_id = $_GET['employee_id'];
        $salary_type = $_GET['salary_type'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_increment.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salaryincrement_excel', array('branch' => $branch, 'employee_id' => $employee_id, 'salary_type' => $salary_type), false, true);
        Yii::app()->end();
    }

    public function actionPrintBranchListExcel() {
        $branchname = $_GET['branchname'];
        $location = $_GET['location'];
        $currency = $_GET['currency'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_Branchlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_branchlist_excel', array('branchname' => $branchname, 'location' => $location, 'currency' => $currency), false, true);
        Yii::app()->end();
    }

    public function actionPrintOvertimelistExcel() {
        $overtime_from_date = $_GET['overtime_from_date'];
        $overtime_to_date = $_GET['overtime_to_date'];
        $emp_id = $_GET['emp_id'];
        $overtime_emp_sponsor = $_GET['overtime_emp_sponsor'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_overtimelist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_overtimelist_excel', array('overtime_from_date' => $overtime_from_date, 'overtime_to_date' => $overtime_to_date, 'emp_id' => $emp_id, 'overtime_emp_sponsor' => $overtime_emp_sponsor), false, true);
        Yii::app()->end();
    }

    public function actionPrintInOutExcel() {
        $employee_id = $_GET['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'In_Out.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_inoutdocument_excel', array('employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintMonthlyAttendanceReport() {
        $attend_emp_sponsor = $_POST['branch_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'In_Out.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//hrreports/print_employee_monthly_attendance_list', array('model' => $model, 'year' => $year, 'month' => $month, 'attend_emp_sponsor' => $attend_emp_sponsor, 'title' => $title), false, true);
        Yii::app()->end();
    }

    public function actionPrintLeaveLedgerExcel() {
        $employee_id = $_GET['employee_id'];
        $year = $_GET['year'];
        $leavetype = $_GET['leave_id'];
        $branch = $_GET['branch'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'LeaveLedger.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_leaveledgerlist_excel', array('employee_id' => $employee_id, 'year' => $year, 'leavetype' => $leavetype, 'branch' => $branch), false, true);
        Yii::app()->end();
    }

    public function actionPrintexcelbranchdetail() {
        $branch = $_GET['branch'];
        $employee_id = $_GET['employee_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_branchdetails.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeebranch_excel', array('branch' => $branch, 'employee_id' => $employee_id, 'date_from' => $date_from, 'date_to' => $date_to), false, true);
        Yii::app()->end();
    }

    public function actionExcelleaveyeardetails() {
        $employee_id = $_GET['employee_id'];
        $year = $_GET['year'];
        $leavetype = $_GET['leavetype'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'LeaveDetails.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_leavedetails_excel', array('employee_id' => $employee_id, 'year' => $year, 'leavetype' => $leavetype, 'title' => $title), false, true);
        Yii::app()->end();
    }

    public function actionExcelLeaveBalance() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $leavetype = $_GET['leave_name'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Leavebalance.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_leavebalance_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id, 'leavetype' => $leavetype, 'title' => $title), false, true);
        Yii::app()->end();
    }

    public function actionPrintAdvanceExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $status = $_GET['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Salaryadvance.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_advance_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id, 'status' => $status, 'title' => $title), false, true);
        Yii::app()->end();
    }

    public function actionPrintOrderAnnexureReportExcel() {
        $id = $_GET['id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'order_annexure.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('order_annexure_individual_excel', array('id' => $id, 'status' => $status, 'title' => $title), false, true);
        Yii::app()->end();
    }

    public function actionPrintNomineeExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $status = $_GET['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Nominees Details.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_nominee_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id, 'status' => $status), false, true);
        Yii::app()->end();
    }

    public function actionPrintPurchaseExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Purchase Details.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_purchase_excel', array('date_to' => $date_to, 'date_from' => $date_from, 'employee_id' => $employee_id, 'branch_id' => $branch_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintTrainingExcel() {
        $employee_id = $_GET['employee_id'];
        $course_id = $_GET['course_id'];
        $type = $_GET['type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Training List.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        if ($type == 'T') {
            $this->renderPartial('print_training_excel', array('course_id' => $course_id), false, true);
        } else {
            $this->renderPartial('print_competency_excel', array('employee_id' => $employee_id, 'course_id' => $course_id), false, true);
        }
        Yii::app()->end();
    }

    public function actionExcelAnnualList() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Annual Leave List.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_annualleave_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintTrainingPlan() {
        $year = $_GET['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Training Plan.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_training_plan_excel', array('year' => $year), false, true);
        Yii::app()->end();
    }

    public function actionPrintExpenseExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        $status = $_GET['status'];
        $sort_field = Yii::app()->request->getParam('sort_field');
        $sort_order= Yii::app()->request->getParam('sort_order');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Expense Details.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_expense_excel', array('date_to' => $date_to, 'date_from' => $date_from, 'employee_id' => $employee_id, 'branch_id' => $branch_id,'status' => $status,'sort_field'=>$sort_field,'sort_order'=>$sort_order), false, true);
        Yii::app()->end();
    }

    public function actionMastersalaryExcel() {
        $wps_company_id = $_GET['wps_company_id'];
        $month = $_GET['month'];
        $year = $_GET['year'];
        $date_block = $year . '-' . $month . '-01';
        $condition = '(date_blocked="0000-00-00" OR date_blocked>="' . $date_block . '")';
        if ($wps_company_id != '') {
            $condition .= ' AND employee_wps_company="' . $wps_company_id . '"';
        }
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeefullname . ' ' . $value->employeecode] = $value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'master_salary_report.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salary_master_excel', array('wps_company_id' => $wps_company_id, 'month' => $month, 'year' => $year, 'arr_employee' => $arr_employee), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeAppraisalList() {
        $employee_id = $_GET['employee_id'];
        $analysis_period = $_GET['analysis_period'];
        $branch_id = $_GET['attend_emp_sponsor'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Appraisal Details.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_appraisal_excel', array('branch_id' => $branch_id, 'analysis_period' => $analysis_period, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeIndividualAppraisalList() {
        $employee_id = $_GET['employee_id'];
        $analysis_period = $_GET['analysis_period'];
        $branch_id = $_GET['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Appraisal Individual Details.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_appraisal_individual_excel', array('branch_id' => $branch_id, 'analysis_period' => $analysis_period, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeEosList() {
        $employee_id = $_GET['employee_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'End Of Service.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_eos_excel', array('from_date' => $from_date, 'to_date' => $to_date, 'employee_id' => $employee_id), false, true);
        Yii::app()->end();
    }

    public function actionPrintEmployeeRecruitmentList() {
        $employee_id = $_GET['employee_id'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Recruitment.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_recruitment_excel', array('from_date' => $from_date, 'to_date' => $to_date, 'employee_id' => $employee_id), false, true);
        //Yii::app()->end();
    }

    public function actiongrosssalaryexcel() {
        $branch = $_GET['branch_id'];
        $category = $_GET['category'];
        $year = $_GET['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_report.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salary_gross_excel', array('branch' => $branch, 'year' => $year, 'category' => $category), false, true);
        Yii::app()->end();
    }

    function decimalHours($time) {
        $hms = explode(":", $time);
        return ($hms[0] + ($hms[1] / 60) + ($hms[2] / 3600));
    }

    public function actionPrintEmployeeQualificationReportExcel() {
        $filename = 'employee_qualification_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('print_empployee_qualification_report_excel', $_REQUEST, false, true);
        Yii::app()->end();

        return;
    }

    public function actionPrintLeaveEncashmentExcel() {
        $branch_id = $_GET['branch'];
        $employee_id = $_GET['employee_id'];
        $year = $_GET['year'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'LeaveEncashmentlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_leave_encashment_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'year' => $year));
        Yii::app()->end();
    }
     public function actionPrintEmployeeHierarchyListExcel() {
         //code added by rahul on20-7-22//
        $Branch = $_GET['Branch'];
        $department = $_GET['department'];
        $employee_id = $_GET['employee_id'];
        $functionality_id = $_GET['functionality_id'];
        
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_hierarchy_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeehierarchylist_excel', array('Branch' => $Branch,'department' => $department, 'employee_id' => $employee_id, 'functionality_id' => $functionality_id), false, true);
        Yii::app()->end();
    }
    public function actionPrintEmployeeSettingsListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $report_type = $_GET['report_type'];
       $model='';
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
       
        header("Content-type: application/vnd.ms-excel");
       
        if ($report_type == "W") {
            $filename = 'Employee Weekend List.xls';
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            $this->renderPartial('employee_weekend_list_excel', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), false, true);
        } elseif ($report_type == "B") {
            $filename = 'Employee Biometric List.xls';
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            $this->renderPartial('employee_biometric_list_excel', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), false, true);
        } elseif ($report_type == "C") {
            $filename = 'Employee Contract Type List.xls';
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            $this->renderPartial('employee_contracttype_list_excel', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), false, true);
            
        } elseif ($report_type == "O") {
            $filename = 'Employee Overtime List.xls';
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            $this->renderPartial('employee_overtime_list_excel', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), false, true);            
        } else {
            $filename = 'Employee Weekend List.xls';
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            $this->renderPartial('employee_weekend_list_excel', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), false, true);
            
        }

        Yii::app()->end();
    }
    public function actionPrintEmployeeTeamListExcel() {
        $branch_id =(int) $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $team_name = $_GET['team_name'];
        $reportman_id = $_GET['reportman_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_team_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeeteamlist_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'team_name' => $team_name, 'reportman_id' => $reportman_id), false, true);
        Yii::app()->end();
    }
     public function actionPrintEmployeeBankdetailsExcel() {
        $branch_id =(int) $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $bank_name = $_GET['bank_name'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_bank_details.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employee_bankdetais_excel', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'bank_name' => $bank_name), false, true);
        Yii::app()->end();
    }
     public function actionPrintEmployeePunchHistoryExcel() {
         if (isset($_GET['branch_id'])) {
         $attend_emp_sponsor =(int) $_GET['branch_id'];
         } 
        else
         {
         $attend_emp_sponsor = '';
         }
        
        
        $emp_id = $_GET['emp_id'];
        $from_date = $_GET['punch_from_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_punch_history_details.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employee_punch_history_excel', array('attend_emp_sponsor' => $attend_emp_sponsor, 'emp_id' => $emp_id, 'from_date' => $from_date), false, true);
        Yii::app()->end();
    }
     public function actionMasterMonthlySalaryExcel() {
        $branch = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $month_type = $_GET['month'];
        $year = $_GET['year'];
         $month_start =1; 
         $month_end = 12;
        if($month_type==2){
            $month_start = 7; 
        }else if($month_type==1){
         $month_end =6;
        }
        $date_block=$year.'-'.$month_start.'-01';
        $condition='(date_blocked="0000-00-00" OR date_blocked>="'.$date_block.'")';
        if($branch!=''){
            $condition.=' AND branch_or_sponsor_id="'.$branch.'"';
        }
        if($employee_id!=''){
            $condition.=' AND id="'.$employee_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition)); 
        $arr_employee=array(); 
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeefullname]=$value['id'];
        }
        ksort($arr_employee);       
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'master_monthly_salary_report.xls';
      header("Content-type: application/vnd.ms-excel");
      header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salary_monthly_master_excel', array('branch' => $branch, 'month' => $month, 'year' => $year,'arr_employee'=>$arr_employee,'month_start'=>$month_start,'month_end'=>$month_end), false, true);
        Yii::app()->end();
    }
     //dept chngelist added by nisha on 06-02-2023
     public function actionPrintEmployeedepartmentChangeListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_department_change_list.xls';
       header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeedepartment_changelist_excel', array('Branch' => $Branch, 'employee_id' => $employee_id, 'date_to' => $date_to,'date_from'=>$date_from), false, true);
        Yii::app()->end();
    }
    //desn chngelist added by nisha on 06-02-2023
     public function actionPrintEmployeedesignationChangeListExcel() {
        $Branch = $_GET['Branch'];
        $employee_id = $_GET['employee_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'employee_designation_change_list.xls';
       header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_employeedesignation_changelist_excel', array('Branch' => $Branch, 'employee_id' => $employee_id, 'date_to' => $date_to,'date_from'=>$date_from), false, true);
        Yii::app()->end();
    }

    //PrintSalaryNonzero added by nisha on 22-02-2023
 public function actionPrintSalaryNonzero() {
        $sponser_id = $_GET['sponser_id'];
        $year = $_GET['year'];
        $month = $_GET['month'];
        $category = $_GET['category'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_non_zero_report.xls';
     header("Content-type: application/vnd.ms-excel");
      header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salary_nonzero_excel', array('branch' => $sponser_id, 'month' => $month, 'year' => $year), false, true);
        Yii::app()->end();
    }
    public function actionPrintSalaryNonzerobefore() {
        $sponser_id = $_GET['sponser_id'];
        $year = $_GET['year'];
        $month = $_GET['month'];
        $category = $_GET['category'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'salary_non_zero_report.xls';
     header("Content-type: application/vnd.ms-excel");
      header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_before_salary_nonzero_excel', array('branch' => $sponser_id, 'month' => $month, 'year' => $year), false, true);
        Yii::app()->end();
    }

public function actionPrintSalaryAdvanceExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $status = $_GET['status'];
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $title='';
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Salaryadvance.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_salary_advance_excel', array('employee_id' => $employee_id, 'branch_id' => $branch_id, 'status' => $status, 'title' => $title,'from_date'=>$from_date,'to_date'=>$to_date), false, true);
        Yii::app()->end();
    }
    public function actionPrintExcuseExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        $status = $_GET['status'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Excuse Details.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_excuse_excel', array('date_to' => $date_to, 'date_from' => $date_from, 'employee_id' => $employee_id, 'branch_id' => $branch_id,'status' => $status), false, true);
        Yii::app()->end();
    }
    public function actionEmployeeWeekendExcel() {
    $branch_id = $_GET['branch_id'];
    $employee_id = $_GET['employee_id'];
    $condition = '1=1';
    if ($branch_id >0) {
        $condition .= ' AND t.branch_or_sponsor_id = "' . $branch_id . '"';
    } else {
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition.= ' and t.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
    }
    if ($employee_id >0) {
        $condition .= ' AND t.id = "' . $employee_id . '"';
    }
    $model_user = User::model()->findByPk(Yii::app()->user->id);
    if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
        $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
    }

    $model_employee = Employee::model()->findAll(array('condition' => $condition));
    $arr_employee = array();
    foreach ($model_employee as $key => $value) {
        $arr_employee[$value['employeefullname'] . ' ' . $value['employeecode']] = $value['id'];
    }
    ksort($arr_employee);
    $j = 1;
    $weekend = array('H' => 'Half', 'F' => 'Full');
    $arr_day= array(1=>"Sunday",2=>"Monday",3=>"Tuesday",4=>"Wednesday",5=>"Thursday",6=>"Friday",7=>"Saturday");
    Yii::import('ext.PHPExcel.PHPExcel');
    $objPHPExcel = new PHPExcel();
        // Add some data
    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
    $objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A1', 'No')
    ->setCellValue('B1', 'ID')
    ->setCellValue('C1', 'Branch')
    ->setCellValue('D1', 'Employee Name')
    ->setCellValue('E1', 'Weekend 1')
    ->setCellValue('F1', 'Weekend 2')
    ->setCellValue('G1', 'Weekend 3');
    $objPHPExcel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
    $rowCount = 2;
    $number = 1;
    $objPHPExcel->getActiveSheet()
    ->getStyle('A1:G1')
    ->applyFromArray(
        array(
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'D3D3D3')
            )
        )
    );
    if (!empty($arr_employee)) {
        foreach ($arr_employee as $emp_val) {
            $empdetail = Employee::model()->findbyPK($emp_val);
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->getStyle('B' . $rowCount . ':B' . $rowCount . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT); 
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            if ($empdetail->weekend_off1 > 0) {
                $weekvalue = $arr_day[$empdetail->weekend_off1];
            } else {
                $weekvalue = "-";
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $weekvalue);
            if ($empdetail->weekend_off2 > 0) {
                $weekvalue1 = $arr_day[$empdetail->weekend_off2];
            } else {
                $weekvalue1 = "-";
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $weekvalue1);
            if ($empdetail->weekend_off3 > 0) {
                $weekvalue2 = $arr_day[$empdetail->weekend_off3];
            } else {
                $weekvalue2 = "-";
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $weekvalue2);
            $end=$rowCount;
            $rowCount++;
            $number++;
        }
    }
        // Rename worksheet
    $objPHPExcel->getActiveSheet()->setTitle('Employee Weekend Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $objPHPExcel->setActiveSheetIndex(0);
    header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
    header('Content-Disposition: attachment;filename="Employee Weekend Details.xls"');
    header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public function actionPrintDepartmentHierarchyListExcel() {
        $department = $_GET['department'];
        $functionality_id = $_GET['functionality_id'];
        $condition = 'isActive="Y"';
        if ($department != '') {
            $condition .= ' AND t.id = "' . $department . '"';
        }
        $modeldepartment = MasDepartment::model()->findAll(array('condition' => $condition));
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
            // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
        $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1', 'No')
        ->setCellValue('B1', 'Department')
        ->setCellValue('C1', 'Max Level')
        ->setCellValue('D1', 'Level 1')
        ->setCellValue('D2', 'Type')         
        ->setCellValue('E2', 'Authority')         
        ->setCellValue('F1', 'Level 2')
        ->setCellValue('F2', 'Type')         
        ->setCellValue('G2', 'Authority')         
        ->setCellValue('H1', 'Level 3')
        ->setCellValue('H2', 'Type')         
        ->setCellValue('I2', 'Authority')         
        ->setCellValue('J1', 'Level 4')
        ->setCellValue('J2', 'Type')         
        ->setCellValue('K2', 'Authority')         
        ->setCellValue('L1', 'Level 5')
        ->setCellValue('L2', 'Type')         
        ->setCellValue('M2', 'Authority');       
        $objPHPExcel->getActiveSheet()->getStyle('A1:M2')->getFont()->setBold(true)->setSize(12);
        $rowCount = 3;
        $number = 1;
        $objPHPExcel->getActiveSheet()
        ->getStyle('A1:M2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D3D3D3')
                ),
          )
        );
           $objPHPExcel->getActiveSheet()
        ->getStyle('A1:M2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D3D3D3')
                ),
          )
        );
        $styleArray = array(
        'borders' => array(
            'allborders' => array(
              'style' => PHPExcel_Style_Border::BORDER_THIN
            )
          )
        );
        $objPHPExcel->getActiveSheet()->mergeCells("A1:A2");
        $objPHPExcel->getActiveSheet()->mergeCells("B1:B2");
        $objPHPExcel->getActiveSheet()->mergeCells("C1:C2");
        $objPHPExcel->getActiveSheet()->mergeCells("D1:E1");
        $objPHPExcel->getActiveSheet()->mergeCells("F1:G1");
        $objPHPExcel->getActiveSheet()->mergeCells("H1:I1");
        $objPHPExcel->getActiveSheet()->mergeCells("J1:K1");
        $objPHPExcel->getActiveSheet()->mergeCells("L1:M1");
        $objPHPExcel->getActiveSheet()->getStyle("D1:M1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
       if (!empty($modeldepartment)) {
            $desig_arr = array('L' => 'LINE MANAGER', 'S' => 'SUPERVISOR', 'H' => 'Admin', 'N' => 'ESS');
            $model_approval = new HrDepartmentApproveLevel();
            foreach ($modeldepartment as $dept_val) {
                $max_level=$level_1_type=$level_2_type=$level_3_type=$level_4_type=$level_5_type='';
                $level_1_authority =$level_2_authority=$level_3_authority=$level_4_authority=$level_5_authority='-';
                $model_level_approval = HrDepartmentApproveLevel::model()->find(array('condition' => 'department_id="' . $dept_val->id . '" AND functionality_id="' . $functionality_id . '"'));
                if (!empty($model_level_approval) && $model_level_approval->id > 0) {
                    $model_approval->level_1_authority = $model_level_approval->level_1_authority;
                    $model_approval->level_2_authority = $model_level_approval->level_2_authority;
                    $model_approval->level_3_authority = $model_level_approval->level_3_authority;
                    $model_approval->level_4_authority = $model_level_approval->level_4_authority;
                    $model_approval->level_5_authority = $model_level_approval->level_5_authority;
                    $max_level =$model_level_approval->max_level;
                    if($model_level_approval->max_level >= 1) {
                        $level_1_type =$desig_arr[$model_level_approval->level_1_type]; 
                        if ($model_level_approval->level_1_type == 'H') {
                            $level_1_authority = Employee::model()->findByPK($model_level_approval->level_1_authority)->employeefullname;
                        }
                    }
                    if ($model_level_approval->max_level >= 2) {
                        $level_2_type=$desig_arr[$model_level_approval->level_2_type];
                        if ($model_level_approval->level_2_type == 'H') {
                           $level_2_authority= Employee::model()->findByPK($model_level_approval->level_2_authority)->employeefullname;
                        }
                    }
                    if ($model_level_approval->max_level >= 3) {
                        $level_3_type=$desig_arr[$model_level_approval->level_3_type];
                        if ($model_level_approval->level_3_type == 'H') {
                            $level_3_authority=Employee::model()->findByPK($model_level_approval->level_3_authority)->employeefullname;
                       }
                    }
                    if ($model_level_approval->max_level >= 4) {
                        $level_4_type=$desig_arr[$model_level_approval->level_4_type];
                        if ($model_level_approval->level_4_type == 'H') {
                            $level_4_authority=Employee::model()->findByPK($model_level_approval->level_4_authority)->employeefullname;
                        }
                    }
                     if ($model_level_approval->max_level >= 5) {
                        $level_5_type=$desig_arr[$model_level_approval->level_5_type];
                        if ($model_level_approval->level_5_type == 'H') {
                            $level_5_authority =Employee::model()->findByPK($model_level_approval->level_5_authority)->employeefullname;
                        }
                     }
                }
                $objPHPExcel->getActiveSheet()->getStyle('A1:M2')->applyFromArray($styleArray);
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $dept_val->department_name, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $max_level, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->getStyle('C'.$rowCount.':C'.$rowCount.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

                $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$level_1_type, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$level_1_authority, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$level_2_type, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$level_2_authority, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$level_3_type, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('I'.$rowCount,$level_3_authority, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('J'.$rowCount,$level_4_type, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('K'.$rowCount,$level_4_authority, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('L'.$rowCount,$level_5_type, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('M'.$rowCount,$level_5_authority, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->getStyle('A'. $rowCount.':M'.$rowCount)->applyFromArray($styleArray);
                $end=$rowCount;
                $rowCount++;
                $number++;
            }
        }
        
            // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Department Hierarchy Details');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Department Hierarchy Details.xls"');
        header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
            // If you're serving to IE over SSL, then the following may be needed
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');
    }
     public function actionexcelticketyeardetails() {
        $employee_id = $_GET['employee_id'];
        $year = $_GET['year'];
        //Ticket Details
        $ticket_details_array=array();
        $s=0;
         $condition='year="'.$year.'" AND (status=12 || status=14)';
        if($employee_id >0){
            $condition.=' AND t.employee_id="' . $employee_id . '"';
        }
       
        $model_user = User::model()->findByPk(Yii::app()->user->id);

        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
              $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        $model_details=EmployeeTicket::model()->with('leavedetail')->findAll(array('condition'=>$condition));
        if (!empty($model_details)) {
            foreach ($model_details as $i=>$value) {    
                $ticket_details_array[$s]['date']=date('d/m/Y',strtotime($value->date_approved));
                $ticket_details_array[$s]['ticketdeduct']=$value->ticket_percentage;
                $ticket_details_array[$s]['ticketdadd']=0.00;
                $travel_date=$return_date="";
                if ($value->travel_date != '' && $value->travel_date != '0000-00-00') {
                    $travel_date = date("d/m/Y", strtotime($value->travel_date));
                }
                if ($value->return_date != '' && $value->return_date != '0000-00-00') {
                    $return_date = date("d/m/Y", strtotime($value->return_date));
                }
                if($travel_date!='' && $return_date!=''){
                    $remarks='Ticket from '.$travel_date.' to '.$return_date; 
                }else{
                    $remarks="";
                }
                $ticket_details_array[$s]['remarks']=$remarks;
                $s++;
            }
        }
        //ticket Encashment
        $model_encashment_details=EmployeeTicketEncashment::model()->findAll(array('condition'=>$condition));
        if (!empty($model_encashment_details)) {
            foreach ($model_encashment_details as $i=>$value) {    
                $ticket_details_array[$s]['date']=date('d/m/Y',strtotime($value->approved_date));
                $ticket_details_array[$s]['ticketdeduct']=$value->ticket_percentage;
                $ticket_details_array[$s]['ticketdadd']=0.00;
                $date_apply='';
                if ($value->date_apply != '' && $value->date_apply != '0000-00-00') {
                    $date_apply = date("d/m/Y", strtotime($value->date_apply));
                }
                if($date_apply!=''){
                    $remarks='Ticket Encashment applied on '.$date_apply; 
                }else{
                    $remarks="";
                }
                $ticket_details_array[$s]['remarks']=$remarks;                      
                $s++;
            }
        }
        //ticket Addition
        $model_addition_details=HrEmployeeTicketLedger::model()->findAll(array('condition'=>'employee_id="' . $employee_id . '" and YEAR(created_date_time)="'.$year.'"'));
        if (!empty($model_addition_details)) {
            foreach ($model_addition_details as $i=>$value) {    
                $ticket_details_array[$s]['date']=date('d/m/Y',strtotime($value->created_date_time)).' **';
                $ticket_details_array[$s]['ticketdeduct']=$value->ticket_percentage_deducted;
                $ticket_details_array[$s]['ticketdadd']=$value->ticket_percentage;
                $ticket_details_array[$s]['remarks']=$value->remarks;                      
                $s++;
            }
        }
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getActiveSheet()->getRowDimension(0)->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Date')
                ->setCellValue('C1', 'Remarks')
                ->setCellValue('D1', 'Ticket Addition(+)')
                ->setCellValue('E1', 'Ticket Deduction(-)');
        $objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true)->setSize(12);
        if (!empty($ticket_details_array)) {
            $model_opening_details= EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id ="'.$employee_id.'" and ticket_year="'.$year.'"'));       
            $rowCount = 3;
            $number = 1;
            $objPHPExcel->getActiveSheet()
            ->getStyle('A1:E1')
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'D3D3D3')
                    )
                )
            );
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Opening Balance');
        $objPHPExcel->getActiveSheet()->getStyle('A2:D2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->mergeCells('A2:D2');
        $objPHPExcel->getActiveSheet()->SetCellValue('E2', number_format($model_opening_details->opening_balance, 2, '.', ''));
        $objPHPExcel->getActiveSheet()->getStyle('E2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        $objPHPExcel->getActiveSheet()
        ->getStyle('A2:E2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '28a745')
                )
            )
        );
        $total_addition=0.00;
        $total_deduction=0.00;
        foreach ($ticket_details_array as $i=>$value) {

            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $value['date'], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $value['remarks'], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, number_format($value['ticketdadd'], 2, '.', ''));
            $total_addition+=$value['ticketdadd'];
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, number_format($value['ticketdeduct'], 2, '.', ''));
            $total_deduction+=$value['ticketdeduct'];

            $rowCount++;
            $number++;
        }

       // $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1,.$rowCount., 'Total');
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Total');
        $objPHPExcel->getActiveSheet()->mergeCells('A'.$rowCount.':C'.$rowCount);
                                      
        $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount.':C'.$rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, number_format($total_addition, 2, '.', ''));
        $objPHPExcel->getActiveSheet()->getStyle('D'.$rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, number_format($total_deduction, 2, '.', ''));
        $objPHPExcel->getActiveSheet()->getStyle('E'.$rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
         $objPHPExcel->getActiveSheet()
        ->getStyle('A'.$rowCount.':E'.$rowCount)
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'ffc107')
                )
            )
        );
       $rowCount++; 

        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, 'Closing Balance');
        $objPHPExcel->getActiveSheet()->mergeCells('A'.$rowCount.':D'.$rowCount);
                                      
        $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount.':D'.$rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount,  number_format($model_opening_details->ticket_balance, 2, '.', ''));
         $objPHPExcel->getActiveSheet()
        ->getStyle('A'.$rowCount.':E'.$rowCount)
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '28a745')
                )
            )
        );
        }
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Ticket Ledger');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Ticket Ledger.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public function actionPrintEmployeelevelListExcel() {
        $employee_id = $_GET['employee_id'];
        $department = $_GET['department_name'];
        $functionality_id = $_GET['functionality_id'];
        $condition = 'employeedetail.isActive !="B"';
        if ($employee_id > 0) {
            $condition .= ' AND (level_1_authority="' . $employee_id . '" OR level_2_authority="' . $employee_id . '" OR level_3_authority="' . $employee_id . '" OR level_4_authority="' . $employee_id . '" OR level_5_authority="' . $employee_id . '")';
        }
        if ($functionality_id > 0) {
            $condition .= ' AND t.functionality_id="' . $functionality_id . '"';
        }
        if ($department > 0) {
               $condition.=' AND employeedetail.department="' . $department . '"';
        }
        $model_approval_authority = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => $condition, 'order' => 'functionality_id,employeedetail.de_first_name asc'));
        $functionality_name = HrMasterFunction::getdetails();
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getActiveSheet()->getRowDimension(0)->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(40);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Functionality')
                ->setCellValue('C1', 'Employee Code')
                ->setCellValue('D1', 'Employee Name')
                ->setCellValue('E1', 'Department')
                ->setCellValue('F1', 'Level 1')
                ->setCellValue('G1', 'Level 2')
                ->setCellValue('H1', 'Level 3')
                ->setCellValue('I1', 'Level 4')
                ->setCellValue('J1', 'Level 5');
        $objPHPExcel->getActiveSheet()->getStyle('A1:J1')->getFont()->setBold(true)->setSize(12);
        if (!empty($model_approval_authority)) {
            $rowCount = 2;
            $number = 1;
            $objPHPExcel->getActiveSheet()
                    ->getStyle('A1:I1')
                    ->applyFromArray(
                            array(
                                'fill' => array(
                                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                    'color' => array('rgb' => 'D3D3D3')
                                )
                            )
            );
            foreach ($model_approval_authority as $k => $row) {
                $level_1 = $level_2 = $level_3 = $level_4 = $level_5 = 'N';
                if ($row->max_level >= 1) {
                    if ($row->level_1_authority == $employee_id) {
                        $level_1 = 'Y';
                    }
                }
                if ($row->max_level >= 2) {
                    if ($row->level_2_authority == $employee_id) {
                        $level_2 = 'Y';
                    }
                }
                if ($row->max_level >= 3) {
                    if ($row->level_3_authority == $employee_id) {
                        $level_3 = 'Y';
                    }
                }
                if ($row->max_level >= 4) {
                    if ($row->level_4_authority == $employee_id) {
                        $level_4 = 'Y';
                    }
                }
                if ($row->max_level >= 5) {
                    if ($row->level_5_authority == $employee_id) {
                        $level_5 = 'Y';
                    }
                }
                if ($level_1 == "Y" || $level_2 == "Y" || $level_3 == "Y" || $level_4 == "Y" || $level_5 == "Y") {
                    $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $functionality_name[$row->functionality_id]);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $row->employeedetail->employeecode);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $row->employeedetail->employeefullname);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $row->employeedetail->departmentdetail->department_name);
                    if ($level_1 == "Y") {
                        $objPHPExcel->getActiveSheet()->getStyle('F' . $rowCount . ':F' . $rowCount)->applyFromArray(
                                array(
                                    'fill' => array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'color' => array('rgb' => 'FF0000')
                                    )
                                )
                        );
                    } else if ($row->max_level >= 1){
                        $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $row->level1details->employeefullname." - ".$row->level1details->employeecode);
                    }
                    if ($level_2 == "Y") {
                        $objPHPExcel->getActiveSheet()->getStyle('G' . $rowCount . ':G' . $rowCount)->applyFromArray(
                                array(
                                    'fill' => array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'color' => array('rgb' => 'FF0000')
                                    )
                                )
                        );
                    } else if ($row->max_level >= 2){
                        $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $row->level2details->employeefullname." - ".$row->level2details->employeecode);
                    }
                    if ($level_3 == "Y") {
                        $objPHPExcel->getActiveSheet()->getStyle('H' . $rowCount . ':H' . $rowCount)->applyFromArray(
                                array(
                                    'fill' => array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'color' => array('rgb' => 'FF0000')
                                    )
                                )
                        );
                    } else if ($row->max_level >= 3){
                        $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $row->level3details->employeefullname." - ".$row->level3details->employeecode);
                    }
                    if ($level_4 == "Y") {
                        $objPHPExcel->getActiveSheet()->getStyle('I' . $rowCount . ':I' . $rowCount)->applyFromArray(
                                array(
                                    'fill' => array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'color' => array('rgb' => 'FF0000')
                                    )
                                )
                        );
                    } else if ($row->max_level >= 4) {
                        $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $row->level4details->employeefullname." - ".$row->level4details->employeecode);
                    }
                    if ($level_5 == "Y") {
                        $objPHPExcel->getActiveSheet()->getStyle('J' . $rowCount . ':J' . $rowCount)->applyFromArray(
                                array(
                                    'fill' => array(
                                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                        'color' => array('rgb' => 'FF0000')
                                    )
                                )
                        );
                    } else if ($row->max_level >= 5){
                        $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $row->level5details->employeefullname." - ".$row->level5details->employeecode);
                    }
                    // $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount,$level_1 );
                    $end = $rowCount;
                    $rowCount++;
                    $number++;
                }
            }
        }
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Level');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Level.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public function actionPrintEosClearancetExcel() {
        $employee_id = $_GET['employee_id'];
        $branch_id = $_GET['branch'];
        $condition = '1=1';
        if ($employee_id != '') {
            $condition .= ' AND employee_id= "' . $employee_id . '"';
        }
        if ($branch_id != '') {
            $condition .= ' AND employeedetail.branch_or_sponsor_id= "' . $branch_id . '"';
        }
        $model_clearance = HrEmployeeEosClearance::model()->with('employeedetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'functionality_id,employeedetail.de_first_name asc'));
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getActiveSheet()->getRowDimension(0)->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Employee Code')
                ->setCellValue('C1', 'Employee Name')
                ->setCellValue('D1', 'Apply Date')
                ->setCellValue('E1', 'Status');
        $objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true)->setSize(12);
        if (!empty($model_clearance)) {
            $rowCount = 2;
            $number = 1;
            $objPHPExcel->getActiveSheet()
                    ->getStyle('A1:E1')
                    ->applyFromArray(
                            array(
                                'fill' => array(
                                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                    'color' => array('rgb' => 'D3D3D3')
                                )
                            )
            );
            foreach ($model_clearance as $k => $row) {
                
                    $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $row->employeedetail->employeecode);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount,$row->employeedetail->employeefullname);
                    $apply_date = '';
                    if ($row->apply_date != '0000-00-00' && $row->apply_date!= '') {
                        $apply_date = date("d/m/Y", strtotime($row->apply_date));
                    }
                    $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $apply_date);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, HrEmployeeEosClearance::getClearanceStatus($row->status));
            }
                    $end = $rowCount;
                    $rowCount++;
                    $number++;
        }  
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('EOS Clearance');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="EOS Clearance.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public function actionPrintNotPunchExcel() {
        $from_date = $_GET['punch_from_date'];
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $sort_type = $_GET['sort_type'];
        if ($from_date != '') {
            $from_date = date('Y-m-d', strtotime(str_replace('/', '-', $from_date)));
        }
        $criteria = new CDbCriteria;
        $criteria->with = array('attendances');
        $criteria->together = true;
        $criteria->addCondition('t.isActive= "Y"');
        $criteria->addCondition('date_join <= :date_from');
        if ($sort_type == 2) {
            $criteria->addCondition('EXISTS (SELECT 1 FROM erp_hr_employee_attendance ea WHERE ea.employee_id = t.id AND ea.attendance_date = "' . $from_date . '" AND (login_time="" OR  logout_time="" OR login_time=logout_time) AND ea.status=1)');
        }else{
            $criteria->addCondition('NOT EXISTS (SELECT 1 FROM erp_hr_employee_attendance ea WHERE ea.employee_id = t.id AND ea.attendance_date = :date_from AND ea.status!=2)');
        }
        $criteria->params[':date_from'] = $from_date;
        if (!empty($employee_id)) {
            $criteria->addCondition('t.id = :employee_id');
            $criteria->params[':employee_id'] = $employee_id;
        }
        if (!empty($branch_id)) {
            $criteria->addCondition('t.branch_or_sponsor_id = :attend_emp_sponsor');
            $criteria->params[':attend_emp_sponsor'] = $branch_id;
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $criteria->addCondition('t.reporting_manager = :reporting_manager');
            $criteria->params[':reporting_manager'] = $model_user->department_head_id;
        }
        $criteria->order = 't.de_first_name';
        $model_punch = Employee::model()->findAll($criteria);
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(40);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Branch')
                ->setCellValue('C1', 'Biometric No')
                ->setCellValue('D1', 'Employee Code')
                ->setCellValue('E1', 'Employee Name')
                ->setCellValue('F1', 'Reporting Manager');
        $objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true)->setSize(12);
        $rowCount = 2;
        $number = 1;
        $objPHPExcel->getActiveSheet()
                ->getStyle('A1:F1')
                ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D3D3D3')
                            )
                        )
        );
        if (!empty($model_punch)) {
            foreach ($model_punch as $j => $detail) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $detail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $detail->employee_biometric_code, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->getStyle('C' . $rowCount . ':C' . $rowCount . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $detail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $detail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $detail->reportingmanager->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                $rowCount++;
                $number++;
            }
        }
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Not Punch Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Not Punch Details.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public function actionEmployeeLeaveBalanceExcel() {
        $model = new EmployeeLeave();
        $employee_id = $_GET['employee_id'];
        $leavetype = $_GET['leavetype'];
        $branch_id = $_GET['branch_id'];
        $model_setting = HrGenerelSettings::model()->find();
        $year = date("Y");
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $year = $year - 1;
        }
        $condition = "employeedetail.branch_or_sponsor_id='".$branch_id."' AND leave_year='".$year."'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if($employee_id!=''){
            $condition.= " AND t.employee_id= '".$employee_id."'";
        }
        if($leavetype!=''){
            $condition.= " AND t.leave_type= '".$leavetype."'";
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $model = $model->with('employeedetail','leavetype')->findAll(array('condition' => $condition));
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(45);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Emp.Code')
                ->setCellValue('C1', 'Employee Name')
                ->setCellValue('D1', 'Leave Type')
                ->setCellValue('E1', 'Leave Opening')
                ->setCellValue('F1', 'Current Balance');
        $objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true)->setSize(12);
        $startRow=$rowCount = 2;
        $number = 1;
        $objPHPExcel->getActiveSheet()
                ->getStyle('A1:I1')
                ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D3D3D3')
                            )
                        )
        );
        
        if (!empty($model)) {
            foreach ($model as $empdetail) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $empdetail->employeedetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $empdetail->employeedetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $empdetail->leavetype->leave_name, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $empdetail->leave_opening, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $empdetail->leave_current_balance, PHPExcel_Cell_DataType::TYPE_STRING);
                $end = $rowCount;
                $rowCount++;
                $number++;
            }
        }
        $objPHPExcel->getActiveSheet()
                    ->getStyle("E{$startRow}:F{$end}")
                    ->getNumberFormat()
                    ->setFormatCode('0.00');
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Leave Balance Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Leave Balance Details.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }

}
