<?php

class EosdetailsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'getEosDetails', 'EmployeeeosCalculation', 'maseos', 'SaveMasEOSClearance', 'Mascreate', 'getEosDetails', 'Create', 'Employeeforeos', 'SaveemployeeEos', 'getEosDetails', 'GetList', 'clearanceapproval', 'GetClearanceforApproval', 'eosapprovalbylm', 'downloaddocument', 'deleteeoscleaarnce', 'printeoscleaarncedetails',
                    'EosrequestList', 'GeteosRequest', 'ApproveRequest', 'SaveApproveRequest', 'vieweosdetails', 'ResignationDocument', 'HrexitDocument', 'EosclearanceDocument', 'downloadeosdocument', 'UploadeosDocuments', 'eosclearancelist', 'GetClearanceList', 'eosclearanceview', 'saveeosclearanceApproveReject',
                    'UploadDocument', 'saveUploadDocument', 'Disable', 'RemovelineItem', 'Printeosdetails', 'getbranchemployee', 'deleteeos'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionMaseos() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_eos_clearance_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('mas_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new MasEOSClearance();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'clearance_name',
            2 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (clearance_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $disable_button = $edit_button = 0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_eos_clearance_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_button = 1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_eos_clearance_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button = 1;
            }
            if ($row['isActive'] == 'Y') {
                $status = "Active";
            } else {
                $status = "Not Active";
            }
            $rowData[] = array($m, $row['clearance_name'], $status, array('id' => $row->id, "status" => $row->isActive, 'edit_button' => $edit_button, 'disable_button' => $disable_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionMascreate() {
        $model = new MasEOSClearance();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('mas_create', array('model' => $model), false, true);
    }

    public function actionSaveMasEOSClearance() {
        if (isset($_POST['MasEOSClearance'])) {
            $model = new MasEOSClearance();
            if (!empty($_POST['MasEOSClearance']['id'])) {
                $model = $model->findByPk($_POST['MasEOSClearance']['id']);
                $model->scenario = 'update';
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $model_max_level = MasEOSClearance::model()->find(array('select' => 'MAX(level) as level', 'condition' => 'level>0'));
                if ($model_max_level->level == '') {
                    $model->level = 1;
                }
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $model_max_level = MasEOSClearance::model()->find(array('select' => 'MAX(level) as level', 'condition' => 'level>0'));
                if (!empty($model_max_level) && $model_max_level->level > 0) {
                    $model->level = $model_max_level + 1;
                } else {
                    $model->level = 1;
                }
            }
            $model->clearance_name = $_POST['MasEOSClearance']['clearance_name'];
            $model->isActive = $_POST['MasEOSClearance']['isActive'];
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    //Modified on 17/8/2018
    public function actionIndex() {
        $this->render('index');
    }

    public function actiongetEosDetails() {
        $id = Yii::app()->request->getparam("empid");
        $date_leaving = Yii::app()->request->getparam("date_leaving");
        $date_leaving = date("Y-m-d", strtotime(str_replace('/', '-', $date_leaving)));
        $modelemployee = Employee::model()->findbyPK($id);
        if ($modelemployee->date_join != '' && $modelemployee->date_join != "0000-00-00") {
            $d1 = strtotime($modelemployee->date_join);
            $d2 = strtotime($date_leaving);
            $datediff = $d2 - $d1;
            $service_days = $datediff / (60 * 60 * 24);
            $years = round($service_days / 365, 1);
            $date1 = new DateTime($modelemployee->date_join);
            $date2 = new DateTime($date_leaving);
            $dd = date_diff($date1, $date2);
            $dayss = 'Day';
            if ($dd->d > 1) {
                $dayss = 'Days';
            }
            $service_period = "$dd->y Yrs $dd->m Month $dd->d $dayss";
            $this->renderPartial('employee_listeos_details', array('id' => $id, 'service_days' => $service_period, 'modelemployee' => $modelemployee, 'date_leaving' => $date_leaving,), false, true);
        } else {
            $this->render('employee_eos_error');
        }
    }

    public function actionEmployeeeosCalculation() {
        $id = Yii::app()->request->getparam("employee_id");
        $branch_or_sponsor_id = Yii::app()->request->getparam("branch");
        $notice_period = Yii::app()->request->getparam("notice_period");
        $date_leaving = Yii::app()->request->getparam("date_leaving");
        $releaving_type = Yii::app()->request->getparam("releaving_type");
        $rule_type = Yii::app()->request->getparam("eos_rule");
        $lop = Yii::app()->request->getparam("lop");
        $leaving_date = str_replace('/', '-', $date_leaving);
        $date_leave = date("Y-m-d", strtotime($leaving_date));
        $leaving_year = date("Y", strtotime($date_leave));
        $month_eos = date("m", strtotime($date_leave));
        $modelemployee = Employee::model()->findbyPK($id);
        //Service Period
        $d1 = strtotime($modelemployee->date_join);
        $d2 = strtotime($date_leave);
        $datediff = $d2 - $d1;
        $service_days = $datediff / (60 * 60 * 24) + 1;
        $years = round($service_days / 365, 1);
        $date1 = new DateTime($modelemployee->date_join);
        $date2 = new DateTime($date_leave);
        $dd = date_diff($date1, $date2);
        $dayss = 'Day';
        if ($dd->d > 1) {
            $dayss = 'Days';
        }
        $service_period = "$dd->y Yrs $dd->m Month $dd->d $dayss";
        $eos_year = $dd->y;
        $eos_month = $dd->m / 12;
        $eos_days = $dd->d / 365;
        //Salary Details
        $model_salary_details = EmployeeSalary::model()->findAll(array('condition' => 'employee_id="' . $id . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00")) AND isActive="Y"'));
        //Start Gratuity Calculation
        $gratuityamount = 0.00;
        $gratuity_year_details = array();
        if ($rule_type == 1) {
            if ($years > 5) {
                //Gratuity For First Five Years
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from="1" AND gratuity_period_to="5"'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount / 30);
                $balance_eos_year = $eos_year - 5;
                $gross_amt_1 = ($days * $salary_per_day * 5);
                $gratuity_year_details[0]['year'] = 'First 5 years';
                $gratuity_year_details[0]['amount'] = $gross_amt_1;
                $gratuity_year_details[0]['employee_id'] = $id;
                $gratuity_year_details[0]['gratuity_id'] = $model_gratuity->id;
                //Gratuity After Five Years
                if ($balance_eos_year > 0) {
                    //Gratuity After Five Years
                    $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from>=5'));
                    $days = $model_gratuity->gratuity_provision_days;
                    $salary_types = explode(',', $model_gratuity->salary_type);
                    $salaryamount = 0.00;
                    $gratuity = 0.00;
                    for ($i = 0; $i < count($salary_types); $i++) {
                        $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                        if (!empty($model_salary)) {
                            $salaryamount += $model_salary->amount;
                        }
                    }
                    $salary_per_day = ($salaryamount / 30);
                    $gross_amt_2 = ($days * $salary_per_day * $balance_eos_year) + ($days * $salary_per_day * $eos_month) + ($days * $salary_per_day * $eos_days);
                    $gratuity_year_details[1]['year'] = '6th year onward';
                    $gratuity_year_details[1]['amount'] = $gross_amt_2;
                    $gratuity_year_details[1]['employee_id'] = $id;
                    $gratuity_year_details[1]['gratuity_id'] = $model_gratuity->id;
                } else if ($eos_month > 0 || $eos_days > 0) {
                    $gross_amt_2 = ($days * $salary_per_day * $eos_month) + ($days * $salary_per_day * $eos_days);
                    $gratuity_year_details[1]['year'] = 'After 5 year';
                    $gratuity_year_details[1]['amount'] = $gross_amt_2;
                    $gratuity_year_details[1]['employee_id'] = $id;
                    $gratuity_year_details[1]['gratuity_id'] = $model_gratuity->id;
                }
                $gratuityamount = ceil($gross_amt_1 + $gross_amt_2);
            } else {
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and days_from<="' . $service_days . '" AND days_to>="' . $service_days . '"'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount / 30);
                $gross_amount = ($days * $salary_per_day * $eos_year) + ($days * $salary_per_day * $eos_month) + ($days * $salary_per_day * $eos_days);
                $gratuityamount = ceil($gross_amount);
                //Gratuity Less than 5 Year
                $gratuity_slab = '';
                if ($model_gratuity->gratuity_period_from == 0) {
                    $gratuity_slab = '0 to 1 year';
                } else if ($model_gratuity->gratuity_period_from == 1) {
                    $gratuity_slab = '1 to 5 years';
                }
                $gratuity_year_details[0]['year'] = $gratuity_slab;
                $gratuity_year_details[0]['amount'] = $gratuityamount;
                $gratuity_year_details[0]['employee_id'] = $id;
                $gratuity_year_details[0]['gratuity_id'] = $model_gratuity->id;
            }
        } else if ($rule_type == 2) {
            if ($years >= 5) {
                //Gratuity For First Five Years
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from="1" AND gratuity_period_to="5"'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount * 12 / 365);
                $balance_eos_year = $eos_year - 5;
                $gross_amt_1 = ($days * $salary_per_day * 5);
                $gratuity_year_details[0]['year'] = 'First 5 years';
                $gratuity_year_details[0]['amount'] = $gross_amt_1;
                $gratuity_year_details[0]['employee_id'] = $id;
                $gratuity_year_details[0]['gratuity_id'] = $model_gratuity->id;
                //Gratuity After Five Years
                if ($balance_eos_year > 0 || $eos_month > 0 || $eos_days > 0) {
                    //Gratuity After Five Years
                    $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from>=5'));
                    $days = $model_gratuity->gratuity_provision_days;
                    $salary_types = explode(',', $model_gratuity->salary_type);
                    $salaryamount = 0.00;
                    $gratuity = 0.00;
                    for ($i = 0; $i < count($salary_types); $i++) {
                        $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                        if (!empty($model_salary)) {
                            $salaryamount += $model_salary->amount;
                        }
                    }
                    $salary_per_day = ($salaryamount * 12 / 365);
                    $gross_amt_2 = ($days * $salary_per_day * $balance_eos_year) + ($days * $salary_per_day * $eos_month) + ($days * $salary_per_day * $eos_days);
                    $gratuity_year_details[1]['year'] = '6th year onward';
                    $gratuity_year_details[1]['amount'] = $gross_amt_2;
                    $gratuity_year_details[1]['employee_id'] = $id;
                    $gratuity_year_details[1]['gratuity_id'] = $model_gratuity->id;
                }
                $gratuityamount = ceil($gross_amt_1 + $gross_amt_2);
            } else {
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and days_from<="' . $service_days . '" AND days_to>="' . $service_days . '"'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount * 12 / 365);
                $tot_days_eos = ($service_days / 365);
                $gross_amount = ($days * $salary_per_day * $tot_days_eos);
//                $gross_amount=($days*$salary_per_day*$eos_year)+($days*$salary_per_day*$eos_month)+($days*$salary_per_day*$eos_days);
                $gratuityamount = ceil($gross_amount);
                //Gratuity Less than 5 Year
                $gratuity_slab = '';
                if ($model_gratuity->gratuity_period_from == 0) {
                    $gratuity_slab = '0 to 1 year';
                } else if ($model_gratuity->gratuity_period_from == 1) {
                    $gratuity_slab = '1 to 5 years';
                }
                $gratuity_year_details[0]['year'] = $gratuity_slab;
                $gratuity_year_details[0]['amount'] = $gratuityamount;
                $gratuity_year_details[0]['employee_id'] = $id;
                $gratuity_year_details[0]['gratuity_id'] = $model_gratuity->id;
            }
        } else if ($rule_type == 3) { //Jafza giving 30 for all employees worked after 5 years
            if ($years >= 5) {
                //Gratuity
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from>=5'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount * 12 / 365);
                $tot_days_eos = ($service_days / 365);
                $gross_amt = ($days * $salary_per_day * $tot_days_eos);
                $gratuity_year_details[0]['year'] = $service_period;
                $gratuity_year_details[0]['amount'] = $gross_amt;
                $gratuity_year_details[0]['employee_id'] = $id;
                $gratuity_year_details[0]['gratuity_id'] = $model_gratuity->id;
                $gratuityamount = round($gross_amt);
            } else {
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from="1" AND gratuity_period_to="5"'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount * 12 / 365);
                $tot_days_eos = ($service_days / 365);
                $gross_amt = ($days * $salary_per_day * $tot_days_eos);
                $gratuityamount = round($gross_amt);
                $gratuity_year_details[0]['year'] = $service_period;
                $gratuity_year_details[0]['amount'] = $gratuityamount;
                $gratuity_year_details[0]['employee_id'] = $id;
                $gratuity_year_details[0]['gratuity_id'] = $model_gratuity->id;
            }
        }
        //End Gratuity Calculation
        //End Gratuity Per Year
        //Start Notice Period Salary
      $notice_period_salary = 0.00;
        if($notice_period>0){
            $model_notice_period = HrMasEosNoticeperiod::model()->findbyPK($notice_period);
            if(!empty($model_notice_period)){
                $emp_salary_amount = 0;
                $per_day_salary = 0;
                $model_total_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $id . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                if ($model_total_salary->amount > 0) {
                    $emp_salary_amount = $model_total_salary->amount;
                    $per_day_salary = $model_total_salary->amount / 30;
                    
                }
                $notice_period_value=$model_notice_period->month_day_value;
                if($model_notice_period->type=='D'){
                    $notice_period_salary = round($notice_period_value * $per_day_salary, 2);
                }else if($model_notice_period->type=='M'){
                    $notice_period_salary = round($notice_period_value * $emp_salary_amount, 2);
                }
            }
        }
        //End Notice Period Salary
        //Start Loan Amount Calculation
        $loan_amount = 0.00;
        $total_loan_amount = 0.00;
        $monthly_payment = 0.00;
        $total_loan_paid = 0.00;
        $loan_pending = 0.00;
        $model_loan = EmployeeLoanDetail::model()->findAll(array('condition' => '(loan_status="14" OR loan_status="15") and isActive="Y" AND employee_id="' . $id . '"'));
        if (!empty($model_loan)) {
            foreach ($model_loan as $key_1 => $loan_detail) {
                $monthly_payment = $loan_detail->loan_monthly_payment;  //Monthly Payment
                $total_loan_amount = $loan_detail->loan_amount; //Total Loan Amount
                $total_loan_paid = $loan_detail->loan_repayment;  //Total loan paid
                $loan_pending = $total_loan_amount - $total_loan_paid;
                $loan_amount += $loan_pending;
            }
        }
        //End loan amount Calculation 
        //Salary Advance Amount
        $salary_advance = 0.00;
        $model_salary_advance = EmployeeSalaryAdvance::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $id . '" and (advance_payment_status="14" OR advance_payment_status="15")'));
        if ($model_salary_advance->amount > 0) {
            $salary_advance = $model_salary_advance->amount;
        }
        //End Salary Advance Amount   
        //Salary Calculation
        $model_last_salary = SalarySlip::model()->find(array('select' => 'max(salary_processing_id) as salary_processing_id', 'condition' => 'employee_id="' . $id . '"'));
        $salary_days = 0.00;
        $next_payment_date = "";
        $salary_payment_date = "";
        if ($model_last_salary->salary_processing_id > 0) {
            $model_last_processing = SalaryProcessing::model()->findbyPK($model_last_salary->salary_processing_id);
            $last_payment_date = $model_last_processing->payroll_enddate;
            $next_payment_date = $salary_payment_date = date('Y-m-d', strtotime('+1 days', strtotime($last_payment_date)));
            $date1_convert = strtotime($next_payment_date);
            $date2_convert = strtotime($date_leave);
            $salary_days = $date2_convert - $date1_convert;
            $salary_days = floor($salary_days / (60 * 60 * 24) + 1);
        } else {
            //Master Salary Lock details
            $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
            if (!empty($model_lock_month)) {
                $payroll_month = $model_lock_month->payroll_month;
                $payroll_year = $model_lock_month->payroll_year;
                if ($payroll_month == 12) {
                    $payroll_year += 1;
                }
                $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                $payroll_start_day = $model_lock_days->payroll_start_day;
                $next_payroll_month = $payroll_month;
                if ($payroll_start_day > 1) {
                    if ($payroll_month == 12) {
                        $payroll_month = 1;
                    }
                    $next_payroll_month = $payroll_month + 1;
                }
                if ($payroll_start_day == 1) {

                    if ($payroll_month == 12) {
                        $payroll_month = 1;
                    } else {
                        $payroll_month += 1;
                    }
                    $default_start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                } else {
                    $default_start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                }
                if (strtotime($default_start_date) > strtotime($modelemployee->date_join)) {
                    $salary_payment_date = $default_start_date;
                } else {
                    $salary_payment_date = $next_payment_date;
                }
                $date1_convert = strtotime($salary_payment_date);
                $date2_convert = strtotime($date_leave);
                $salary_days = $date2_convert - $date1_convert;
                $salary_days = floor($salary_days / (60 * 60 * 24) + 1);
            }
        }
        $salary_start_date = $salary_payment_date;
        $employee_salary = 0.00;
        $employee_per_day_salary = 0.00;
        $arr_salary_detail = array();
        if ($salary_payment_date != '' & $salary_payment_date != '0000-00-00') {
            $model_salary_details_1 = EmployeeSalary::model()->with('salary')->findAll(array('condition' => 'salary.salary_occurence="2" and employee_id="' . $id . '" AND (("' . $salary_payment_date . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $salary_payment_date . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
            foreach ($model_salary_details_1 as $key => $salarydetail) {
                $employee_salary += $salarydetail->amount;
            }
            $date_con_1 = strtotime($salary_payment_date);
            $salary_payment_date_last = date('Y-m-t');
            $date_con_2 = strtotime($salary_payment_date_last);
            $total_working_day = $date_con_2 - $date_con_1;
            $total_working_days = floor($total_working_day / (60 * 60 * 24)) + 1;
            $days = $total_working_days;
            if ($days > 0) {
                $employee_per_day_salary = $employee_salary / $days; //Employee Per day salary
            }
            if ($salary_days > 0) {
                $employee_salary = round($employee_per_day_salary * $salary_days, 2);
            } else {
                $employee_salary = 0.00;
            }
        }
        //Start Leave Salary Calculation
        $uncalculated_leave_count = 0.00;
        $model_leave_settled = EmployeeLeavesettlement::model()->find(array('condition' => 'employee_id ="' . $id . '" and status="1"'));
        $leave_salary = 0.00;
        if (empty($model_leave_settled)) {
            $model_leave_type = MasLeave::model()->findAll(array('condition' => 'isActive =  "Y" and encashable="Y" AND branch_id="' . $modelemployee->branch_or_sponsor_id . '"'));
            $leave_count = $deducted_leave_count = $encashed_leave = 0;
            foreach ($model_leave_type as $key => $value) {
                $model_leave = EmployeeLeave::model()->find(array('select' => 'leave_current_balance', 'condition' => 'employee_id="' . $id . '" AND leave_type="' . $value->id . '" AND leave_year="' . date('Y') . '"'));
                if (!empty($model_leave) && $model_leave->leave_current_balance > 0) {
                    $leave_count += $model_leave->leave_current_balance;
                }
                if ($salary_days > 0) {
                    if ($value->leave_type == 1) {
                        $inc_value = 0;
                        if ($years >= 10) {
                            $inc_value = $value->leave_days_above_10;
                        } else if ($years >= 5) {
                            $inc_value = $value->leave_days_above_5;
                        } else if ($years >= 1) {
                            $inc_value = $value->leave_days_above_1;
                        } else {
                            $inc_value = $value->leave_days;
                        }
                        $lve_val = ($inc_value * 12) / 365;
                        $uncalculated_leave_count = round($salary_days * $lve_val, 2);
                    }
                }
                if ($month_eos < 12 && $leaving_year == date('Y')) {
                    $balance_month = 12 - $month_eos;
                    if ($value->leave_type == 2) {
                        $inc_value = 0;
                        if ($years >= 10) {
                            $inc_value = $value->leave_days_above_10;
                        } else if ($years >= 5) {
                            $inc_value = $value->leave_days_above_5;
                        } else if ($years >= 1) {
                            $inc_value = $value->leave_days_above_1;
                        } else {
                            $inc_value = $value->leave_days;
                        }
                        $deducted_leave_count += round((($inc_value / 12) * $balance_month), 2);
                    }
                }
            }
            if ($deducted_leave_count > 0) {
                $leave_count = $leave_count - $deducted_leave_count;
            }
            $encashed_leave = $leave_count;
            $leave_count += $uncalculated_leave_count;
            $model_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'consider_leave_settlement="Y" and employee_id="' . $id . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
            if (!empty($model_salary) && $model_salary->amount > 0) {
                $salary_amount = $model_salary->amount;
                $employee_per_day_salary = $salary_amount / 30;
                $leave_salary = round($leave_count * $employee_per_day_salary, 2);
            }
        }
        if ($service_days < 180) {
            $leave_salary = 0.00;
        }
        //End Leave Salary Calculation
        //Leave Amount Calculation
        $leave_count = 0;
        $leave_deduction_amount = 0.00;
        $model_master_leave = MasLeave::model()->findAll(array('condition' => 'salary_deduction="Y" AND branch_id="' . $modelemployee->branch_or_sponsor_id . '"'));
        foreach ($model_master_leave as $key => $value) {
            $model_master_leave = EmployeeAttendance::model()->with('leave')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id="' . $id . '" AND attendance_date>="' . $salary_payment_date . '" AND attendance_date<="' . $date_leave . '" AND status="3" AND leave.leave_type="' . $value->id . '"'));
            $leave_count += $model_master_leave->id;
        }
        //Absent Salary Deduction
        if ($salary_payment_date != '' & $salary_payment_date != '0000-00-00') {
            $model_absent = EmployeeAttendance::model()->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $id . ' AND attendance_date>="' . $salary_payment_date . '" AND attendance_date<="' . $date_leave . '" AND status="2"'));
            if ($model_absent->id > 0) {
                $leave_count += $model_absent->id;
            }
        }
        //End Absent calculation
        $leave_deduction_amount = round($employee_per_day_salary * $leave_count, 2);
        //End leave calculation
        //Overtime Calculation

        $overtime_work = "00:00:00";
        $overtime_amount = 0.00;
        $normal_overime_time_detail = "00:00:00";
        $holiday_overime_time_detail = "00:00:00";
        $weekend_overime_time_detail = "00:00:00";
        if ($modelemployee->overtime == "Y") {
            //Normal overtime
            $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`))) As normal_overtime', 'condition' => 'employee_id="' . $modelemployee->id . '" AND attendance_date>="' . $salary_payment_date . '" AND attendance_date<="' . $date_leave . '"'));
            // $overtime_work = $model_attendance->normal_overtime;
            if ($model_attendance->normal_overtime != "00:00:00") {
                $normal_overime_time_detail = $model_attendance->normal_overtime;
                $normal_overtime = explode(':', $model_attendance->normal_overtime);
                $n_overtime = $normal_overtime[0];
                //Overtime Salary
                $model_master_normal = MasOverTime::model()->findByPk(1);
                $each_normal_ot = explode(',', $model_master_normal->salary);
                $normal_overtime_salary = 0.00;
                foreach ($each_normal_ot as $value_1) {
                    $model_normalovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $modelemployee->id . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                    $normal_overtime_salary += $model_normalovertime_salary->amount;
                }

                $normal_ot_salary_per_day = round($normal_overtime_salary / 30, 2);  //Per day salary for overtime 
                //Salary Per hour
                $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($modelemployee->branch_or_sponsor_id);
                $working_hours_second = "";
                if ($model_company_shift->branch_working_hours != '00:00:00') {
                    //$working_time=date("H:i",strtotime($model_company_shift->branch_working_hours));
                    // $working_hours_second = strtotime($working_time); //In second
                    $working_time = explode(':', $model_company_shift->branch_working_hours);
                    $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                } else {
                    $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                    $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                    $original_start_time = strtotime($original_start_time);
                    $original_stop_time = strtotime($original_stop_time);
                    $working_hours_second = ($original_stop_time - $original_start_time); //In second
                }
                $salary_per_second_normal = $normal_ot_salary_per_day / $working_hours_second;
                $salary_per_hour_normal = $salary_per_second_normal * 3600;
                //Overtimesalary
                $salary_overtime_normal = $salary_per_hour_normal * $model_master_normal->times;
                $normal_salary_per_min = ($salary_overtime_normal / 60);
                $overtime_amount += round((float) $n_overtime * (float) $salary_overtime_normal, 2);
                $overtime_amount += round((float) $normal_overtime[1] * (float) $normal_salary_per_min, 2);
            }
            //End Normal Overtime
            //Start Holiday Overtime
            $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`holiday_overtime`))) As holiday_overtime', 'condition' => 'employee_id="' . $modelemployee->id . '" AND attendance_date>="' . $salary_payment_date . '" AND attendance_date<="' . $date_leave . '"'));
            //$overtime_work = $model_attendance->holiday_overtime;
            if ($model_attendance->holiday_overtime != "00:00:00") {
                $holiday_overime_time_detail = $model_attendance->holiday_overtime;
                $holiday_overtime = explode(':', $model_attendance->holiday_overtime);
                $h_overtime = $holiday_overtime[0];

                //Overtime Salary                            
                $model_master_holiday = MasOverTime::model()->findByPk(2);
                $each_holiday_ot = explode(',', $model_master_holiday->salary);
                $holiday_overtime_salary = 0.00;
                foreach ($each_holiday_ot as $value_1) {
                    $model_holidayovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $modelemployee->id . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                    $holiday_overtime_salary += $model_holidayovertime_salary->amount;
                }
                $holiday_ot_salary_per_day = $holiday_overtime_salary / 30;  //Per day salary for overtime
                //Salary Per hour
                $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($modelemployee->branch_or_sponsor_id);
                $working_hours_second = "";
                if ($model_company_shift->branch_working_hours != '00:00:00') {
//                            $working_time=date("H:i",strtotime($model_company_shift->branch_working_hours));
//                            $working_hours_second = strtotime($working_time); //In second
                    $working_time = explode(':', $model_company_shift->branch_working_hours);
                    $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                } else {
                    $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                    $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                    $original_start_time = strtotime($original_start_time);
                    $original_stop_time = strtotime($original_stop_time);
                    $working_hours_second = ($original_stop_time - $original_start_time); //In second
                }
                $salary_per_second_holiday = $holiday_ot_salary_per_day / $working_hours_second;
                $salary_per_hour_holiday = $salary_per_second_holiday * 3600;
                //Overtimesalary
                $salary_overtime_holiday = $salary_per_hour_holiday * $model_master_holiday->times;
                $holiday_salary_per_min = ($salary_overtime_holiday / 60);
                $overtime_amount += round((float) $h_overtime * (float) $salary_overtime_holiday, 2);
                $overtime_amount += round((float) $holiday_overtime[1] * (float) $holiday_salary_per_min, 2);
            }
            //End Holiday Overtime
            //Weekend Overtime
            $model_attendance_weekend = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`weekend_overtime`))) As weekend_overtime', 'condition' => 'employee_id="' . $modelemployee->id . '" AND attendance_date>="' . $salary_payment_date . '" AND attendance_date<="' . $date_leave . '"'));
            if ($model_attendance_weekend->weekend_overtime != "00:00:00") {
                $weekend_overime_time_detail = $model_attendance_weekend->weekend_overtime;
                $weekend_overtime = explode(':', $model_attendance_weekend->weekend_overtime);
                $w_overtime = $weekend_overtime[0];

                //Overtime Salary                            
                $model_master_weekend = MasOverTime::model()->findByPk(3);
                $each_weekend_ot = explode(',', $model_master_weekend->salary);
                $weekend_overtime_salary = 0.00;
                foreach ($each_weekend_ot as $value_1) {
                    $model_weekendovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $modelemployee->id . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                    $weekend_overtime_salary += $model_weekendovertime_salary->amount;
                }
                $weekend_ot_salary_per_day = $weekend_overtime_salary / 30;  //Per day salary for overtime 
                //Salary Per hour
                $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($modelemployee->branch_or_sponsor_id);
                $working_hours_second = "";
                if ($model_company_shift->branch_working_hours != '00:00:00') {
//                            $working_time=date("H:i",strtotime($model_company_shift->branch_working_hours));
//                            $working_hours_second = strtotime($working_time); //In second
                    $working_time = explode(':', $model_company_shift->branch_working_hours);
                    $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                } else {
                    $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                    $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                    $original_start_time = strtotime($original_start_time);
                    $original_stop_time = strtotime($original_stop_time);
                    $working_hours_second = ($original_stop_time - $original_start_time); //In second
                }
                $salary_per_second_weekend = $weekend_ot_salary_per_day / $working_hours_second;
                $salary_per_hour_weekend = $salary_per_second_weekend * 3600;
                //Overtimesalary
                $salary_overtime_weekend = $salary_per_hour_weekend * $model_master_weekend->times;
                $weekend_salary_per_min = ($salary_overtime_weekend / 60);
                $overtime_amount += round((float) $w_overtime * (float) $salary_overtime_weekend, 2);
                $overtime_amount += round((float) $weekend_overtime[1] * (float) $weekend_salary_per_min, 2);
            }
            //End weekend overtime      
        }
        if ($salary_payment_date != '' & $salary_payment_date != '0000-00-00') {
            $model_total_overtime = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`)+time_to_sec(`holiday_overtime`)+time_to_sec(`weekend_overtime`))) As normal_overtime', 'condition' => 'employee_id="' . $modelemployee->id . '" AND attendance_date>="' . $salary_payment_date . '" AND attendance_date<="' . $date_leave . '"'));
            $overtime_work = $model_total_overtime->normal_overtime;
        }
        //End Overtime Calculation       
        //Pension Calculation
        $pension_salary = 0.00;
        $employee_percent_amt = 0.00;
        $company_percent_amt = 0.00;
        $total_pension_amount = 0.00;
        if ($modelemployee->have_pension == 1) {
            $model_master_pension = MasPension::model()->find(array('condition' => 'nationality="' . $modelemployee->nationality . '"'));
            if (!empty($model_master_pension)) {
                $salary_type = explode(',', $model_master_pension->salary_type);
                if (count($salary_type) > 1) {
                    foreach ($salary_type as $value_1) {
                        $model_pension_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $modelemployee->id . '" AND (("' . $next_payment_date . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $next_payment_date . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                        $pension_salary += $model_pension_salary->amount;
                    }
                } else {
                    $model_pension_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $modelemployee->id . '" AND (("' . $next_payment_date . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $next_payment_date . '" AND valid_to="0000-00-00")) AND salary_type="' . $model_pension_salary->salary_type . '" AND isActive="Y"'));
                    $pension_salary = $model_pension_salary->amount;
                }
                $employee_percent_amt = (($pension_salary * $model_master_pension->employee_percent) / 100);
                $company_percent_amt = (($pension_salary * $model_master_pension->company_percent) / 100);
                $total_pension_amount = $employee_percent_amt + $company_percent_amt;
            }
        }
        //End Pension Calculation
        //Total Addition
        $total_additions = $overtime_amount;
        //Total Deduction
        $total_deductions = $leave_deduction_amount + $employee_percent_amt;
        $total_salary_amount = ($employee_salary + $total_additions) - $total_deductions;
        $total_addition_amount = round($leave_salary + $overtime_amount + $employee_salary + $gratuityamount + $notice_period_salary, 2);
        $total_deductions_amount = round($loan_amount + $salary_advance + $leave_deduction_amount + $employee_percent_amt, 2);
        $total_amount = round($total_addition_amount - $total_deductions_amount, 2);
        //Assets
        $model_asset = EmployeeAsset::model()->findAll(array('condition' => 'employee_id="' . $id . '" AND asset_status="1"'));
        $model_master_clearance = MasEOSClearance::model()->findAll(array('condition' => 'isActive="Y"'));
        $model_eos = new EmployeeEOS();
        $model_eos_details = new EmployeeEOSDetails();
        $model_eos_clearance = new EmployeeEosClearanceDetails();
        $model_eos_gratuity_details = new EosGratuityDetails();
        $model_eos_payment_details = array(new EmployeeEosPayment());
        $this->renderPartial('employee_eos_details',
                array(
                    'salary_start_date' => $salary_start_date,
                    'date_leaving' => $date_leave,
                    'total_amount' => $total_amount,
                    'total_deductions_amount' => $total_deductions_amount,
                    'employee_percent_amt' => $employee_percent_amt,
                    'leave_deduction_amount' => $leave_deduction_amount,
                    'total_addition_amount' => $total_addition_amount,
                    'overtime_amount' => $overtime_amount,
                    'employee_salary' => $employee_salary,
                    'salary_advance' => $salary_advance,
                    'loan_amount' => $loan_amount,
                    'notice_period_id' => $notice_period,
                    'notice_period_salary' => $notice_period_salary,
                    'gratuityamount' => $gratuityamount,
                    'leave_salary' => $leave_salary,
                    'model_salary_details' => $model_salary_details,
                    'service_days' => $service_days,
                    'service_period' => $service_period,
                    'date_leaving' => $date_leave,
                    'model_eos' => $model_eos,
                    'model_eos_details' => $model_eos_details,
                    'model_eos_clearance' => $model_eos_clearance,
                    'model_master_clearance' => $model_master_clearance,
                    'modelemployee' => $modelemployee,
                    'model_asset' => $model_asset,
                    'id' => $id,
                    'lop' => $lop,
                    'gratuity_year_details' => $gratuity_year_details,
                    'model_eos_gratuity_details' => $model_eos_gratuity_details,
                    'model_eos_payment_details' => $model_eos_payment_details,
                    'gratuity_rule_id' => $rule_type,
                    'releaving_type' => $releaving_type,
                    'encashed_leave' => $encashed_leave,
                ), false, true);
    }

    public function actionSaveemployeeEos() {
        if (isset($_POST['EmployeeEOS'])) {
            $model = new EmployeeEOS();
            $model->attributes = $_POST['EmployeeEOS'];
            $model->apply_date = date('Y-m-d');
            $model->branch_or_sponsor_id = $_POST['EmployeeEOS']['branch_or_sponsor_id'];
            $model->employee_id = $_POST['EmployeeEOS']['employee_id'];
            $model->gratuity_rule_id = $_POST['EmployeeEOS']['gratuity_rule_id'];
            $model->releaving_type = $_POST['EmployeeEOS']['releaving_type'];
            $model->service_days = $_POST['EmployeeEOS']['service_days'];
            $model->leave_settlement = $_POST['EmployeeEOS']['leave_settlement'];
            $model->leave_encashed_balance = $_POST['EmployeeEOS']['leave_encashed_balance'];
            $model->overtime_salary = $_POST['EmployeeEOS']['overtime_salary'];
            $model->gratuity = $_POST['EmployeeEOS']['gratuity'];
            $model->lop = $_POST['EmployeeEOS']['lop'];
            $model->notice_period_salary = $_POST['EmployeeEOS']['notice_period_salary'];
            $model->employee_salary = $_POST['EmployeeEOS']['employee_salary'];
            $model->addition_others = $_POST['EmployeeEOS']['addition_others'];
            $model->additions = $_POST['EmployeeEOS']['additions'];
            $model->salary_advance = $_POST['EmployeeEOS']['salary_advance'];
            $model->leave_amount = $_POST['EmployeeEOS']['leave_amount'];
            $model->loan = $_POST['EmployeeEOS']['loan'];
            $model->pension_amount = $_POST['EmployeeEOS']['pension_amount'];
            $model->deduction_others = $_POST['EmployeeEOS']['deduction_others'];
            $model->deductions = $_POST['EmployeeEOS']['deductions'];
            $model->total_amount = $_POST['EmployeeEOS']['total_amount'];
            $model->salary_start_date = $_POST['EmployeeEOS']['salary_start_date'];
            $model->date_leaving = $_POST['EmployeeEOS']['date_leaving'];
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $validate = $model->validate();
            $model_hr_settings = HrGenerelSettings::model()->find();
            if ($model_hr_settings->eos_clearance == 'Y') {
                $model_eos_clearance = new HrEmployeeEosClearance();
                $model_eos_clearance->employee_id = $model->employee_id;

                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and functionality_id="14"'));
                $model_eos_clearance->function_type = $model_master_approve_setting->id;
                $model_eos_clearance->max_level = $model_master_approve_setting->max_level;
                $model_eos_clearance->last_approved_level = 0;
                $model_eos_clearance->apply_date = date('Y-m-d');
                $model_eos_clearance->status = 1;
                $model_eos_clearance->created_by = Yii::app()->user->id;
                $model_eos_clearance->created_date_time = date('Y-m-d h:i:s');
                $validate = $model_eos_clearance->validate() && $validate;
            }
            if ($validate) {
                $model->save();
                if ($model_hr_settings->eos_clearance == 'Y') {
                    $model_eos_clearance->eos_id = $model->id;
                    $model_eos_clearance->save();
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="35"'));
                    if (!empty($model_settings)) {
                        if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                            Yii::import('application.modules.hr.controllers.MailController');
                            //    MailController::sendmail(35,$model->employee_id,$model_eos_clearance->id);
                        }
                    }
                }
                //EOS Details
                if ((isset($_POST['EmployeeEOSDetails']))) {
                    foreach ($_POST['EmployeeEOSDetails'] as $i => $items) {
                        $model_eos_details = new EmployeeEOSDetails();
                        $model_eos_details->eos_id = $model->id;
                        $model_eos_details->employee_id = $items['employee_id'];
                        $model_eos_details->salary_id = $items['salary_id'];
                        $model_eos_details->salary_name = $items['salary_name'];
                        $model_eos_details->salary_amount = $items['salary_amount'];
                        $model_eos_details->save();
                    }
                }
                //End EOS Details
                //EOS Gratuity Details
                if ((isset($_POST['EosGratuityDetails']))) {
                    foreach ($_POST['EosGratuityDetails'] as $i => $items) {
                        $model_eos_gratuity_details = new EosGratuityDetails();
                        $model_eos_gratuity_details->eos_id = $model->id;
                        $model_eos_gratuity_details->employee_id = $items['employee_id'];
                        $model_eos_gratuity_details->gratuity_mas_id = $items['gratuity_mas_id'];
                        $model_eos_gratuity_details->payment_period = $items['payment_period'];
                        $model_eos_gratuity_details->amount = $items['amount'];
                        $model_eos_gratuity_details->save();
                    }
                }
                //End EOS Gratuity Details
                //Asset
                if ((isset($_POST['EmployeeAsset']))) {
                    foreach ($_POST['EmployeeAsset'] as $i => $items) {
                        if ($items['id'] > 0 && $items['asset_status'] > 0) {
                            $model_asset = EmployeeAsset::model()->findByPK($items['id']);
                            $model_asset->asset_status = $items['asset_status'];
                            if ($items['asset_date_return'] != '0000-00-00' && $items['asset_date_return'] != '') {
                                $model_asset->asset_date_return = str_replace('/', '-', $items['asset_date_return']);
                                $model_asset->asset_date_return = date("Y-m-d", strtotime($model_asset->asset_date_return));
                            }
                            $model_asset->updated_by = Yii::app()->user->id;
                            $model_asset->updated_date_time = date('Y-m-d h:i:s');
                            $model_asset->save(false);
                        }
                    }
                }
                //End Asset
                //Clearance
                if ($model_hr_settings->eos_clearance == 'N') {
                    if ((isset($_POST['EmployeeEosClearanceDetails']))) {
                        foreach ($_POST['EmployeeEosClearanceDetails'] as $i => $items) {
                            if ($items['clearance_id'] > 0) {
                                $model_clearance = new EmployeeEosClearanceDetails();
                                $model_clearance->eos_id = $model->id;
                                $model_clearance->employee_id = $model->employee_id;
                                $model_clearance->clearance_id = $items['clearance_id'];
                                $model_clearance->clearance_status = $items['clearance_status'];
                                $model_clearance->created_by = Yii::app()->user->id;
                                $model_clearance->created_date_time = date('Y-m-d h:i:s');
                                $model_clearance->save();
                            }
                        }
                    }
                }
                //End Clearance
                //Additions/Deductions
                if ((isset($_POST['EOSAddition']))) {
                    foreach ($_POST['EOSAddition'] as $i => $items) {
                        if ($items['amount'] > 0) {
                            $model_payment = new EmployeeEosPayment();
                            $model_payment->eos_id = $model->id;
                            $model_payment->employee_id = $model->employee_id;
                            $model_payment->mas_payment_type = $items['mas_payment_type'];
                            $model_payment->amount = $items['amount'];
                            $model_payment->created_by = Yii::app()->user->id;
                            $model_payment->created_date_time = date('Y-m-d h:i:s');
                            $model_payment->save(false);
                        }
                    }
                }
                //Deductions
                if ((isset($_POST['EOSDeduction']))) {
                    foreach ($_POST['EOSDeduction'] as $i => $items) {
                        $model_payment = new EmployeeEosPayment();
                        if ($items['amount'] > 0) {
                            $model_payment->eos_id = $model->id;
                            $model_payment->employee_id = $model->employee_id;
                            $model_payment->mas_payment_type = $items['mas_payment_type'];
                            $model_payment->amount = $items['amount'];
                            $model_payment->created_by = Yii::app()->user->id;
                            $model_payment->created_date_time = date('Y-m-d h:i:s');
                            $model_payment->save(false);
                        }
                    }
                }
                //End Clearance
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = json_decode(CActiveForm::validate($model, '', false), true);
                $error1 = json_decode(CActiveForm::validate($model_eos_clearance, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error, $error1));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionEosrequestList() {
        $model_module_eos = HrModules::model()->findByPK(17);
        if ($model_module_eos->grant_access == 1 && $model_module_eos->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_empeos_settlement_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('eos_request_list');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGeteosRequest() {

        $model = new EmployeeEOS();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'apply_date',
            4 => 't.id',
            5 => 'total_amount',
            6 => 'status',
            7 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $arr_status = $_POST['status'];
        $status = 1;
        if (is_countable($arr_status) && count($arr_status) > 1) {
            $status = implode(',', $arr_status);
        } else {
            $status = $arr_status[0];
        }
        $condition = '1=1';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if ($status != '') {
            $condition .= " AND status IN(" . $status . ")";
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $apply_date = "";
            if ($row['apply_date'] != '0000-00-00' && $row['apply_date'] != '') {
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            $date_leaving = "";
            if ($row['date_leaving'] != '0000-00-00' && $row['date_leaving'] != '') {
                $date_leaving = date("d/m/Y", strtotime($row['date_leaving']));
            }
            $en_id = $this->ciphertext($row['id'], "e");
//            $button_string="";      
            $eos_approve = $eos_upload = $eos_print = $eos_download = $eos_view = $eos_delete = $eos_clearance_view = $resignation_eos_print = $hr_exit_eos_print = $eos_clearance_print = $resignation_eos_download = $hr_exit_eos_download = $eos_clearance_download = 0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_eos_settlement_edit']) || Yii::app()->user->authorised_user == 1) {
                if ($row['status'] == 1) {
                    $eos_approve = 1;
//                    $button_string.= '<button class="btn btn-primary btn-xs" title="Edit/Approve/Reject Request" onclick="loadPopupModal(\'hr/eosdetails/approverequest&id='.$row['id'].'\',\'END OF SERVICE\',\'xl\')"><i class="fa fa-thumbs-up"></i></button> &nbsp;';												
                }
            }
            $model_upload_eos_resignation = HrMasterUpload::model()->findByPK(21);
            $model_upload_eos_exit_document = HrMasterUpload::model()->findByPK(22);
            $model_upload_eos_clearance = HrMasterUpload::model()->findByPK(23);
            if ($model_upload_eos_resignation->isActive == 'Y' || $model_upload_eos_exit_document->isActive == 'Y' || $model_upload_eos_clearance->isActive == 'Y') {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_eos_settlement_upload']) || Yii::app()->user->authorised_user == 1) {
                    if (($row['resignation_document'] == '' || $row['hr_exit_document'] == '' || $row['eosclearance_document'] == '') && $row['status'] != 3) {
                        $eos_upload = 1;
//                        $button_string.= '<button class="btn btn-primary btn-xs" title="Upload Document" onclick="loadPopupModal(\'hr/eosdetails/uploadeosdocuments&id=' . $row['id'] . '\',\'Upload Documents\',\'md\')"><i class="fa fa-upload"></i></button>&nbsp;';           
                    }
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_eos_settlement_print']) || Yii::app()->user->authorised_user == 1) {
                $eos_print = 1;
//                $button_string.= '<a href="?r=hr/eosdetails/printeosdetails&id=' .$en_id. '" title="Print EOS Details" target="_blank"><button class="btn btn-primary btn-xs" title="Print EOS Details" ><i class="fa fa-print"></i></button></a>&nbsp;';
                if ($row['resignation_document'] == '' && $row['status'] != 3) {
                    $resignation_eos_print = 1;
//                    $button_string.= '<a href="?r=hr/eosdetails/resignationdocument&id=' . $row['id'] . '" title="Resignation Document" target="_blank"><button class="btn btn-primary btn-xs" title="Resignation Document" ><i class="fa fa-print"></i></button></a>&nbsp;';
                }
                if ($row['hr_exit_document'] == '' && $row['status'] != 3) {
                    $hr_exit_eos_print = 1;
//                    $button_string.= '<a href="?r=hr/eosdetails/hrexitdocument&id=' . $row['id'] . '" title="Hr Exit Document" target="_blank"><button class="btn btn-primary btn-xs" title="Hr Exit Document" ><i class="fa fa-print"></i></button></a>&nbsp;';
                }
                if ($row['eosclearance_document'] == '' && $row['status'] != 3) {
                    $eos_clearance_print = 1;
//                    $button_string.= '<a href="?r=hr/eosdetails/eosclearancedocument&id=' . $row['id'] . '" title="Eos Clearance Document" target="_blank"><button class="btn btn-primary btn-xs" title="Eos Clearance Document" ><i class="fa fa-print"></i></button></a>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_eos_settlement_download']) || Yii::app()->user->authorised_user == 1) {
                if ($row['resignation_document'] != '') {
                    $resignation_eos_download = 1;
//                    $button_string.= '<a href="?r=hr/eosdetails/downloadeosdocument&type=1&id=' . $row['id'] . '" title="Download Resignation Document"><button class="btn btn-primary btn-xs" title="Download Resignation Document" ><i class="fa fa-download"></i></button></a>&nbsp;';           
                }
                if ($row['hr_exit_document'] != '') {
                    $hr_exit_eos_download = 1;
//                    $button_string.= '<a href="?r=hr/eosdetails/downloadeosdocument&type=2&id=' . $row['id'] . '" title="Download Exit Interview Document"><button class="btn btn-primary btn-xs" title="Download Exit Interview Document" ><i class="fa fa-download"></i></button></a>&nbsp;';           
                }
                if ($row['eosclearance_document'] != '') {
                    $eos_clearance_download = 1;
//                    $button_string.= '<a href="?r=hr/eosdetails/downloadeosdocument&type=3&id=' . $row['id'] . '" title="Download EOS Clearance Document"><button class="btn btn-primary btn-xs" title="Download EOS Clearance Document" ><i class="fa fa-download"></i></button></a>&nbsp;';           
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_eos_settlement_view']) || Yii::app()->user->authorised_user == 1) {
                $eos_view = 1;
//                $button_string.= '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'hr/eosdetails/vieweosdetails&id='.$row['id'].'\',\'END OF SERVICE\',\'xl\')"><i class="fa fa-eye"></i></button> &nbsp;';												
            }
            if ($row['status'] == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_eos_settlement_delete']) || Yii::app()->user->authorised_user == 1) {
                    $eos_delete = 1;
//                    $button_string.='<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete" onclick="deleteeos(' . $row['id'] . ')"><i class="fa fa-trash"></i></a> &nbsp;' ;                       
                }
            }
            $model_clearance = HrEmployeeEosClearance::model()->find(array('condition' => 'eos_id=' . $row['id']));
            $model_hr_settings = HrGenerelSettings::model()->find();
            $flag = false;
            $clearance_id = 0;
            if ($model_hr_settings->eos_clearance == 'Y') {
                $flag = true;
                if (!empty($model_clearance)) {
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_empeos_clearance_view']) || Yii::app()->user->authorised_user == 1) {
                        $eos_clearance_view = 1;
                        $clearance_id = $model_clearance['id'];
//                        $button_string.= '<button class="btn btn-primary btn-xs" title="View EOS Clearance" onclick="loadPopupModal(\'hr/eosdetails/eosclearanceview&id='.$model_clearance['id'].'\',\'View EOS Clearance\',\'xl\')"><i class="fa fa-eye"></i></button> &nbsp;';												
                    }
                }
            }
            $rowData[] = array(++$m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $date_leaving, $apply_date, $row['total_amount'], EmployeeEOS::getStatus($row['status']), HrEmployeeEosClearance::getClearanceStatus($model_clearance->status), array('id' => $row['id'], 'flag' => $flag, 'eos_approve' => $eos_approve, 'eos_upload' => $eos_upload, 'eos_print' => $eos_print, 'eos_download' => $eos_download, 'eos_view' => $eos_view, 'eos_delete' => $eos_delete, 'eos_clearance_view' => $eos_clearance_view, 'en_id' => $en_id, 'resignation_eos_print' => $resignation_eos_print, 'hr_exit_eos_print' => $hr_exit_eos_print, 'eos_clearance_print' => $eos_clearance_print, 'resignation_eos_download' => $resignation_eos_download, 'hr_exit_eos_download' => $hr_exit_eos_download, 'eos_clearance_download' => $eos_clearance_download, 'clearance_id' => $clearance_id));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionApproveRequest() {
        $model = new EmployeeEOS();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_asset = EmployeeAsset::model()->findAll(array('condition' => 'employee_id="' . $model->employee_id . '" AND asset_status="1"'));
            $model_eos_details = EmployeeEOSDetails::model()->findAll(array('condition' => 'eos_id="' . $id . '"'));
            $model_eos_clearance = EmployeeEosClearanceDetails::model()->findAll(array('condition' => 'eos_id="' . $id . '"'));
            if (empty($model_eos_clearance)) {
                $model_eos_clearance = array(new EmployeeEosClearanceDetails());
            }
            $model_payment_details = EmployeeEosPayment::model()->findAll(array('condition' => 'eos_id="' . $id . '"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('approve_request_form', array('model' => $model, 'model_payment_details' => $model_payment_details, 'model_asset' => $model_asset, 'model_eos_details' => $model_eos_details, 'model_eos_clearance' => $model_eos_clearance), false, true);
    }

    public function actionSaveApproveRequest() {
        if (isset($_POST['EmployeeEOS'])) {
            $model = new EmployeeEOS();
            if ((int) @$_POST['EmployeeEOS']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeEOS']['id'];
                $model->scenario = 'update';
                $model = EmployeeEOS::model()->findByPK($_POST['EmployeeEOS']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }
            $model->approve_date = date('Y-m-d');
            $model->status = $_POST['EmployeeEOS']['status'];
            $model->hr_comment = $_POST['EmployeeEOS']['hr_comment'];
            if ($_POST['EmployeeEOS']['resignation_document'] != '') {
                $model->resignation_document = $_POST['EmployeeEOS']['resignation_document'];
            }
            if ($_POST['EmployeeEOS']['hr_exit_document'] != '') {
                $model->hr_exit_document = $_POST['EmployeeEOS']['hr_exit_document'];
            }
            if ($_POST['EmployeeEOS']['eosclearance_document'] != '') {
                $model->eosclearance_document = $_POST['EmployeeEOS']['eosclearance_document'];
            }
            if ($model->validate()) {
                $model->save();
                //Asset
                if ((isset($_POST['EmployeeAsset']))) {
                    foreach ($_POST['EmployeeAsset'] as $i => $items) {
                        if ($items['id'] > 0 && $items['asset_status'] > 0) {
                            $model_asset = EmployeeAsset::model()->findByPK($items['id']);
                            $model_asset->asset_status = $items['asset_status'];
                            if ($items['asset_date_return'] != '0000-00-00' && $items['asset_date_return'] != '') {
                                $model_asset->asset_date_return = str_replace('/', '-', $items['asset_date_return']);
                                $model_asset->asset_date_return = date("Y-m-d", strtotime($model_asset->asset_date_return));
                            }
                            $model_asset->updated_by = Yii::app()->user->id;
                            $model_asset->updated_date_time = date('Y-m-d h:i:s');
                            $model_asset->save(false);
                        }
                    }
                }
                //End Asset
                //Clearance
                if ((isset($_POST['EmployeeEosClearanceDetails']))) {
                    foreach ($_POST['EmployeeEosClearanceDetails'] as $i => $items) {
                        if ($items['clearance_id'] > 0) {
                            if ($items['id'] > 0) {
                                $model_clearance = EmployeeEosClearanceDetails::model()->findByPK($items['id']);
                                $model_clearance->updated_by = Yii::app()->user->id;
                                $model_clearance->updated_date_time = date('Y-m-d h:i:s');
                            } else {
                                $model_clearance = new EmployeeEosClearanceDetails();
                                $model_clearance->created_by = Yii::app()->user->id;
                                $model_clearance->created_date_time = date('Y-m-d h:i:s');
                            }
                            $model_clearance->eos_id = $model->id;
                            $model_clearance->employee_id = $model->employee_id;
                            $model_clearance->clearance_id = $items['clearance_id'];
                            $model_clearance->clearance_status = $items['clearance_status'];
                            $model_clearance->save();
                        }
                    }
                }
                //End Clearance
                $alert_flag = 0;
                if ($model->status == 2) {
                    //Updating Employee table
                    $model_level = new HrEmployeeApproveLevel();
                    //Level 1 
                    $model_level_1 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="' . $model->employee_id . '" and max_level="1" AND level_1_authority="' . $model->employee_id . '"'));
                    //Level 2 
                    $model_level_2 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="' . $model->employee_id . '" and max_level="2" AND (level_1_authority="' . $model->employee_id . '" OR level_2_authority="' . $model->employee_id . '")'));
                    //Level 1 
                    $model_level_3 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="' . $model->employee_id . '" and max_level="3" AND (level_1_authority="' . $model->employee_id . '" OR level_2_authority="' . $model->employee_id . '" OR level_3_authority="' . $model->employee_id . '")'));
                    //Level 1 
                    $model_level_4 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="' . $model->employee_id . '" and max_level="4" AND (level_1_authority="' . $model->employee_id . '" OR level_2_authority="' . $model->employee_id . '" OR level_3_authority="' . $model->employee_id . '" OR level_4_authority="' . $model->employee_id . '")'));
                    //Level 1 
                    $model_level_5 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="' . $model->employee_id . '" and max_level="5" AND (level_1_authority="' . $model->employee_id . '" OR level_2_authority="' . $model->employee_id . '" OR level_3_authority="' . $model->employee_id . '" OR level_4_authority="' . $model->employee_id . '" OR level_5_authority="' . $model->employee_id . '")'));
                    $jsonData = array();
                    if (!empty($model_level_1) || !empty($model_level_2) || !empty($model_level_3) || !empty($model_level_4) || !empty($model_level_5)) {
                        Employee::model()->updateByPK($model->employee_id, array('date_leaving' => $model->date_leaving, 'fcm_token' => "", 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')));
                        $alert_flag = 1;
                    } else {
                        Employee::model()->updateByPK($model->employee_id, array('date_leaving' => $model->date_leaving, 'fcm_token' => "", 'date_blocked' => date('Y-m-d'), 'isActive' => "B", 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')));
                    }
                    //Updating User Table
                    $model_user = User::model()->find(array("condition" => 'company_id="' . Yii::app()->user->master_user_company_id . '" and employee_id ="' . $model->employee_id . '" and level="2"'));
                    User::model()->updateByPK($model_user->id, array('isActive' => "N", 'token' => "", 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')));
                }
                $jsonData['flag'] = $alert_flag;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionVieweosDetails() {
        $model = new EmployeeEOS();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_asset = EmployeeAsset::model()->findAll(array('condition' => 'employee_id="' . $model->employee_id . '" AND asset_status="1"'));
            $model_eos_details = EmployeeEOSDetails::model()->findAll(array('condition' => 'eos_id="' . $id . '"'));
            $model_eos_clearance = EmployeeEosClearanceDetails::model()->findAll(array('condition' => 'eos_id="' . $id . '"'));
            $model_payment_details = EmployeeEosPayment::model()->findAll(array('condition' => 'eos_id="' . $id . '"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('vieweosdetails', array('model' => $model, 'model_payment_details' => $model_payment_details, 'model_asset' => $model_asset, 'model_eos_details' => $model_eos_details, 'model_eos_clearance' => $model_eos_clearance), false, true);
    }

    public function actionResignationDocument() {
        $id = Yii::app()->request->getParam('id');
        $model_eos = EmployeeEOS::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.resignation_form', array('id' => $id, 'model_eos' => $model_eos), true));
        $mPDF1->Output('Resignation.pdf', 'I');
    }

    public function actionHrexitDocument() {
        $id = Yii::app()->request->getParam('id');
        $model_eos = EmployeeEOS::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.hrexit_interview_form', array('id' => $id, 'model_eos' => $model_eos), true));
        $mPDF1->Output('Exit Interview.pdf', 'I');
    }

    public function actionEosclearanceDocument() {
        $id = Yii::app()->request->getParam('id');
        $model_eos = EmployeeEOS::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.eos_clearance_form', array('id' => $id, 'model_eos' => $model_eos), true));
        $mPDF1->Output('Clearance.pdf', 'I');
    }

    public function actiondownloadeosdocument() {
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $file = '';
        if ($type == 1) {
            $document = EmployeeEOS::model()->findByPk($id);
            $file = $document->resignation_document;
        } else if ($type == 2) {
            $document = EmployeeEOS::model()->findByPk($id);
            $file = $document->hr_exit_document;
        } else if ($type == 3) {
            $document = EmployeeEOS::model()->findByPk($id);
            $file = $document->eosclearance_document;
        }

        $path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }

    public function actionUploadeosDocuments() {
        $model = new EmployeeEOS();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_eos_document', array('model' => $model), false, true);
    }

    public function actionsaveUploadDocument() {
        if (isset($_POST['EmployeeEOS'])) {
            $model = new EmployeeEOS();
            if ((int) @$_POST['EmployeeEOS']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeEOS']['id'];
                $model->scenario = 'update';
                $model = EmployeeEOS::model()->findByPK($_POST['EmployeeEOS']['id']);
            }
            if ($_POST['EmployeeEOS']['resignation_document'] != '') {
                $model->resignation_document = $_POST['EmployeeEOS']['resignation_document'];
            }
            if ($_POST['EmployeeEOS']['hr_exit_document'] != '') {
                $model->hr_exit_document = $_POST['EmployeeEOS']['hr_exit_document'];
            }
            if ($_POST['EmployeeEOS']['eosclearance_document'] != '') {
                $model->eosclearance_document = $_POST['EmployeeEOS']['eosclearance_document'];
            }
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasEOSClearance();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    public function actionRemovelineItem() {
        $id = $_POST['id'];
        if ($id > 0) {
            EmployeeEosClearanceDetails::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionPrinteosdetails() {
        $id = Yii::app()->request->getParam('id');
        $id = $this->ciphertext($id, "d");
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.eosdetails.eos_print', array('id' => $id), true));
        $mPDF1->Output('EOS Details.pdf', 'I');
    }

    public function actionprinteoscleaarncedetails() {
        $id = Yii::app()->request->getParam('id');
        $id = $this->ciphertext($id, "d");
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.eosdetails.eos_clearance_print', array('id' => $id), true));
        $mPDF1->Output('EOS Clearance Details.pdf', 'I');
    }

    public static function geteos($id, $gratuity_date, $rule_type) {
        $date_leave = date("Y-m-d");
        if ($gratuity_date != '') {
            $date_leave = date("Y-m-d", strtotime(str_replace('/', '-', $gratuity_date)));
        }
        $modelemployee = Employee::model()->findbyPK($id);
        //Service Period
        $d1 = strtotime($modelemployee->date_join);
        $d2 = strtotime($date_leave);
        $datediff = $d2 - $d1;
        $service_days = $datediff / (60 * 60 * 24) + 1;
        $years = round($service_days / 365, 1);
        $date1 = new DateTime($modelemployee->date_join);
        $date2 = new DateTime($date_leave);
        $dd = date_diff($date1, $date2);
        $eos_year = $dd->y;
        $eos_month = $dd->m / 12;
        $eos_days = $dd->d / 365;
        //Start Gratuity Calculation
        $gratuityamount = 0.00;
        if ($rule_type == 1) {
            if ($years > 5) {
                //Gratuity For First Five Years
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from="1" AND gratuity_period_to="5"'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary->amount)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount / 30);
                $balance_eos_year = $eos_year - 5;
                $gross_amt_1 = ($days * $salary_per_day * 5);
                $gratuity_year_details[0]['year'] = 'First 5 years';
                $gratuity_year_details[0]['amount'] = $gross_amt_1;
                $gratuity_year_details[0]['employee_id'] = $id;
                $gratuity_year_details[0]['gratuity_id'] = $model_gratuity->id;
                //Gratuity After Five Years
                if ($balance_eos_year > 0) {
                    //Gratuity After Five Years
                    $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from>=5'));
                    $days = $model_gratuity->gratuity_provision_days;
                    $salary_types = explode(',', $model_gratuity->salary_type);
                    $salaryamount = 0.00;
                    $gratuity = 0.00;
                    for ($i = 0; $i < count($salary_types); $i++) {
                        $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                        if (!empty($model_salary->amount)) {
                            $salaryamount += $model_salary->amount;
                        }
                    }
                    $salary_per_day = ($salaryamount / 30);
                    $gross_amt_2 = ($days * $salary_per_day * $balance_eos_year) + ($days * $salary_per_day * $eos_month) + ($days * $salary_per_day * $eos_days);
                } else if ($eos_month > 0 || $eos_days > 0) {
                    $gross_amt_2 = ($days * $salary_per_day * $eos_month) + ($days * $salary_per_day * $eos_days);
                }
                $gratuityamount = ceil($gross_amt_1 + $gross_amt_2);
            } else {
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and days_from<="' . $service_days . '" AND days_to>="' . $service_days . '"'));

                if (!empty($model_gratuity)) {
                    $days = $model_gratuity->gratuity_provision_days;
                    $salary_types = explode(',', $model_gratuity->salary_type);

                    $salaryamount = 0.00;
                    $gratuity = 0.00;
                    for ($i = 0; $i < count($salary_types); $i++) {
                        $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                        if (!empty($model_salary)) {
                            $salaryamount += $model_salary->amount;
                        }
                    }
                    $salary_per_day = ($salaryamount / 30);
                    $gross_amount = ($days * $salary_per_day * $eos_year) + ($days * $salary_per_day * $eos_month) + ($days * $salary_per_day * $eos_days);
                    $gratuityamount = ceil($gross_amount);
                }
            }
        } else if ($rule_type == 2) {
            if ($years >= 5) {
                //Gratuity For First Five Years
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from="1" AND gratuity_period_to="5"'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount * 12 / 365);
                $balance_eos_year = $eos_year - 5;
                $gross_amt_1 = ($days * $salary_per_day * 5);
                //Gratuity After Five Years
                if ($balance_eos_year > 0 || $eos_month > 0 || $eos_days > 0) {
                    //Gratuity After Five Years
                    $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from>=5'));
                    $days = $model_gratuity->gratuity_provision_days;
                    $salary_types = explode(',', $model_gratuity->salary_type);
                    $salaryamount = 0.00;
                    $gratuity = 0.00;
                    for ($i = 0; $i < count($salary_types); $i++) {
                        $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                        if (!empty($model_salary)) {
                            $salaryamount += $model_salary->amount;
                        }
                    }
                    $salary_per_day = ($salaryamount * 12 / 365);
                    $gross_amt_2 = ($days * $salary_per_day * $balance_eos_year) + ($days * $salary_per_day * $eos_month) + ($days * $salary_per_day * $eos_days);
                }
                $gratuityamount = ceil($gross_amt_1 + $gross_amt_2);
            } else {
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and days_from<="' . $service_days . '" AND days_to>="' . $service_days . '"'));

                if (!empty($model_gratuity)) {
                    $days = $model_gratuity->gratuity_provision_days;
                    $salary_types = explode(',', $model_gratuity->salary_type);
                    $salaryamount = 0.00;
                    $gratuity = 0.00;
                    for ($i = 0; $i < count($salary_types); $i++) {
                        $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                        if (!empty($model_salary)) {
                            $salaryamount += $model_salary->amount;
                        }
                    }


                    $salary_per_day = ($salaryamount * 12 / 365);
                    $tot_days_eos = ($service_days / 365);
                    $gross_amount = ($days * $salary_per_day * $tot_days_eos);
//                $gross_amount=($days*$salary_per_day*$eos_year)+($days*$salary_per_day*$eos_month)+($days*$salary_per_day*$eos_days);
                    $gratuityamount = ceil($gross_amount);
                }
            }
        } else if ($rule_type == 3) { //Jafza giving 30 for all employees worked after 5 years
            if ($years >= 5) {
                //Gratuity
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from>=5'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($salaryamount)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount * 12 / 365);
                $tot_days_eos = ($service_days / 365);
                $gross_amt = ($days * $salary_per_day * $tot_days_eos);
                $gratuityamount = round($gross_amt);
            } else {
                $model_gratuity = MasGratuity::model()->find(array('condition' => 'rule_type="' . $rule_type . '" and gratuity_period_from="1" AND gratuity_period_to="5"'));
                $days = $model_gratuity->gratuity_provision_days;
                $salary_types = explode(',', $model_gratuity->salary_type);
                $salaryamount = 0.00;
                $gratuity = 0.00;
                for ($i = 0; $i < count($salary_types); $i++) {
                    $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $id . '" and salary_type="' . $salary_types[$i] . '" AND (("' . $date_leave . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $date_leave . '" AND valid_to="0000-00-00"))'));
                    if (!empty($model_salary)) {
                        $salaryamount += $model_salary->amount;
                    }
                }
                $salary_per_day = ($salaryamount * 12 / 365);
                $tot_days_eos = ($service_days / 365);
                $gross_amt = ($days * $salary_per_day * $tot_days_eos);
                $gratuityamount = round($gross_amt);
            }
        }
        //End Gratuity Calculation
        return $gratuityamount;
    }

    public function actiongetbranchemployee() {
        $branch = $_POST['branch'];
        $dropdownlist = CHtml::dropdownlist('employee_id', '', Employee::getEosemployee($branch), array('empty' => 'Select', 'data-label' => '<b>Employee Name</b>', 'data-search' => 'true'));
        $jsonData['employee'] = $dropdownlist;
        echo CJSON::encode($jsonData);
    }

    public function actiondeleteeos() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = EmployeeEOS::model()->findByPk($id);
            if ($model->id) {
                $model_eos_clearance_exists = HrEmployeeEosClearance::model()->find(array('condition' => 'eos_id="' . $model->id . '"'));
                if (!empty($model_eos_clearance_exists)) {
                    if ($model_eos_clearance_exists->approve_level1_document != '') {
                        $doc_file = $model_eos_clearance_exists->approve_level1_document;
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/" . $doc_file;
                        unlink($path);
                    }
                    if ($model_eos_clearance_exists->approve_level2_document != '') {
                        $doc_file = $model_eos_clearance_exists->approve_level2_document;
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/" . $doc_file;
                        unlink($path);
                    }
                    if ($model_eos_clearance_exists->approve_level3_document != '') {
                        $doc_file = $model_eos_clearance_exists->approve_level3_document;
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/" . $doc_file;
                        unlink($path);
                    }
                    if ($model_eos_clearance_exists->approve_level4_document != '') {
                        $doc_file = $model_eos_clearance_exists->approve_level4_document;
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/" . $doc_file;
                        unlink($path);
                    }
                    if ($model_eos_clearance_exists->approve_level5_document != '') {
                        $doc_file = $model_eos_clearance_exists->approve_level5_document;
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/" . $doc_file;
                        unlink($path);
                    }
                    if ($model_eos_clearance_exists->approved_document != '') {
                        $doc_file = $model_eos_clearance_exists->approved_document;
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/" . $doc_file;
                        unlink($path);
                    }
                }
                EmployeeEOSDetails::model()->deleteAll('eos_id=:refer_id', array(':refer_id' => $model->id));
                EosGratuityDetails::model()->deleteAll('eos_id=:refer_id', array(':refer_id' => $model->id));
                EmployeeEosClearanceDetails::model()->deleteAll('eos_id=:refer_id', array(':refer_id' => $model->id));
                EmployeeEosPayment::model()->deleteAll('eos_id=:refer_id', array(':refer_id' => $model->id));
                HrEmployeeEosClearance::model()->deleteAll('eos_id=:refer_id', array(':refer_id' => $model->id));
                $model_details_exist = EmployeeEOSDetails::model()->findAll(array('condition' => 'eos_id="' . $model->id . '"'));
                $model_gratuity_exist = EosGratuityDetails::model()->findAll(array('condition' => 'eos_id="' . $model->id . '"'));
                $model_clearance_exist = EmployeeEosClearanceDetails::model()->findAll(array('condition' => 'eos_id="' . $model->id . '"'));
                $model_payment_exist = EmployeeEosPayment::model()->findAll(array('condition' => 'eos_id="' . $model->id . '"'));
                $model_eos_clearance_exist = HrEmployeeEosClearance::model()->findAll(array('condition' => 'eos_id="' . $model->id . '"'));
                if (empty($model_details_exist) && empty($model_gratuity_exist) && empty($model_clearance_exist) && empty($model_payment_exist) && empty($model_eos_clearance_exist)) {
                    EmployeeEOS::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                } else {
                    $jsonData['status'] = 'Error';
                    $jsonData['msg'] = 'Error in EOS Deletion';
                }
            } else {
                $jsonData['status'] = 'Error';
                $jsonData['msg'] = 'Error in EOS Deletion';
            }
        } else {
            $jsonData['status'] = 'Error';
            $jsonData['msg'] = 'Error in EOS Deletion';
        }
        echo CJSON::encode($jsonData);
    }

    public function actiondeleteeoscleaarnce() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = HrEmployeeEosClearance::model()->findByPk($id);
            if (!empty($model)) {
                HrEmployeeEosClearance::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actioneosclearancelist() {
        $model_module_eos = HrModules::model()->findByPK(17);
        if ($model_module_eos->grant_access == 1 && $model_module_eos->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_empeos_clearance_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('clearance_index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetClearanceList() {
        $model = new HrEmployeeEosClearance();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employeecode',
            2 => 'employeedetail.employeefullname',
            3 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            // $condition =" (department_name LIKE '%".$searchString."%')";
        }
        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $print_button = $view_button = 0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_empeos_clearance_view']) || Yii::app()->user->authorised_user == 1) {
                $view_button = 1;
                $button_string = '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'hr/eosdetails/eosclearanceview&id=' . $row['id'] . '\',\'View EOS Clearance \',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            $employee_eos = EmployeeEOS::model()->findByPK($row->eos_id);
            if ($employee_eos['status'] == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_empeos_clearance_delete']) || Yii::app()->user->authorised_user == 1) {
                    // $button_string.='<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete" onclick="deleteeoscleaarnce(' . $row['id'] . ')"><i class="fa fa-trash"></i></a>&nbsp;' ;                       
                }
            }
            $en_id = $this->ciphertext($row->eos_id, "e");
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_empeos_clearance_print']) || Yii::app()->user->authorised_user == 1) {
                $print_button = 1;
                $button_string .= '<a href="?r=hr/eosdetails/printeoscleaarncedetails&id=' . $en_id . '" title="Print EOS Details" target="_blank"><button class="btn btn-primary btn-xs" title="Print EOS Details" ><i class="fa fa-print"></i></button></a>&nbsp;';
            }
            //
            $rowData[] = array($m, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, HrEmployeeEosClearance::getClearanceStatus($row->status), array('id' => $row['id'], 'en_id' => $en_id, 'print_button' => $print_button, 'view_button' => $view_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionEosClearanceView() {
        $model = new HrEmployeeEosClearance();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('eos_clearance_details_view', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionClearanceApproval() {
        $this->layout = "main";
        $model_module_eos = HrModules::model()->findByPK(17);
        if ($model_module_eos->grant_access == 1 && $model_module_eos->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('clearance_approval');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetClearanceforApproval() {
        $model = new HrEmployeeEosClearance();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employee_id',
            2 => 'leave_type',
            3 => 'apply_date',
            4 => 'leave_start_date',
            5 => 'leave_end_date',
            6 => 'leave_status',
            7 => 'no_days',
            8 => 'hr_comment',
            9 => 'line_manager_id',
            10 => 'approved_id',
            11 => 'employeedetail.isActive',
        );
        $model_employee = User::model()->findByPk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $model_employee_detail = Employee::model()->findByPk($employee_id);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $pending_eos = HrEmployeeEosClearance::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND (last_approved_level<approvelevel.max_level) And t.id IN(' . $pending_eos . ')';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (apply_date LIKE '%" . $searchString . "%' OR employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'apply_date asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $department_id = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                    $department_id = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                    $department_id = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                    $department_id = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                    $department_id = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                    $department_id = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }

            if ($show_approve_button == 1) { //For Approval
                $approve_reject = 1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="Approve / Reject Eos Clearance" onclick="loadPopupModal(\'hr/eosdetails/eosapprovalbylm&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '&department=' . $department_id . '\',\'Approve / Reject Eos Clearance \',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
            }
            $button_string .= '<button class="btn btn-success btn-xs" title="View EOS Clearance Details" onclick="loadPopupModal(\'hr/eosdetails/EosClearanceView&id=' . $row['id'] . '\',\'Eos Clearance Details\',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            $rowData[] = array($m, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, $apply_date, HrEmployeeEosClearance::getClearanceStatus($row->status), array('final_level' => $final_level, 'level_no' => $level_no, 'id' => $row['id'], 'approve_reject' => $approve_reject, 'department_id' => $department_id));

            $m++;
        }
        $data['data'] = $rowData;
        $data['condition'] = $condition;
        $data['user'] = Yii::app()->user->id;
        echo json_encode($data);
    }

    public function actioneosapprovalbylm() {
        $id = Yii::app()->request->getparam("id");
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $department = Yii::app()->request->getparam("department");
        $model = HrEmployeeEosClearance::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('clearance_approve_reject_form', array('model' => $model, 'level' => $level, 'final_level' => $final_level, 'department' => $department), false, true);
    }

    public function actionsaveeosclearanceApproveReject() {
        if (isset($_POST['HrEmployeeEosClearance'])) {
            $model = new HrEmployeeEosClearance();
            if ((int) @$_POST['HrEmployeeEosClearance']['id'] > 0) {
                $model->id = (int) $_POST['HrEmployeeEosClearance']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->status = $_POST['HrEmployeeEosClearance']['status'];
            $model->last_approved_level = $_POST['HrEmployeeEosClearance']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($level == 1 && $final_level == 'N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_department_id = $_POST['approve_department_id'];
                $model->approve_level1_document = $_POST['approve_document'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2 && $final_level == 'N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_department_id = $_POST['approve_department_id'];
                $model->approve_level2_document = $_POST['approve_document'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level == 'N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_department_id = $_POST['approve_department_id'];
                $model->approve_level3_id = $approved_employee_id;
                $model->approve_level3_document = $_POST['approve_document'];
            } else if ($level == 4 && $final_level == 'N') {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_department_id = $_POST['approve_department_id'];
                $model->approve_level4_id = $approved_employee_id;
                $model->approve_level4_document = $_POST['approve_document'];
            } else if ($level == 5 && $final_level == 'N') {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_department_id = $_POST['approve_department_id'];
                $model->approve_level5_id = $approved_employee_id;
                $model->approve_level5_document = $_POST['approve_document'];
            }
            if ($final_level == 'Y') {
                $model->approved_date = date('Y-m-d');
                $model->approve_comments = $_POST['approval_comment'];
                $model->approved_document = $_POST['approve_document'];
                $model->approved_department_id = $_POST['approve_department_id'];
                $model->approved_by = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="36"'));
                if (!empty($model_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(36, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actiondownloaddocument() {
        $id = Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getParam('level');
        $document = HrEmployeeEosClearance::model()->findByPk($id);
        if ((int) $level > 0) {
            $doc = 'approve_level' . $level . '_document';
        } else {
            $doc = 'approved_document';
        }
        $file = $document[$doc];
        $arr_doc_val = explode(',', $file);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/document.zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/eosdocument/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/eosdocument/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
}
