<?php

class EmployeegeocodeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetList', 'Create','edit', 'Save','editSave','Disable','deleteGeocode','deleteemployeegeocode'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

   
    public function actionGetList() {
        $model = new HrEmployeeGeocode();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employee_id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (t.employee_id LIKE '%" . $searchString . "%' || employeedetail.de_first_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail','geolocation_details')->count(array('condition' => $condition));
        $model = $model->with('employeedetail','geolocation_details')->findAll(array('condition' => $condition, 'group'=>'t.employee_id','limit' => $limit, 'offset' => $offset, 'order' =>'employeedetail.de_first_name' ));
       //group by employee_id
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m =$offset;
        foreach ($model as $row) {
            $edit=$delete=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_employee_geocode_edit'])  || Yii::app()->user->authorised_user == 1) {
                $edit=1;
//                $button_string = '<div style="width:100%; text-align:center;"><button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'employeegeocode/create&id=' . $row['id'] . '\',\'Edit Geocode \',\'md\')"><i class="fa fa-edit"></i></button></div>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_geocode_disable']) || Yii::app()->user->authorised_user == 1) {
                $delete=1;
            }
            $rowData[] = array(++$m, $row['employeedetail']['employeefullname'], $row['geolocation_details']['geocode_location'],$row['id'], array('id' => $row->employee_id, 'status' => $row->isActive,"edit" => $edit,"delete" =>$delete));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model_geocode=array(new HrEmployeeGeocode()); 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model_geocode'=> $model_geocode), false, true);
    }


    public function actionEdit() {
        $model_geocode=array(new HrEmployeeGeocode()); 
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model_geocode= HrEmployeeGeocode::model()->findAll(array('condition' => 'employee_id="'. $id.'"')); 
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('edit', array('model_geocode'=> $model_geocode,'employee_id'=>$id), false, true);
    }

    public function actionSave() {
        $model_geocode =array(new HrEmployeeGeocode());
        
        if ((isset($_POST['HrEmployeeGeocode'])) && ($_POST['HrEmployeeGeocode'][0]['employee_id'] >0)) {
                $i = 0;
                foreach ($_POST['HrEmployeeGeocode'] as $m => $items) {
                    if ($items['geocode_location_id'] >0) {
                        if ($items['id'] > 0) {
                            $model_geocode[$i] = HrEmployeeGeocode::model()->findByPK($items['id']);
                            $model_geocode[$i]->updated_by = Yii::app()->user->id;
                            $model_geocode[$i]->updated_date_time = date('Y-m-d H:i:s');
                          
                        } else {
                            $model_geocode[$i] = new HrEmployeeGeocode();
                            $model_geocode[$i]->created_by = Yii::app()->user->id;
                            $model_geocode[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_geocode[$i]->employee_id = $items['employee_id'];
                        $model_geocode[$i]->geocode_location_id = $items['geocode_location_id'];
                        $model_geocode[$i]->latitude = $items['latitude'];
                        $model_geocode[$i]->longitude = $items['longitude'];
                        $model_geocode[$i]->description = $items['description'];
                        $valid = $model_geocode[$i]->validate();
                        $i++;
                    }
                }
            }

            if ($valid) {
                if (!empty($model_geocode)) {
                    foreach ($model_geocode as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validateTabular($model_geocode, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1));
                if ($error != '[]')
                    echo $error;
            }
        }
    
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new HrEmployeeGeocode();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    public function actiondeleteGeocode() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new HrEmployeeGeocode();
            $model = $model->findByPk($id);
            $model_geocode_history = new HrEmployeeGeocodeHistory();
            $model_geocode_history->geocode_tble_id = $model->id;
            $model_geocode_history->geocode_location_id = $model->geocode_location_id;
            $model_geocode_history->employee_id = $model->employee_id;
            $model_geocode_history->latitude = $model->latitude;
            $model_geocode_history->longitude = $model->longitude;
            $model_geocode_history->description = $model->description;
            $model_geocode_history->geo_tble_created_by = $model->created_by;
            $model_geocode_history->geo_tble_created_date_time = $model->created_date_time;
            $model_geocode_history->created_by = Yii::app()->user->id;
            $model_geocode_history->created_date_time = date('Y-m-d H:i:s');
            $model_geocode_history->save(false);
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actiondeleteemployeegeocode() {
        $id = $_POST['id'];
        if ($id > 0) 
        {   
            $model_geocode = HrEmployeeGeocode::model()->findAll(array('condition'=>'employee_id="'.$id.'"'));
            foreach ($model_geocode as $key => $value) {
                $model_geocode_history = new HrEmployeeGeocodeHistory();
                $model_geocode_history->geocode_tble_id = $value->id;
                $model_geocode_history->geocode_location_id = $value->geocode_location_id;
                $model_geocode_history->employee_id = $value->employee_id;
                $model_geocode_history->latitude = $value->latitude;
                $model_geocode_history->longitude = $value->longitude;
                $model_geocode_history->description = $value->description;
                $model_geocode_history->geo_tble_created_by = $value->created_by;
                $model_geocode_history->geo_tble_created_date_time = $value->created_date_time;
                $model_geocode_history->created_by = Yii::app()->user->id;
                $model_geocode_history->created_date_time = date('Y-m-d H:i:s');
                $model_geocode_history->save(false);
            }
            HrEmployeeGeocode::model()->deleteAll(array('condition'=>'employee_id="'.$id.'"'));
            $model = HrEmployeeGeocode::model()->findAll(array('condition'=>'employee_id="'.$id.'"'));
            if (empty($model)) {
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
        }
        else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}
