<?php

class EmployeedevicedetailsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetList', 'Create','edit', 'Save','editSave','Disable','deleteGeocode','deletedevicedetails','ExcelEmployeeDeviceList','ClearAllTokens','ClearAllStatus'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_app= HrModules::model()->findByPK(29);
        if ($model_module_app->grant_access == 1 && $model_module_app->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_empployee_device_view']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
        
    }

   
    public function actionGetList() {
        $model = new User();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $device_type = $_POST['device_type'];
        $employee_version = $_POST['employee_version'];
        $id= $_POST['id'];
        $columns = array(
            0 => 't.id',
            1 => 't.employee_id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'employee_details.isActive="Y" AND company_id="'.Yii::app()->user->master_user_company_id.'" AND employee_id >0';
        if ($id > 0) {
            $condition .= ' and employee_details.id="' . $id . '"';
        }
        if ($employee_version > 0) {
            $condition .= ' and app_current_version="' . $employee_version . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            //$condition = "  (employee_details.employee_id LIKE '%" . $searchString . "%')";
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition .= " AND (employee_details.employee_code LIKE '%" . $searchString_en . "%' || employee_details.de_first_name LIKE '%" . $searchString . "%')";
        }
        if($device_type==1){
            $condition.=' AND device_type="IOS"';
        }else if($device_type==2){
            $condition.=' AND device_type="ANDROID"';
        }else if($device_type==3){
            $condition.=' AND (device_type="ANDROID" || device_type="IOS")';
        }else if($device_type==4){
          $condition.=' AND device_type=""';  
        }
        $count = $model->with('employee_details')->count(array('condition' => $condition));
        $model = $model->with('employee_details')->findAll(array('condition' => $condition,'limit' => $limit, 'offset' => $offset, 'order' => 'employee_details.de_first_name'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $edit_button =$clear_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_device_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_button =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_device_disable']) || Yii::app()->user->authorised_user == 1) {
               $clear_button =1; 
            }
            $rowData[] = array($m, $this->ciphertext($row['employee_details']['employee_code'],"d"),$row['employee_details']['employeefullname'], $row['device_id'], $row['device_type'], $row['device_description'],$row['app_current_version'],$row['id'], array('id' => $row->employee_id,'edit_button'=>$edit_button,'clear_button'=>$clear_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
   


    public function actionEdit() {
        $user=new User(); 
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $user= user::model()->findByPK($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit', array('user'=> $user), false, true);
    }

    public function actionSave() {
        $model =new User();
        if ((isset($_POST['User'])) && ($_POST['User']['id'] >0)) {
            $user_id= $_POST['User']['id'];
            $updated=date('Y-m-d H:i:s');
            $status= User::model()->updateByPk($user_id, array('device_id' => $_POST['User']['device_id'],'device_type' => $_POST['User']['device_type'],'updated_by' => Yii::app()->user->id,'updated_date_time'=>$updated)); 
            $jsonData['id'] = $model->id;
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'failed';
        }
         echo CJSON::encode($jsonData);
    }

     public function actiondeletedevicedetails() {
        $id = $_POST['id'];
        if ($id > 0) {
            $updated=date('Y-m-d H:i:s');
            $status= User::model()->updateByPk($id, array('device_id' => '','app_force_updated'=>'N','device_type' => '','device_description' => '','app_current_version'=>'','token'=>'','updated_by' => Yii::app()->user->id,'updated_date_time'=>$updated)); 
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

//download device details in excel
public function actionExcelEmployeeDeviceList() {
       
    $model=new User();
    $condition = 'employee_details.isActive="Y" AND company_id="'.Yii::app()->user->master_user_company_id.'" AND employee_id >0';
    $modelDevices= $model->with('employee_details')->findAll(array('condition' => $condition));
    Yii::import('ext.PHPExcel.PHPExcel');
    $objPHPExcel = new PHPExcel();

    // Set column widths
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
    // $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
    // $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);

    // Set headers
    $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Employee Code')
                ->setCellValue('C1', 'Employee Name')
                ->setCellValue('D1', 'App Status');
                // ->setCellValue('E1', 'Device Id')
                // ->setCellValue('F1', 'Device Type');

    $objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true)->setSize(12);
    
   // Fill data
$rowCount = 2;
$number = 1;

foreach ($modelDevices as $device) {
$objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, $number);
$objPHPExcel->getActiveSheet()->setCellValue('B' . $rowCount, $this->ciphertext($device->employee_details->employee_code, "d"));
$objPHPExcel->getActiveSheet()->setCellValue('C' . $rowCount, $device->employee_details->de_first_name);
$objPHPExcel->getActiveSheet()->setCellValue('D' . $rowCount, $device->device_id ? 'Installed' : 'Not Installed');

// Set the alignment for the Employee Code cell (column B  AND A)
$objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
$objPHPExcel->getActiveSheet()->getStyle('B' . $rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

$rowCount++;
$number++;
}

// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Employee Device Details');
$objPHPExcel->setActiveSheetIndex(0);

// Set response headers for the download
header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
header('Content-Disposition: attachment;filename="Employee_Device_Details.xls"');
header('Cache-Control: max-age=0');
header('Cache-Control: max-age=1');
header('Cache-Control: cache, must-revalidate');
header('Pragma: public');

// Save the Excel file to output
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
exit; // Terminate the script to prevent any additional output

}
public function actionClearAllTokens() {
    $model = new User();
    $condition = 'employee_details.isActive="Y" AND company_id="'.Yii::app()->user->master_user_company_id.'" AND employee_id >0 AND token!=""';
    $model = $model->with('employee_details')->findAll(array('condition' => $condition));
    foreach ($model as $row) {
        $updated=date('Y-m-d H:i:s');
        $status= User::model()->updateByPk($row->id, array('token'=>'','updated_by' => Yii::app()->user->id,'updated_date_time'=>$updated)); 
    }
    if ($status > 0) {
        $jsonData['status'] = 'success';
    } else {
        $jsonData['status'] = 'error';
    }
        echo CJSON::encode($jsonData);
    }
public function actionClearAllStatus() {
    $model = new User();
    $condition = 'employee_details.isActive="Y" AND company_id="'.Yii::app()->user->master_user_company_id.'" AND employee_id >0 AND level="2"';
    $model = $model->with('employee_details')->findAll(array('condition' => $condition));
    foreach ($model as $row) {
        $updated=date('Y-m-d H:i:s');
        $status= User::model()->updateByPk($row->id, array('app_force_updated'=>'N','updated_by' => Yii::app()->user->id,'updated_date_time'=>$updated)); 
    }
    if ($status > 0) {
        $jsonData['status'] = 'success';
    } else {
        $jsonData['status'] = 'error';
    }
        echo CJSON::encode($jsonData);
    }


}
