<?php

class EmployeedetailsController extends Controller {

    public $layout = 'main';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('contact', 'SaveContact', 'DependantDetails', 'SaveDependantDetails', 'OrganizationChart','GetEmployeeList',
                    'LeaveExcuse','GetExcuseList','ViewMeetingRequest','PendingLeaves','GetPendingLeaveList','ViewLeavedetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionContact() {

        $id = (int) Yii::app()->request->getParam('id');
        $model = EmployeeContacts::model()->find(array('condition' => 'employee_id="' . $id . '"'));
        if (empty($model->id)) {
            $model = new EmployeeContacts();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('contact_details', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionSaveContact() {
        if (isset($_POST['EmployeeContacts'])) {
            $model = new EmployeeContacts();
            if ((int) @$_POST['EmployeeContacts']['id'] > 0) {
                $model = EmployeeContacts::model()->findByPK($_POST['EmployeeContacts']['id']);
                $model->id = (int) $_POST['EmployeeContacts']['id'];
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->scenario = 'staffadd';
            $model->attributes = $_POST['EmployeeContacts'];
            $model->address = $_POST['EmployeeContacts']['address'];
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDependantDetails() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_dependants = EmployeeDependants::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
        if (empty($model_dependants)) {
            $model_dependants = array(new EmployeeDependants());
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('dependants_details', array('model_dependants' => $model_dependants, 'id' => $id), false, true);
    }

    public function actionSaveDependantDetails() {
        if (isset($_POST['EmployeeDependants'])) {
            $valid = true;
            foreach ($_POST['EmployeeDependants'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model_dependants[$i] = EmployeeDependants::model()->findByPK($items['id']);
                    $model_dependants[$i]->updated_by = Yii::app()->user->id;
                    $model_dependants[$i]->updated_date_time = date('Y-m-d h:i:s');
                } else {
                    $model_dependants[$i] = new EmployeeDependants();
                    $model_dependants[$i]->created_by = Yii::app()->user->id;
                    $model_dependants[$i]->created_date_time = date('Y-m-d h:i:s');
                }
                $model_dependants[$i]->dependant_name = $items['dependant_name'];
                $model_dependants[$i]->relationship = $items['relationship'];
                $model_dependants[$i]->employee_id = $items['employee_id'];
                $model_dependants[$i]->nationality = $items['nationality'];
                if ($items['date_of_birth'] != '' && $items['date_of_birth'] != '0000-00-00') {
                    $model_dependants[$i]->date_of_birth = date("Y-m-d", strtotime(str_replace('/', '-', $items['date_of_birth'])));
                }
                $valid = $model_dependants[$i]->validate() && $valid;
            }
            if ($valid) {
                if (!empty($model_dependants)) {
                    foreach ($model_dependants as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model_dependants, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionOrganizationChart() {
        $model_module_org_chart = HrModules::model()->findByPK(35);
        $id = Yii::app()->request->getparam('id');
        if ($model_module_org_chart->grant_access == 1 && $model_module_org_chart->isActive == 'Y'){
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('organization_chart', array('id' => $id), false, true);
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeList() {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $id = $_POST['id'];
        $columns = array(
            0 => 'id',
            1 => 'employee_code',
            2 => 'first_name',
            3 => 'department',
            4 => 'designation',
            5 => 'date_join'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" and reporting_manager="'.$id.'"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition = " (employee_code LIKE '%" . $searchString_en . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $joining_date = "";
            if ($row['date_join'] != '' && $row['date_join'] != '0000-00-00') {
                $joining_date = date("d/m/Y", strtotime($row->date_join));
            }
            $rowData[] = array($m,$this->ciphertext($row['employee_code'], "d"), $this->ciphertext($row['first_name'], "d") . ' ' . $this->ciphertext($row['last_name'], "d"), $row->departmentdetail->department_name, $row->designationdetail->designation_name, $joining_date);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionLeaveExcuse() {
        $id = Yii::app()->request->getparam('id');
        $model_module_leave = HrModules::model()->findByPK(3);
        if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('leave_excuse', array('id' => $id), false, true);
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetExcuseList() {
        $model = new EmployeeLeaveExcuse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $id = $_POST['id'];
        $columns = array(
            0 => 't.id',
            1 => 'request_date',
            2 => 'employeedetail.employee_code',
            3 => 'employeedetail.first_name',
            4 => 'departmentdetail.department_name',
            5 => 'designationdetail.designation_name',
            6 => 'type',
            7 => 'customer_name',
            8 => 'excuse_reason',
            9 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'employeedetail.isActive="Y" and employeedetail.reporting_manager="'.$id.'" and YEAR(request_date)="'.date('Y').'"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%' OR request_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail','employeedetail.departmentdetail','employeedetail.designationdetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail','employeedetail.departmentdetail','employeedetail.designationdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $type='';
            if ($row['type'] == 1) {
                $type = 'Meeting';
            } else {
                $type = 'Excuse';
            }
            $button_string= '<button class="btn btn-primary btn-xs" title="Excuse / Meeting Requests" onclick="loadPopupModal(\'hr/employeedetails/viewmeetingrequest&id=' . $row['id'] . '\',\'' . $type . ' Requests \',\'lg\')"><i class="fa fa-eye"></i></button>';
            $rowData[] = array($m, date('d/m/Y', strtotime($row['request_date'])),$this->ciphertext($row['employeedetail']['employee_code'], "d"),$row['employeedetail']['employeefullname'], $row->employeedetail->departmentdetail->department_name, $row->employeedetail->designationdetail->designation_name, $type, $row['customer_name'],'<div title="'.$row['excuse_reason'].'">'.$row['excuse_reason'].'</div>',$button_string,);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionViewMeetingRequest() {
        $model = new EmployeeLeaveExcuse();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('request_view', array('model' => $model, 'id' => $id), false, true);
    }
    public function actionPendingLeaves() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('pending_applied_leaves');
    }
    public function actionGetPendingLeaveList() {
        $model = new EmployeeLeaveDetail();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'leavetype.leave_name',
            4 => 'apply_date',
            5 => 'leave_start_date',
            6 => 'leave_end_date',
            7 => 'no_days',
            8 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $user_login_id = Yii::app()->user->id;
        $model_user = User::model()->findbypk($user_login_id);
        $model_employee = Employee::model()->findByPk($model_user->employee_id);
        $condition = "employeedetail.branch_or_sponsor_id='".$model_employee->branch_or_sponsor_id."' and leave_status='1'";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%' OR leavetype.leave_name LIKE '%".$searchString."%')";      
        }
        $count = $model->with('employeedetail', 'leavetype')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'leavetype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' =>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $apply_date = "";
            $leave_start_date = "";
            $leave_end_date = "";
            $button_string = "";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }
            if ($row['leave_start_date'] != '' && $row['leave_start_date'] != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($row->leave_start_date));
            }
            if ($row['leave_end_date'] != '' && $row['leave_end_date'] != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($row->leave_end_date));
            }
            $button_string.= '<button class="btn btn-primary btn-xs" title="View Leave Details" onclick="loadPopupModal(\'hr/employeedetails/viewleavedetails&id=' . $row['id'] . '\',\'Employee Leave Details\',\'lg\')"><i class="fa fa-eye"></i></button>';
            $rowData[] = array($m, $this->ciphertext($row->employeedetail->employee_code, "d"),$row->employeedetail->employeefullname, $row->leavetype->leave_name, $apply_date, $leave_start_date, $leave_end_date, $row->no_days, $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    } 
    public function actionViewLeavedetails() {
        $model = new EmployeeLeaveDetail();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('leave_details_view', array('model' => $model, 'id' => $id), false, true);
    }
}
