<?php
class EmployeecheckerController extends Controller
{
    

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            
array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','GetEmployeeList','checker','Create','GetCheckerEmployeeList'),
                'expression' => '$user->isMember()',
            ),


            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    
public function actionGetEmployeeList(){
        $model=new Employee();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $id= $_POST['id'];
        $department= $_POST['dept'];
        $designation= $_POST['desg'];
        $branch_id= $_POST['branch_id'];
        $status= $_POST['status'];
        $team= $_POST['team'];
        $report_id= $_POST['report_id'];
        $columns = array(
            0 =>'id',
            1 =>'branch_or_sponsor_id',
            2 =>'employee_code',
            3 =>'first_name',
            4 =>'department',
            5 =>'designation',
            6 =>'date_join',
            7 =>'reporting_manager',
            8=>'t.id',
            9=>'isActive'
        );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
//                $condition = 't.isActive="Y"';
                $condition = '1=1';
                $model_user = User::model()->findByPk(Yii::app()->user->id);
                if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
                    $condition.= ' and t.reporting_manager="'.$model_user->department_head_id.'"';
                }
                if($status=="Y"){
                   $condition.= ' AND t.isActive!="B"';
                }else if($status=="N"){
                   $condition.= ' AND t.isActive="B"';
                }
                if($branch_id>0){
                    $condition.= ' and t.branch_or_sponsor_id="'.$branch_id.'"';
                }
                else{
                    if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                        $condition.= ' and t.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
                    }
                }
                if($id>0){
                    $condition.= ' and t.id="'.$id.'"';
                }
                if($department>0){
                    $condition.= ' and t.department="'.$department.'"';
                }
                if($designation>0){
                    $condition.= ' and t.designation="'.$designation.'"';
                }
                 if($team>0){
                    $condition.= ' and t.team_id="'.$team.'"';
                }
                 if($report_id>0){
                    $condition.= ' and t.reporting_manager="'.$report_id.'"';
                }
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $searchString_en=$this->ciphertext($searchString,"e");
                  $condition.=" and (id LIKE '%".$searchString."%' OR employee_biometric_code='".$searchString."' OR employee_code LIKE '%".$searchString_en."%' OR first_name LIKE '%".$searchString_en."%' OR middle_name LIKE '%".$searchString_en."%' OR last_name LIKE '%".$searchString_en."%')";      
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'id asc'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=$offset;
                $model_general_setting = HrGenerelSettings::model()->find();
                foreach ($model as $row)
                {
                    $button_string="";
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_edit'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Edit Employee Details" onclick="loadPopupModal(\'hr/employee/create&id='.$row['id'].'\',\''.$row['employeefullname'].' \',\'xl\')"><i class="fa fa-edit"></i></button>';
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_view'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= ' <button class="btn btn-success btn-xs" title="View Employee Details" onclick="loadPopupModal(\'hr/employee/view&id='.$row['id'].'\',\''.$row['employeefullname'].' \',\'xl\')"><i class="fa fa-eye"></i></button>';
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_block_unblock'])  || Yii::app()->user->authorised_user == 1) {
                        if($row['isActive']!='B'){
                            $button_string .=' <a href ="javascript:void(0);" title="Block Employee Details" class="btn btn-danger btn-xs" title="Block" onclick="BlockEmployee(' . $row['id'] . ')"><i class="fa fa-ban "></i></a>' ;
                        }else{
                            $button_string .=' <a href ="javascript:void(0);" title="Unblock Employee Details" class="btn btn-success btn-xs" title="UnBlock" onclick="UnBlockEmployee(' . $row['id'] . ')"><i class="fa fa-retweet"></i></a>' ;
                        }
                    }
                    if($model_general_setting->enable_mail=='Y'){
                        if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_send_password'])  || Yii::app()->user->authorised_user == 1) {                        
                            $button_string .=' <a href ="javascript:void(0);" class="btn btn-warning btn-xs" title="Reset & Send Employee Password" onclick="resetpassword('.$row['id'].')"><i class="fa fa-lock"></i></a>' ;
                        }
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_snapshot_tab']) || Yii::app()->user->authorised_user == 1) {
                        $button_string.= ' <a href="?r=hr/employee/printemployeesnapshotpdf&id='.$this->ciphertext($row['id'],"e").'" title="Print Snapshot" target="_blank"><button class="btn btn-default btn-xs" title="Print Snapshot" ><i class="fa fa-print"></i></button></a>';
                    }
                    $joining_date="";
                    if($row['date_join']!='' && $row['date_join']!='0000-00-00'){
                        $joining_date=date("d/m/Y",strtotime($row->date_join));
                    }
                    $rowData[]=array(++$m,
                        
                        $this->ciphertext($row['employee_code'],"d"),
                        $this->ciphertext($row['first_name'],"d").' '.$this->ciphertext($row['last_name'],"d"),
                        $row->employee_iban_no,
                        $row->employee_iban_no,
                        $row->employee_wps_company,
                        $row->reportingmanager->employeefullname,
                        $button_string,
                        $row['isActive']);
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    

public function actionGetCheckerEmployeeList(){
        $model=new Employee();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $id= $_POST['id'];
        $department= $_POST['dept'];
        $designation= $_POST['desg'];
        $branch_id= $_POST['branch_id'];
        $status= $_POST['status'];
        $team= $_POST['team'];
        $report_id= $_POST['report_id'];
        $columns = array(
            0 =>'id',
            1 =>'branch_or_sponsor_id',
            2 =>'employee_code',
            3 =>'first_name',
            4 =>'department',
            5 =>'designation',
            6 =>'date_join',
            7 =>'reporting_manager',
            8=>'t.id',
            9=>'isActive'
        );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
//                $condition = 't.isActive="Y"';
                $condition = '1=1';
                $model_user = User::model()->findByPk(Yii::app()->user->id);
                if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
                    $condition.= ' and t.reporting_manager="'.$model_user->department_head_id.'"';
                }
                if($status=="Y"){
                   $condition.= ' AND t.isActive!="B"';
                }else if($status=="N"){
                   $condition.= ' AND t.isActive="B"';
                }
                if($branch_id>0){
                    $condition.= ' and t.branch_or_sponsor_id="'.$branch_id.'"';
                }
                else{
                    if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                        $condition.= ' and t.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
                    }
                }
                if($id>0){
                    $condition.= ' and t.id="'.$id.'"';
                }
                if($department>0){
                    $condition.= ' and t.department="'.$department.'"';
                }
                if($designation>0){
                    $condition.= ' and t.designation="'.$designation.'"';
                }
                 if($team>0){
                    $condition.= ' and t.team_id="'.$team.'"';
                }
                 if($report_id>0){
                    $condition.= ' and t.reporting_manager="'.$report_id.'"';
                }
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $searchString_en=$this->ciphertext($searchString,"e");
                  $condition.=" and (id LIKE '%".$searchString."%' OR employee_biometric_code='".$searchString."' OR employee_code LIKE '%".$searchString_en."%' OR first_name LIKE '%".$searchString_en."%' OR middle_name LIKE '%".$searchString_en."%' OR last_name LIKE '%".$searchString_en."%')";      
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'id asc'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=$offset;
                $model_general_setting = HrGenerelSettings::model()->find();
                foreach ($model as $row)
                {
                    $button_string="";
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_edit'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Edit Employee Details" onclick="loadPopupModal(\'hr/employee/create&id='.$row['id'].'\',\''.$row['employeefullname'].' \',\'xl\')"><i class="fa fa-edit"></i></button>';
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_view'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= ' <button class="btn btn-success btn-xs" title="View Employee Details" onclick="loadPopupModal(\'hr/employee/view&id='.$row['id'].'\',\''.$row['employeefullname'].' \',\'xl\')"><i class="fa fa-eye"></i></button>';
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_block_unblock'])  || Yii::app()->user->authorised_user == 1) {
                        if($row['isActive']!='B'){
                            $button_string .=' <a href ="javascript:void(0);" title="Block Employee Details" class="btn btn-danger btn-xs" title="Block" onclick="BlockEmployee(' . $row['id'] . ')"><i class="fa fa-ban "></i></a>' ;
                        }else{
                            $button_string .=' <a href ="javascript:void(0);" title="Unblock Employee Details" class="btn btn-success btn-xs" title="UnBlock" onclick="UnBlockEmployee(' . $row['id'] . ')"><i class="fa fa-retweet"></i></a>' ;
                        }
                    }
                    if($model_general_setting->enable_mail=='Y'){
                        if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_send_password'])  || Yii::app()->user->authorised_user == 1) {                        
                            $button_string .=' <a href ="javascript:void(0);" class="btn btn-warning btn-xs" title="Reset & Send Employee Password" onclick="resetpassword('.$row['id'].')"><i class="fa fa-lock"></i></a>' ;
                        }
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_snapshot_tab']) || Yii::app()->user->authorised_user == 1) {
                        $button_string.= ' <a href="?r=hr/employee/printemployeesnapshotpdf&id='.$this->ciphertext($row['id'],"e").'" title="Print Snapshot" target="_blank"><button class="btn btn-default btn-xs" title="Print Snapshot" ><i class="fa fa-print"></i></button></a>';
                    }
                    $joining_date="";
                    if($row['date_join']!='' && $row['date_join']!='0000-00-00'){
                        $joining_date=date("d/m/Y",strtotime($row->date_join));
                    }
                    $rowData[]=array(++$m,
                        
                        $this->ciphertext($row['employee_code'],"d"),
                        $this->ciphertext($row['first_name'],"d").' '.$this->ciphertext($row['last_name'],"d"),
                        $row->employee_iban_no,
                        $row->employee_iban_no,
                        $row->employee_wps_company,
                        $row->reportingmanager->employeefullname,
                        $button_string,
                        $row['isActive']);
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }



public function actionCreate(){
        $model=new Employee(); 
        $model_asset=array(new EmployeeAsset()); 
        $model_leave=array(new EmployeeLeave());  
        $emp_wps =new EmployeewpsCompany();     
        $model_inoutdocument=array(new EmployeeInoutDocument());     
        $model_documents=array(new EmployeeDocuments());   
        $model_salary=array(new EmployeeSalary());   
        $model_employee_salary=array(new EmployeeSalary()); 
        $model_notes=array(new EmployeeNotes()); 
        $model_dependants=array(new EmployeeDependants()); 
        $model_qualification=array(new HrEmployeeQualification()); 
        $id=(int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($id>0){
            $model=$model->findByPk($id);
            $model_qualification= HrEmployeeQualification::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
            if(empty($model_qualification)){
                $model_qualification=array(new HrEmployeeQualification()); 
            }
            $model_dependants= EmployeeDependants::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
            if(empty($model_dependants)){
                $model_dependants=array(new EmployeeDependants()); 
            }
            $model_asset= EmployeeAsset::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
            $emp_wps= EmployeewpsCompany::model()->find(array('condition' => 'employee_id="'. $id.'"'));
            if(empty($model_asset)){
                $model_asset=array(new EmployeeAsset()); 
            }
            $model_setting = HrGenerelSettings::model()->find();
            $year = date("Y");
            $current_month = date("m");
            if($current_month<$model_setting->leave_carry_forward_month){
               $year=$year-1;
            }
            $model_leave= EmployeeLeave::model()->findAll(array('condition' => 'employee_id="'. $id.'" and leave_year="'.$year.'"'));
//            if(empty($model_leave)){
//                $model_leave=array(new EmployeeLeave()); 
//            }   
            $model_inoutdocument=array(new EmployeeInoutDocument()); 
            $model_inoutdocument_details= EmployeeInoutDocument::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));           
            $model_documents= EmployeeDocuments::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
            if(empty($model_documents)){
                $model_documents=array(new EmployeeDocuments()); 
            }  
            $model_salary= EmployeeSalary::model()->findAll(array('condition' => 'employee_id="'. $id.'" and isActive="Y"'));
            if(empty($model_salary)){
                $model_salary=array(new EmployeeSalary()); 
            }  
            $model_salary_details_employee= EmployeeSalary::model()->with('salary')->findAll(array('condition' => 'employee_id="'. $id.'" and t.isActive="N"','order'=>'salary.salary_name asc'));
            if(empty($model_salary_details_employee)){
                $model_salary_details_employee=array(new EmployeeSalary()); 
            }  
            $model_employee_salary=array(new EmployeeSalary()); 
            $model_loan= EmployeeLoanDetail::model()->findAll(array('condition' => 'employee_id="'. $id.'" and loan_status!=0'));
            $model_issued_certificates= EmployeeCertificate::model()->findAll(array('condition' => 'employee_id="'. $id.'" and (status="12" OR status="14")'));
            $model_warning_notice= EmployeeAttendanceWarning::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
            $model_notes= EmployeeNotes::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
            $model_contact= EmployeeContacts::model()->find(array('condition' => 'employee_id="'. $id.'"'));
            if($model_contact->id==''){
                $model_contact=new EmployeeContacts(); 
            }
            $model_training_details= HrTrainingDetails::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
            $this->renderPartial('create_employee', array('model' => $model,'model_contact' => $model_contact,'model_qualification' => $model_qualification,'model_training_details'=>$model_training_details,'model_dependants'=>$model_dependants,'model_notes'=>$model_notes,'model_warning_notice' => $model_warning_notice,'model_inoutdocument_details'=>$model_inoutdocument_details,'model_employee_salary'=>$model_employee_salary,'emp_wps'=>$emp_wps,'model_asset' => $model_asset,'model_leave' => $model_leave,'model_inoutdocument' => $model_inoutdocument,'model_issued_certificates' => $model_issued_certificates,'model_documents' => $model_documents,'model_salary' => $model_salary,'model_loan' => $model_loan,'model_salary_details_employee' =>$model_salary_details_employee), false, true);
        }else{
            $model_mas_company=MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
            $total_employee_count = Employee::model()->count();
            if($total_employee_count<=$model_mas_company->total_employees_allowed){
                $this->renderPartial('create', array('model' => $model), false, true);
            }else{
                throw new CHttpException(404, 'Page not found.');
            }
        }                                     
    }

}
