<?php

class DocumentController extends Controller
{    
 public $layout = 'main';
    public function accessRules() {
        return array(
                array('allow', 
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', 
                    'actions' => array('index','UpdateDocument','Upload','DownloadDocument'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', 
                    'users' => array('*'),
                    ),
                );
    }
 
    public function actionIndex() {
        $this->layout = 'main';
        $model_module_employee = HrModules::model()->findByPK(1);
        if ($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y') {
            $model = new Employee();
            $model_documents = array(new EmployeeDocuments());
            $employee_id = Yii::app()->user->id;
            $modelemployee = User::model()->findByPK($employee_id);
            $model_settings = HrGenerelSettings::model()->find();
            $id = $modelemployee->employee_id;
            if ($id > 0) {
                $model = $model->findByPk($id);
                //$model_documents= EmployeeDocuments::model()->findAll(array('condition' => 'employee_id="'. $id.'"'));
                $model_documents = EmployeeDocuments::model()->with('document')->findAll(array('condition' => 'employee_id="' . $id . '" and document.view_in_employee="Y"'));
                if (empty($model_documents)) {
                    $model_documents = array(new EmployeeDocuments());
                }
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_document', array('model' => $model, 'model_documents' => $model_documents, 'model_settings' => $model_settings), false, true);
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionUpdateDocument() {
        if (isset($_POST['EmployeeDocuments'])) {            //print_r($_POST); die();
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['EmployeeDocuments'])) && ($_POST['EmployeeDocuments'][0]['document_id']!='')){			
                foreach ($_POST['EmployeeDocuments'] as $i => $items) {
                    if($items['id']>0){
                        $model_document[$i] = EmployeeDocuments::model()->findByPK($items['id']);   
                        $model_document[$i]->scenario = 'add';
                        $model_document[$i]->created_by= Yii::app()->user->id;
                        $model_document[$i]->created_date_time = date('Y-m-d h:i:s');
                    }else{
                        $model_document[$i] = new EmployeeDocuments();   
                        $model_document[$i]->scenario = 'update';
                        $model_document[$i]->updated_by= Yii::app()->user->id;
                        $model_document[$i]->updated_date_time = date('Y-m-d h:i:s');
                    }   
										
                    $model_document[$i]->document_id = $items['document_id'];
                    $model_document[$i]->document_number = $items['document_number'];
                    $model_document[$i]->employee_id = $items['employee_id'];
                    $model_document[$i]->document_file = $items['document_file'];
                    if ($items['validate_till_date'] != '' && $items['validate_till_date'] != '0000-00-00') {
                        $items['validate_till_date'] = str_replace('/', '-', $items['validate_till_date']);
                        $valid_date=date("Y-m-d", strtotime($items['validate_till_date']));
                        $model_document[$i]->validate_till_date = $valid_date;
                        $current_date=date("Y-m-d");
                        if (strtotime($valid_date)>strtotime($current_date)){
                            $model_document[$i]->status =0;
                            $model_document[$i]->expiry_notify =0;
                        }
                    }
                    if ($items['renew_on'] != '' && $items['renew_on'] != '0000-00-00') {
                        $items['renew_on'] = str_replace('/', '-', $items['renew_on']);
                        $model_document[$i]->renew_on = date("Y-m-d", strtotime($items['renew_on']));                   
                    }
					
                    $valid=$model_document[$i]->validate() && $valid;
                    
                }
            }
            if($valid){
                //SaveDocument
                if (!empty($model_document)) {
                    foreach ($model_document as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
				Yii::app()->end();
            }else{
                $error1=array();
                if ($model_document[0]->document_id > 0){
                   $error1 = json_decode(CActiveForm::validateTabular($model_document, '', false), true);
                }
         
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    
    public function actiondownloadDocument() {
        $id =Yii::app()->request->getParam('id');		
        $arr_employee_document = EmployeeDocuments::model()->findByPk($id);		
        $file = $arr_employee_document->document_file;
        $arr_doc_val = explode(',', $arr_employee_document->document_file);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" .$arr_employee_document->document->document_name . "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/documents/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_employee_document->document_file;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
 
}