<?php

class DisablepayslipController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'deleteInOut','GetList','SaveDisapbleslip'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
     if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_menu']) || Yii::app()->user->authorised_user == 1) {
         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {

        $model = new MasCompanyBranchSponsor();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'branch_or_sponsor_name',           
            2 => 'salary_slip_view_ess',
            3 =>'id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = ' t.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (branch_or_sponsor_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";

            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_edit']) || Yii::app()->user->authorised_user == 1) {
                $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/branch/create&id=' . $row['id'] . '\',\'Edit Branch \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            $context_data = array(
                "id" => $row['id'],
                'status' => $row['isActive']
            );
            $rowData[] = array($m, $row['branch_or_sponsor_name'], $row['salary_slip_view_ess'], $row['id'], $context_data);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasCompanyBranchSponsor();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveDisapbleslip() {
        $model = new MasCompanyBranchSponsor;
        if (isset($_POST['MasCompanyBranchSponsor'])) {
            if ((int) @$_POST['MasCompanyBranchSponsor']['id'] > 0) {
                $model->id = (int) $_POST['MasCompanyBranchSponsor']['id'];
                $model->scenario = 'update';
                $model = MasCompanyBranchSponsor::model()->findByPK($_POST['MasCompanyBranchSponsor']['id']);
            } 
            $model->salary_slip_view_ess = $_POST['MasCompanyBranchSponsor']['salary_slip_view_ess'];
                $model->save();
                $jsonData['model'] = 'MasCompanyBranchSponsor';
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
    }
}
  
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasCompanyBranchSponsor();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}
