<?php

class CurrencyController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetCurrencyList', 'SaveCurrency', 'DisableCurrency', 'DirectAdd'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_currency_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetCurrencyList() {
        $model = new MasCurrency();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'currency',
            2 => 'currency_code',
            3 => 'exchange_rate'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = "1=1 ";
            $searchString = $_POST['search']['value'];
            $condition.=" and (currency LIKE '%" . $searchString . "%' OR currency_code LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $edit_button=$disable_button=0;
        foreach ($model as $row) {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_currency_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_currency_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button=1;
            }
            $rowData[] = array($m,
                $row['currency'],
                $row['currency_code'],
                $row['exchange_rate'],
                array('id' => $row['id'], 'code' => $row['currency'], 'isActive' => $row['isActive'],'edit_button'=>$edit_button,'disable_button'=>$disable_button));

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasCurrency();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('currency_form', array('model' => $model), false, false);
    }

    public function actionSaveCurrency() {
        $model = new MasCurrency();
        if (isset($_POST['MasCurrency'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasCurrency']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasCurrency']['id'];
                $model = $model->findByPk($id);
                 $model->scenario = 'update';
            } else {
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['MasCurrency'];
            if ($model->save()) {
                $currency_form ="";
                if(!empty($_POST['currency_form'])){
                     $currency_form = $_POST['currency_form'];
                }
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $currency_form;
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
                // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
            // $this->render('currency_form', array('model' => $model), false, true);
        }
    }

    public function actionDisableCurrency() {
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['id'];
        /* $model_c = Customer::model()->findAll(array('condition' =>'customer_currency_id = '.$id.' '));
          $model_com = Company::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_cr = Creditnote::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_in = Invoice::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_l = Lead::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_o = Order::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_pi = PurchasingInvoice::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_po = PurchasingOrder::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_q = Quotes::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_v = Vendor::model()->findAll(array('condition' =>'vendor_currency_id = '.$id.' '));
          if(empty($model_c) && empty($model_com) && empty($model_cr) && empty($model_in) && empty($model_l) && empty($model_o) && empty($model_pi) && empty($model_po) && empty($model_q) && empty($model_v)){
         */
        if (!empty($id)) {
            $model = new MasCurrency();
            $model = $model->findByPk($id);
            if ($model->isActive == 'N') {
                $model->isActive = 'Y';
            }else{
                $model->isActive = 'N';            
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $model->save(FALSE);
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $code = $_POST['code'];
        $rate = $_POST['rate'];
        if ($name != '' && $code != '' && $rate != '') {
            $modelCurrency = new MasCurrency;
            $modelCurrency->created_by = Yii::app()->user->id;
            $modelCurrency->created_datetime = date('Y-m-d h:i:s');
            $modelCurrency->currency = $name;
            $modelCurrency->currency_code = $code;
            $modelCurrency->exchange_rate = $rate;
            if ($modelCurrency->save()) {
                $data = MasCurrency::getCurrency();
                if ($from == 'customer') {
                    $model = new Customer;
                    $field_name = 'customer_currency_id';
                }
                if ($from == 'lead') {
                    $model = new Lead;
                    $field_name = 'currency';
                }
                if ($from == 'quote') {
                    $model = new Quotes;
                    $field_name = 'currency';
                }
                if ($from == 'order') {
                    $model = new Order;
                    $field_name = 'currency';
                }
                if ($from == 'invoice') {
                    $model = new Invoice;
                    $field_name = 'currency';
                }
                if ($from == 'vendor') {
                    $model = new Vendor;
                    $field_name = 'vendor_currency_id';
                }
                $model->$field_name = $modelCurrency->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Currency'));
                $status = array("status" => "success", "drop" => $drop, "rate" => $modelCurrency->exchange_rate);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelCurrency, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
