<?php

class CompanydocumentController extends Controller
{
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','deleteDocument','SaveDocument','GetList','Upload','UploadCompanyDocuments','downloadDocument'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_company_doc_menu']) || Yii::app()->user->authorised_user == 1) {    
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
         
    public function actionGetList(){
        $model=new CompanyDocument();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 =>'t.id',
            1 =>'documentname.document_name',
            2 =>'document_number',
            3 =>'validate_till_date',
            4 =>'renew_on',
            5 =>'t.id',
            6=> 't.id',
           );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition='1=1';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" and (documentname.document_name LIKE '%".$searchString."%' OR document_number LIKE '%".$searchString."%')";
        }
        $count = $model->with('documentname')->count(array('condition'=>$condition));
        $model=$model->with('documentname')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";
            $download_button=0;
            if($row->document_file!=''):    
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_company_doc_download'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<a class="btn btn-primary btn-xs" title="Download" href='.$this->createUrl('companydocument/downloaddocument',array('id'=>$row['id'])).' target="_blank"><i class="fa fa-download"></i></a>';
                    $download_button =1;
                }
            endif;
            if($row['document_type'] == '1'){
                $type   = "Documents";
            }
            else if($row['document_type'] == '2'){
                $type   = "Vehicles";
            }
            $validate_till_date='';
            $renew_on='';
            if($row['validate_till_date']!='' && $row['validate_till_date']!='0000-00-00'){
                $validate_till_date=date("d/m/Y", strtotime($row['validate_till_date']));
            }
            if($row['validate_till_date']!='' && $row['validate_till_date']!='0000-00-00'){
                $renew_on=date("d/m/Y", strtotime($row['renew_on']));
            }
            $rowData[]=array($m,$row['documentname']['document_name'],$row['document_number'],$validate_till_date,$renew_on,$type,array('id'=>$row['id'],'download_button'=>$download_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model_documents= CompanyDocument::model()->findAll(array('condition' => 'company_id="'.Yii::app()->user->master_user_company_id.'"'));
        if(empty($model_documents)){
            $model_documents=array(new CompanyDocument()); 
        }            
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('document_form', array('model_documents' => $model_documents), false, true);
    }
     public function actionSaveDocument() {
        if (isset($_POST['CompanyDocument'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['CompanyDocument'])) && ($_POST['CompanyDocument'][0]['document_id']!='')){			
                foreach ($_POST['CompanyDocument'] as $i => $items) {
                    if($items['id']>0){
                        $model_document[$i] = CompanyDocument::model()->findByPK($items['id']);   
                        $model_document[$i]->scenario = 'add';
                        $model_document[$i]->updated_by= Yii::app()->user->id;
                        $model_document[$i]->updated_date_time = date('Y-m-d H:i:s');
                    }else{
                        $model_document[$i] = new CompanyDocument();   
                        $model_document[$i]->scenario = 'update';
                        $model_document[$i]->created_by= Yii::app()->user->id;
                        $model_document[$i]->created_date_time = date('Y-m-d H:i:s');
                    }   
										
                    $model_document[$i]->document_id = $items['document_id'];
                    $model_document[$i]->document_number = $items['document_number'];
                    $model_document[$i]->document_type = $items['document_type'];
                    $model_document[$i]->company_id=Yii::app()->user->master_user_company_id;
                    $model_document[$i]->document_file = $items['document_file'];
                    if ($items['validate_till_date'] != '' && $items['validate_till_date'] != '0000-00-00') {
                        $items['validate_till_date'] = str_replace('/', '-', $items['validate_till_date']);
                        $valid_date=date("Y-m-d", strtotime($items['validate_till_date']));
                        $model_document[$i]->validate_till_date = $valid_date;
                        $current_date=date("Y-m-d");
                        if (strtotime($valid_date)>strtotime($current_date)){
                            $model_document[$i]->status =0;
                            $model_document[$i]->expiry_notify =0;
                        }
                    }
                    if ($items['renew_on'] != '' && $items['renew_on'] != '0000-00-00') {
                        $items['renew_on'] = str_replace('/', '-', $items['renew_on']);
                        $model_document[$i]->renew_on = date("Y-m-d", strtotime($items['renew_on']));                   
                    }
					
                    $valid=$model_document[$i]->validate() && $valid;
                    
                }
            }
            if($valid){
                //SaveDocument
                if (!empty($model_document)) {
                    foreach ($model_document as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
				Yii::app()->end();
            }else{
                $error1=array();
                if ($model_document[0]->document_id > 0){
                   $error1 = json_decode(CActiveForm::validateTabular($model_document, '', false), true);
                }
         
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    public function actiondeleteDocument(){
        $id = $_POST['id'];
        if($id>0){

            $model = new CompanyDocument();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
     public function actiondownloadDocument() {
        $id =Yii::app()->request->getParam('id');		
        $company_document = CompanyDocument::model()->findByPk($id);		
        $file = $company_document->document_file;
        $arr_doc_val = explode(',', $company_document->document_file);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" .$company_document->documentname->document_name . "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/documents/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $company_document->document_file;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
 
}