<?php

class CircularController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'DeleteCircular', 'SaveCircular', 'GetList', 'DirectAdd', 'UploadCircular','getEmployeeName','deletecirculardocument',
                    'ViewCircular', 'ClearCircular','OutIndex','indoorindex','OutdoorIndex','downloadDocument','downloadCircularDocument','clearcirculardetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $model_module_circular = HrModules::model()->findByPK(18);
        if ($model_module_circular->grant_access == 1 && $model_module_circular->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_others_incircular_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {

        $model = new CompanyCircular();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $type= $_POST['type'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'branch_or_sponsor_id',
            2 => 'title',
            3 => 'notes',
            4 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" and circular_type="'.$type.'"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (t.notes LIKE '%" . $searchString . "%')";
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and t.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = '';
            $edit_circular =$delete_circular=$delete_outcircular=$edit_outcircular=0;
            if($type=='1'){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_indoor_circular_edit'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/circular/create&id=' . $row['id'] . '\',\'Edit Circular \',\'lg\')"><i class="fa fa-edit"></i></button>';
                    $edit_circular=1;
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_indoor_circular_delete'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="DeleteCircular(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                    $delete_circular =1;
                }
            }else{                
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_outdoor_circular_edit'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/circular/create&id=' . $row['id'] . '\',\'Edit Circular \',\'lg\')"><i class="fa fa-edit"></i></button>';
                    $edit_outcircular=1;
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_outdoor_circular_delete'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="DeleteCircular(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                    $delete_outcircular =1;
                    
                }
            }
            $branch_name =array();
            $branchname="";
            $branch_id=explode(',',$row['branch_or_sponsor_id']);
            foreach ($branch_id as $value) {                            
                $branch_name[]=MasCompanyBranchSponsor::model()->findbyPk($value)->branch_or_sponsor_name;
            }
            if(!empty($branch_name)){
                $branchname=  implode(',', $branch_name);
            }
            $rowData[] = array($m, $branchname,$row['title'], $row['notes'], array('id'=>$row['id'],'edit_circular'=>$edit_circular,'delete_circular'=>$delete_circular,'delete_outcircular'=>$delete_outcircular,'edit_outcircular'=>$edit_outcircular));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new CompanyCircular();
        $id = (int) Yii::app()->request->getParam('id');
        $type = (int) Yii::app()->request->getParam('type');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('circular_form', array('model' => $model,'type'=>$type), false, true);
    }
    public function actiongetEmployeeName() {
        $model = new CompanyCircular();  
        $id = implode(',', $_POST['id']);   
        $jsonData['emp_name'] = CHtml::activeDropdownlist($model,"employee_id", Employee::getMultipleBranchEmployee($id), array('multiple' => true,'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
        $jsonData['status'] = 'success';
        
        echo CJSON::encode($jsonData);
    }

    public function actionSaveCircular() {
        if (isset($_POST['CompanyCircular'])) {
            $model = new CompanyCircular();
            if ((int) @$_POST['CompanyCircular']['id'] > 0) {
                $model->id = (int) $_POST['CompanyCircular']['id'];
                $model = $model->findByPK($model->id);
            }
            $model->attributes = $_POST['CompanyCircular'];
            $model->circular_type = $_POST['CompanyCircular']['circular_type'];
            $model->circular_document = $_POST['CompanyCircular']['circular_document'];
            $model->title = $_POST['CompanyCircular']['title'];
            $model->notes = $_POST['CompanyCircular']['notes'];
            if(isset($_POST['CompanyCircular']['branch_or_sponsor_id']) && count($_POST['CompanyCircular']['branch_or_sponsor_id']) > 0){
                $model->branch_or_sponsor_id = implode(',',$_POST['CompanyCircular']['branch_or_sponsor_id']);
            }else{
                $model->branch_or_sponsor_id = "";
            }
            if(isset($_POST['CompanyCircular']['employee_id']) && count($_POST['CompanyCircular']['employee_id']) > 0){
                $model->employee_id = implode(',',$_POST['CompanyCircular']['employee_id']);
            }else{
                $model->employee_id = "";
            }
            $model->date_circular = date('Y-m-d');          
            $model->created_by = Yii::app()->user->id;
            if ($model->validate()) {
                $model->save();      
                 //Mail
                $type=$_POST['CompanyCircular']['circular_type'];
                $mail_function=0;
                if($type==1){
                    $mail_function=21;
                }else{
                     $mail_function=22;
                }
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="'.$mail_function.'"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail($mail_function,0,$model->id);
                    }
                }
                $jsonData['type'] = $model->circular_type;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteCircular() {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id != 0) {
            CompanyCircular::model()->updateByPK($id, array('isActive' => 'N'));
            echo CJSON::encode(array('status' => 'success'));
        }
    }
    
    public function actionUploadCircular($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
    	$field_id = "";
        $new_file_name='';
        $current_date =date('Y-m-d');
    	if(isset($_GET['field_id']))
    	{
    		$field_id = Yii::app()->request->getParam('field_id');
                $new_file_name=$field_id.'_'.$current_date;
    	}  
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
    	// make the directory to store the pic:
    	if (!is_dir($folder)) {
    		mkdir($folder, 0777, TRUE);
    	}
    	$allowedExtensions = array("csv", "zip", "png", "txt", "pdf", "doc", "docx", "jpg", "jpeg", "gif"); //array("jpg","jpeg","gif","exe","mov" and etc...
    	$sizeLimit = 10 * 1024 * 1024; // maximum file size in bytes
    	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
    	$result = $uploader->handleUpload($folder,false,$new_file_name);
    	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
    	$result['field_id'] = $field_id;
    	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    	echo $return; // it's array
    }
    
    public function actionViewCircular() {
        $id = Yii::app()->request->getparam("id");
        $eid = Yii::app()->request->getparam("eid");
        $type = Yii::app()->request->getparam("type");
        $model = CompanyCircular::model()->findbyPK($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('view_circular', array('model' => $model, 'eid' => $eid), false, true);
    }

    public function actionClearCircular() {
        if (isset($_POST['CompanyCircular'])) {
            $id = $_POST['CompanyCircular'];
            $employee = $_POST['employeeid_circular'];
            $model = CompanyCircular::model()->findByPK($id);
            if ($model->employees_viewed != '') {
                $employees_viewed = $model->employees_viewed . ',' . $employee;
            } else {
                $employees_viewed = $employee;
            }
            $model->employees_viewed = $employees_viewed;
            $model->save(false);
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionOutIndex() {
        $model_module_circular = HrModules::model()->findByPK(18);
        if ($model_module_circular->grant_access == 1 && $model_module_circular->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_others_outcircular_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('outindex');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionIndoorIndex() {
        $this->layout = 'main';
        $model_module_circular = HrModules::model()->findByPK(18);
        if ($model_module_circular->grant_access == 1 && $model_module_circular->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('indoor_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionOutdoorIndex() {
         $this->layout = 'main';
        $model_module_circular = HrModules::model()->findByPK(18);
        if ($model_module_circular->grant_access == 1 && $model_module_circular->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('outdoor_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actiondownloadDocument() {
        $id = Yii::app()->request->getParam('id');
        $arr_employee_document = CompanyCircular::model()->findByPk($id);
        $file = "";
        $arr_doc_val = array();
        $file = $arr_employee_document->circular_document;
        $arr_doc_val = explode(',', $arr_employee_document->circular_document);       
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/circular/document.zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/leavedocument/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/circular/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
     public function actiondownloadCircularDocument() {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_employee_document = CompanyCircular::model()->findByPk($id);
        $file = $arr_employee_document->circular_document;
        $arr_doc_val = explode(',', $arr_employee_document->circular_document);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/circular/" . $arr_employee_document->branch_sponsor->branch_or_sponsor_name . "_" . date('d-m-Y') . ".zip";
           if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/circular/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_employee_document->circular_document;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/circular/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    
    public function actionclearcirculardetails() {
            $id = Yii::app()->request->getparam('id');
            $employee = Yii::app()->request->getparam('emp_id');
            $model = CompanyCircular::model()->findByPK($id);
            $employees_viewed='';
            if ($model->employees_viewed != '') {
                $employees_viewed = $model->employees_viewed . ',' . $employee;
            } else {
                $employees_viewed = $employee;
            }
            $model->employees_viewed = $employees_viewed;
            $model->save(false);
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
    }
    public function actiondeletecirculardocument() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $document_detail = new CompanyCircular();
        $model_documents = CompanyCircular::model()->findByPk($id);
        $document_file_array = explode(',', $model_documents->circular_document);
        if (($key = array_search($file_name, $document_file_array)) !== false) {
            unset($document_file_array[$key]);
            $files = '';
            if (!empty($document_file_array)) {
                $files = implode(',', $document_file_array);
            }
            CompanyCircular::model()->updateByPK($id, array('circular_document' => $files));
            unlink(Yii::getPathOfAlias('webroot') . "/uploads/circular/" . $file_name);
            $div_file = '<span id="spancircularfile_' . $i . '">';
            if (!empty($document_file_array)) {
                foreach ($document_file_array as $value_file) {
                    $f_name = "'" . $value_file . "'";
                    $div_file .= $value_file . '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deletecirculardocument(this.id,' . $id . ',' . $f_name . ');" id="delete_notice_file_' . $i . '"><i class="fa fa-trash"></i></a><br>';
                }
            }
            $files ='';
            $div_file .= '</span>';
           // $div_file .= CHtml::activeHiddenField($document_detail, "circular_document", array('value' => $files));
            echo $div_file;
        }
    }

}
