<?php

class CheckerController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetListIban', 'GetListMolid', 'GetListRoutingid', 'GetListWpscid'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

//code added by abin on 07-07-2023 to return the error data of iban
    public function actionGetListIban() {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'id',
        );

        $emp_id = $_POST['employee_ids'];
        $modelEmployee = new Employee();
        $count = $modelEmployee->count(array('condition' => 'id IN (' . $emp_id . ')'));
        $modelEmployee = $modelEmployee->findall(array('condition' => 'id IN (' . $emp_id . ')', 'offset' => $offset, 'limit' => $limit));
        $rowData = array();
        $m = $offset;
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        foreach ($modelEmployee as $eachEmployeeDetails) {
            $employee_id = $eachEmployeeDetails->id;
            $employee_name = $eachEmployeeDetails->de_first_name;
            $employee_iban_no = $eachEmployeeDetails->employee_iban_no;
            $employee_iban_no_len = strlen($employee_iban_no);
            $last_number = substr($employee_iban_no, 2);
            if ($employee_iban_no == '') {
                $err_blank = "IBAN Should not be blank" . "<font color=red>;</font>  <br>";
                $err_lastnum = "";
                $err_len = "";
                $err_ae = "";
                $err_space = "";
            } else if ($employee_iban_no != '') {
                $err_blank = "";
                if (is_numeric($last_number)) {
                    $err_lastnum = "";
                } else {
                    $err_lastnum = "Last 21 characters Should be Numeric" . "<font color=red>;</font>  <br>";
                }
                if ($employee_iban_no_len != '23') {
                    $err_len = "Length of IBAN Should be 23" . "<font color=red>;</font> <br>";
                } else {
                    $err_len = "";
                }
                if (preg_match('/\s/', $employee_iban_no)) {
                    $err_space = "IBAN Contains SPACE" . "<font color=red>;</font>  <br>";
                } else {
                    $err_space = "";
                }
                $ae = substr($employee_iban_no, 0, 2);
                if ($ae != 'AE') {
                    $err_ae = "IBAN Should Starts with AE" . "<font color=red>;</font>  <br>";
                } else {

                    $err_ae = "";
                }
            }
            $employee_name_pop = $eachEmployeeDetails->de_first_name;
            $div = ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/employeechecker/create&id=' . $employee_id . '\',\'' . $employee_name_pop . '\',\'xl\')"><i class="fa fa-pencil" title="Edit"></i></button>';
            $rowData[] = array(++$m,$employee_id,$employee_name,$employee_iban_no,$err_blank . $err_len . $err_space . $err_ae . $err_lastnum,'<div class="btn-wrap text-center">' . $div . '</div>',
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    // end of code by abin
//code added by abin on 07-07-2023 to return the error data of mol id
    public function actionGetListMolid() {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'id',
        );
        $emp_id = $_POST['employee_ids'];
        $modelEmployee = new Employee();
        $count = $modelEmployee->count(array('condition' => 'id IN (' . $emp_id . ')'));
        $modelEmployee = $modelEmployee->findall(array('condition' => 'id IN (' . $emp_id . ')', 'offset' => $offset, 'limit' => $limit));
        $rowData = array();
        $m = $offset;
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        foreach ($modelEmployee as $eachEmployeeDetails) {
            $div = '';
            $employee_name_pop = "$eachEmployeeDetails->de_first_name";
            $employee_id = $eachEmployeeDetails->id;
            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/employeechecker/create&id=' . $employee_id . '\',\'' . $employee_name_pop . '\',\'xl\')"><i class="fa fa-pencil" title="Edit"></i></button>';
            $employee_name = $eachEmployeeDetails->de_first_name;
            $employee_molid = $eachEmployeeDetails->personal_file_no;
            $employee_modelid_len = strlen($employee_molid);
            if ($employee_molid == '') {
                $err_blank = "MOL ID Should not be blank" . "<font color=red>;</font>  <br>";
                $err_len = "";
                $err_spec = "";
                $err_space = "";
            } else if ($employee_molid != '') {
                $err_blank = "";
                if ($employee_modelid_len != '14') {
                    $err_len = "Length of MOL ID Should be 14" . "<font color=red>;</font>  <br>";
                } else {
                    $err_len = "";
                }
                if (preg_match('/\s/', $employee_molid)) {
                    $err_space = "MOL ID Contains SPACE" . "<font color=red>;</font>  <br>";
                } else {
                    $err_space = "";
                }
                $pattern = '/[\'\/~`\!@#\$%\^&\*\(\)_\-\+=\{\}\[\]\|;:"\<\>,\.\?\\\]/';
                if (preg_match($pattern, $employee_molid)) {
                    $err_spec = "MOL ID Contains Special Characters" . "<font color=red>;</font>  <br>";
                } else {
                    $err_spec = "";
                }
            }
            $rowData[] = array(++$m,$employee_id,$employee_name,$employee_molid,$err_blank . $err_len . $err_space . $err_spec,'<div class="btn-wrap text-center">' . $div . '</div>',
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

//end of code by abin
//code added by abin on 10-07-2023 to return the error data of routing id
    public function actionGetListRoutingid() {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'id',
        );

        $emp_id = $_POST['employee_ids'];
        $modelEmployee = new Employee();
        $count = $modelEmployee->count(array('condition' => 'id IN (' . $emp_id . ')'));
        $modelEmployee = $modelEmployee->findall(array('condition' => 'id IN (' . $emp_id . ')', 'offset' => $offset, 'limit' => $limit));
        $rowData = array();

        $m = $offset;
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        foreach ($modelEmployee as $eachEmployeeDetails) {
            $div = '';
            $employee_name_pop = "$eachEmployeeDetails->de_first_name";
            $employee_id = $eachEmployeeDetails->id;
            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/employeechecker/create&id=' . $employee_id . '\',\'' . $employee_name_pop . '\',\'xl\')"><i class="fa fa-pencil" title="Edit"></i></button>';
            $employee_name = $eachEmployeeDetails->de_first_name;
            $employee_routingid = $eachEmployeeDetails->employee_wpscode;
            $employee_routingid_len = strlen($employee_routingid);
            if ($employee_routingid == "") {
                $err_blank = "Routing Code should not be blank" . "<font color=red>;</font>  <br>";
                $err_nun = "";
                $err_len = "";
                $err_space = "";
            } else if ($employee_routingid != "") {
                $err_blank = "";
                if ($employee_routingid_len != '9') {
                    $err_len = "Length of Routing Code Should be 9" . "<font color=red>;</font>  <br>";
                } else {
                    $err_len = "";
                }
                if (preg_match('/\s/', $employee_routingid)) {
                    $err_space = "Routing Code Contains SPACE" . "<font color=red>;</font>  <br>";
                } else {
                    $err_space = "";
                }
                if (is_numeric($employee_routingid)) {
                    $err_nun = "";
                } else {
                    $err_nun = "Routing Code should be numeric" . "<font color=red>;</font>  <br>";
                }
            }
            $rowData[] = array(++$m,$employee_id,$employee_name,$employee_routingid, $err_len . $err_space . $err_blank . $err_nun,'<div class="btn-wrap text-center">' . $div . '</div>',
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

//end of code by abin
//code added by abin on 10-07-2023 to return the error data of WPS company
    public function actionGetListWpscid() {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'id',
        );
        $emp_id = $_POST['employee_ids'];
        $modelEmployee = new Employee();
        $count = $modelEmployee->count(array('condition' => 'id IN (' . $emp_id . ')'));
        $modelEmployee = $modelEmployee->findall(array('condition' => 'id IN (' . $emp_id . ')', 'offset' => $offset, 'limit' => $limit));
        $rowData = array();
        $m = $offset;
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        foreach ($modelEmployee as $eachEmployeeDetails) {
            $div = '';
            $employee_name_pop = "$eachEmployeeDetails->de_first_name";
            $employee_id = $eachEmployeeDetails->id;
            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/employeechecker/create&id=' . $employee_id . '\',\'' . $employee_name_pop . '\',\'xl\')"><i class="fa fa-pencil" title="Edit"></i></button>';
            $employee_name = $eachEmployeeDetails->de_first_name;
            $employee_wpscompany = $eachEmployeeDetails->employee_wps_company;
            if ($employee_wpscompany == "" || $employee_wpscompany == "0") {
                $err_blank = "WPS Company should not be blank";
            } else if ($employee_wpscompany != "") {
                $err_blank = "";
            }
            $rowData[] = array( ++$m,$employee_id,$employee_name,$employee_wpscompany,$err_blank,'<div class="btn-wrap text-center">' . $div . '</div>',
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    //end of code by abin
}
