<?php

class CertificateauthController extends Controller
{
	 public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetList', 'Create','edit', 'Save','editSave','Disable','deleteAuthorization','deleteCode','Upload','Getempdesignation','Deletesign'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {
        $model = new HrMasCertificateAutorization();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employee_id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (t.employee_id LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'group'=>'t.employee_id','limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
       //group by employee_id
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $edit_button=$disable_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_signature_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_button =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_signature_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button=1;
            }
            $rowData[] = array(++$m, $row['employeedetail']['employeefullname'], $row['designation'],  $row['id'], array('id' => $row->employee_id, 'status' => $row->isActive,'edit_button'=>$edit_button,'disable_button'=>$disable_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model_auth=array(new HrMasCertificateAutorization()); 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $id ="";
        $this->renderPartial('create', array('model_auth'=> $model_auth,'employee_id'=>$id), false, true);
    }


    public function actionEdit() {
        $model_auth=array(new HrMasCertificateAutorization()); 
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model_auth= HrMasCertificateAutorization::model()->findAll(array('condition' => 'employee_id="'. $id.'"')); 
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('edit', array('model_auth'=> $model_auth,'employee_id'=>$id), false, true);
    }

    public function actionSave() {
        $model_auth =array(new HrMasCertificateAutorization());
        if ((isset($_POST['HrMasCertificateAutorization'])) && ($_POST['HrMasCertificateAutorization'][0]['employee_id'] >0)) {
                $i = 0;
                foreach ($_POST['HrMasCertificateAutorization'] as $m => $items) {
                        if ($items['id'] > 0) {
                            $model_auth[$i] = HrMasCertificateAutorization::model()->findByPK($items['id']);
                          
                        } else {
                            $model_auth[$i] = new HrMasCertificateAutorization();
                            $model_auth[$i]->created_by = Yii::app()->user->id;
                            $model_auth[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_auth[$i]->employee_id = $items['employee_id'];
                        $model_auth[$i]->designation = $items['designation'];
                        $model_auth[$i]->authority_signature = $items['authority_signature'];
                        $valid = $model_auth[$i]->validate();
                        $i++;
                    }
            }

            if ($valid) {
                if (!empty($model_auth)) {
                    foreach ($model_auth as $eachModel) {
                        $eachModel->save();
                    }
                }
                $model_id="";
                if(!empty($model_id)){
                    $model_id = $model->id;
                }
                $jsonData['id'] = $model_id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1=array();
                 if ($model_auth[0]->employee_id >0) {
                    $error1 = json_decode(CActiveForm::validateTabular($model_auth, '', false), true);
                }
                  $error = CJSON::encode(array_merge_recursive($error1));
                if ($error != '[]')
                    echo $error;
            }
        }
    
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new HrMasCertificateAutorization();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    public function actiondeleteCode() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new HrMasCertificateAutorization();
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actiondeleteAuthorization() {
        $id = $_POST['id'];
        if ($id > 0) 
        {
            HrMasCertificateAutorization::model()->deleteAll(array('condition'=>'employee_id="'.$id.'"'));
            $model = HrMasCertificateAutorization::model()->findAll(array('condition'=>'employee_id="'.$id.'"'));
            if (empty($model)) {
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
        }
        else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionDeletesign() {
        $id = $_POST['id'];
        if($id>0){
            $modelDocument = new HrMasCertificateAutorization();
            $model_doc = HrMasCertificateAutorization::model()->findbyPK($id);
            $document_details = explode(',', $model_doc->authority_signature);
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $model_doc->authority_signature;
            unlink($path);
            $model_doc->authority_signature="";
            $model_doc->save();
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}
