<?php

class AttendenceformatController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Formatform','SaveFormat','GetList','index'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_attendance_format_menu']) || Yii::app()->user->authorised_user == 1) {
        $this->render('index');
         }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetList() {
        $model = new HrAttendanceUploadFormat();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'branch_id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (branch_sponsor.branch_or_sponsor_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('branch_details')->count(array('condition' => $condition));
        $model = $model->with('branch_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'branch_details.branch_or_sponsor_name asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $id_array =array('E' => 'Employee ID', 'B' => 'Biometric ID');
        $format_array= array(1 => 'dd/mm/YYYY',2=> 'YYYY-mm-dd',3 => 'mm/dd/YYYY',7 => 'dd-F-YYYY',4=> 'dd/mm/YYYY HH:mm:ss',5=> 'YYYY-mm-dd HH:mm:ss',6=> 'mm/dd/YYYY HH:mm:ss');
        foreach ($model as $row) {
            $edit_button =0;
            $icon='';
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_attendance_format_edit'])  || Yii::app()->user->authorised_user == 1) {
                $icon='<div class="btn-wrap text-center">
                <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/attendenceformat/Formatform&id=' . $row['id'] . '\',\'Attendence format\',\'lg\')">
                <i class="fa fa-pencil"></i></button> ';
               $icon.= '</div>';
               $edit_button=1;
            }
            $sponsor_name="";
            if($row['branch_id']>0){
                $sponsor_name = $row['branch_details']['branch_or_sponsor_name'];
            }
            $rowData[] = array($m,$sponsor_name, $format_array[$row['date_format']],$id_array[$row['use_employee_code_r_biometric']],array('id'=>$row['id'],'edit_button'=>$edit_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionFormatform() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrAttendanceUploadFormat();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('format_form', array('model' => $model), false, true);
    }
  
    public function actionSaveFormat() {
        if (isset($_POST['HrAttendanceUploadFormat'])) {
            $other=array();
            $model= new HrAttendanceUploadFormat();  
            $valid = true;
            if ((int) @$_POST['HrAttendanceUploadFormat']['id'] > 0) { 
                $id = (int) $_POST['HrAttendanceUploadFormat']['id'];  
                $model = $model->findByPK($id);
                   
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['HrAttendanceUploadFormat']; 
            $model->branch_id = $_POST['HrAttendanceUploadFormat']['branch_id']; 
            
            $employee_id=$attendance_date=$login_time=$logout_time=0;
        /*    $arr_duplicate=array();
            $p=0;
            if($model->use_employee_code_r_biometric=='E'){
                $arr_duplicate[$p]=$model->employee_id;
                $p++;
            }else if($model->use_employee_code_r_biometric=='B'){
                $arr_duplicate[$p]=$model->biometric_id;
                $p++;
            }
            if($model->attendance_date>0){
                $arr_duplicate[$p]=$model->attendance_date;
                $p++;
            }
            if($model->time_from=='C'){
                if($model->login_time>0){
                    $arr_duplicate[$p]=$model->login_time;
                    $p++;
                }
                if($model->logout_time>0){
                    $arr_duplicate[$p]=$model->logout_time;
                    $p++;
                }
            }else if($model->time_from=='S'){
                if($model->status_column>0){
                    $arr_duplicate[$p]=$model->status_column;
                    $p++;
                }
            }
            $unique = array_unique($arr_duplicate);
            $duplicates = array_diff_assoc($arr_duplicate, $unique);
            if(!empty($duplicates)){
                $other[]='CSV Column number must be unique number.Please check column numbers.';
                $valid=false;
            }*/
            $valid=$model->validate() && $valid;
            if($valid){
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error_1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error_1, $other));
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
}
