<?php

class AttendanceController extends Controller {

    //public $layout = 'main';
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout','SaveBiometricAutoUpload'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('uploademployeeattendance', 'DownloadAttendanceformat','deleteAttendance','deleteattendancebydate','Getpayrolldatebybranch',
                    'Index', 'GetList', 'UploadAttendaceCsv', 'SaveAttendanceUpload', 'EmployeeDailyAttendance',
                    'dailyAttendanceEmployeeList', 'saveEmployeeattendance', 'saveEmployeeDailyAttendance', 'employeeMonthlyAttendance',
                    'getEmployeeList', 'GetEmployeeForMonthlyAttendance', 'editAttendance', 'SaveEditAttendance', 'loadMonthlyAttendance',
                    'Getlogintime', 'employeeIndex', 'GetEmployeeAttendanceList', 'EmployeeWorkingHours', 'getWorkingHoursReport',
                    'EditOvertime','SaveEditOvertime','ChangeAttendanceManager','LoadEmployeeByManager','saveattendancemanager','DailyAttendance',
                    'listemployeebyattendancemanager','ChangeWeekend','ChangeOvertime','listemployeebybranch','listemployeebranch','SaveOvertime',
                    'SaveWeekend','LateNotice','GetMorninglateList','IssueNotice','DownloadNotice','GetbranchSalarylocked','GetsalarylockedDate',
                    'AddmonthlyAttendance','loademployeedetailsbybranch','viewattendancedetails','MorninglateList','AttendanceOnsite','loadhiringattendance',
                    'Savehiringattendance','Getlastlockeddate','UploadmonthlyAttendance','SaveMonthlyAttendanceUpload','SaveBiometricUpload','EmployeeList',
                    'AddBiometricno','getemployeelistbybranch','SaveBiometricno','DailyattendanceList','attendancestatus','GetStatus','LocksalaryAttendance',
                    'saveautoaddattendance','Punch','Savepunchdetails','MarkabsentDetails','ListEmployee'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionUploademployeeattendance() {
        $model_general_setting = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_attendance_form',array('model_general_setting'=>$model_general_setting));
    }
    public function actionDownloadAttendanceformat() {
        $filename = 'attendance_format.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Employee Code,Name,Date(YYYY-mm-dd),Login Time(00:00),LogOut Time(00:00)';
        Yii::app()->end();
    }
    public function actionDownloadAttendanceformatold() {

        $branch = Yii::app()->request->getParam('branch');
        $file = fopen("csvs/attendanceformat.csv", "w");
        $j = 1;
        $modelemployee = Employee::model()->findAll(array('condition' => 't.isActive!="B" AND t.branch_or_sponsor_id = "' . $branch . '"'));
        $arr_employee = array();
        foreach ($modelemployee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'], "d") . ' ' . $this->ciphertext($value['last_name'], "d"). '-' . $value['employeecode']] = $value['id'];
        }
        ksort($arr_employee);
        $j = 0;
        $list[$j++] = 'Employee Code,Biometric Code,Name,Login Time(00:00),LogOut Time(00:00)';
        foreach ($arr_employee as $key_id) {
            $empdetail = Employee::model()->findByPk($key_id);
            $list[$j++] = $this->ciphertext($empdetail->employee_code, "d") . ',' . $empdetail->employee_biometric_code . ',' . $this->ciphertext($empdetail->first_name, "d") . ' ' . $this->ciphertext($empdetail->middle_name, "d") . ' ' . $this->ciphertext($empdetail->last_name, "d");
        }

        foreach ($list as $line) {

            fputcsv($file, explode(',', $line));
        }

        fclose($file);
        $filename = 'csvs/attendanceformat.csv';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"attendanceformat.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionSaveAttendanceUpload() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $docs = $_POST['attendance_file'];
        $date_from = $_POST['date_from'];
        date_default_timezone_set("Asia/Dubai");
        $branch = $_POST['attendance_branch'];
        $condition_upload='branch_id=0';
        if($branch>0){
            $condition_upload='branch_id="' . $branch . '"';
        }
        $model_upload_format= HrAttendanceUploadFormat::model()->find(array('condition' =>$condition_upload));  
        if(empty($model_upload_format)){
            $model_upload_format= HrAttendanceUploadFormat::model()->find(array('condition' =>'branch_id=0'));  
        }
        $employee_code_type=$model_upload_format->use_employee_code_r_biometric;
        $employee_code_column=0;
        //COde Column
        if($employee_code_type=='E'){
            $employee_code_column=$model_upload_format->employee_id;
        }elseif($employee_code_type=='B'){
            $employee_code_column=$model_upload_format->employee_id;
        }
        //Attendance Column
        $attendance_code_column=$model_upload_format->attendance_date;
        //Attendance Date Format
        $attendance_format_val=$model_upload_format->date_format;
        //Time column
        $in_column=$out_column=0;
        $in_column_status=$out_column_status=$status_column_no=$status_time_column=0;
        $time_from_type=$model_upload_format->time_from;
        if($time_from_type=='C'){
            $in_column=$model_upload_format->login_time;
            $out_column=$model_upload_format->logout_time;
        }elseif($employee_code_type=='S'){
            $status_column_no=$model_upload_format->status_column;
            $in_column_status=strtolower($model_upload_format->status_login);
            $out_column_status=strtolower($model_upload_format->status_logout);
            $status_time_column=strtolower($model_upload_format->status_time);
        }
        if($date_from!=''){
            $date_from = date("Y-m-d", strtotime(str_replace('/', '-', $date_from)));
            $weekvalue = date('w', strtotime($date_from));
            $weekvalue+=1;
            if ($weekvalue == 1) {
                $day = "Sunday";
            } else if ($weekvalue == 2) {
                $day = "Monday";
            } else if ($weekvalue == 3) {
                $day = "Tuesday";
            } else if ($weekvalue == 4) {
                $day = "Wednesday";
            } else if ($weekvalue == 5) {
                $day = "Thursday";
            } else if ($weekvalue == 6) {
                $day = "Friday";
            } else if ($weekvalue == 7) {
                $day = "Saturday";
            }
        }
        $branch = $_POST['attendance_branch'];
        $docs = str_replace(',', '', $docs);
        $attendance_list = $this->readCSV("uploads/attendance/" . $docs);
        foreach (array_slice($attendance_list, 1) as $i => $eachItem) {
            $emp_no = 0;
            $uploaded_date  ='';
            if(!empty($eachItem[$employee_code_column])){
                $emp_no = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$employee_code_column]), '"')); //Employee Code OR Biometric Code
            }
            if(!empty($eachItem[$attendance_code_column])){
                $uploaded_date = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$attendance_code_column]), '"'));
            }
            //Changing Date Format
            if($attendance_format_val==1 || $attendance_format_val==4){
                $uploaded_date_frm=date("Y-m-d", strtotime(str_replace('/', '-', $uploaded_date)));
            }else if($attendance_format_val==2 || $attendance_format_val==5){
                $uploaded_date_frm=date("Y-m-d", strtotime($uploaded_date));
            }else if($attendance_format_val==3 || $attendance_format_val==6){
                $uploaded_date_frm=date("Y-m-d", strtotime($uploaded_date));
            }else if($attendance_format_val==7){
                $uploaded_date_frm=date("Y-m-d", strtotime($uploaded_date));
            }
//            echo $emp_no;die();
            if(strtotime($uploaded_date_frm)==strtotime($date_from)){
                $in=$out='';
                if ($emp_no != '') {
                    if($employee_code_type=='E'){
                        $employee_code = $this->ciphertext($emp_no, "e");
                        $model = Employee::model()->find(array('condition' => 'employee_code="' . $employee_code . '" and t.isActive!="B" '));
//                        print_r($model); 
                    }else if($employee_code_type=='B'){
                        $model = Employee::model()->find(array('condition' => 'employee_biometric_code="' . $emp_no . '" and t.isActive!="B" '));
                    }
                    if (!empty($model)) {
                        if($time_from_type=='C'){
                            $in = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$in_column]), '"'));
                            $out = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$out_column]), '"'));
                        }else if($time_from_type=='S'){
                            $type = strtolower(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$status_column_no]), '"')));
                            if($type==$in_column_status){
                                $in = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$status_time_column]), '"'));
                            }else if($type==$out_column_status){
                                $out = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$status_time_column]), '"'));
                            }
                        }
                        $weekend=0;
                        $weektype='';
                        $model_attendance_1 = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $model->id . '" and attendance_date="' . $date_from . '"'));
                        if ($model->weekend_off1 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off1_type;
                        }
                        if ($model->weekend_off2 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off2_type;
                        }
                        if ($model->weekend_off3 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off3_type;
                        }
                        $order_manhours=0;
                        if (empty($model_attendance_1)) {
                            $model_attendance = new EmployeeAttendance();
                            $model_attendance->created_by = Yii::app()->user->id;
                            $model_attendance->created_date_time = date('Y-m-d H:i:s');
                            $order_manhours=0;
                        } else {
                            $model_attendance = EmployeeAttendance::model()->findByPK($model_attendance_1->id);
                            $order_manhours=$model_attendance->order_manhours;
                            $model_attendance->updated_by = Yii::app()->user->id;
                            $model_attendance->updated_date_time = date('Y-m-d H:i:s');
                            if($model_attendance->login_time!='00:00'){
                                $in = date("H:i", strtotime($model_attendance->login_time));
                            }
                            if($model_attendance->logout_time!='00:00'){
                                $out = date("H:i", strtotime($model_attendance->logout_time));
                            }
                        }
                        if (($in != '' && $in != 'A' && $in != '0:00' && $in != '00:00') || ($model_attendance->id>0 && $in== '00:00')) {
                            $in = date("H:i", strtotime($in));
                         }
                         if (($out != '' && $out != 'A' && $out != '0:00' && $out != '00:00') || ($model_attendance->id>0 && $in== '00:00')) {
                            $out = date("H:i", strtotime($out));
                         }
                        $model_attendance->employee_id = $model->id;
                        $model_attendance->upload_file = $docs;
                        $model_attendance->attendance_via = "U";
                        $model_attendance->status = 1;
                        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
                        if(!empty($model_shift)){
                            $model_attendance->shift_id = $model_shift->id;
                            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                        }
                        if(empty($model_shift)){
                            $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                            $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                        }
                        if($weekend==1 && $weektype=='H'){
                            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
                        }
                        //Attendance time
                        $model_attendance->login_time ='00:00';
                        $model_attendance->logout_time ='00:00';
                        if ($in != '' && $in != 'A' && $in != '00:00' && $in != '0:00') {
                            $model_attendance->login_time = $in;
                        }
                        if ($out != '' && $out != 'A' && $out != '00:00' && $out != '0:00') {
                            $model_attendance->logout_time = $out;
                        }
                        if ($model->employee_exclude_biometric == 1) {
                            if ($in == '' || $in == '00:00' || $in == '0:00'){
                                $model_attendance->login_time =$original_start_time;
                            }
                            if ($out == '' || $out == '00:00' || $out == '0:00'){
                                $model_attendance->logout_time =$original_stop_time;
                            }

                        }else {
                            if ($in == '' || $in == '00:00' || $in == '0:00' || $out == '' || $out == '00:00' || $out == '0:00' || $in == 'A' && $out == 'A') {
                                if ($in != '' && $in != 'A' && $in != '00:00' && $in != '0:00' && ($out == '' || $out == 'A' || $out == '00:00' || $out == '0:00')) {
                                    $model_attendance->status = 1;
                                }else{
                                    $model_attendance->status = 2;
                                }
                            }
                        }
                        //Working Details
                        $model_attendance->morning_late =$this->morninglate($model->id,$date_from,$model_attendance->login_time);
                        $model_attendance->total_working =$this->totalworking($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->variance_time_loss =$this->totaltimeloss($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->excess_time =$this->excesstime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->shift_id = $this->shiftdetail($model->id,$date_from);
                        if ($model_attendance->status == 1 && $model->overtime == "Y" && $model_attendance->login_time != '' && $model_attendance->logout_time != '' && $order_manhours==0) {
                            $model_settings = HrGenerelSettings::model()->find();
                            $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
                            if(!empty($model_holiday) && $model_settings->holiday_ot_from=='O') {
                                $model_attendance->holiday_overtime = $this->holidayasworkingovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }else if(!empty($model_holiday)){
                                $model_attendance->holiday_overtime = $this->holidayovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }else if($model_master_shift->shift_type=='N'){
                                $model_attendance->night_shift_overtime=$this->nightshiftovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->holiday_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }else if($weekend==1) {
                                $model_attendance->weekend_overtime =$this->weekendovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->holiday_overtime = '00:00:00';
                            }else if(empty($model_holiday)) {
                                $model_attendance->normal_overtime = $this->normalovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->holiday_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }
                        } else {
                            $model_attendance->holiday_overtime = 0;
                            $model_attendance->normal_overtime = 0;
                            $model_attendance->weekend_overtime = 0;
                            $model_attendance->night_shift_overtime=0;
                        }
                        $model_attendance->branch_or_sponsor_id = $model->branch_or_sponsor_id;
                        $model_attendance->attendance_date = $date_from;
                        $model_attendance->week_day = $day;
                        if(!empty($model_master_shift) && $model_master_shift->shift_type=='N' && $model_attendance->status == 1){
                            $model_attendance->night_shift_allowance=$model_shift->allowance_amount;
                        }
                        $model_attendance->save(false);
                    }
                }
            }
        }
        //Saving Attendance of All Employees
        $modelemployee = Employee::model()->findAll(array('condition' => 'branch_or_sponsor_id="' . $branch . '" and t.isActive!="B" and date_join<="'.$date_from.'"'));
        foreach ($modelemployee as $j => $empdetail) {
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                            OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $empdetail->id . '"'));
            if(!empty($model_shift)){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                if(!empty($model_master_shift)){
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                }
            }
            if(empty($model_shift)){
                $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
            }
            $status = 2;      // Absent
            $leave_id=0;
            $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => 'leave_start_date <= "' . $date_from . '" AND  leave_end_date >="' . $date_from . '" AND employee_id="' . $empdetail->id . '" and leave_status="12"'));
            if (!empty($arr_leave_details)) {
                $status = 3;   // leave
                $leave_id=$arr_leave_details->id;
            }
            $weekend=0;
            $weekend_type='';
            if ($empdetail->weekend_off1 == $weekvalue) {
                $status = 5;  // Weekend
                if($empdetail->weekend_off1_type=='H'){
                    $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                    $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                }
            }
            if ($empdetail->weekend_off2 == $weekvalue) {
                $status = 5;  // Weekend
                if($empdetail->weekend_off2_type=='H'){
                    $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                    $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                }
            }
            if ($empdetail->weekend_off3 == $weekvalue) {
                $status = 5;  // Weekend
               if($empdetail->weekend_off3_type=='H'){
                    $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                    $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                }
            }
            $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$empdetail->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
            if (!empty($model_holiday)) {
                $status = 4;  // Holiday
            }
            $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $date_from . '" and employee_id="' . $empdetail->id . '"'));
            if (empty($model_attendance_detail)) {
                if ($empdetail->employee_exclude_biometric==1 && $status==2) {
                    $model_attendance_add = new EmployeeAttendance;
                    $model_attendance_add->employee_id = $empdetail->id;
                    $model_attendance_add->shift_id = $model_shift->id;
                    $model_attendance_add->login_time = $original_start_time;
                    $model_attendance_add->logout_time = $original_stop_time;
                    $model_attendance_add->normal_overtime = 0;
                    $model_attendance_add->holiday_overtime = 0;
                    $model_attendance_add->weekend_overtime = 0;
                    $model_attendance_add->attendance_date = $date_from;
                    $model_attendance_add->week_day = $day;
                    $model_attendance_add->status = 1;
                    $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;
                    $model_attendance_add->save(false);
                }else{
                    $model_attendance_add = new EmployeeAttendance;
                    $model_attendance_add->employee_id = $empdetail->id;
                    $model_attendance_add->shift_id = $model_shift->id;
                    $model_attendance_add->login_time ='00:00';
                    $model_attendance_add->logout_time = '00:00';
                    $model_attendance_add->normal_overtime = 0;
                    $model_attendance_add->holiday_overtime = 0;
                    $model_attendance_add->weekend_overtime = 0;
                    $model_attendance_add->attendance_date = $date_from;
                    $model_attendance_add->week_day=$day;
                    $model_attendance_add->status=$status;
                    if ($status==3) {
                        $model_attendance_add->leave_id = $arr_leave_details->id;
                    }
                    $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;
                    $model_attendance_add->save(false);
                }
            }else if($model_attendance_detail->status!=1){
                EmployeeAttendance::model()->updateByPK($model_attendance_detail->id, array('status'=>$status,'leave_id' => $leave_id)); 
            }
            
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionEmployeeDailyAttendance() {
        $model_general_setting = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('daily_attendance_form',array('model_general_setting'=>$model_general_setting));
    }
    
    public function actionDailyAttendanceEmployeeList() {
        $attendancebranch = $_POST['attendancebranch'];
        $shift_id = $_POST['shift_id'];
        $from_date = $_POST['from_date'];
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('daily_attendance_employes_list', array('branch' => $attendancebranch, 'shift_id' => $shift_id, 'date_from' => $from_date));
    }
    public function actionsaveEmployeeDailyAttendance() {        
        if (isset($_POST['EmployeeAttendance'])) {
            $validate=true;
            date_default_timezone_set("Asia/Dubai");
            foreach ($_POST['EmployeeAttendance'] as $i => $items) {
                $leave_id = '';
                if(!empty($items['leave_id'])){
                $leave_id = $items['leave_id'];
                }
                $order_manhours=0;
                if ($items['id'] > 0) {
                    $model[$i] = EmployeeAttendance::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                    $order_manhours=$model[$i]->order_manhours;
                } else {
                    $model[$i] = new EmployeeAttendance();
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                    $order_manhours=0;
                }
                $model[$i]->employee_id = $items['employee_id'];
                $model[$i]->branch_or_sponsor_id = $items['branch_or_sponsor_id'];
                $model[$i]->shift_id = $items['shift_id'];
                $model[$i]->login_time = $items['login_time'];
                $model[$i]->logout_time = $items['logout_time'];               
                $model[$i]->status = $items['status'];
                $model[$i]->week_day = $items['week_day'];
                $model[$i]->leave_id = $leave_id;
                $model[$i]->attendance_date = $items['attendance_date'];
                $status=$items['status'];
                $employee_id=$items['employee_id'];
                $login_time=$items['login_time'];
                $logout_time=$items['logout_time'];
                $attendance_date=$items['attendance_date'];
                $shift_id=$items['shift_id'];
                $weekvalue = date('w', strtotime($attendance_date));
                $weekvalue+=1;
                $weekend=0;
                $weekend_type='';
                $model_employee = Employee::model()->findbyPk($employee_id);
                if ($model_employee->weekend_off1 == $weekvalue) {
                    $weekend=1;
                    $weekend_type=$model_employee->weekend_off1_type;
                }
                if ($model_employee->weekend_off2 == $weekvalue) {
                    $weekend=1;
                    $weekend_type=$model_employee->weekend_off2_type;
                }
                if ($model_employee->weekend_off3 == $weekvalue) {
                    $weekend=1;
                    $weekend_type=$model_employee->weekend_off3_type;
                }
                if($shift_id>0){
                    $model_shift_detail =EmployeeShift::model()->findByPK($shift_id); 
                    $model_master_shift =MasShift::model()->findByPK($model_shift_detail->shift_id);
                    $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                    $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                }else{
                    $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model_employee->branch_or_sponsor_id);
                    $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                    $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                }
                if($weekend==1 && $weekend_type=='H'){
                    $original_start_time=date("H:i",strtotime($model_company_shift->weekend_work_starttime));
                    $original_stop_time=date("H:i",strtotime($model_company_shift->weekend_work_endtime));
                }
                //Working Details
                $model[$i]->morning_late =$this->morninglate($model_employee->id,$attendance_date,$login_time);
                $model[$i]->total_working =$this->totalworking($model_employee->id,$attendance_date,$login_time,$logout_time);
                $model[$i]->variance_time_loss =$this->totaltimeloss($model_employee->id,$attendance_date,$login_time,$logout_time);
                $model[$i]->excess_time =$this->excesstime($model_employee->id,$attendance_date,$login_time,$logout_time);
                $model[$i]->shift_id = $this->shiftdetail($model_employee->id,$attendance_date);
                if ($status==1 && $model_employee->overtime == "Y" && $login_time!= '' && $logout_time!= '' && $order_manhours==0) {
                        $model_settings = HrGenerelSettings::model()->find();
                        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model_employee->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $attendance_date . '"'));
                        if(!empty($model_holiday) && $model_settings->holiday_ot_from=='O') {
                            $model[$i]->holiday_overtime = $this->holidayasworkingovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                            $model[$i]->night_shift_overtime ='00:00:00';
                            $model[$i]->normal_overtime = '00:00:00';
                            $model[$i]->weekend_overtime = '00:00:00';
                        }else if(!empty($model_holiday)){
                            $model[$i]->holiday_overtime = $this->holidayovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                            $model[$i]->night_shift_overtime ='00:00:00';
                            $model[$i]->normal_overtime = '00:00:00';
                            $model[$i]->weekend_overtime = '00:00:00';
                        }else if(!empty($model_master_shift) && $model_master_shift->shift_type=='N'){
                            $model[$i]->night_shift_overtime=$this->nightshiftovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                            $model[$i]->holiday_overtime ='00:00:00';
                            $model[$i]->normal_overtime = '00:00:00';
                            $model[$i]->weekend_overtime = '00:00:00';
                        }else if($weekend==1) {
                            $model[$i]->weekend_overtime =$this->weekendovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                            $model[$i]->night_shift_overtime ='00:00:00';
                            $model[$i]->normal_overtime = '00:00:00';
                            $model[$i]->holiday_overtime = '00:00:00';
                        }else if(empty($model_holiday)) {                           
                            $model[$i]->normal_overtime = $this->normalovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                            $model[$i]->night_shift_overtime ='00:00:00';
                            $model[$i]->holiday_overtime = '00:00:00';
                            $model[$i]->weekend_overtime = '00:00:00';
                        }
                    } else {
                        $model[$i]->night_shift_overtime= 0;
                        $model[$i]->holiday_overtime= 0;
                        $model[$i]->normal_overtime= 0;
                        $model[$i]->weekend_overtime = 0;
                }
                if(!empty($model_master_shift) && $model_master_shift->shift_type=='N' && $status==1){
                    $model[$i]->night_shift_allowance=$model_shift_detail->allowance_amount;
                }
                $validate = $model[$i]->validate() && $validate; 
            }
            if ($validate) {
                foreach ($model as $eachModel) {
                    $eachModel->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error_array = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode($error_array);
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }
    
    public function actionEmployeeMonthlyAttendance() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('monthly_attendance_form');
    }
    
    public function actionGetEmployeeList() {
        $branch= $_POST['branch'];
        $data = array();
        if ($branch>0) {

            $data['employee'] = CHtml::dropdownlist('monthly_employee_id', "", Employee::getEmployee($branch), array('class' => 'col-sm-3 form-control_1', 'title' => 'Select Employee', 'data-label' => 'Employee <span style="color:red">*</span>', 'prompt' => 'Select Employee','data-search'=>true,'onchange'=>'branchsalarylocked(this.value);'));
        }
        echo CJSON::encode($data);
    }
    public function actionEmployeeList() {
        $branch= $_POST['branch'];
        $data = array();
        if ($branch>0) {

            $data['employee'] = CHtml::dropdownlist('employee_id', "", Employee::getEmployee($branch), array('class' => 'col-sm-3 form-control_1', 'title' => 'Select Employee', 'data-label' => 'Employee', 'prompt' => 'Select Employee','data-search'=>true));
        }
        echo CJSON::encode($data);
    }
    
    public function actionGetEmployeeForMonthlyAttendance() {
        $emp_id = $_POST['emp_id'];
        $date_from = $_POST['date_from'];
        $date_to = $_POST['date_to'];
        $modelemployee = Employee::model()->findbyPk($emp_id);
        $branch_or_sponsor_id = $modelemployee->branch_or_sponsor_id;
        $this->render('monthly_attendance_details', array('modelemployee' => $modelemployee, 'emp_id' => $emp_id, 'branch_or_sponsor_id' => $branch_or_sponsor_id, 'date_from' => $date_from,'date_to' => $date_to), false, true);
    }
     public function actionGetlogintime() {
        $attend_date = Yii::app()->request->getParam('attend_date');
        $weekvalue = date('w', strtotime($attend_date));
        $weekvalue+=1;
        $emp_id = Yii::app()->request->getParam('emp_id');
        $status = Yii::app()->request->getParam('status');
        $condition_1 = 'employee_id="'.$emp_id.'" AND ((from_date>="' . $attend_date . '" AND to_date<="' . $attend_date . '") OR (from_date<="' . $attend_date . '" AND to_date>="' . $attend_date . '"))';       
        $modelshift = EmployeeShift::model()->find(array('condition' => $condition_1));
        $shift_id = $modelshift->shift_id;
        $modelemployee = Employee::model()->findbyPk($emp_id);
        $start_time = '';
        $end_time = '';
        if ($status ==3) {
            $arr_leave = Employeeleave::model()->find(array('condition' => 'leave_start_date <= "' . $attend_date . '" AND  leave_end_date >="' . $attend_date . '" AND employee_id="' . $emp_id . '" and status="4"'));
            $leave_type = MasLeave::model()->findByPK($arr_leave->leave_type);
            $display_1 = 0;
            $med_message="";
            if ($leave_type->document_medical_certificate_upload == "Y") {
                $display_1 = 1;
                if ($arr_leave->medical_certificate == '') {
                    $med_message = 'Document Upload Pending';
                } else {
                    $med_message = 'Document Uploaded';
                }
            }
        } else {
            if ($status == 2 || $status == 4 || $status == 5) {
                $start_time = '';
                $end_time = '';
            } else {
                $workday = MasShift::model()->findByPK($shift_id);
                $start_time = date("H:i", strtotime($workday->start_time));
                $end_time = date("H:i", strtotime($workday->end_time));
                if ($modelshift->shift_id==''){
                    $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($modelemployee->branch_or_sponsor_id);
                    $start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                    $end_time = date("H:i", strtotime($model_company_shift->workend_time));
                }
                //WEEKEND WORKING
                if ($modelemployee->weekend_off1 == $weekvalue) {
                    if($modelemployee->weekend_off1_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($modelemployee->branch_or_sponsor_id);
                        $start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $end_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($modelemployee->weekend_off2 == $weekvalue) {
                    if($modelemployee->weekend_off2_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($modelemployee->branch_or_sponsor_id);
                        $start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $end_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($modelemployee->weekend_off3 == $weekvalue) {
                    if($modelemployee->weekend_off3_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($modelemployee->branch_or_sponsor_id);
                        $start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $end_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                $model = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $attend_date . '" and employee_id="' . $emp_id . '"'));
                if (!empty($model)) {
                    if($model->login_time!='00:00'){
                        $start_time = date("H:i", strtotime($model->login_time));
                    }
                    if($model->logout_time!='00:00'){
                        $end_time = date("H:i", strtotime($model->logout_time));
                    }
                }
            }
        }
        $jsonData['start_time'] = $start_time;
        $jsonData['end_time'] = $end_time;
        $jsonData['med_stat'] = $display_1;
        $jsonData['med_msg'] = $med_message;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionIndex() {
        $model_module_attendance = HrModules::model()->findByPK(2);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empatt_att_list_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y')) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
         }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetList() {

        $model = new EmployeeAttendance();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.branch_or_sponsor_id',
            2 => 'employeedetail.employee_code',
            3 => 'employeedetail.first_name',
            4 => 'employeedetail.designation',
            5 => 'attendance_date',
            6 => 'login_time',
            7 => 'logout_time',
            8 => 'normal_overtime',
            9 => 'status',
            10 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if (isset($_POST['branch_id']) && $_POST['branch_id'] > 0) {
            $condition.= ' AND t.branch_or_sponsor_id="' . $_POST['branch_id'] . '"';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and t.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
            }
        }
        if (isset($_POST['empid']) && $_POST['empid'] > 0) {
            $condition.= ' AND t.employee_id="' . $_POST['empid'] . '"';
        }
        if (isset($_POST['from_date']) && !empty($_POST['from_date'])) {
            $from_date = date('Y-m-d', strtotime($_POST['from_date']));
            $condition.= ' AND t.attendance_date >="' . $from_date . '"';
        }
        if (isset($_POST['to_date']) && $_POST['to_date']) {
            $to_date = date('Y-m-d', strtotime($_POST['to_date']));
            $condition.= ' AND t.attendance_date <="' . $to_date . '"';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";      
        
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $model_general_setting = HrGenerelSettings::model()->find();
        $lock_attendance_leave=$model_general_setting->lock_attendance_leave;
        foreach ($model as $row) {
            //Salary Locked
            $model_lock = SalarySlip::model()->with('processing')->find(array('select'=>'max(t.salary_processing_id) as salary_processing_id','condition' => 'processing.payroll_status="2" and employee_id="'.$row->employee_id.'"'));
            $last_locked_date="";
            if(!empty($model_lock) && $model_lock->salary_processing_id>0){
                $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
                $last_locked_date= date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
            }else{
                if(!empty($row->employeedetail->branch_or_sponsor_id) && $row->employeedetail->branch_or_sponsor_id > 0){
                $model_lock_branch = SalaryProcessing::model()->find(array('select'=>'max(payroll_enddate) as payroll_enddate','condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="'.$row->employeedetail->branch_or_sponsor_id.'" OR payroll_branch_or_sponsor_id="0")'));
                }
                if(!empty($model_lock_branch) && $model_lock_branch->payroll_enddate!='' && $model_lock_branch->payroll_enddate!='0000-00-00'){
                    $last_locked_date= date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                }
            }
            $button_string = "";$overtime='-';   
            
            $attendance_edit_lock=$attendance_edit_no_lock=$overtime_edit_lock=$overtime_edit_no_lock=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_attendance_list_edit'])  || Yii::app()->user->authorised_user == 1) {
                if ($row['status'] != 3 && (strtotime($row['attendance_date'])>=strtotime($last_locked_date)) && $lock_attendance_leave=="Y") {
                    $attendance_edit_lock =1;
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Edit Attendance" onclick="loadPopupModal(\'hr/attendance/editattendance&id=' . $row['id'] . '\',\'Edit Attendance  \',\'lg\')"><i class="fa fa-edit"></i></button>';
                }else if ($row['status'] != 3 && $lock_attendance_leave=="N") {
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Edit Attendance" onclick="loadPopupModal(\'hr/attendance/editattendance&id=' . $row['id'] . '\',\'Edit Attendance  \',\'lg\')"><i class="fa fa-edit"></i></button>';
                    $attendance_edit_no_lock =1;
                }
            }
            $status=array(1=>"Present",2=>"Absent",3=>"Leave",4=>"Holiday",5=>"Weekend");
            if (isset($row['employeedetail']['overtime']) && $row['employeedetail']['overtime'] == 'Y') {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_att_overtime_edit'])  || Yii::app()->user->authorised_user == 1) {
                    if (strtotime($row['attendance_date'])>=strtotime($last_locked_date) && $lock_attendance_leave=="Y") {
                        $button_string.= ' <button class="btn btn-info btn-xs" title="Edit OverTime" onclick="loadPopupModal(\'hr/attendance/editovertime&id=' . $row['id'] . '\',\'Edit Overtime  \',\'lg\')"><i class="fa fa-edit"></i></button>';            
                    $overtime_edit_lock=1;
                    }else if ($lock_attendance_leave=="N") {
                        $button_string.= ' <button class="btn btn-info btn-xs" title="Edit OverTime" onclick="loadPopupModal(\'hr/attendance/editovertime&id=' . $row['id'] . '\',\'Edit Overtime  \',\'lg\')"><i class="fa fa-edit"></i></button>';            
                        $overtime_edit_no_lock=1;
                    }
                }
                $weekend=0;
                $date_from = $row['attendance_date'];
                $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$row['employeedetail']['branch_or_sponsor_id'].'",branch_id)  AND holiday_date="' . $date_from . '"'));
                $weekvalue = date('w', strtotime($date_from));
                $weekvalue+=1;
                if ($row['employeedetail']['weekend_off1'] == $weekvalue) {
                    $weekend=1;
                }
                if ($row['employeedetail']['weekend_off2'] == $weekvalue) {
                    $weekend=1;
                }
                if($weekend==1){
                    $overtime = date("H:i", strtotime($row['weekend_overtime']));
                }else if(!empty($model_holiday)){
                    $overtime = date("H:i", strtotime($row['holiday_overtime']));
                }else{
                    $overtime = date("H:i", strtotime($row['normal_overtime']));
                }
            }
            $rowData[] = array($m,$row['branch_sponsor']['branch_or_sponsor_name'], $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row['employeedetail']['designationdetail']['designation_name'], date('d/m/Y', strtotime($row['attendance_date'])) . " ( " . $row['week_day'] . " )",date("H:i", strtotime($row->login_time)),date("H:i", strtotime($row->logout_time)),$overtime, $status[$row['status']], array("id"=>$row['id'],"attendance_edit_lock"=>$attendance_edit_lock,"attendance_edit_no_lock"=>$attendance_edit_no_lock,'overtime_edit_lock'=>$overtime_edit_lock,'overtime_edit_no_lock'=>$overtime_edit_no_lock));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionEditAttendance() {
        $model = new EmployeeAttendance();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_attendance_form', array('model' => $model), false, true);
    }
    public function actionEditOvertime() {
        $model = new EmployeeAttendance();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('edit_attendanceovertime_form', array('model' => $model), false, true);
    }
    public function actionSaveEditOvertime() {
        $model = new EmployeeAttendance();
        if (isset($_POST['EmployeeAttendance'])) {
            if ((int) @$_POST['EmployeeAttendance']['id'] > 0) {
                $id = (int) @$_POST['EmployeeAttendance']['id'];
                $model = $model->findByPk($id);
            }
            $model->attributes = $_POST['EmployeeAttendance'];
            $model->normal_overtime = $_POST['EmployeeAttendance']['normal_overtime'];
            if(isset($_POST['EmployeeAttendance']['holiday_overtime'])){
                $model->holiday_overtime = $_POST['EmployeeAttendance']['holiday_overtime'];
            }
             if(isset($_POST['EmployeeAttendance']['weekend_overtime'])){
                $model->weekend_overtime = $_POST['EmployeeAttendance']['weekend_overtime'];
             }
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
            
    }
    public function actionSaveEditAttendance() {
        $model = new EmployeeAttendance();
        date_default_timezone_set("Asia/Dubai");
        if (isset($_POST['EmployeeAttendance'])) {
            $order_manhours=0;
            if ((int) @$_POST['EmployeeAttendance']['id'] > 0) {
                $id = (int) @$_POST['EmployeeAttendance']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $order_manhours=$model->order_manhours;
            }
            $model->attributes = $_POST['EmployeeAttendance'];
            $model->attendance_date = $_POST['EmployeeAttendance']['attendance_date'];
            $model->employee_id = $_POST['EmployeeAttendance']['employee_id'];
            $model->week_day = $_POST['EmployeeAttendance']['week_day'];
            $model->branch_or_sponsor_id = $_POST['EmployeeAttendance']['branch_or_sponsor_id'];
            $model->login_time = $_POST['EmployeeAttendance']['login_time'];
            $model->logout_time = $_POST['EmployeeAttendance']['logout_time'];
            $model->status = $_POST['EmployeeAttendance']['status'];    
            $status= $_POST['EmployeeAttendance']['status'];
            $attendance_date=$_POST['EmployeeAttendance']['attendance_date'];
            $login_time=$_POST['EmployeeAttendance']['login_time'];
            $logout_time=$_POST['EmployeeAttendance']['logout_time'];
            $employee_id=$_POST['EmployeeAttendance']['employee_id'];
            $shift_id=$_POST['EmployeeAttendance']['shift_id'];
            $weekvalue = date('w', strtotime($attendance_date));
            $weekvalue+=1;
            $model_employee = Employee::model()->findbyPk($employee_id);
            $weekend=0;
            if ($model_employee->weekend_off1 == $weekvalue) {
                $weekend=1;
            }
            if ($model_employee->weekend_off2 == $weekvalue) {
                $weekend=1;
            }
            $original_start_time="";
            $original_stop_time="";
            if($shift_id>0){
                $model_shift_detail =EmployeeShift::model()->findByPK($shift_id); 
                $model_master_shift =MasShift::model()->findByPK($model_shift_detail->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else{
                $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model_employee->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
            }
            //Working Details
            $model->morning_late =$this->morninglate($model_employee->id,$attendance_date,$login_time);
            $model->total_working =$this->totalworking($model_employee->id,$attendance_date,$login_time,$logout_time);
            $model->variance_time_loss =$this->totaltimeloss($model_employee->id,$attendance_date,$login_time,$logout_time);
            $model->excess_time =$this->excesstime($model_employee->id,$attendance_date,$login_time,$logout_time);
            $model->shift_id = $this->shiftdetail($model_employee->id,$attendance_date);
            if ($status==1 && $model_employee->overtime == "Y" && $login_time!= '' && $logout_time!= '' && $order_manhours==0) {
                $model_settings = HrGenerelSettings::model()->find();
                $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model_employee->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $attendance_date . '"'));
                if(!empty($model_holiday) && $model_settings->holiday_ot_from=='O') {
                    $model->holiday_overtime = $this->holidayasworkingovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                    $model->night_shift_overtime ='00:00:00';
                    $model->normal_overtime = '00:00:00';
                    $model->weekend_overtime = '00:00:00';
                }else if(!empty($model_holiday)){
                    $model->holiday_overtime = $this->holidayovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                    $model->night_shift_overtime ='00:00:00';
                    $model->normal_overtime = '00:00:00';
                    $model->weekend_overtime = '00:00:00';
                }else if($model_master_shift->shift_type=='N'){
                    $model->night_shift_overtime=$this->nightshiftovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                    $model->holiday_overtime ='00:00:00';
                    $model->normal_overtime = '00:00:00';
                    $model->weekend_overtime = '00:00:00';
                }else if($weekend==1) {
                    $model->weekend_overtime =$this->weekendovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                    $model->night_shift_overtime ='00:00:00';
                    $model->normal_overtime = '00:00:00';
                    $model->holiday_overtime = '00:00:00';
                }else if (empty($model_holiday)) {
                    $model->normal_overtime = $this->normalovertime($model_employee->id,$attendance_date,$login_time,$logout_time);
                    $model->night_shift_overtime ='00:00:00';
                    $model->holiday_overtime = '00:00:00';
                    $model->weekend_overtime = '00:00:00';
                }
            } else {
                $model->night_shift_overtime=0;
                $model->holiday_overtime= 0;
                $model->normal_overtime= 0;
                $model->weekend_overtime =0;
            }
            if(!empty($model_master_shift) && $model_master_shift->shift_type=='N' && $status==1){
                $model->night_shift_allowance=$model_shift_detail->allowance_amount;
            }
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionEmployeeIndex() {
        $this->layout = 'main';
        $model_module_attendance = HrModules::model()->findByPK(2);
        if ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y') {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index_employee');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetEmployeeAttendanceList() {

        $month_id = $_POST['month_id'];
        $year_id = $_POST['year_id'];
        $emp_id = $_POST['emp_id'];
        $this->renderPartial('employee_attendance_list', array('month_id' => $month_id, 'employee_id' => $emp_id, 'year_id' => $year_id));
    }
    public function actionLoadMonthlyAttendance() {

        $id = (int) Yii::app()->request->getParam('id');
        $date1 = Yii::app()->request->getParam('date1');
        $date2 = Yii::app()->request->getParam('date2');
        $type = Yii::app()->request->getParam('type');
        $model = Employee::model()->findByPK($id);

        $model_attendance = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $id . '" AND attendance_date>="' . $date1 . '" AND attendance_date<="' . $date2 . '" '));
        ;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_monthly_attendance_form', array('modelemployee' => $model, 'model_attendance' => $model_attendance, 'date_from' => $date1, 'date_to' => $date2, 'type' => $type), false, true);
    }



    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }

    public function actionUploadAttendaceCsv($folder = null) {

        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $field_id = "";
        if (isset($_GET['field_id'])) {
            $field_id = Yii::app()->request->getParam('field_id');
        }


        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("csv");
        $sizeLimit = 10 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropIfImage($folder, $fileName, 600, 300);

        $imagename = Yii::app()->basePath . '/../uploads/attendance/' . $fileName;

        Yii::import("ext.EPhpThumb.EPhpThumb");


        echo $return; // it's array
    }

    /*     * *******************  End  Upload Attendance ************************ */
    public function actionEmployeeWorkingHours() {
        $this->layout = 'main';
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index_working_hours');
    }

    public function actionGetWorkingHoursReport() {

        $type = $_POST['type'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $employee_id = $_POST['employee_id'];
        if ($type == 1) {
            $this->renderPartial('employee_daily_working_hours', array('month' => $month, 'year' => $year, 'employee_id' => $employee_id));
        } else if ($type == 2) {
            $this->renderPartial('employee_weekly_working_hours', array('month' => $month, 'year' => $year, 'employee_id' => $employee_id));
        } else if ($type == 3) {
            $this->renderPartial('employee_monthly_working_hours', array('month' => $month, 'year' => $year, 'employee_id' => $employee_id));
        }
    }
    public function actionChangeAttendanceManager() {
        $model = new Employee;
        $model_employee = Employee::model()->findAll(array('condition' => 'attendance_manager="0" and isActive!="B"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('attendance_manager_change_form', array('model' => $model, 'model_employee' => $model_employee));
    }
    public function actionLoadEmployeeByManager() {
        $attendancemanager = $_POST['attendancemanager'];
        $model_employee = Employee::model()->findAll(array('condition' => 'attendance_manager="' . $attendancemanager . '" and isActive!="B"'));       
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->renderPartial('attendance_manager_change_employee_list', array('model' => $model_employee, 'attendancemanager' => $attendancemanager), false, true);
    }
    public function actionsaveattendancemanager() {        
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $each) {
                if (in_array($each['id'], $_POST['arraycid'])) {
                    if ($each['id'] != '') {
                        $model_employee = Employee::model()->findByPK($each['id']);
                    }
                    $model_employee->attendance_manager = $_POST['attendance_manager_id'];
                    $model_employee->save(false);
                    $attendance_manager_id=$_POST['attendance_manager_id'];
                    $model_level_approval = HrEmployeeApproveLevel::model()->findAll(array('condition' => 'employee_id="' . $each['id'] . '"'));
                    foreach ($model_level_approval as $key => $value) {
                        $model_level=HrEmployeeApproveLevel::model()->findByPK($value->id);
                        $level_1=$value->level_1_type;
                        if($level_1=='S'){
                            $model_level->level_1_authority = $attendance_manager_id;
                        }
                        $level_2=$value->level_2_type;
                        if($level_2=='S'){
                            $model_level->level_2_authority = $attendance_manager_id;
                        }
                        $level_3=$value->level_3_type;
                        if($level_3=='S'){
                            $model_level->level_3_authority = $attendance_manager_id;
                        }
                        $level_4=$value->level_4_type;
                        if($level_4=='S'){
                            $model_level->level_4_authority = $attendance_manager_id;
                        }
                        $level_5=$value->level_5_type;
                        if($level_5=='S'){
                            $model_level->level_5_authority = $attendance_manager_id;
                        }
                        $model_level->save();
                    }
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionDailyAttendance() {
        $id= Yii::app()->request->getparam("id");
        $model_setting = HrGenerelSettings::model()->find();
        $model_lock = SalarySlip::model()->with('processing')->find(array('select'=>'max(t.salary_processing_id) as salary_processing_id','condition' => 'processing.payroll_status="2" and employee_id="' . $id . '"'));
        $last_locked_date="";
        if(!empty($model_lock) && $model_lock->salary_processing_id>0){
            $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
            $payroll_enddate= date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
            $last_locked_date=date('d/m/Y',strtotime($payroll_enddate));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('daily_attendance',array('id'=>$id,'model_setting'=>$model_setting,'last_locked_date'=>$last_locked_date));
    }
    public function actionlistemployeebyattendancemanager() {
        $date_from= $_POST['from_date'];
        $id= $_POST['id'];
        $model_employee = Employee::model()->findAll(array('condition' => 'attendance_manager="' . $id . '" and isActive!="B"')); 
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('dailyattendance_employee_list', array('arr_employee' => $arr_employee,'date_from' => $date_from));
    }
    public function actionChangeWeekend() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_weekend');
    }
    public function actionChangeOvertime() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('change_overtime');
    }
    public function actionlistemployeebybranch() {
        $branch = $_POST['branch'];
        $condition = "isActive!='B'";
        if ($branch > 0) {
            $condition.=' AND (branch_or_sponsor_id="'.$branch.'")';
        }      
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('employee_details_weekend', array('arr_employee' => $arr_employee));
    }
     public function actionlistemployeebranch() {
        $branch = $_POST['branch'];
        $condition = "isActive!='B'";
        if ($branch > 0) {
            $condition.=' AND (branch_or_sponsor_id="'.$branch.'")';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and (branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.'))';
            }
        }
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('employee_details_overtime', array('arr_employee' => $arr_employee));
    }
    public function actionSaveOvertime() {
        if ((isset($_POST['Employee']))) {
            $validate = true;
            foreach ($_POST['Employee'] as $i => $items) {
                    $model_employee[$i] = new Employee();
                    if ($items['id'] > 0) {
                        $model_employee[$i] = $model_employee[$i]->findByPK($items['id']);
                    }          
                    $model_employee[$i]->overtime = $items['overtime'];
                    $model_employee[$i]->update_nominee_ess = $items['update_nominee_ess'];
                    $model_employee[$i]->update_contact_ess = $items['update_contact_ess'];
                    //$validate = $model_employee[$i]->validate() && $validate;
                
            }
            if (!empty($model_employee)) {
                //if ($validate) {
                    if (!empty($model_employee)) {
                        foreach ($model_employee as $eachModel) {
                            $eachModel->save(false);
                        }
                    }                    
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
//                } else {
//                    $error1 = json_decode(CActiveForm::validateTabular($model_employee, '', false), true);
//                    $error = CJSON::encode($error1);
//                    if ($error != '[]')
//                        echo $error;
//                }
            }else {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        }
    }
    public function actionSaveWeekend() {
        if ((isset($_POST['Employee']))) {
            $validate = true;
            foreach ($_POST['Employee'] as $i => $items) {
                    $model_employee[$i] = new Employee();
                    if ($items['id'] > 0) {
                        $model_employee[$i] = $model_employee[$i]->findByPK($items['id']);
                    }          
                    $model_employee[$i]->weekend_off1 = $items['weekend_off1'];
                    $model_employee[$i]->weekend_off2 = $items['weekend_off2'];
                    $model_employee[$i]->weekend_off3 = $items['weekend_off3'];
                    $model_employee[$i]->weekend_off1_type = $items['weekend_off1_type'];
                    $model_employee[$i]->weekend_off2_type = $items['weekend_off2_type'];
                    $model_employee[$i]->weekend_off3_type = $items['weekend_off3_type'];
                    //$validate = $model_employee[$i]->validate() && $validate;
                
            }
            if (!empty($model_employee)) {
               // if ($validate) {
                    if (!empty($model_employee)) {
                        foreach ($model_employee as $eachModel) {
                            $eachModel->save(false);
                        }
                    }                    
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
//                } else {
//                    $error1 = json_decode(CActiveForm::validateTabular($model_employee, '', false), true);
//                    $error = CJSON::encode($error1);
//                    if ($error != '[]')
//                        echo $error;
//                }
            }else {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        }
    }
    public function actionLateNotice() {
         $model_module_attendance = HrModules::model()->findByPK(2);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empatt_late_notice_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y')) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_morning_late');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetMorninglateList() {
        $to_date = $_POST['to_date'];
        $branch = $_POST['branch'];
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->renderPartial('employee_morning_late', array('to_date' => $to_date, 'branch' => $branch), false, true);
    
    }
    public function actionIssueNotice() {
        date_default_timezone_set("Asia/Dubai");
        $from_date= $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $id= $_POST['id'];
        $model_warning= new EmployeeAttendanceWarning();
        $model_warning->employee_id =$id;
        $model_warning->date_from =$from_date;
        $model_warning->date_to=$to_date;
        $model_warning->created_by=Yii::app()->user->id;;
        $model_warning->created_date_time =date('Y-m-d H:i:s');;
        $model_warning->save();
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionDownloadNotice() {
        $id= Yii::app()->request->getParam('id');
        $model_warning = EmployeeAttendanceWarning::model()->findbyPK($id);
        EmployeeAttendanceWarning::model()->updateByPK($model_warning->id, array('view_status'=>1));
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.warning_notice', array('id'=>$id,'model_warning'=>$model_warning), true));
        $mPDF1->Output('notice.pdf', 'D');
    }
    public function actionGetbranchSalarylocked() {
        $branch =$_POST['branch'];
        $model_general_setting = HrGenerelSettings::model()->find();
        $model_lock_branch = SalaryProcessing::model()->find(array('select'=>'max(payroll_enddate) as payroll_enddate','condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="'.$branch.'" OR payroll_branch_or_sponsor_id="0")'));
        //$model_lock = SalaryProcessing::model()->find(array('select'=>'max(t.id) as id','condition' => 'payroll_status="2" and payroll_branch_or_sponsor_id="0"'));

        $last_locked_date="";
        if($model_lock_branch->payroll_enddate!='' && $model_lock_branch->payroll_enddate!='0000-00-00'){
            $payroll_enddate= date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
            $last_locked_date=date('d/m/Y',strtotime($payroll_enddate));
        }
        $jsonData['lock_attendance_leave'] = $model_general_setting->lock_attendance_leave;
        $jsonData['last_locked_date'] = $last_locked_date;
        echo CJSON::encode($jsonData);
    }
    public function actionGetsalarylockedDate() {
        $id =$_POST['employeeid'];
        $model_employee= Employee::model()->findbyPk($id);
        $model_general_setting = HrGenerelSettings::model()->find();
        $model_lock = SalarySlip::model()->with('processing')->find(array('select'=>'max(t.salary_processing_id) as salary_processing_id','condition' => 'processing.payroll_status="2" and employee_id="'.$id.'"'));
        $last_locked_date="";
        $last_locked_date_1="";
        if($model_general_setting->lock_attendance_leave=="Y"){
            if($model_lock->salary_processing_id>0){
                $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
                $payroll_enddate= date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
                $last_locked_date_1=$payroll_enddate;
                $last_locked_date=date('d/m/Y',strtotime($payroll_enddate));
            }else{
                $model_lock_branch = SalaryProcessing::model()->find(array('select'=>'max(payroll_enddate) as payroll_enddate','condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="'.$model_employee->branch_or_sponsor_id.'" OR payroll_branch_or_sponsor_id="0")'));
                if($model_lock_branch->payroll_enddate!='' && $model_lock_branch->payroll_enddate!='0000-00-00'){
                    $payroll_enddate= date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                    $last_locked_date_1=$payroll_enddate;
                    $last_locked_date=date('d/m/Y',strtotime($payroll_enddate));
                }
            }
            $joining_date=$model_employee->date_join;
            if(strtotime($joining_date)>strtotime($last_locked_date_1)){
                $last_locked_date=date('d/m/Y',strtotime($joining_date));
            }
        }else{
            $last_locked_date=date('d/m/Y',strtotime($model_employee->date_join));
        }
        $jsonData['lock_attendance_leave'] = $model_general_setting->lock_attendance_leave;
        $jsonData['last_locked_date'] = $last_locked_date;
        echo CJSON::encode($jsonData);
    }
    public function actionAddmonthlyAttendance() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('monthlyattendance_index');
    }
    public function actionloademployeedetailsbybranch() {
        $branch = $_POST['branch'];
        $date_from = $_POST['date_from'];
        $date_to = $_POST['date_to'];
        $condition = "isActive!='B'";
        if ($branch > 0) {
            $condition.=' AND (branch_or_sponsor_id="'.$branch.'")';
        }else{
            if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
                $condition.= ' and (branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.'))';
            }
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and t.reporting_manager="'.$model_user->department_head_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('monthly_attendance_employee_details', array('arr_employee' => $arr_employee,'date_from' => $date_from,'date_to' => $date_to));
    }
    public function actionViewattendanceDetails() {

        $id = (int) Yii::app()->request->getParam('id');
        $date1 = Yii::app()->request->getParam('date1');
        $date2 = Yii::app()->request->getParam('date2');
        $type = Yii::app()->request->getParam('type');
        $model = Employee::model()->findByPK($id);
        $model_attendance = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $id . '" AND attendance_date>="' . $date1 . '" AND attendance_date<="' . $date2 . '" '));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view_attendance_details', array('modelemployee' => $model, 'model_attendance' => $model_attendance, 'date_from' => $date1, 'date_to' => $date2, 'type' => $type), false, true);
    }
    public function actionMorninglateList() {
        $to_date = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->renderPartial('morning_late_details', array('to_date' => $to_date), false, true);
    
    }
    public function actionSaveMonthlyAttendanceUpload() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $docs = $_POST['attendance_file'];
        date_default_timezone_set("Asia/Dubai");
        $branch = $_POST['attendance_branch'];
        $from_date = $_POST['date_from'];
        $to_date = $_POST['date_to'];
        $total_days=0;
        $start_date='';
        $condition_upload='branch_id=0';
        if($branch>0){
            $condition_upload='branch_id="' . $branch . '"';
        }
        $model_upload_format= HrAttendanceUploadFormat::model()->find(array('condition' =>$condition_upload));  
        if(empty($model_upload_format)){
            $model_upload_format= HrAttendanceUploadFormat::model()->find(array('condition' =>'branch_id=0'));  
        }
        $employee_code_type=$model_upload_format->use_employee_code_r_biometric;
        $employee_code_column=0;
        //COde Column
        if($employee_code_type=='E'){
            $employee_code_column=$model_upload_format->employee_id;
        }elseif($employee_code_type=='B'){
            $employee_code_column=$model_upload_format->employee_id;
        }
        //Attendance Column
        $attendance_code_column=$model_upload_format->attendance_date;
        //Attendance Date Format
        $attendance_format_val=$model_upload_format->date_format;
        //Time column
        $in_column=$out_column=0;
        $in_column_status=$out_column_status=$status_column_no=$status_time_column=0;
        $time_from_type=$model_upload_format->time_from;
        if($time_from_type=='C'){
            $in_column=$model_upload_format->login_time;
            $out_column=$model_upload_format->logout_time;
        }elseif($employee_code_type=='S'){
            $status_column_no=$model_upload_format->status_column;
            $in_column_status=strtolower($model_upload_format->status_login);
            $out_column_status=strtolower($model_upload_format->status_logout);
            $status_time_column=strtolower($model_upload_format->status_time);
        }
        if($from_date!='' && $to_date!=''){
            $from_date_1 = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
            $start_date=$from_date_1;
            $to_date_1 = date("Y-m-d", strtotime(str_replace('/', '-', $to_date)));
            $d1 = strtotime($from_date_1);
            $d2 = strtotime($to_date_1);
            $diff = $d2 - $d1;
            $total_days = floor($diff / (60 * 60 * 24)+1);
        }
        $docs = str_replace(',', '', $docs);
        $attendance_list = $this->readCSV("uploads/attendance/" . $docs);
        foreach (array_slice($attendance_list, 1) as $i => $eachItem) {
            $emp_no =0;
            $uploaded_date ='';
            if(!empty($eachItem[$employee_code_column])){
            $emp_no = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$employee_code_column]), '"')); //Employee Code OR Biometric Code
             }
             if(!empty($eachItem[$attendance_code_column])){
                $uploaded_date = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$attendance_code_column]), '"'));
            }
             //Changing Date Format
            if($attendance_format_val==1 || $attendance_format_val==4){
                $date_from=date("Y-m-d", strtotime(str_replace('/', '-', $uploaded_date)));
            }else if($attendance_format_val==2 || $attendance_format_val==5){
                $date_from=date("Y-m-d", strtotime($uploaded_date));
            }else if($attendance_format_val==3 || $attendance_format_val==6){
                $date_from=date("Y-m-d", strtotime($uploaded_date));
            }else if($attendance_format_val==7){
                $uploaded_date_frm=date("Y-m-d", strtotime($uploaded_date));
            }
            if($date_from!=''){
                $weekvalue = date('w', strtotime($date_from));
                $weekvalue+=1;
                if ($weekvalue == 1) {
                    $day = "Sunday";
                } else if ($weekvalue == 2) {
                    $day = "Monday";
                } else if ($weekvalue == 3) {
                    $day = "Tuesday";
                } else if ($weekvalue == 4) {
                    $day = "Wednesday";
                } else if ($weekvalue == 5) {
                    $day = "Thursday";
                } else if ($weekvalue == 6) {
                    $day = "Friday";
                } else if ($weekvalue == 7) {
                    $day = "Saturday";
                }
            }       
            if ($emp_no != '') {
                if(strtotime($date_from)>= strtotime($start_date)){          
                    $in=$out='';
                    if($employee_code_type=='E'){
                        $employee_code = $this->ciphertext($emp_no, "e");
                        $model = Employee::model()->find(array('condition' => 'employee_code="' . $employee_code . '" and t.isActive!="B" '));
                    }else if($employee_code_type=='B'){
                        $model = Employee::model()->find(array('condition' => 'employee_biometric_code="' . $emp_no . '" and t.isActive!="B" '));
                    }                 
                    if (!empty($model)) {
                        if($time_from_type=='C'){
                            $in = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$in_column]), '"'));
                            $out = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$out_column]), '"'));
                        }else if($time_from_type=='S'){
                            $type = strtolower(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$status_column_no]), '"')));
                            if($type==$in_column_status){
                                $in = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$status_time_column]), '"'));
                            }else if($type==$out_column_status){
                                $out = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[$status_time_column]), '"'));
                            }
                        }
                        $weekend=0;
                        $weektype='';
                        $model_attendance_1 = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $model->id . '" and attendance_date="' . $date_from . '"'));
                        if ($model->weekend_off1 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off1_type;
                        }
                        if ($model->weekend_off2 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off2_type;
                        }
                        if ($model->weekend_off3 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off3_type;
                        }
                        $order_manhours=0;
                        if (empty($model_attendance_1)) {
                            $model_attendance = new EmployeeAttendance();
                            $model_attendance->created_by = Yii::app()->user->id;
                            $model_attendance->created_date_time = date('Y-m-d H:i:s');
                            $order_manhours=0;
                        } else {
                            $model_attendance = EmployeeAttendance::model()->findByPK($model_attendance_1->id);
                            $model_attendance->updated_by = Yii::app()->user->id;
                            $model_attendance->updated_date_time = date('Y-m-d H:i:s');
                            $order_manhours=$model_attendance->order_manhours;
//                            if($model_attendance->login_time!='00:00'){
//                                $in = date("H:i", strtotime($model_attendance->login_time));
//                            }
//                            if($model_attendance->logout_time!='00:00'){
//                                $out = date("H:i", strtotime($model_attendance->logout_time));
//                            }
                        }
                        if (($in != '' && $in != 'A' && $in != '0:00' && $in != '00:00') || ($model_attendance->id>0 && $in== '00:00')) {
                            $in = date("H:i", strtotime($in));
                         }
                         if (($out != '' && $out != 'A' && $out != '0:00' && $out != '00:00') || ($model_attendance->id>0 && $out== '00:00')) {
                            $out = date("H:i", strtotime($out));
                         }
                        $model_attendance->employee_id = $model->id;
                        $model_attendance->upload_file = $docs;
                        $model_attendance->attendance_via = "U";
                        $model_attendance->status = 1;
                        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
                        if(!empty($model_shift)){
                            $model_attendance->shift_id = $model_shift->id;
                            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                     }
                        if(empty($model_shift)){
                            $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                            $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                        }
                        if($weekend==1 && $weektype=='H'){
                            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
                        }
                        //Attendance time
                        $model_attendance->login_time ='00:00';
                        $model_attendance->logout_time ='00:00';
                        if ($in != '' && $in != '00:00' && $in != '0:00') {
                            $model_attendance->login_time = $in;
                        }
                        if ($out != '' && $out != '00:00' && $out != '0:00') {
                            $model_attendance->logout_time = $out;
                        }
                        if ($model->employee_exclude_biometric == 1) {
                            if ($in == '' || $in == '00:00' || $in == '0:00'){
                                $model_attendance->login_time =$original_start_time;
                            }
                            if ($out == '' || $out == '00:00' || $out == '0:00'){
                                $model_attendance->logout_time =$original_stop_time;
                            }

                        }else {
                            if ($in == '' || $in == 'A' || $in == '00:00' || $in == '0:00' || $out == '' || $out == '00:00' || $out == 'A') {
                                if ($in != '' && $in != 'A' && $in != '00:00' && $in != '0:00' && ($out == '' || $out == '00:00' || $out == '0:00')) {
                                    $model_attendance->status = 1;
                                }else{
                                    $model_attendance->status = 2;
                                }
                            }
                        }
                        //Working Details
                        $model_attendance->morning_late =$this->morninglate($model->id,$date_from,$model_attendance->login_time);
                        $model_attendance->total_working =$this->totalworking($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->variance_time_loss =$this->totaltimeloss($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->excess_time =$this->excesstime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->shift_id = $this->shiftdetail($model->id,$date_from);
                        if ($model_attendance->status == 1 && $model->overtime == "Y" && $model_attendance->login_time != '' && $model_attendance->logout_time != '' && $order_manhours==0) {
                            $model_settings = HrGenerelSettings::model()->find();
                            $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
                            if(!empty($model_holiday) && $model_settings->holiday_ot_from=='O') {
                                $model_attendance->holiday_overtime = $this->holidayasworkingovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }else if(!empty($model_holiday)){
                                $model_attendance->holiday_overtime = $this->holidayovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }else if($model_master_shift->shift_type=='N'){
                                $model_attendance->night_shift_overtime=$this->nightshiftovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->holiday_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }else if($weekend==1) {
                                $model_attendance->weekend_overtime =$this->weekendovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->holiday_overtime = '00:00:00';
                            }else if(empty($model_holiday)) {
                                $model_attendance->normal_overtime = $this->normalovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->holiday_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }
                        } else {
                            $model_attendance->night_shift_overtime = 0;
                            $model_attendance->holiday_overtime = 0;
                            $model_attendance->normal_overtime = 0;
                            $model_attendance->weekend_overtime = 0;
                        }
                        $model_attendance->branch_or_sponsor_id = $model->branch_or_sponsor_id;;
                        $model_attendance->attendance_date = $date_from;
                        $model_attendance->week_day = $day;
                        if(!empty($model_master_shift) && $model_master_shift->shift_type=='N' && $model_attendance->status == 1){
                            $model_attendance->night_shift_allowance=$model_shift->allowance_amount;
                        }
                        $model_attendance->save(false);
                    }
                }
            }
            
        }
        //Saving Attendance of All Employees
        $date_from=$start_date;
        for($s=0;$s<$total_days;$s++){
            $weekvalue = date('w', strtotime($date_from));
            $weekvalue+=1;
            if ($weekvalue == 1) {
                $day = "Sunday";
            } else if ($weekvalue == 2) {
                $day = "Monday";
            } else if ($weekvalue == 3) {
                $day = "Tuesday";
            } else if ($weekvalue == 4) {
                $day = "Wednesday";
            } else if ($weekvalue == 5) {
                $day = "Thursday";
            } else if ($weekvalue == 6) {
                $day = "Friday";
            } else if ($weekvalue == 7) {
                $day = "Saturday";
            }
            $modelemployee = Employee::model()->findAll(array('condition' => 'branch_or_sponsor_id="' . $branch . '" and t.isActive!="B" and date_join<="'.$date_from.'"'));
            foreach ($modelemployee as $j => $empdetail) {
                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
                if(!empty($model_shift)){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                    if(!empty($model_master_shift)){
                        $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                        $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                    }
                }
                if(empty($model_shift)){
                    $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                     if(!empty($model_company_shift)){
                        $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                        $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                    }
                }
                $status = 2;      // Absent
                $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => 'leave_start_date <= "' . $date_from . '" AND  leave_end_date >="' . $date_from . '" AND employee_id="' . $empdetail->id . '" and leave_status="12"'));
                $leave_id =0;
                if (!empty($arr_leave_details)) {
                    $status = 3;   // leave
                    $leave_id=$arr_leave_details->id;
                }
                $weekend=0;
                $weekend_type='';
                if ($empdetail->weekend_off1 == $weekvalue) {
                    $status = 5;  // Weekend
                    if($empdetail->weekend_off1_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($empdetail->weekend_off2 == $weekvalue) {
                    $status = 5;  // Weekend
                    if($empdetail->weekend_off2_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($empdetail->weekend_off3 == $weekvalue) {
                    $status = 5;  // Weekend
                   if($empdetail->weekend_off3_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$empdetail->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
                if (!empty($model_holiday)) {
                    $status = 4;  // Holiday
                }
                $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $date_from . '" and employee_id="' . $empdetail->id . '"'));
                if (empty($model_attendance_detail)) {
                    if ($empdetail->employee_exclude_biometric==1 && $status==2) { 
                        $model_attendance_add = new EmployeeAttendance;
                        $model_attendance_add->employee_id = $empdetail->id;
                        $model_attendance_add->shift_id = $model_shift->id;
                        $model_attendance_add->login_time = $original_start_time;
                        $model_attendance_add->logout_time = $original_stop_time;
                        $model_attendance_add->normal_overtime = 0;
                        $model_attendance_add->holiday_overtime = 0;
                        $model_attendance_add->weekend_overtime = 0;
                        $model_attendance_add->attendance_date = $date_from;
                        $model_attendance_add->week_day = $day;
                        $model_attendance_add->status = 1;
                        $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;   
                        $model_attendance_add->created_by = Yii::app()->user->id;
                        $model_attendance_add->created_date_time = date('Y-m-d H:i:s');
                        $model_attendance_add->save(false);
                    }else{
                        $model_attendance_add = new EmployeeAttendance;
                        $model_attendance_add->employee_id = $empdetail->id;
                        $model_attendance_add->shift_id = $model_shift->id;
                        $model_attendance_add->login_time ='00:00';
                        $model_attendance_add->logout_time = '00:00';
                        $model_attendance_add->normal_overtime = 0;
                        $model_attendance_add->holiday_overtime = 0;
                        $model_attendance_add->weekend_overtime = 0;
                        $model_attendance_add->attendance_date = $date_from;
                        $model_attendance_add->week_day=$day;
                        $model_attendance_add->created_by = Yii::app()->user->id;
                        $model_attendance_add->created_date_time = date('Y-m-d H:i:s');
                        $model_attendance_add->status=$status;
                        if ($status==3) {
                            $model_attendance_add->leave_id = $arr_leave_details->id;
                        }
                        $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;;
                        $model_attendance_add->save(false);
                    }
                }else if($model_attendance_detail->status!=1){
                    if($leave_id >0){
                        EmployeeAttendance::model()->updateByPK($model_attendance_detail->id, array('status'=>$status,'leave_id' => $leave_id)); 
                    }   
                }

            }
            $date_from=date('Y-m-d', strtotime('+1 day', strtotime($date_from)));
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionUploadmonthlyAttendance() {
        $model_general_setting = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_monthly_attendance_form',array('model_general_setting'=>$model_general_setting));
    }
    public function actionAttendanceOnsite() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('attendance_onsite');
    }
    public function actionloadhiringattendance() {
        $branch = Yii::app()->request->getparam("branch");
        $start_date= Yii::app()->request->getparam("start_date");
        $start_end= Yii::app()->request->getparam("start_end");
        $start_date= date("Y-m-d", strtotime(str_replace('/', '-',$start_date)));
        $start_end= date("Y-m-d", strtotime(str_replace('/', '-',$start_end)));
        $condition='employeedetails.branch_or_sponsor_id="'.$branch.'" AND employeedetails.isActive!="B" AND work_date>="'.$start_date.'" and work_date<="'.$start_end.'"';      
        $model_site_attendance = OrderManhours::model()->with('employeedetails')->findAll(array('select'=>'*,min(start_time) as start_time,max(end_time) as end_time,SEC_TO_TIME(SUM(time_to_sec(`overtime_hrs`))) As overtime_hrs','condition' =>$condition,'group'=>'work_date,employee_id','order'=>'work_date asc'));
        $model = new EmployeeAttendance();      //echo '<pre>';  print_r($model_site_attendance);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('employee_attendance_onsite', array('model' => $model, 'model_site_attendance' => $model_site_attendance, 'branch' => $branch,'start_date' => $start_date,'start_end' => $start_end));
    }
    public function actionSavehiringattendance() {        
        if (isset($_POST['EmployeeAttendance'])) {
            $validate=true;
            date_default_timezone_set("Asia/Dubai");
            foreach ($_POST['EmployeeAttendance'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = EmployeeAttendance::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new EmployeeAttendance();
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                $weekvalue = date('w', strtotime($items['attendance_date']));
                $weekvalue+=1;
                if ($weekvalue == 1) {
                    $day = "Sunday";
                } else if ($weekvalue == 2) {
                    $day = "Monday";
                } else if ($weekvalue == 3) {
                    $day = "Tuesday";
                } else if ($weekvalue == 4) {
                    $day = "Wednesday";
                } else if ($weekvalue == 5) {
                    $day = "Thursday";
                } else if ($weekvalue == 6) {
                    $day = "Friday";
                } else if ($weekvalue == 7) {
                    $day = "Saturday";
                }
                $model[$i]->employee_id = $items['employee_id'];
                $model[$i]->branch_or_sponsor_id = $items['branch_or_sponsor_id'];
                $model[$i]->shift_id = $items['shift_id'];
                $model[$i]->login_time = $items['login_time'];
                $model[$i]->logout_time = $items['logout_time'];               
                $model[$i]->status = $items['status'];
                $model[$i]->week_day =$day;
                $model[$i]->leave_id = $items['leave_id'];
                $model[$i]->onsite_normal_overtime = $items['onsite_normal_overtime'];
                $model[$i]->onsite_holiday_overtime = $items['onsite_holiday_overtime'];
                $model[$i]->attendance_date =$items['attendance_date'];
                $model[$i]->order_manhours =$items['order_manhours'];
                $model[$i]->daily_allowance =$items['daily_allowance'];
                $model[$i]->overtime_rate =$items['overtime_rate'];
                $model[$i]->total_overtime_amount =$items['total_overtime_amount'];
                $model[$i]->total_amount =$items['total_amount'];
                $model[$i]->remarks =$items['remarks'];
                $model[$i]->holiday_overtime= 0;
                $model[$i]->normal_overtime= 0;
                $model[$i]->weekend_overtime = 0;
                $model[$i]->attendance_via = 'H';
                $validate = $model[$i]->validate() && $validate; 
            }
            if ($validate) {
                foreach ($model as $eachModel) {
                    $eachModel->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error_array = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode($error_array);
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }
    public function actionGetlastlockeddate() {
        $branch_id = $_POST['branch_id'];
        $end_date='';
        $attendance_start_date='';
        $model_unlock = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate','condition' => '(payroll_branch_or_sponsor_id="' . $branch_id . '" OR payroll_branch_or_sponsor_id="0")'));       
        if ($model_unlock->payroll_enddate != '' && $model_unlock->payroll_enddate != '0000-00-00') {
            $end_date=$model_unlock->payroll_enddate;
            $attendance_start_date=date('Y-m-d', strtotime('+1 days', strtotime($end_date)));
            $attendance_start_date=date("d/m/Y", strtotime($attendance_start_date));
        }else{
            $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $branch_id . '"'));
            if ($model_lock_month->id == '') {
                $model_lock_month = MasterSalaryLock::model()->find();
            }
            $payroll_month = $model_lock_month->payroll_month;
            $payroll_year = $model_lock_month->payroll_year;
            $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $branch_id . '"'));
            if ($model_lock_days->id == '') {
                $model_lock_days = MasterSalaryProcedure::model()->find();
            }
            $payroll_start_day = $model_lock_days->payroll_start_day;
            $payroll_start_date=$payroll_year.'-'.$payroll_month.'-'.$payroll_start_day;
            $attendance_start_date = date('Y-m-d', strtotime('+1 month', strtotime($payroll_start_date)));
            $attendance_start_date=date("d/m/Y", strtotime($attendance_start_date));
        }
        $jsonData['start_date'] = $attendance_start_date;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionSaveBiometricAutoUpload() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=';
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        $connect = ftp_connect('blueskyhrms.com')     or die("Can't connect");
        $ftp_user_name='';
        $ftp_user_pass='';
        ftp_login($connect,$ftp_user_name,$ftp_user_pass)     or die("Can't login");       
        $file_name = date("d-m-Y");
        ftp_get($connect,'upload/biometricattendance/'.$file_name.'.csv',$file_name.'.csv',FTP_BINARY);
        ftp_close($connect);
        $date_from=date("Y-m-d");
        $weekvalue=date('w', strtotime($date_from));
        $weekvalue+=1;
        $day='';
        if ($weekvalue == 1) {
            $day = "Sunday";
        } else if ($weekvalue == 2) {
            $day = "Monday";
        } else if ($weekvalue == 3) {
            $day = "Tuesday";
        } else if ($weekvalue == 4) {
            $day = "Wednesday";
        } else if ($weekvalue == 5) {
            $day = "Thursday";
        } else if ($weekvalue == 6) {
            $day = "Friday";
        } else if ($weekvalue == 7) {
            $day = "Saturday";
        }
        $attendance_list = $this->readEmployeeCSV('upload/biometricattendance/'.$file_name.'.csv');
        foreach (array_slice($attendance_list, 1) as $i => $eachItem) {
            $emp_no = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
            $in = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[10]), '"'));
            $out = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[12]), '"')); 
            $uploaded_date_from = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));
            $date_array =explode('/',$uploaded_date_from);                   
            $uploaded_date_from_1= $date_array[2].'-'.$date_array[0].'-'.$date_array[1];
            if(strtotime($uploaded_date_from_1)==strtotime($date_from)){
                if ($emp_no != '') {
                    if ($in != '' && $in != '0:00' && $in != '00:00') {
                        $in = date("H:i", strtotime($in));
                    }
                    if ($out != '' && $out != '0:00' && $out != '00:00') {
                        $out = date("H:i", strtotime($out));
                    }
                    //$employee_code = $this->ciphertext($emp_no, "e");
                    $model = Employee::model()->find(array('condition' => 'employee_biometric_code="' . $emp_no . '" and t.isActive!="B" '));
                    if (!empty($model)) {
                        $weekend=0;
                        $weektype='';
                        $model_attendance_1 = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $model->id . '" and attendance_date="' . $date_from . '"'));
                        if ($model->weekend_off1 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off1_type;
                        }
                        if ($model->weekend_off2 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off2_type;
                        }
                        if ($model->weekend_off3 == $weekvalue) {
                            $weekend=1;
                            $weektype=$model->weekend_off3_type;
                        }
                        $order_manhours=0;
                        if (empty($model_attendance_1)) {
                            $model_attendance = new EmployeeAttendance();
                            $model_attendance->created_by = Yii::app()->user->id;
                            $model_attendance->created_date_time = date('Y-m-d H:i:s');
                            $order_manhours=0;
                        } else {
                            $model_attendance = EmployeeAttendance::model()->findByPK($model_attendance_1->id);
                            $model_attendance->updated_by = Yii::app()->user->id;
                            $model_attendance->updated_date_time = date('Y-m-d H:i:s');
                            $order_manhours=$model_attendance->order_manhours;
                        }

                        $model_attendance->employee_id = $model->id;
                        $model_attendance->upload_file = $file_name.'.csv';
                        $model_attendance->attendance_via = "U";
                        $model_attendance->status = 1;
                        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
                        $model_attendance->shift_id = $model_shift->id;
                        $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                        $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                        $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                        if($model_shift->shift_id==''){
                            $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                            $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                        }
                        if($weekend==1 && $weektype=='H'){
                            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
                        }
                        //Attendance time
                        $model_attendance->login_time ='00:00';
                        $model_attendance->logout_time ='00:00';
                        if ($in != '' && $in != '00:00' && $in != '0:00') {
                            $model_attendance->login_time = $in;
                        }
                        if ($out != '' && $out != '00:00' && $out != '0:00') {
                            $model_attendance->logout_time = $out;
                        }
                        if ($model->employee_exclude_biometric == 1) {
                            if ($in == '' || $in == '00:00' || $in == '0:00'){
                                $model_attendance->login_time =$original_start_time;
                            }
                            if ($out == '' || $out == '00:00' || $out == '0:00'){
                                $model_attendance->logout_time =$original_stop_time;
                            }

                        }else {
                            if ($in == '' || $in == '00:00' || $in == '0:00' || $out == '' || $out == '00:00' || $out == '0:00') {
                                if ($in != '' && $in != '00:00' && $in != '0:00' && ($out == '' || $out == '00:00' || $out == '0:00')) {
                                    $model_attendance->status = 1;
                                }else{
                                    $model_attendance->status = 2;
                                }
                            }
                        }
                        //Working Details
                        $model_attendance->morning_late =$this->morninglate($model->id,$date_from,$model_attendance->login_time);
                        $model_attendance->total_working =$this->totalworking($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->variance_time_loss =$this->totaltimeloss($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->excess_time =$this->excesstime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                        $model_attendance->shift_id = $this->shiftdetail($model->id,$date_from);
                        if ($model_attendance->status == 1 && $model->overtime == "Y" && $model_attendance->login_time != '' && $model_attendance->logout_time != '' && $order_manhours==0) {
                            $model_settings = HrGenerelSettings::model()->find();
                            $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
                            if(!empty($model_holiday) && $model_settings->holiday_ot_from=='O') {
                                $model_attendance->holiday_overtime = $this->holidayasworkingovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                           }else if(!empty($model_holiday)){
                                $model_attendance->holiday_overtime = $this->holidayovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }else if($model_master_shift->shift_type=='N'){
                                $model_attendance->night_shift_overtime=$this->nightshiftovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->holiday_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }else if($weekend==1) {
                                $model_attendance->weekend_overtime =$this->weekendovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->normal_overtime = '00:00:00';
                                $model_attendance->holiday_overtime = '00:00:00';
                            }else if(empty($model_holiday)) {
                                $model_attendance->normal_overtime = $this->normalovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                                $model_attendance->night_shift_overtime ='00:00:00';
                                $model_attendance->holiday_overtime = '00:00:00';
                                $model_attendance->weekend_overtime = '00:00:00';
                            }
                        } else {
                            $model_attendance->holiday_overtime = 0;
                            $model_attendance->night_shift_overtime = 0;
                            $model_attendance->normal_overtime = 0;
                            $model_attendance->weekend_overtime = 0;
                        }
                        $model_attendance->branch_or_sponsor_id = $model->branch_or_sponsor_id;
                        $model_attendance->attendance_date = $date_from;
                        $model_attendance->week_day = $day;
                        if($model_master_shift->shift_type=='N' && $model_attendance->status == 1){
                            $model_attendance->night_shift_allowance=$model_shift->allowance_amount;
                        }
                        $model_attendance->save(false);
                    }
                }
            }
        }
        //Saving Attendance of All Employees
        $branch=0;
        $condition='t.isActive!="B" and date_join<="'.$date_from.'"';
        if($branch>0){
            $condition.=' and branch_or_sponsor_id="'.$branch.'"';
        }
        $modelemployee = Employee::model()->findAll(array('condition' =>$condition));
        foreach ($modelemployee as $j => $empdetail) {
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                            OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            if($model_shift->shift_id==''){
                $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
            }
            $status = 2;      // Absent
            $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => 'leave_start_date <= "' . $date_from . '" AND  leave_end_date >="' . $date_from . '" AND employee_id="' . $empdetail->id . '" and leave_status="12"'));
            if (!empty($arr_leave_details)) {
                $status = 3;   // leave
            }
            $weekend=0;
            $weekend_type='';
            if ($empdetail->weekend_off1 == $weekvalue) {
                $status = 5;  // Weekend
                if($empdetail->weekend_off1_type=='H'){
                    $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                    $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                }
            }
            if ($empdetail->weekend_off2 == $weekvalue) {
                $status = 5;  // Weekend
                if($empdetail->weekend_off2_type=='H'){
                    $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                    $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                }
            }
            if ($empdetail->weekend_off3 == $weekvalue) {
                $status = 5;  // Weekend
               if($empdetail->weekend_off3_type=='H'){
                    $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                    $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                }
            }
            $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$empdetail->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
            if (!empty($model_holiday)) {
                $status = 4;  // Holiday
            }
            $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $date_from . '" and employee_id="' . $empdetail->id . '"'));
            if (empty($model_attendance_detail)) {
                if ($empdetail->employee_exclude_biometric==1 && $status==2) {
                    $model_attendance_add = new EmployeeAttendance;
                    $model_attendance_add->employee_id = $empdetail->id;
                    $model_attendance_add->shift_id = $model_shift->id;
                    $model_attendance_add->login_time = $original_start_time;
                    $model_attendance_add->logout_time = $original_stop_time;
                    $model_attendance_add->normal_overtime = 0;
                    $model_attendance_add->holiday_overtime = 0;
                    $model_attendance_add->weekend_overtime = 0;
                    $model_attendance_add->attendance_date = $date_from;
                    $model_attendance_add->week_day = $day;
                    $model_attendance_add->status = 1;
                    $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;
                    $model_attendance_add->save(false);
                }else{
                    $model_attendance_add = new EmployeeAttendance;
                    $model_attendance_add->employee_id = $empdetail->id;
                    $model_attendance_add->shift_id = $model_shift->id;
                    $model_attendance_add->login_time ='00:00';
                    $model_attendance_add->logout_time = '00:00';
                    $model_attendance_add->normal_overtime = 0;
                    $model_attendance_add->holiday_overtime = 0;
                    $model_attendance_add->weekend_overtime = 0;
                    $model_attendance_add->attendance_date = $date_from;
                    $model_attendance_add->week_day=$day;
                    $model_attendance_add->status=$status;
                    if ($status==3) {
                        $model_attendance_add->leave_id = $arr_leave_details->id;
                    }
                    $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;;
                    $model_attendance_add->save(false);
                }
            }
            
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function readEmployeeCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionAddBiometricno() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('add_change_biometricno');
    }
    public function actiongetemployeelistbybranch() {
        $branch = $_POST['branch'];
        $condition = "isActive!='B'";
        if ($branch > 0) {
            $condition.=' AND (branch_or_sponsor_id="'.$branch.'")';
        }      
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('employee_biometric_details', array('arr_employee' => $arr_employee));
    }
    public function actionSaveBiometricno() {
        if ((isset($_POST['Employee']))) {
            $validate = true;
            foreach ($_POST['Employee'] as $i => $items) {
                    $model_employee[$i] = new Employee();
                    if ($items['id'] > 0) {
                        $model_employee[$i] = $model_employee[$i]->findByPK($items['id']);
                    }          
                    $model_employee[$i]->employee_biometric_code = $items['employee_biometric_code'];
                
            }
            if (!empty($model_employee)) {
                    if (!empty($model_employee)) {
                        foreach ($model_employee as $eachModel) {
                            $eachModel->save();
                        }
                    }                    
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
            }else {
                $jsonData['status'] = 'error';
                echo CJSON::encode($jsonData);
            }
        }
    }
    public function actionDailyattendanceList() {
        $to_date = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->renderPartial('daily_attendance_details', array('to_date' => $to_date), false, true);
    
    }
    public function actionattendancestatus() {
        $this->layout = 'main';
        $model_module_attendance = HrModules::model()->findByPK(2);
        if ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('attendance_status');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function getSubordinates($managerId) {
        $employees = [];
        $subordinates = Employee::model()->findAll(array('condition' => 'reporting_manager="' . $managerId . '" AND isActive="Y"'));
        foreach ($subordinates as $subordinate) {
            $employees[] = $subordinate->id;
            $model_reporting_mngr = ReportingManager::model()->find(array('condition' => 'employee_id="' . $subordinate->id . '"'));
            if (!empty($model_reporting_mngr)) {
                $employees = array_merge($employees, $this->getSubordinates($subordinate->id));
            }
        }
        return $employees;
    }
    public function actionGetStatus() {

        $model = new EmployeeAttendance();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.branch_or_sponsor_id',
            2 => 'employeedetail.employee_code',
            3 => 'employeedetail.first_name',
            4 => 't.id',
            5 => 't.id',
             6 => 'status',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $from_date = date('Y-m-d', strtotime($_POST['from_date']));
        $to_date = date('Y-m-d', strtotime($_POST['date_to']));
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $condition = 'employeedetail.isActive="Y" AND reporting_manager="' . $empid . '" ';
        /*$arr_employees=$this->getSubordinates($empid);
        $employee_ids='';
        if(!empty($arr_employees)){
            $employee_ids=implode(',',$arr_employees);
        }
        if($employee_ids!=''){
            $condition.= ' and employeedetail.id IN ('.$employee_ids.')';
        }*/
        if ($from_date != '') {
            $from_date = date('Y-m-d', strtotime(str_replace('/', '-', $from_date)));
            $condition .= ' AND t.attendance_date >="' . $from_date . '"';
        }
        if ($to_date != '') {
            $to_date = date('Y-m-d', strtotime(str_replace('/', '-', $to_date)));
            $condition .= ' AND t.attendance_date <="' . $to_date . '"';
        }
        if (isset($_POST['branch_id']) && $_POST['branch_id'] > 0) {
            $condition.= ' AND t.branch_or_sponsor_id="' . $_POST['branch_id'] . '"';
        }
        if ($status!='' && $status > 0) {
            $condition.= ' AND t.status="' . $status. '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";      
        
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order'=>'t.attendance_date  ASC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m=$offset;
        foreach ($model as $row) {
            if ($row['status'] == '1') {
                $status = "Present";
            } else if ($row['status'] == '2') {
                $status = "Absent";
            } else if ($row['status'] == '3') {
                $status = "Leave";
            } else if ($row['status'] == '4') {
                $status = "Holiday";
            } else if ($row['status'] == '5') {
                $status = "Weekend";
            }
            $rowData[] = array(++$m,$row['branch_sponsor']['branch_or_sponsor_name'],date('d/m/Y',strtotime($row['attendance_date'])),$row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'],$row['login_time'],$row['logout_time'], $status);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionLocksalaryAttendance() {
        $model_general_setting = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('locksalary_attendance_form',array('model_general_setting'=>$model_general_setting));
    }
     public function actionsaveautoaddattendance() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        date_default_timezone_set("Asia/Dubai");
        $branch = $_POST['branch'];
        $from_date = $_POST['startdate'];
        $to_date = $_POST['enddate'];
        $total_days=0;
        $start_date='';
        if($from_date!='' && $to_date!=''){
            $from_date_1 = str_replace('/', '-', $from_date);
            $from_date_1 = date("Y-m-d", strtotime($from_date_1));
            $start_date=$from_date_1;
            $to_date_1 = str_replace('/', '-', $to_date);
            $to_date_1 = date("Y-m-d", strtotime($to_date_1));
            $d1 = strtotime($from_date_1);
            $d2 = strtotime($to_date_1);
            $diff = $d2 - $d1;
            $total_days = floor($diff / (60 * 60 * 24)+1);
        }
        $date_from=$start_date;
        for($s=0;$s<$total_days;$s++){
            $weekvalue = date('w', strtotime($date_from));
            $weekvalue+=1;
            if ($weekvalue == 1) {
                $day = "Sunday";
            } else if ($weekvalue == 2) {
                $day = "Monday";
            } else if ($weekvalue == 3) {
                $day = "Tuesday";
            } else if ($weekvalue == 4) {
                $day = "Wednesday";
            } else if ($weekvalue == 5) {
                $day = "Thursday";
            } else if ($weekvalue == 6) {
                $day = "Friday";
            } else if ($weekvalue == 7) {
                $day = "Saturday";
            }
            $condition='branch_or_sponsor_id="' . $branch . '" and t.isActive!="B" and date_join<="'.$date_from.'"';
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
                $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
            }
            $modelemployee = Employee::model()->findAll(array('condition' =>$condition ));
            foreach ($modelemployee as $j => $empdetail) {
                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $empdetail->id . '"'));
                if(!empty($model_shift)){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                }
                $original_start_time ='';
                $original_stop_time='';
                if(!empty($model_master_shift)){
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                }
                if(empty($model_shift) && $model_shift->shift_id==''){
                    $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                    $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                }
                $status = 1;      // Present
                $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => 'leave_start_date <= "' . $date_from . '" AND  leave_end_date >="' . $date_from . '" AND employee_id="' . $empdetail->id . '" and leave_status="12"'));
                $leave_id='';
                if (!empty($arr_leave_details)) {
                    $status = 3;   // leave
                    $leave_id=$arr_leave_details->id;
                }
                $weekend=0;
                $weekend_type='';
                if ($empdetail->weekend_off1 == $weekvalue) {
                    $status = 5;  // Weekend
                    if($empdetail->weekend_off1_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($empdetail->weekend_off2 == $weekvalue) {
                    $status = 5;  // Weekend
                    if($empdetail->weekend_off2_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($empdetail->weekend_off3 == $weekvalue) {
                    $status = 5;  // Weekend
                   if($empdetail->weekend_off3_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$empdetail->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
                if (!empty($model_holiday)) {
                    $status = 4;  // Holiday
                }
                $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $date_from . '" and employee_id="' . $empdetail->id . '"'));
                if (empty($model_attendance_detail)) {
                    if ($status==1) { 
                        $model_attendance_add = new EmployeeAttendance;
                        $model_attendance_add->employee_id = $empdetail->id;
                        if(!empty($model_shift) && $model_shift->id>0){
                            $model_attendance_add->shift_id = $model_shift->id;
                        }
                        $model_attendance_add->login_time = $original_start_time;
                        $model_attendance_add->logout_time = $original_stop_time;
                        $model_attendance_add->normal_overtime = 0;
                        $model_attendance_add->holiday_overtime = 0;
                        $model_attendance_add->weekend_overtime = 0;
                        $model_attendance_add->attendance_date = $date_from;
                        $model_attendance_add->week_day = $day;
                        $model_attendance_add->status = 1;
                        $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;   
                        $model_attendance_add->created_by = Yii::app()->user->id;
                        $model_attendance_add->created_date_time = date('Y-m-d H:i:s');
                        $model_attendance_add->save(false);
                    }else{
                        $model_attendance_add = new EmployeeAttendance;
                        $model_attendance_add->employee_id = $empdetail->id;
                        if(!empty($model_shift) && $model_shift->id>0){
                            $model_attendance_add->shift_id = $model_shift->id;
                        }
                        $model_attendance_add->login_time ='00:00';
                        $model_attendance_add->logout_time = '00:00';
                        $model_attendance_add->normal_overtime = 0;
                        $model_attendance_add->holiday_overtime = 0;
                        $model_attendance_add->weekend_overtime = 0;
                        $model_attendance_add->attendance_date = $date_from;
                        $model_attendance_add->week_day=$day;
                        $model_attendance_add->created_by = Yii::app()->user->id;
                        $model_attendance_add->created_date_time = date('Y-m-d H:i:s');
                        $model_attendance_add->status=$status;
                        if ($status==3) {
                            $model_attendance_add->leave_id = $arr_leave_details->id;
                        }
                        $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;
                        $model_attendance_add->created_by = Yii::app()->user->id;
                        $model_attendance_add->created_date_time = date('Y-m-d H:i:s');
                        $model_attendance_add->save(false);
                    }
                }else if($model_attendance_detail->status!=1){
                    EmployeeAttendance::model()->updateByPK($model_attendance_detail->id, array('status'=>$status,'leave_id' => $leave_id)); 
                }

            }
            $date_from=date('Y-m-d', strtotime('+1 day', strtotime($date_from)));
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionPunch() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('punch_index');
    }
    public function actionSavepunchdetails() {
        $punch_date= $_POST['punch_date'];
        $punch_time= $_POST['punch_time_value'];
        $employee_id= $_POST['punch_employee_id'];
        $shift_id= $_POST['attendance_shift_id'];
        $model_employee = Employee::model()->findByPK($employee_id);
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $punch_date . '" AND to_date>="' . $punch_date . '") OR  (from_date BETWEEN  "' . $punch_date . '" AND  "' . $punch_date . '"
                                OR to_date BETWEEN  "' . $punch_date . '" AND  "' . $punch_date . '")) AND employee_id="' .$employee_id. '"'));
        if(empty($model_shift) && $shift_id>0){
            $shift_group_identify=1;
            $model_shift_exist= EmployeeShift::model()->find(array('condition' => 'from_date="' . $punch_date . '" AND to_date="' . $punch_date . '" AND shift_id="'.$shift_id.'"'));
            if(!empty($model_shift_exist)){
                $shift_group_identify=$model_shift_exist->shift_group_identify;
            }else{
                $model_shift_value= EmployeeShift::model()->find(array('select' => 'max(shift_group_identify) as shift_group_identify'));
                if(!empty($model_shift_value)){
                    $shift_group_identify=$model_shift_value->shift_group_identify+1;
                }
            }
            $model_shift= new EmployeeShift();                          
            $model_shift->employee_id   = $employee_id;
            $model_shift->allowance_amount   =0;
            $model_shift->branch_id      = $model_employee->branch_or_sponsor_id;
            $model_shift->shift_id      = $shift_id;
            $model_shift->from_date     = $punch_date;
            $model_shift->to_date       =$punch_date; 
            $model_shift->shift_group_identify= $shift_group_identify;
            $model_shift->created_by = Yii::app()->user->id;
            $model_shift->created_date_time = date('Y-m-d H:i:s');
            $model_shift->save(false);
        }
        //Saving Attendance
        $weekvalue = date('w', strtotime($punch_date));
        $weekvalue+=1;
        $day=array(1=>"Sunday",2=>"Monday",3=>"Tuesday",4=>"Wednesday",5=>"Thursday",6=>"Friday",7=>"Saturday");
        $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="'.$punch_date.'" and employee_id="'.$employee_id.'"'));
        $time = date("H:i", strtotime($punch_time));
        if(empty($model_attendance_detail)){
            $model_attendance = new EmployeeAttendance();
            $model_attendance->created_by = Yii::app()->user->id;
            $model_attendance->created_date_time = date('Y-m-d H:i:s');
            
            $model_attendance->status = 1;
            $model_attendance->login_time ='00:00';
            $model_attendance->logout_time ='00:00';
            if ($time != '' && $time != '00:00' && $time != '0:00') {
                $model_attendance->login_time =$time;
                $model_attendance->login_punch_from ='H';
            }
            
        }else{
            $model_attendance = EmployeeAttendance::model()->findByPK($model_attendance_detail->id);
            $model_attendance->updated_by = Yii::app()->user->id;
            $model_attendance->updated_date_time = date('Y-m-d H:i:s');
            if ($model_attendance->login_time != '00:00' && $model_attendance->login_time != '') {
                $model_attendance->logout_time =$time;
                $model_attendance->logout_punch_from ='H';
            }else{
                $model_attendance->login_time =$time;
                $model_attendance->login_punch_from ='H';
            }
        }
        $model_attendance->employee_id = $employee_id;
        $model_attendance->upload_file = '';
        $model_attendance->attendance_via = "E";
        //Working Details
        $model_attendance->morning_late =$this->morninglate($employee_id,$punch_date,$model_attendance->login_time);
        $model_attendance->total_working =$this->totalworking($employee_id,$punch_date,$model_attendance->login_time,$model_attendance->logout_time);
        $model_attendance->variance_time_loss =$this->totaltimeloss($employee_id,$punch_date,$model_attendance->login_time,$model_attendance->logout_time);
        $model_attendance->excess_time =$this->excesstime($employee_id,$punch_date,$model_attendance->login_time,$model_attendance->logout_time);
        $model_attendance->shift_id = $this->shiftdetail($employee_id,$punch_date);
        if ($model_attendance->status == 1 && $model_employee->overtime == "Y" && $model_attendance->login_time != '' && $model_attendance->logout_time != '') {
            $model_settings = HrGenerelSettings::model()->find();
            $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $punch_date . '"'));
            if(!empty($model_holiday) && $model_settings->holiday_ot_from=='O') {
                $model_attendance->holiday_overtime = $this->holidayasworkingovertime($employee_id,$punch_date,$model_attendance->login_time,$model_attendance->logout_time);
                $model_attendance->night_shift_overtime ='00:00:00';
                $model_attendance->normal_overtime = '00:00:00';
                $model_attendance->weekend_overtime = '00:00:00';
            }else if(!empty($model_holiday)){
                $model_attendance->holiday_overtime = $this->holidayovertime($employee_id,$punch_date,$model_attendance->login_time,$model_attendance->logout_time);
                $model_attendance->night_shift_overtime ='00:00:00';
                $model_attendance->normal_overtime = '00:00:00';
                $model_attendance->weekend_overtime = '00:00:00';
            }else if($model_master_shift->shift_type=='N'){
                $model_attendance->night_shift_overtime=$this->nightshiftovertime($employee_id,$punch_date,$model_attendance->login_time,$model_attendance->logout_time);
                $model_attendance->holiday_overtime ='00:00:00';
                $model_attendance->normal_overtime = '00:00:00';
                $model_attendance->weekend_overtime = '00:00:00';
            }else if($weekend==1) {
                $model_attendance->weekend_overtime =$this->weekendovertime($employee_id,$punch_date,$model_attendance->login_time,$model_attendance->logout_time);
                $model_attendance->night_shift_overtime ='00:00:00';
                $model_attendance->normal_overtime = '00:00:00';
                $model_attendance->holiday_overtime = '00:00:00';
            }else if(empty($model_holiday)) {
                $model_attendance->normal_overtime = $this->normalovertime($employee_id,$punch_date,$model_attendance->login_time,$model_attendance->logout_time);
                $model_attendance->night_shift_overtime ='00:00:00';
                $model_attendance->holiday_overtime = '00:00:00';
                $model_attendance->weekend_overtime = '00:00:00';
            }
        } else {
            $model_attendance->holiday_overtime = '00:00:00';
            $model_attendance->normal_overtime = '00:00:00';
            $model_attendance->weekend_overtime = '00:00:00';
            $model_attendance->night_shift_overtime='00:00:00';
        }
        $model_attendance->branch_or_sponsor_id = $model_employee->branch_or_sponsor_id;
        $model_attendance->attendance_date = $punch_date;
        $model_attendance->week_day = $day[$weekvalue];
        $model_attendance->attendance_via = 'E';
        $model_attendance->save();
        //Saving to Punch History
        $punch_status='I';
        $sql_query= "Select * from erp_hr_attendance_punch_history where attendance_date='".$punch_date."' and employee_id='".$employee_id."' ORDER BY punch_time DESC";
        $model_attendance_puched = Yii::app()->db->createCommand($sql_query)->queryAll();
        $sql_query= "Select * from hr_attendance where employee_id='".$model_employee->employee_biometric_code."' AND DATE(punch_date)='".$punch_date."' AND (device_serial='AEWU200260017' OR device_serial='AEWU193960024') ORDER BY punch_date desc";
        $zk_status_details = Yii::app()->db2->createCommand($sql_query)->queryAll();
        $out_time=$out_time_sw='00:00';
        if(!empty($zk_status_details)){
            $out_time=date("H:i",strtotime($zk_status_details[0]['punch_date']));//ZK
        }
        if(!empty($model_attendance_puched)){
            $out_time_sw=date("H:i",strtotime($model_attendance_puched[0]['punch_time']));//Software
        }
        if($out_time!='00:00' && $out_time_sw!='00:00' && strtotime($out_time)>strtotime($out_time_sw)){
            if($zk_status_details[0]['device_serial']=='AEWU200260017'){
                $punch_status='I';
            }else {
                $punch_status='O';
            }
        }else if($out_time!='00:00' && $out_time_sw!='00:00' && strtotime($out_time_sw)>strtotime($out_time)){
            if($model_attendance_puched[0]['punch_status']=='I'){
                $punch_status='O';
            }else if($model_attendance_puched[0]['punch_status']=='O'){
                $punch_status='I';
            }
        }else if($out_time!='00:00'){
            if($zk_status_details[0]['device_serial']=='AEWU200260017'){
                $punch_status='I';
            }else {
                $punch_status='O';
            }
        }else if($out_time!='00:00'){
            if($model_attendance_puched[0]['punch_status']=='I'){
                $punch_status='O';
            }else if($model_attendance_puched[0]['punch_status']=='O'){
                $punch_status='I';
            }
        }
        $model_punch_history= new HrAttendancePunchHistory();                          
        $model_punch_history->employee_id   = $employee_id;
        $model_punch_history->attendance_date     = $punch_date;
        $model_punch_history->punch_time=$punch_time; 
        $model_punch_history->punch_status=$punch_status; 
        $model_punch_history->created_by = Yii::app()->user->id;
        $model_punch_history->created_date_time = date('Y-m-d H:i:s');
        $model_punch_history->save();
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    //Morning Late-Start
    function morninglate($employee_id,$date,$login_time){
        $model_general_settings = HrGenerelSettings::model()->find();
        $cool_off_time=$model_general_settings->cool_off_time;
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue+=1;
        $weektype='';
        $weekend=0;

        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off3_type;
        }
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
        if(!empty($model_shift) && $model_shift->shift_id>0){
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
        }else if($weekend==1 && $weektype=='H'){
            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
        }else{
            $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
        }
        $mor_late= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $weektype!='F' && empty($model_holiday)){
            $from_time      = strtotime($login_time);
            $secs = strtotime($cool_off_time)-strtotime("00:00:00");
            $morning_start = date("H:i",strtotime($original_start_time)+$secs);
            $morning_shift_in_time  = strtotime($morning_start);
            $shift_in_time  = strtotime($original_start_time);
            $time_diff      = $from_time - $shift_in_time;
            if($morning_shift_in_time >=$from_time){
                $mor_late = '00:00';
            }else{              
                $mor_late = gmdate('H:i', $time_diff);
            }
        }
        return $mor_late;
    }
    //Morning Late-End
    //Total Working -Start
    function totalworking($employee_id,$date,$login_time,$logout_time){
        $total_working= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if(!empty($model_shift) && $model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                if($model_master_shift->shift_type=='N'){
                    $diff = ($working_start_time-$working_stop_time);
                }else{
                    if($working_stop_time>$working_start_time){
                        $diff = ($working_stop_time - $working_start_time);
                    }else{
                        $diff = ($working_start_time-$working_stop_time);
                    }
                }
            }else{
                if($working_stop_time>$working_start_time){
                    $diff = ($working_stop_time - $working_start_time);
                }else{
                    $diff = ($working_start_time-$working_stop_time);
                }
            }
            $total_working = gmdate('H:i', $diff); 
        }
        return $total_working;
    }
    //Total Working -End
    //Total Time Loss Per Day -Start
    function totaltimeloss($employee_id,$date,$login_time,$logout_time){
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue+=1;
        $weektype='';
        $weekend=0;

        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours=$model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
        if(!empty($model_shift) && $model_shift->shift_id>0){
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        }else if($weekend==1 && $weektype=='H'){
            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
        }else{
            $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
        }
        
        $total_working=$total_timeloss= '00:00';
        if(empty($model_holiday)){
            if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
                $working_stop_time = strtotime($login_time);
                $working_start_time = strtotime($logout_time);
                if($working_stop_time>$working_start_time){
                    $diff = ($working_stop_time - $working_start_time);
                }else{
                    $diff = ($working_start_time-$working_stop_time);
                }
                $total_working = $this->totalworking($employee_id,$date,$login_time,$logout_time);
                if((strtotime($total_working)<strtotime($branch_working_hours)) && $weekend==0){
                    $timeloss_stop_time = strtotime($branch_working_hours);
                    $timeloss_start_time = strtotime($total_working);
                    $timeloss_diff = ($timeloss_stop_time - $timeloss_start_time);
                    $total_timeloss = gmdate('H:i', $timeloss_diff); 
                }
            }
        }
        return $total_timeloss;
    }
    //Total Time Loss Per Day -End
    //Total Excess Time Per Day -Start
    function excesstime($employee_id,$date,$login_time,$logout_time){
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekend=0;
        $weekvalue+=1;
        $weektype='';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours=$model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
        if(!empty($model_shift) && $model_shift->shift_id>0){
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        }else if($weekend==1 && $weektype=='H'){
            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
        }else{
            $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
        }
        
        $total_working=$total_excess_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            if($working_stop_time>$working_start_time){
                $diff = ($working_stop_time - $working_start_time);
            }else{
                $diff = ($working_start_time-$working_stop_time);
            }
            $total_working = $this->totalworking($employee_id,$date,$login_time,$logout_time);
            if($weekend==1 || !empty($model_holiday) && $model_holiday->id>0){
                $total_excess_time=$total_working;
            }else if(strtotime($total_working)>strtotime($branch_working_hours)){
                $stop_time = strtotime($total_working);
                $start_time = strtotime($branch_working_hours);;
                $time_excess = ($stop_time - $start_time);
                $total_excess_time = gmdate('H:i', $time_excess); 
            }
        }
        return $total_excess_time;
    }
    //Total Excess Time Per Day -End
    //Holiday Overtime Calculation Beyond Working Time-Start
    function holidayasworkingovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_holiday_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_holiday_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }
    //Holiday Overtime Calculation Beyond Working Time-End
    //Holiday Overtime Calculation Beyond Working Time-Start
    function holidayovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            $weekend=0;
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_holiday_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_holiday_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if ($diff > 0) {
                $work_time_1 = gmdate('H:i', $diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $diff);
                }
            }
        }
        return $over_time;
    }
    //Holiday Overtime Calculation Beyond Working Time-End
    //Normal Overtime Calculation-Start
    function normalovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            $weekend='';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if(!empty($model_shift) && $model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_normal_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_normal_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }
    //Normal Overtime Calculation-End
    //Weeekend Overtime Calculation-Start
    function weekendovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            $weekend=0;

            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_weekend_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_weekend_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if($weektype=='F'){
                if ($diff > 0) {
                    $work_time_1 = gmdate('H:i', $diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $diff);
                    }
                }
            }else if($weektype=='H'){
                //Original time
                $original_start_time = strtotime($original_start_time);
                $original_stop_time = strtotime($original_stop_time);
                $original_diff = ($original_stop_time - $original_start_time);
                //Difference
                $overtime_diff = $diff - $original_diff;
                if ($overtime_diff > 0) {
                    $work_time_1 = gmdate('H:i', $overtime_diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $overtime_diff);
                    }
                }
            }
        }
        return $over_time;
    }
    //Weekend Overtime Calculation-End
    //Night Shift Overtime Calculation-Start
    function nightshiftovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            $weekend=0;

            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_night_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_night_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }
    //Night Shift Overtime Calculation-End
    function decimalHours($time)
    {
        $hms = explode(":", $time);
        return ((float) $hms[0] + (float) ($hms[1]/60) + (float) ($hms[2]/3600));
    }
    function shiftdetail($employee_id,$date){
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
        $shift_id=0;
        if(!empty($model_shift) && $model_shift->id>0){
            $shift_id=$model_shift->id;
        }
        return $shift_id;
    }
    //copied by nisha on 09-03-2023
    public function actionMarkabsentDetails() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('mark_absent_details',array());
    }
    public function actionListEmployee() {
        $attendancebranch = $_POST['attendancebranch'];
        $from_date = $_POST['from_date'];
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('_employees_list', array('branch' => $attendancebranch,'date_from' => $from_date));
    }
    public function actiondeleteAttendance() {
        $model_max_date = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'isActive="Y"'));
        $payroll_enddate = date('d/m/Y', strtotime('+1 days', strtotime($model_max_date->payroll_enddate)));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('delete_attendance_form',array('payroll_enddate'=>$payroll_enddate));
}
    public function actiondeleteattendancebydate() {
        $attendancebranch = $_POST['branch'];
        $from_date = $_POST['date_delete'];
        $date_delete = date("Y-m-d", strtotime(str_replace('/', '-', $from_date)));
        $model = new EmployeeAttendance();
         $condition = 'attendance_date="' . $date_delete . '" AND status ="2"';
        if($attendancebranch!=''){
           $condition.= ' AND branch_or_sponsor_id = "'.$attendancebranch.'"';
        }
        $model = $model->findAll(array('condition' => $condition));
        if (!empty($model)) {
            $status = EmployeeAttendance::model()->deleteAll(array('condition' => $condition));
        }
        if ($status > 0) {
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionGetpayrolldatebybranch() {
        $branch_id = $_POST['branch_id'];
        if($branch_id!='')
        {
            $model_max_date = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_branch_or_sponsor_id="' . $branch_id . '"'));
        }else{
             $model_max_date = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'isActive="Y"'));
        }
        if ($model_max_date->payroll_enddate != '' && $model_max_date->payroll_enddate != '0000-00-00') {
           $payroll_date =$model_max_date->payroll_enddate; 
           $payroll_enddate = date('d/m/Y', strtotime('+1 days', strtotime($payroll_date)));
        }else{
                if($branch_id!=''){
                    $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $branch_id . '"'));
                }
                if (empty($model_lock_month)) {
                    $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="0"'));
                }
            $payroll_month = $model_lock_month->payroll_month;
            $payroll_year = $model_lock_month->payroll_year;
            $payroll_enddate = '01'. '/' .$payroll_month . '/' .$payroll_year ;
        }
        
        $jsonData['payroll_date'] = $payroll_enddate;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
}
