<?php
// created by nisha on 26-03-2023
class AppraisalemployeeController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetAppraisalList', 'Create','SaveAppraisal','deleteappraisaldetail','employeeindex',
                    'GetAppraisalEmployeeList','GetAppraisalQuestionReview','ReviewbyLm','View','PrintappraisalReportPDF','SaveAppraisalMultiple','loadmasterbranch','employeedetailbydepartment','loademployeequestions','deleteQuestion','SaveemployeeQuestions','questionapproval','SaveApprovedQuestions','appraisalCreate','getquestiondetails','SaveEmployeeAppraisal','GetApprovedquestions','employeedepartmentdetail','Getappraisaldetils'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_appraisal_questions_menu']) || Yii::app()->user->authorised_user == 1) {
            $en_id = Yii::app()->request->getParam('id');
            $branch =$this->ciphertext($en_id,"d");
            if($branch!=''){
                $model = new HrAppraisal();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index', array('model' => $model,'branch'=>$branch));
            }else{
                throw new CHttpException(404, 'Page not found.');
            }
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetAppraisalList() {
        $model = new HrAppraisal();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status  = $_POST['status'];
        $employee_id  = $_POST['employee_id'];
        $branch_id=$_POST['branch_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'departmentdetail.department_name',
            4 => 'designationdetail.designation_name',
            5 => 'employeedetail.date_join',
            6 => 'appraisal_for',
            7 => 't.created_date_time',
            8 => 'status',
            9 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "employeedetail.branch_or_sponsor_id='".$branch_id."'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if($status!=''){
            $condition.= " And status= '".$status."'";
        }else{
            $condition.= " And status IN(-3,-2,-1)";
        }
        if($employee_id>0){
             $condition.= ' and t.employee_id ="'.$employee_id.'"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employee_code LIKE '%".$searchString_en."%' OR first_name LIKE '%".$searchString_en."%' OR middle_name LIKE '%".$searchString_en."%' OR last_name LIKE '%".$searchString_en."%' OR appraisal_for LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail','employeedetail.departmentdetail','employeedetail.designationdetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail','employeedetail.departmentdetail','employeedetail.designationdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'order' => $orderBy));        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string="";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=0;
            $final_level='N';
            if($row->status==-1){
                    $show_approve_button=1;
                    $level_no=0;
                }
            if($next_approval_level==0){
                $final_level='Y';
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_questions_edit'])  || Yii::app()->user->authorised_user == 1) && $row['status']==-3) {
              //  $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/appraisalemployee/create&id=' . $row['id'] . '\',\'Edit Appraisal Questions \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_questions_delete'])  || Yii::app()->user->authorised_user == 1) && $row['status']==-3) {
                $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteappraisaldetail(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_questions_view'])  || Yii::app()->user->authorised_user == 1) && $row['status']!=-3) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'hr/appraisalemployee/view&id=' . $row['id'] . '\',\'View Appraisal Objectives \',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            // if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_print'])  || Yii::app()->user->authorised_user == 1) && $row['status']==-1) {
            //     $button_string .= '<a class="btn btn-primary btn-xs" title="Print Appraisal Details" target="_blank" href="?r=hr/appraisalemployee/PrintappraisalReportPDF&id=' . $row['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            // }
            $joining_date = "";
            if ($row['employeedetail']['date_join'] != '' && $row['employeedetail']['date_join'] != '0000-00-00') {
                $joining_date = date("d/m/Y", strtotime($row['employeedetail']['date_join']));
            }
            $created_date = "";
            if ($row['created_date_time'] != '' && $row['created_date_time'] != '0000-00-00') {
                $created_date = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $rowData[] = array($m,$row['employeedetail']['employeecode'],$row['employeedetail']['employeefullname'], $row['employeedetail']['departmentdetail']['department_name'], $row['employeedetail']['designationdetail']['designation_name'], $joining_date, $row['appraisal_for'], $created_date, HrAppraisal::getstatus($row['status']), $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $branch=(int) Yii::app()->request->getParam('branch');
        $model = new HrAppraisal();
        $model_analysis=array(new HrAppraisalAnalysis()); 
        $model_type=array(new HrAppraisalType()); 

        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            $model_type= HrAppraisalType::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            if(empty($model_analysis)){
                $model_analysis=array(new HrAppraisalAnalysis()); 
            }
            if(empty($model_type)){
                $model_type=array(new HrAppraisalType()); 
            }
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'model_analysis' => $model_analysis,'model_Type'=>$model_type,'model_settings'=>$model_settings,'branch'=>$branch), false, true);
    }
    
     public function actionGetquestionDetails() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_questions= HrAppraisalQuestions::model()->findAll(array('condition' => 'appraisal_type="'. $id.'"'));
        $arr_type= HrAppraisalQuestions::model()->findAll(array('select'=>'t.appraisal_type','condition' => 'appraisal_type="'. $id.'"','group'=>'t.appraisal_type'));
        $model_analysis=new HrAppraisalAnalysis(); 
        $model_settings = HrGenerelSettings::model()->find();
        $model_Type=new HrAppraisalType();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('appraisal_questions', array('model_questions' => $model_questions,'model_type'=>$arr_type,'model_analysis' => $model_analysis,'model_Type'=>$model_Type,'model_settings'=>$model_settings), false, true);
    }
    public function actionSaveAppraisal() {
        $other=array();$groups = array();$analysis_ids=array();$type_ids=array();
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            if ($_POST['HrAppraisal']['id'] > 0) {
                $id = (int) $_POST['HrAppraisal']['id'];
                $model = $model->findByPk($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['HrAppraisal'];
            $model->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
            $model->status =1;
            $employee_id=$_POST['HrAppraisal']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
            $model->function_type =$model_master_approve_setting->id;
            $model->last_approved_level =-2;
            $valid=$model->validate();
            //Adding Analysis Data
            if (isset($_POST['HrAppraisalAnalysis'])){
                $i=0;
                foreach ($_POST['HrAppraisalAnalysis'] as $m => $items) {
                    if($items['question_id']!=''){
                        if($items['id']>0){
                            $model_analysis[$i] = HrAppraisalAnalysis::model()->findByPK($items['id']); 
                            $model_analysis[$i]->updated_by= Yii::app()->user->id;
                            $model_analysis[$i]->updated_date_time = date('Y-m-d H:i:s');
                            $analysis_ids[]=$items['id'];
                        }else{
                            $model_analysis[$i] = new HrAppraisalAnalysis(); 
                            $model_analysis[$i]->created_by= Yii::app()->user->id;
                            $model_analysis[$i]->created_date_time = date('Y-m-d H:i:s');
                        }   
                        $model_analysis[$i]->appraisal_type = $items['appraisal_type'];
                        $model_analysis[$i]->question_weightage = $items['question_weightage'];
                        $model_analysis[$i]->question_id = $items['question_id'];
                        $model_analysis[$i]->question = $items['question'];
                        $key = $items['appraisal_type'];
                        if (!array_key_exists($key, $groups)) {
                            $groups[$key] = array(
                            'id' => $items['appraisal_type'],
                            'total_weightage' => $items['question_weightage'],
                            );
                        } 
                        else 
                        {
                            $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['question_weightage'];
                        } 
                        $valid=$model_analysis[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //weightage percent on 100 
            if(!empty($groups))
            {
                foreach($groups as $key=>$eachType)  
                {
                    $mas_type=HrMasAppraisalType::model()->findByPk($key);
                    if($eachType['total_weightage']!=100){
                        $other[]=$mas_type->appraisal_type.' should have maximum weightage 100. Now its '.(floatval($eachType['total_weightage']));
                        $valid=false;                        
                    }
                }  
            }
            if (isset($_POST['HrAppraisalType'])){
                $i=0;$total_weightage=0;
                foreach ($_POST['HrAppraisalType'] as $m => $itemtype) {
                    if($itemtype['id']>0){
                        $model_HrAppraisalType[$i] = HrAppraisalType::model()->findByPK($itemtype['id']); 
                        $model_HrAppraisalType[$i]->updated_by= Yii::app()->user->id;
                        $model_HrAppraisalType[$i]->updated_date_time = date('Y-m-d H:i:s');
                        $type_ids[]=$itemtype['id'];
                    }else{
                        $model_HrAppraisalType[$i] = new HrAppraisalType(); 
                        $model_HrAppraisalType[$i]->created_by= Yii::app()->user->id;
                        $model_HrAppraisalType[$i]->created_date_time = date('Y-m-d H:i:s');
                    }   
                    $model_HrAppraisalType[$i]->type_id = $itemtype['type_id'];
                    $model_HrAppraisalType[$i]->weightage = $itemtype['weightage'];  
                    $total_weightage+=$itemtype['weightage']; 
                    $model_HrAppraisalType[$i]->appraisal_id=0;
                    $valid=$model_HrAppraisalType[$i]->validate() && $valid;
                    $i++;
                }
                
            }
            if($total_weightage!=100){
                $other[]='Sum of Weightage of Appraisal Type should be 100. Now its '.(floatval($total_weightage));
                $valid=false;
            }
            //End Analysis Data
            if ($valid) {
                if(!empty($analysis_ids)){
                    HrAppraisalAnalysis::model()->deleteAll('appraisal_id='.$model->id.' AND id NOT IN ('.  implode(',', $analysis_ids).')');
                }
                if(!empty($type_ids)){
                    HrAppraisalType::model()->deleteAll('appraisal_id='.$model->id.' AND id NOT IN ('.  implode(',', $type_ids).')');
                }
                $model->save();
                //Save Analysis
                if (!empty($model_analysis)) {
                    foreach ($model_analysis as $eachModel) {
                        $eachModel->appraisal_id = $model->id;
                        $eachModel->save();

                    }
                }
                if (!empty($model_HrAppraisalType)) {
                    foreach ($model_HrAppraisalType as $eachModel) {
                        $eachModel->appraisal_id = $model->id;
                        $eachModel->save();

                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_analysis[0]->question_id!=''){
                   $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }else{
                    $error2[] ='Please add atleast one question';
                }
                $error3 = json_decode(CActiveForm::validateTabular($model_HrAppraisalType, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$error3,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actiondeleteappraisaldetail() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model =HrAppraisal::model()->findByPk($id);
            if($model->id){
                HrAppraisalAnalysis::model()->deleteAll('appraisal_id=:refer_id', array(':refer_id' => $model->id));
                $model_analysis_exist= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $model->id.'"'));
                if(empty($model_analysis_exist)){
                    HrAppraisal::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                }else{
                    $jsonData['status'] = 'error';
                }
            }else{
                $jsonData['status'] = 'error';
            }
        } else {
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    
    public function actionemployeeindex() {
        $this->layout = 'main';
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('employee_index');
    }

    public function actionView() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrAppraisal();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view', array('model' => $model,'model_analysis' => $model_analysis,'model_settings'=>$model_settings), false, true);
    }
    public function actionPrintappraisalReportPDF() {
        $id = $_GET['id'];
        $model_settings = HrGenerelSettings::model()->find();
        $model =HrAppraisal::model()->findByPk($id);
        $model_analysis= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.appraisal.pdf_appraisal', array('model' => $model,'model_settings' => $model_settings, 'id' => $id,'model_analysis'=>$model_analysis), true));
        $mPDF1->Output('appraisal_details.pdf', 'I');
    }
    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch', array());
    }
 public function actionemployeedetailbydepartment() {
        //copied from reports -updated by nisha  on 24-03-2023
       $department_id = $_POST['department_id'];
       $field_name = $_POST['field_name'];
        $branch_id = $_POST['branch_id'];           
       $sql = "SELECT id, first_name,last_name,employee_code FROM erp_hr_employee WHERE isActive!='B'";
        if ($department_id != "") {
            $sql.= " AND department ='" . $department_id."'";
        }
        if ($branch_id != "") {
            $sql.= " AND branch_or_sponsor_id ='" . $branch_id."'";
        }
        $model = Yii::app()->db->createCommand($sql)->queryAll();
        $arr_employee = array();
        $employee_details = array();
        if(!empty($model)){
            foreach ($model as $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d"). '-' . Yii::app()->controller->ciphertext($value['employee_code'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
        }
       $dropdownlist=CHtml::dropdownlist($field_name,'',CHtml::listData($employee_details, 'id', 'name'), array('class' => 'tooltipster', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'onchange'=>'getQuestions();', 'data-search' => true,'multiple'=>true));
       $jsonData['employee'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }

     public function actionemployeedepartmentdetail() {
        //copied from reports -updated by nisha  on 24-03-2023
       $department_id = $_POST['department_id'];
       $field_name = $_POST['field_name'];
       $branch_id = $_POST['branch'];    
       $sql = "SELECT id, first_name,last_name,employee_code FROM erp_hr_employee WHERE isActive!='B'";
        if ($department_id != "") {
            $sql.= " AND department ='" . $department_id."'";
        }
        if ($branch_id != "") {
            $sql.= " AND branch_or_sponsor_id ='" . $branch_id."'";
        }
        $model = Yii::app()->db->createCommand($sql)->queryAll();
        $arr_employee = array();
        $employee_details = array();
        if(!empty($model)){
            foreach ($model as $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d"). '-' . Yii::app()->controller->ciphertext($value['employee_code'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
        }
       $dropdownlist=CHtml::dropdownlist($field_name,'',CHtml::listData($employee_details, 'id', 'name'), array('class' => 'tooltipster', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true,'multiple'=>true));
       $jsonData['employee'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
public function actionSaveAppraisalMultiple() {
        $other=array();$groups = array();$analysis_ids=array();$type_ids=array();$employees=array();
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            $employees = $_POST['HrAppraisal']['employee_id'];
            $model->created_by= Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->attributes = $_POST['HrAppraisal'];
            $model->employee_id=$employees[0];
            $model->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
            $model->status =1;
            $employee_id=$employees[0];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
            $model->function_type ='';
            if(!empty($model_master_approve_setting )){
                $model->function_type =$model_master_approve_setting->id;
            }
            $model->last_approved_level =-2;
            $valid=$model->validate();
            $model_type= HrMasAppraisalType::model()->findAll();
            //Adding Analysis Data
            if (!empty($model_type)){
                $i=0;
                foreach ($model_type as $k=>$type) {
                    $model_analysis_data= HrAppraisalQuestions::model()->findAll(array('condition' => 'appraisal_type="'. $type->id.'"'));
                    if(!empty($model_analysis_data)){
                        foreach ($model_analysis_data as $m => $items) {
                        if($items['id']>0){
                        $model_analysis[$i] = new HrAppraisalAnalysis(); 
                        $model_analysis[$i]->created_by= Yii::app()->user->id;
                        $model_analysis[$i]->created_date_time = date('Y-m-d H:i:s');
                        $model_analysis[$i]->appraisal_type = $items['appraisal_type'];
                        $model_analysis[$i]->question_weightage = $items['weightage_percent'];
                        $model_analysis[$i]->question_id = $items['id'];
                        $model_analysis[$i]->question = $items['question'];
                        $key = $items['appraisal_type'];
                        if (!array_key_exists($key, $groups)) {
                            $groups[$key] = array(
                            'id' => $items['appraisal_type'],
                            'total_weightage' => $items['weightage_percent'],
                            );
                        } 
                        else 
                        {
                            $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['weightage_percent'];
                        } 
                        $valid=$model_analysis[$i]->validate() && $valid;
                        $i++;
                         }
                    }
                }
            }
        }
            //weightage percent on 100 
            if(!empty($groups))
            {
                foreach($groups as $key=>$eachType)  
                {
                    $mas_type=HrMasAppraisalType::model()->findByPk($key);
                    if($eachType['total_weightage']!=100){
                        $other[]=$mas_type->appraisal_type.' should have maximum weightage 100. Now its '.(floatval($eachType['total_weightage']));
                        $valid=false;                        
                    }
                }  
            }

             if (!empty($model_type)){
                $j=0;$total_weightage=0;
                foreach ($model_type as $n => $itemtype) {
                    $model_HrAppraisalType[$j] = new HrAppraisalType(); 
                    $model_HrAppraisalType[$j]->created_by= Yii::app()->user->id;
                    $model_HrAppraisalType[$j]->created_date_time = date('Y-m-d H:i:s');
                    $model_HrAppraisalType[$j]->type_id = $itemtype['id'];
                    $model_HrAppraisalType[$j]->weightage = 0;  
                    $model_HrAppraisalType[$j]->appraisal_id=0;
                    $valid=$model_HrAppraisalType[$j]->validate() && $valid;
                    $j++;
                }
                
            }
           
            // if ($model_analysis[0]->question_id==''){
            //     $valid=false;
            // }
            //End Analysis Data
            if ($valid) {
                for($i=0;$i<count($employees);$i++){
                    $modelAppraisal = new HrAppraisal();
                    $modelAppraisal->created_by= Yii::app()->user->id;
                    $modelAppraisal->created_date_time = date('Y-m-d H:i:s');
                    $modelAppraisal->appraisal_for = trim($_POST['HrAppraisal']['appraisal_for']);
                    $modelAppraisal->employee_id=$employees[$i];
                    $employee_id=$employees[$i];
                    $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
                    if(!empty($model_master_approve_setting)){
                    $modelAppraisal->function_type =$model_master_approve_setting->id;
                    }
                    $modelAppraisal->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
                    $modelAppraisal->status =-3;
                    $modelAppraisal->last_approved_level =-1;
                    $modelAppraisal->department_id =$_POST['HrAppraisal']['department_id'];;
                    $modelAppraisal->save();
                    $app_id= $modelAppraisal->id;
                    $jsonData['app_id_'.$i] = $app_id;
                    //Save Analysis
                    if (!empty($model_analysis)) {
                        foreach ($model_analysis as $eachanalysisModel) {
                            $each_analysis= new HrAppraisalAnalysis();
                            $each_analysis->attributes =$eachanalysisModel->attributes;
                            $each_analysis->appraisal_id = $app_id;
                            $each_analysis->save();
                        }
                    }
                    if (!empty($model_HrAppraisalType)) {
                        foreach ($model_HrAppraisalType as $eachModel) {
                            $eachtype= new HrAppraisalType();
                            $eachtype->attributes =$eachModel->attributes;
                            $eachtype->appraisal_id = $app_id;
                            $eachtype->save();

                        }
                    }
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="32"'));
                    if(!empty($model_settings) && !empty($model_mail_settings)){
                        if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                             Yii::import('application.modules.hr.controllers.MailController'); 
                             MailController::sendmail(32,$modelAppraisal->employee_id,$modelAppraisal->id);
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if(!empty($model_analysis[0]->question_id)){
                   $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionloademployeequestions() {
        $model_analysis=new HrAppraisalAnalysis(); 
        $model_type=new HrAppraisalType(); 
        $modelemployee = User::model()->findByPK(Yii::app()->user->id);
        $employee_id = $modelemployee->employee_id;
        $model= HrAppraisal::model()->find(array('condition' => 'employee_id="'. $employee_id.'" AND status="-3"'));  
        if (!empty($model)) {
            $id= $model->id;
            $model_analysis= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            $model_type= HrAppraisalType::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            if(empty($model_analysis)){
                $model_analysis=array(new HrAppraisalAnalysis()); 
            }
            if(empty($model_type)){
                $model_type=array(new HrAppraisalType()); 
            }
        }else{
            $model = new HrAppraisal();
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('employee_questions', array('model' => $model,'model_analysis' => $model_analysis,'model_Type'=>$model_type,'model_settings'=>$model_settings), false, true);
    }

     
     public function actiondeleteQuestion(){
        $id = $_POST['id'];
        if($id>0){
            $model = new HrAppraisalAnalysis();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionSaveemployeeQuestions() {
        //save questions from employee portal
        $other=array();$groups = array();$analysis_ids=array();$type_ids=array();
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            if ($_POST['HrAppraisal']['id'] > 0) {
                $id = (int) $_POST['HrAppraisal']['id'];
                $model = $model->findByPk($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $employee_id = $modelemployee->employee_id;
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
            if(!empty($model_master_approve_setting))
            {
            $model->function_type =$model_master_approve_setting->id;
            }
            $model->last_approved_level =-1;
            $model->appraisal_for = $_POST['HrAppraisal']['appraisal_for'];
            $model->employee_id=$employee_id;

            if($_POST['flag_status']==1){
                $model->status =-2;
            }else{
                $model->status =-3;
            } 

            $valid=$model->validate();
            //Adding Analysis Data
            if (isset($_POST['HrAppraisalAnalysis'])){
                $i=0;
                foreach ($_POST['HrAppraisalAnalysis'] as $m => $items) {
                        if($items['id']>0){
                            $model_analysis[$i] = HrAppraisalAnalysis::model()->findByPK($items['id']); 
                            $model_analysis[$i]->updated_by= Yii::app()->user->id;
                            $model_analysis[$i]->updated_date_time = date('Y-m-d H:i:s');
                            $analysis_ids[]=$items['id'];
                        }else{
                            $model_analysis[$i] = new HrAppraisalAnalysis(); 
                            $model_analysis[$i]->created_by= Yii::app()->user->id;
                            $model_analysis[$i]->created_date_time = date('Y-m-d H:i:s');
                        }   
                        $model_analysis[$i]->appraisal_type = $items['appraisal_type'];
                        $model_analysis[$i]->question_weightage = $items['question_weightage'];
                        $model_analysis[$i]->question_id = $items['question_id'];
                        $model_analysis[$i]->question = $items['question'];
                        $key = $items['appraisal_type'];
                        if (!array_key_exists($key, $groups)) {
                            $groups[$key] = array(
                            'type'=>'no-grade',
                            'id' => $items['appraisal_type'],
                            'total_weightage' => $items['question_weightage'],
                            );
                        } 
                        else 
                        {
                            $groups[$key]['type'] =$items['question_weightage'];
                            $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['question_weightage'];
                        } 
                        $valid=$model_analysis[$i]->validate() && $valid;
                        $i++;
                }
            }
            //weightage percent on 100 
            if(!empty($groups))
            {
                foreach($groups as $key=>$eachType)  
                {
                    $mas_type=HrMasAppraisalType::model()->findByPk($key);
                    if(!empty($mas_type)){
                        if($eachType['total_weightage']!=100){
                            $other[]=$mas_type->appraisal_type.' should have maximum weightage 100. Now its '.(floatval($eachType['total_weightage']));
                            $valid=false;                        
                        }
                    }
                }  
            }
          
            //End Analysis Data
            if ($valid) {
                $model->save();
                //Save Analysis
                if (!empty($model_analysis)) {
                    foreach ($model_analysis as $eachModel) {
                        $eachModel->appraisal_id = $model->id;
                        $eachModel->save();

                    }
                }
                //Updating Appraisal Type Table
                HrAppraisalType::model()->deleteAll(array('condition'=>'appraisal_id="'.$model->id.'"'));
                $model_analysis_type = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'.$model->id.'"','group'=>'appraisal_type'));
                if(!empty($model_analysis_type)){
                    $type_count=count($model_analysis_type);
                    foreach ($model_analysis_type as $key => $value) {
                        $model_HrAppraisalType= new HrAppraisalType(); 
                        $model_HrAppraisalType->created_by= Yii::app()->user->id;
                        $model_HrAppraisalType->created_date_time = date('Y-m-d H:i:s');
                        $model_HrAppraisalType->type_id = $value->appraisal_type;
                        $model_HrAppraisalType->weightage = round(100/$type_count);  
                        $model_HrAppraisalType->appraisal_id=$model->id;
                        $model_HrAppraisalType->save();
                    }
                }

                //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="33"'));
                    if(!empty($model_settings) && !empty($model_mail_settings)){
                        if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                             Yii::import('application.modules.hr.controllers.MailController'); 
                             MailController::sendmail(33,$modelAppraisal->employee_id,$modelAppraisal->id);
                        }
                    }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {

                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_analysis[0]->question!=''){
                   $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }else{
                    $error2[] ='Please add atleast one question';
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionquestionapproval()
    {

        $this->layout = "main";

        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);

        $this->render('questions_approval');
    }

    public function actionGetAppraisalQuestionReview() {
        $model = new HrAppraisal();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'departmentdetail.department_name',
            4 => 'designationdetail.designation_name',
            5 => 'employeedetail.date_join',
            6 => 'appraisal_for',
            7 => 't.created_date_time',
            8 => 'status',
            9 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $modelemployee = User::model()->findByPK(Yii::app()->user->id);
        $employee_id = $modelemployee->employee_id;
        $condition = 'employeedetail.isActive="Y"  AND t.status="-2" AND employeedetail.reporting_manager ="'. $employee_id.'"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employee_code LIKE '%".$searchString_en."%' OR first_name LIKE '%".$searchString_en."%' OR middle_name LIKE '%".$searchString_en."%' OR last_name LIKE '%".$searchString_en."%' OR appraisal_for LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail','employeedetail.departmentdetail','employeedetail.designationdetail','approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail','employeedetail.departmentdetail','employeedetail.designationdetail','approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=-1;
            $final_level='N';
            $button_string.= '<button class="btn btn-primary btn-xs" title="Appraisal Review" onclick="loadPopupModal(\'hr/appraisalemployee/reviewbylm&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Appraisal Review\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';           
            $joining_date = "";
            if ($row['employeedetail']['date_join'] != '' && $row['employeedetail']['date_join'] != '0000-00-00') {
                $joining_date = date("d/m/Y", strtotime($row['employeedetail']['date_join']));
            }
            $created_date = "";
            if ($row['created_date_time'] != '' && $row['created_date_time'] != '0000-00-00') {
                $created_date = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $rowData[] = array($m,$row['employeedetail']['employeecode'],$row['employeedetail']['employeefullname'], $row['employeedetail']['departmentdetail']['department_name'], $row['employeedetail']['designationdetail']['designation_name'], $joining_date, $row['appraisal_for'], $created_date, HrAppraisal::getstatus($row['status']), $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionReviewbyLm() {
        $id = (int) Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = new HrAppraisal();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('lm_approval', array('model' => $model,'model_analysis' => $model_analysis,'model_settings'=>$model_settings,'level'=>$level,'final_level'=>$final_level), false, true);
    }
     public function actionSaveApprovedQuestions_old() {
        //approved questions by line manager
        $other=array();$groups = array();$analysis_ids=array();$type_ids=array();
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            if ($_POST['HrAppraisal']['id'] > 0) {
                $id = (int) $_POST['HrAppraisal']['id'];
                $model = $model->findByPk($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $employee_id = $modelemployee->employee_id;
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
           // $model->function_type =$model_master_approve_setting->id;
            $model->last_approved_level =-1;
            $model->appraisal_for = trim($_POST['HrAppraisal']['appraisal_for']);
            $model->employee_id=$_POST['HrAppraisal']['employee_id'];
            $model->department_id=$_POST['HrAppraisal']['department_id'];
            $model->approve_question_level1_id=$employee_id;
            $model->status=$_POST['HrAppraisal']['status'];
            $model->revert_comment=$_POST['HrAppraisal']['revert_comment'];

            $valid=$model->validate();
            //Adding Analysis Data
            if (isset($_POST['HrAppraisalAnalysis'])){
                $i=0;
                foreach ($_POST['HrAppraisalAnalysis'] as $m => $items) {
                        if($items['id']>0){
                            $model_analysis[$i] = HrAppraisalAnalysis::model()->findByPK($items['id']); 
                            $model_analysis[$i]->updated_by= Yii::app()->user->id;
                            $model_analysis[$i]->updated_date_time = date('Y-m-d H:i:s');
                            $analysis_ids[]=$items['id'];
                        }else{
                            $model_analysis[$i] = new HrAppraisalAnalysis(); 
                            $model_analysis[$i]->created_by= Yii::app()->user->id;
                            $model_analysis[$i]->created_date_time = date('Y-m-d H:i:s');
                        }   
                        $model_analysis[$i]->appraisal_type = $items['appraisal_type'];
                        $model_analysis[$i]->question_weightage = $items['question_weightage'];
                        $model_analysis[$i]->question_id = $items['question_id'];
                        $model_analysis[$i]->question = $items['question'];
                        $key = $items['appraisal_type'];
                        if (!array_key_exists($key, $groups)) {
                            $groups[$key] = array(
                            'type'=>'no-grade',
                            'id' => $items['appraisal_type'],
                            'total_weightage' => $items['question_weightage'],
                            );
                        } 
                        else 
                        {
                            $groups[$key]['type'] =$items['question_weightage'];
                            $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['question_weightage'];
                        } 
                        $valid=$model_analysis[$i]->validate() && $valid;
                        $i++;
                }
            }
            //weightage percent on 100 
            if(!empty($groups))
            {
                foreach($groups as $key=>$eachType)  
                {
                    $mas_type=HrMasAppraisalType::model()->findByPk($key);
                    if($eachType['total_weightage']!=100){
                        $other[]=$mas_type->appraisal_type.' should have maximum weightage 100. Now its '.(floatval($eachType['total_weightage']));
                        $valid=false;                        
                    }
                }  
            }
          
            //End Analysis Data
            if ($valid) {
               
               if(!empty($analysis_ids)){
                    HrAppraisalAnalysis::model()->deleteAll('appraisal_id='.$model->id.' AND id NOT IN ('.  implode(',', $analysis_ids).')');
                }
                if(!empty($type_ids)){
                    HrAppraisalType::model()->deleteAll('appraisal_id='.$model->id.' AND id NOT IN ('.  implode(',', $type_ids).')');
                }
                $model->save();
                //Save Analysis
                if (!empty($model_analysis)) {
                    foreach ($model_analysis as $eachModel) {
                        $eachModel->appraisal_id = $model->id;
                        $eachModel->save();

                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {

                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_analysis[0]->question_id!=''){
                   $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }else{
                    $error2[] ='Please add atleast one question';
                }
                $error = CJSON::encode(array_merge_recursive($error1,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

     public function actionSaveApprovedQuestions() {
        //approved questions by line manager
        $other=array();$groups = array();$analysis_ids=array();$type_ids=array();
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            if ($_POST['HrAppraisal']['id'] > 0) {
                $id = (int) $_POST['HrAppraisal']['id'];
                $model = $model->findByPk($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $employee_id = $modelemployee->employee_id;
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
           // $model->function_type =$model_master_approve_setting->id;
            $model->last_approved_level =-1;
            $model->appraisal_for = trim($_POST['HrAppraisal']['appraisal_for']);
            $model->employee_id=$_POST['HrAppraisal']['employee_id'];
            $model->department_id=$_POST['HrAppraisal']['department_id'];
            $model->approve_question_level1_id=$employee_id;
            $model->status=$_POST['HrAppraisal']['status'];
            $model->revert_comment=$_POST['HrAppraisal']['revert_comment']." ". $_POST['reason'];
            $valid=$model->validate();
            if ($valid) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {

                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }


    private  function getPendingapprovaladmin($branch, $from) {
        $condition = '1=1';
        if ($branch > 0) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        $model_details = HrAppraisal::model()->with('employeedetail')->findAll(array('condition' => $condition));
        $arr_id = array();
        $appraisal_id = 0;
        foreach ($model_details as $key => $value) {
                $last_approved_level = $value->last_approved_level;
                $next_approval_level = $last_approved_level + 1;
                if ($value->status == -1) {
                        $arr_id[] = $value->id;
                }
        }
        if (!empty($arr_id)) {
            $appraisal_id = implode(',', $arr_id);
        }
        if ($from == 1) {
            return $appraisal_id;
        } else if ($from == 2) {
            return count($arr_id);
        }
    }

    public function actionappraisalCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $branch=(int) Yii::app()->request->getParam('branch');
        $model = new HrAppraisal();
        $model_analysis=array(new HrAppraisalAnalysis()); 
        $model_type=array(new HrAppraisalType()); 
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            $model_type= HrAppraisalType::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            if(empty($model_analysis)){
                $model_analysis=array(new HrAppraisalAnalysis()); 
            }
            if(empty($model_type)){
                $model_type=array(new HrAppraisalType()); 
            }
        }
            $model_questions= HrAppraisalQuestions::model()->findAll();
        
    
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('appraisal_create', array('model' => $model,'model_analysis' => $model_analysis,'model_Type'=>$model_type,'model_settings'=>$model_settings,'branch'=>$branch,'model_questions'=>$model_questions), false, true);
    }
    
   public function actionSaveEmployeeAppraisal_old() {
        if (isset($_POST['HrAppraisal'])) {
            $valid=true;
            $other=array();$groups = array();
            $employees = $_POST['HrAppraisal']['employee_id'];
            for($i=0;$i<count($employees);$i++){
                $groups = array();
                    $model_appraisal_details = HrAppraisal::model()->find(array('condition' => 'employee_id="'. $employees[$i].'" AND appraisal_for="'.$_POST['HrAppraisal']['appraisal_for'].'"'));
                    if(empty($model_appraisal_details)){
                        $modelAppraisal[$i] = new HrAppraisal();
                        $modelAppraisal[$i]->created_by= Yii::app()->user->id;
                        $modelAppraisal[$i]->created_date_time = date('Y-m-d H:i:s');
                    }else{
                        $modelAppraisal[$i] =HrAppraisal::model()->findByPk($model_appraisal_details->id);
                        $modelAppraisal[$i]->updated_by= Yii::app()->user->id;
                        $modelAppraisal[$i]->updated_date_time = date('Y-m-d H:i:s');
                        $modelAppraisal[$i]->id=$model_appraisal_details->id;
                        $appraisal_id = $model_appraisal_details->id;
                    }
                    $modelAppraisal[$i]->appraisal_for = $_POST['HrAppraisal']['appraisal_for'];
                    $modelAppraisal[$i]->employee_id=$employees[$i];
                    $employee_id=$employees[$i];
                    $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
                    $modelAppraisal[$i]->function_type =$model_master_approve_setting->id;
                    $modelAppraisal[$i]->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
                      $modelAppraisal[$i]->department_id = $_POST['HrAppraisal']['department_id'];
                    $modelAppraisal[$i]->status =1;
                    $modelAppraisal[$i]->last_approved_level =0;
                    $valid=$modelAppraisal[$i]->validate() && $valid;

                    if($appraisal_id >0){
                        $model_analysis_data = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $appraisal_id.'"'));
//                        $model_type= HrMasAppraisalType::model()->findAll(array('condition' => 'appraisal_id="'. $appraisal_id.'"'));  
                    }
                    if(empty($model_analysis_data)){
                    //Adding Analysis Data
                    if (isset($_POST['HrAppraisalAnalysis'])){
                        $l=0;
                        foreach ($_POST['HrAppraisalAnalysis'] as $m => $items) {
                            if($items['question']>0){
                                $model_analysis[$l] = new HrAppraisalAnalysis(); 
                                $model_analysis[$l]->created_by= Yii::app()->user->id;
                                $model_analysis[$l]->created_date_time = date('Y-m-d H:i:s');
                                $model_analysis[$l]->appraisal_type = $items['appraisal_type'];
                                $model_analysis[$l]->question_weightage = $items['question_weightage'];
                                $model_analysis[$l]->question_id = $items['question_id'];
                                $model_analysis[$l]->question = $items['question'];
                                $key = $items['appraisal_type'];
                                $model_HrAppraisalType[$l] = HrAppraisalType::findByPk($items['appraisal_type']); 
                                if(empty($model_HrAppraisalType[$l])){
                                   $model_HrAppraisalType[$l] = new HrAppraisalType(); 
                                   $model_HrAppraisalType[$l]->created_by= Yii::app()->user->id;
                                    $model_HrAppraisalType[$l]->created_date_time = date('Y-m-d H:i:s');
                                    $model_HrAppraisalType[$l]->type_id = $items['appraisal_type'];
                                    $model_HrAppraisalType[$l]->weightage = 0;  
                                    $model_HrAppraisalType[$l]->appraisal_id=0; 
                                }
                                if (!array_key_exists($key, $groups)) {
                                    $groups[$key] = array(
                                    'id' => $items['appraisal_type'],
                                    'total_weightage' => $items['question_weightage'],
                                    );
                                } 
                                else 
                                {
                                    $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['question_weightage'];
                                } 
                                $valid=$model_analysis[$l]->validate() && $valid;
                                $l++;
                            }
                        }
                 }
             }
            
            //weightage percent on 100 
            if(!empty($groups))
            {
                foreach($groups as $key=>$eachType)  
                {
                    $mas_type=HrMasAppraisalType::model()->findByPk($key);
                    if($eachType['total_weightage']!=100){
                        $other[]=$mas_type->appraisal_type.' should have maximum weightage 100. Now its '.(floatval($eachType['total_weightage']));
                        $valid=false;                        
                    }
                }  
            }
    }

           //print_r($model_analysis); die();
            if (empty($modelAppraisal)){
                $valid=false;
            }
            if (empty($model_analysis)){
                $valid=false;
            }
            //End Analysis Data
            if ($valid) {
            foreach ($modelAppraisal as $m=>$each){
                    $each->save();
                    //Save Analysis
                    if (!empty($model_analysis)) {
                        foreach ($model_analysis as $eachanalysisModel) {
                            $each_analysis= new HrAppraisalAnalysis();
                            $each_analysis->attributes =$eachanalysisModel->attributes;
                            $each_analysis->appraisal_id = $each->id;
                            $each_analysis->save();
                        }
                    }
                    if (!empty($model_HrAppraisalType)) {
                        foreach ($model_HrAppraisalType as $eachModel) {
                            $eachtype= new HrAppraisalType();
                            $eachtype->attributes =$eachModel->attributes;
                            $eachtype->appraisal_id = $each->id;
                            $eachtype->save();
                        }
                }
                
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="23"'));
                    if(!empty($model_settings) && !empty($model_mail_settings)){
                        if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                             Yii::import('application.modules.hr.controllers.MailController'); 
                             MailController::sendmail(23,$each->employee_id,$each->id);
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1=$error2=array();
                if(!empty($modelAppraisal)){
                    $error1 = json_decode(CActiveForm::validateTabular($modelAppraisal, '', false), true);
                }
                if(!empty($model_analysis)){
                    $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }else{
                    $other[]='Please Add atleast one objective';
                }
                if(empty($modelAppraisal)){
                    $model = new HrAppraisal();
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
public function actionSaveEmployeeAppraisal() {
        $other=array();$groups = array();$analysis_ids=array();$type_ids=array();$employees=array();
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            $show_btn = $_POST['show_btn'];
            $employees = $_POST['HrAppraisal']['employee_id'];
            $model->created_by= Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->attributes = $_POST['HrAppraisal'];
            $model->employee_id=$employees[0];
            $model->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
            $model->status =1;
            $employee_id=$employees[0];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
            $settings_id='';
            if(!empty($model_master_approve_setting)){
                $settings_id= $model_master_approve_setting->id;
            }
            $model->function_type =$settings_id;
            $model->last_approved_level =-2;
            $valid=$model->validate();
            $model_type= HrMasAppraisalType::model()->findAll();
            //Adding Analysis Data
            if (isset($_POST['HrAppraisalAnalysis'])){
                $i=0;
                foreach ($_POST['HrAppraisalAnalysis'] as $m => $items) {
                    if($items['question']!=''){
                        $model_analysis[$i] = new HrAppraisalAnalysis(); 
                        $model_analysis[$i]->created_by= Yii::app()->user->id;
                        $model_analysis[$i]->created_date_time = date('Y-m-d H:i:s');
                        $model_analysis[$i]->appraisal_type = $items['appraisal_type'];
                        $model_analysis[$i]->question_weightage = $items['question_weightage'];
                        $model_analysis[$i]->question_id = $items['question_id'];
                        $model_analysis[$i]->question = $items['question'];
                        $key = $items['appraisal_type'];
                        $model_HrAppraisalType[$i] = HrAppraisalType:: model()->findByPk($items['appraisal_type']); 
                        if(empty($model_HrAppraisalType[$i])){
                                   $model_HrAppraisalType[$i] = new HrAppraisalType(); 
                                   $model_HrAppraisalType[$i]->created_by= Yii::app()->user->id;
                                    $model_HrAppraisalType[$i]->created_date_time = date('Y-m-d H:i:s');
                                    $model_HrAppraisalType[$i]->type_id = $items['appraisal_type'];
                                    $model_HrAppraisalType[$i]->weightage = 0;  
                                    $model_HrAppraisalType[$i]->appraisal_id=0; 
                        }
                        if (!array_key_exists($key, $groups)) {
                            $groups[$key] = array(
                            'id' => $items['appraisal_type'],
                            'total_weightage' => $items['question_weightage'],
                            );
                        } 
                        else 
                        {
                            $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['question_weightage'];
                        } 
                        $valid=$model_analysis[$i]->validate() && $valid;

                        $i++;
                    }
                }
            }
            //weightage percent on 100 
            if(!empty($groups))
            {
                foreach($groups as $key=>$eachType)  
                {
                    $mas_type=HrMasAppraisalType::model()->findByPk($key);
                    if($eachType['total_weightage']!=100){
                        $other[]=$mas_type->appraisal_type.' should have maximum weightage 100. Now its '.(floatval($eachType['total_weightage']));
                        $valid=false;                        
                    }
                }  
            }



            if ($show_btn ==1){
                if (!empty($model_analysis) && $model_analysis[0]->question==''){
                    $other[]= "Please Add atleast one objective";
                    $valid=false;
                }
            }
            //End Analysis Data
            if ($valid) {
                for($i=0;$i<count($employees);$i++){
                    $modelAppraisal = HrAppraisal::model()->find(array('condition' => 'employee_id="'. $employees[$i].'" AND appraisal_for="'.trim($_POST['HrAppraisal']['appraisal_for']).'"'));
                    if(empty($modelAppraisal)){
                    $modelAppraisal = new HrAppraisal();
                    $modelAppraisal->created_by= Yii::app()->user->id;
                    $modelAppraisal->created_date_time = date('Y-m-d H:i:s');
                    $modelAppraisal->appraisal_for = trim($_POST['HrAppraisal']['appraisal_for']);
                    $modelAppraisal->employee_id=$employees[$i];
                    $employee_id=$employees[$i];
                    $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="6"'));
                    $modelAppraisal->function_type =$model_master_approve_setting->id;
                    $modelAppraisal->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
                      $modelAppraisal->department_id = $_POST['HrAppraisal']['department_id'];
                    $modelAppraisal->status =1;
                    $modelAppraisal->last_approved_level =0;
                    $modelAppraisal->save();
                    $app_id= $modelAppraisal->id;
                    $jsonData['app_id_'.$i] = $app_id;
                    //Save Analysis
                    if (!empty($model_analysis)) {
                        foreach ($model_analysis as $eachanalysisModel) {
                            $each_analysis= new HrAppraisalAnalysis();
                            $each_analysis->attributes =$eachanalysisModel->attributes;
                            $each_analysis->appraisal_id = $app_id;
                            $each_analysis->save();
                        }
                    }
                    if (!empty($model_HrAppraisalType)) {
                        foreach ($model_HrAppraisalType as $eachModel) {
                            $eachtype= new HrAppraisalType();
                            $eachtype->attributes =$eachModel->attributes;
                            $eachtype->appraisal_id = $app_id;
                            $eachtype->save();

                        }
                    }
                }else{
                           $modelAppraisal->last_approved_level =0;
                           $modelAppraisal->status = 1;
                           $modelAppraisal->save();
                           $app_id= $modelAppraisal->id;
                           $jsonData['app_id_'.$i] = $app_id;
                }
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="23"'));
                    if(!empty($model_settings) && !empty($model_mail_settings)){
                        if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                             Yii::import('application.modules.hr.controllers.MailController'); 
                             MailController::sendmail(23,$modelAppraisal->employee_id,$modelAppraisal->id);
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {

                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_analysis) && $model_analysis[0]->question!=''){
                   $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }else{

                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetApprovedquestions() {
        $empid = (int) Yii::app()->request->getParam('id');
        $model = new HrAppraisal();
        $model_approved_analysis=new HrAppraisalAnalysis(); 
        $flag=0;
        if ($empid > 0) {
            $model = $model->find(array('condition' => 'employee_id="'. $empid.'" AND status=-1'));
            $id='';
            if(!empty($model)){
            $id = $model ->id;
            }
            $model_approved_analysis= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            $model_type= HrAppraisalType::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            if(!empty($model_approved_analysis)){
                $flag=1;
            }
            if(empty($model_approved_analysis)){
                $model_approved_analysis=array(new HrAppraisalAnalysis()); 
            }
            if(empty($model_type)){
                $model_type=array(new HrAppraisalType()); 
            }
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($flag==1){
            $this->renderPartial('appraisal_approved_questions', array('model_approved_analysis' => $model_approved_analysis,'model_Type'=>$model_type,'model_settings'=>$model_settings,'model_appraisal'=>$model), false, true);
            }
        else{
            echo "failed";
        }
    }
    public function actionGetappraisaldetils() {
        $empid = $_POST['id'];
        $model = new HrAppraisal();
        $appraisal_for='';
        $flag=0;
        if (count($empid) > 0) { 
            for($i=0;$i<count($empid);$i++){
             $model = HrAppraisal::MODEL()->find(array('condition' =>'status= -1 AND employee_id ="'.$empid[$i].'"'));
             if(empty($model)){
             $flag=1;
         }else{
            $appraisal_for = $model->appraisal_for;
         }

        }
        $jsonData['status']="success";
        $jsonData['appraisal_for']=$appraisal_for;
        $jsonData['flag_qstns']=$flag;
    }else{
        $jsonData['error']="success";
        $jsonData['flag_qstns']=$flag;
    }
    echo CJSON::encode($jsonData);
}
}
